/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.profiles.OWL2DLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonEquivalentClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSuperClassExpression;

public class OWL2RLProfile
implements OWLProfile {
    protected static final Set<IRI> allowedDatatypes = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_NON_POSITIVE_INTEGER.getIRI(), OWL2Datatype.XSD_POSITIVE_INTEGER.getIRI(), OWL2Datatype.XSD_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_LONG.getIRI(), OWL2Datatype.XSD_INT.getIRI(), OWL2Datatype.XSD_SHORT.getIRI(), OWL2Datatype.XSD_BYTE.getIRI(), OWL2Datatype.XSD_UNSIGNED_LONG.getIRI(), OWL2Datatype.XSD_UNSIGNED_BYTE.getIRI(), OWL2Datatype.XSD_FLOAT.getIRI(), OWL2Datatype.XSD_DOUBLE.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_LANGUAGE.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_BOOLEAN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));
    private final OWL2RLSubClassExpressionChecker subClassExpressionChecker = new OWL2RLSubClassExpressionChecker();
    private final OWL2RLSuperClassExpressionChecker superClassExpressionChecker = new OWL2RLSuperClassExpressionChecker();
    private final OWL2RLEquivalentClassExpressionChecker equivalentClassExpressionChecker = new OWL2RLEquivalentClassExpressionChecker();

    @Override
    public String getName() {
        return "OWL 2 RL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet violations = new HashSet();
        violations.addAll(report.getViolations());
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2RLObjectVisitor visitor = new OWL2RLObjectVisitor(walker);
        walker.walkStructure((OWLObjectVisitorEx)visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected boolean isOWL2RLSubClassExpression(OWLClassExpression ce) {
        return (Boolean)ce.accept((OWLClassExpressionVisitorEx)this.subClassExpressionChecker);
    }

    public boolean isOWL2RLSuperClassExpression(OWLClassExpression ce) {
        return (Boolean)ce.accept((OWLClassExpressionVisitorEx)this.superClassExpressionChecker);
    }

    public boolean isOWL2RLEquivalentClassExpression(OWLClassExpression ce) {
        return (Boolean)ce.accept((OWLClassExpressionVisitorEx)this.equivalentClassExpressionChecker);
    }

    private static class OWL2RLEquivalentClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        public Boolean visit(OWLClass desc) {
            return !desc.isOWLThing();
        }

        public Boolean visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression ce : desc.getOperands()) {
                if (((Boolean)ce.accept((OWLClassExpressionVisitorEx)this)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectUnionOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectComplementOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMaxCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasSelf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMaxCardinality desc) {
            return Boolean.FALSE;
        }
    }

    private class OWL2RLSuperClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        public Boolean visit(OWLClass desc) {
            return !desc.isOWLThing();
        }

        public Boolean visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression ce : desc.getOperands()) {
                if (((Boolean)ce.accept((OWLClassExpressionVisitorEx)this)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectUnionOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectComplementOf desc) {
            return OWL2RLProfile.this.isOWL2RLSubClassExpression(desc.getOperand());
        }

        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return (Boolean)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        }

        public Boolean visit(OWLObjectHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMaxCardinality desc) {
            return !(desc.getCardinality() != 0 && desc.getCardinality() != 1 || !((OWLClassExpression)desc.getFiller()).isOWLThing() && !OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)desc.getFiller()));
        }

        public Boolean visit(OWLObjectHasSelf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataAllValuesFrom desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMaxCardinality desc) {
            return desc.getCardinality() == 0 || desc.getCardinality() == 1;
        }
    }

    private class OWL2RLSubClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        public Boolean visit(OWLClass desc) {
            return !desc.isOWLThing();
        }

        public Boolean visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                if (OWL2RLProfile.this.isOWL2RLSubClassExpression(op)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectUnionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                if (OWL2RLProfile.this.isOWL2RLSubClassExpression(op)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectComplementOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return ((OWLClassExpression)desc.getFiller()).isOWLThing() || OWL2RLProfile.this.isOWL2RLSubClassExpression((OWLClassExpression)desc.getFiller());
        }

        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMaxCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasSelf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataHasValue desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMaxCardinality desc) {
            return Boolean.FALSE;
        }
    }

    private class OWL2RLObjectVisitor
    extends OWLOntologyWalkerVisitor<Object> {
        private final Set<OWLProfileViolation<?>> profileViolations;

        OWL2RLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.profileViolations = new HashSet();
        }

        public Set<OWLProfileViolation<?>> getProfileViolations() {
            return new HashSet(this.profileViolations);
        }

        public Object visit(OWLClassAssertionAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getClassExpression())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
            return null;
        }

        public Object visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
            return null;
        }

        public Object visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2RLProfile.this.isOWL2RLSubClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
            return null;
        }

        public Object visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2RLProfile.this.isOWL2RLEquivalentClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonEquivalentClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
            return null;
        }

        public Object visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLFunctionalDataPropertyAxiom axiom) {
            return null;
        }

        public Object visit(OWLHasKeyAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getClassExpression())) {
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
            return null;
        }

        public Object visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
            return null;
        }

        public Object visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getRange()));
            }
            return null;
        }

        public Object visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2RLProfile.this.isOWL2RLSubClassExpression(axiom.getSubClass())) {
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSubClass()));
            }
            if (!OWL2RLProfile.this.isOWL2RLSuperClassExpression(axiom.getSuperClass())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSuperClass()));
            }
            return null;
        }

        public Object visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)rule));
            return super.visit(rule);
        }

        public Object visit(OWLDataIntersectionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataOneOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDatatype node) {
            if (!allowedDatatypes.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            }
            return null;
        }

        public Object visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            return null;
        }
    }
}

