/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.profiles.OWL2DLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonAtomicClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSuperClassExpression;

public class OWL2QLProfile
implements OWLProfile {
    protected static final Set<IRI> allowedDatatypes = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.OWL_REAL.getIRI(), OWL2Datatype.OWL_RATIONAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));
    private final OWL2QLSubClassExpressionChecker subClassExpressionChecker = new OWL2QLSubClassExpressionChecker();
    private final OWL2QLSuperClassExpressionChecker superClassExpressionChecker = new OWL2QLSuperClassExpressionChecker();

    @Override
    public String getName() {
        return "OWL 2 QL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet violations = new HashSet();
        violations.addAll(report.getViolations());
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2QLObjectVisitor visitor = new OWL2QLObjectVisitor(walker);
        walker.walkStructure((OWLObjectVisitorEx)visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected boolean isOWL2QLSubClassExpression(OWLClassExpression ce) {
        return (Boolean)ce.accept((OWLClassExpressionVisitorEx)this.subClassExpressionChecker);
    }

    public boolean isOWL2QLSuperClassExpression(OWLClassExpression ce) {
        return (Boolean)ce.accept((OWLClassExpressionVisitorEx)this.superClassExpressionChecker);
    }

    private class OWL2QLSuperClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        public Boolean visit(OWLClass desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression ce : desc.getOperands()) {
                if (((Boolean)ce.accept((OWLClassExpressionVisitorEx)this)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectUnionOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectComplementOf desc) {
            return OWL2QLProfile.this.isOWL2QLSubClassExpression(desc.getOperand());
        }

        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return !((OWLClassExpression)desc.getFiller()).isAnonymous();
        }

        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasValue desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMaxCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasSelf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataHasValue desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMaxCardinality desc) {
            return Boolean.FALSE;
        }
    }

    private static class OWL2QLSubClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        public Boolean visit(OWLClass desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLObjectIntersectionOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectUnionOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectComplementOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return ((OWLClassExpression)desc.getFiller()).isOWLThing();
        }

        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasValue desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectMaxCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectHasSelf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLObjectOneOf desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return Boolean.TRUE;
        }

        public Boolean visit(OWLDataAllValuesFrom desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataHasValue desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMinCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataExactCardinality desc) {
            return Boolean.FALSE;
        }

        public Boolean visit(OWLDataMaxCardinality desc) {
            return Boolean.FALSE;
        }
    }

    private class OWL2QLObjectVisitor
    extends OWLOntologyWalkerVisitor<Object> {
        private final Set<OWLProfileViolation<?>> profileViolations;

        OWL2QLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.profileViolations = new HashSet();
        }

        public Set<OWLProfileViolation<?>> getProfileViolations() {
            return new HashSet(this.profileViolations);
        }

        public Object visit(OWLDatatype node) {
            if (!allowedDatatypes.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            }
            return null;
        }

        public Object visit(OWLAnonymousIndividual individual) {
            this.profileViolations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            return null;
        }

        public Object visit(OWLHasKeyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSubClassExpression(axiom.getSubClass())) {
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSubClass()));
            }
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getSuperClass())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getSuperClass()));
            }
            return null;
        }

        public Object visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2QLProfile.this.isOWL2QLSubClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
            return null;
        }

        public Object visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2QLProfile.this.isOWL2QLSubClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, ce));
            }
            return null;
        }

        public Object visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
            return null;
        }

        public Object visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, (OWLClassExpression)axiom.getRange()));
            }
            return null;
        }

        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDomain()));
            }
            return null;
        }

        public Object visit(OWLClassAssertionAxiom axiom) {
            if (axiom.getClassExpression().isAnonymous()) {
                this.profileViolations.add(new UseOfNonAtomicClassExpression(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getClassExpression()));
            }
            return null;
        }

        public Object visit(OWLSameIndividualAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)rule));
            return null;
        }

        public Object visit(OWLDataComplementOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataOneOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }
    }
}

