/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.violations.LexicalNotInLexicalSpace;
import org.semanticweb.owlapitools.profiles.violations.OntologyIRINotAbsolute;
import org.semanticweb.owlapitools.profiles.violations.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapitools.profiles.violations.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredDatatype;

public class OWL2Profile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2ProfileObjectWalker visitor = new OWL2ProfileObjectWalker(walker, ontology.getOWLOntologyManager());
        walker.walkStructure((OWLObjectVisitorEx)visitor);
        Set<OWLProfileViolation<?>> pv = visitor.getProfileViolations();
        return new OWLProfileReport(this, pv);
    }

    private static class OWL2ProfileObjectWalker
    extends OWLOntologyWalkerVisitor<Object> {
        private final OWLOntologyManager man;
        private final Set<OWLProfileViolation<?>> profileViolations = new HashSet();

        public OWL2ProfileObjectWalker(OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.man = man;
        }

        public Set<OWLProfileViolation<?>> getProfileViolations() {
            return new HashSet(this.profileViolations);
        }

        public Object visit(OWLOntology ont) {
            OWLOntologyID id = ont.getOntologyID();
            if (!id.isAnonymous()) {
                IRI versionIRI;
                IRI ontologyIRI = id.getOntologyIRI();
                if (!ontologyIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyIRINotAbsolute(ont));
                }
                if ((versionIRI = id.getVersionIRI()) != null && !versionIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyVersionIRINotAbsolute(ont));
                }
            }
            return null;
        }

        public Object visit(IRI iri) {
            if (!iri.isAbsolute()) {
                this.profileViolations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom(), iri));
            }
            return null;
        }

        public Object visit(OWLLiteral node) {
            if (node.getDatatype().isBuiltIn() && !node.getDatatype().getBuiltInDatatype().isInLexicalSpace(node.getLiteral())) {
                this.profileViolations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        public Object visit(OWLDatatypeRestriction node) {
            for (OWLOntology ont : this.man.getImportsClosure(this.getCurrentOntology())) {
                for (OWLDatatypeDefinitionAxiom ax : ont.getAxioms(AxiomType.DATATYPE_DEFINITION)) {
                    if (!node.getDatatype().equals(ax.getDatatype())) continue;
                    this.profileViolations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
            }
            for (OWLFacetRestriction r : node.getFacetRestrictions()) {
                OWL2Datatype dt = node.getDatatype().getBuiltInDatatype();
                if (dt.getFacets().contains(r.getFacet())) continue;
                this.profileViolations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node, r.getFacet()));
            }
            return null;
        }

        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            if (!this.getCurrentOntology().isDeclared((OWLEntity)axiom.getDatatype(), true)) {
                this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDatatype()));
            }
            return null;
        }
    }
}

