/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.profiles.OWL2DLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.violations.LastPropertyInChainNotInImposedRange;
import org.semanticweb.owlapitools.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapitools.profiles.violations.UseOfDataOneOfWithMultipleLiterals;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapitools.profiles.violations.UseOfObjectOneOfWithMultipleIndividuals;
import org.semanticweb.owlapitools.profiles.violations.UseOfObjectPropertyInverse;

public class OWL2ELProfile
implements OWLProfile {
    protected static final Set<IRI> allowedDatatypes = new HashSet<IRI>(Arrays.asList(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI(), OWL2Datatype.RDF_XML_LITERAL.getIRI(), OWL2Datatype.RDFS_LITERAL.getIRI(), OWL2Datatype.OWL_RATIONAL.getIRI(), OWL2Datatype.OWL_REAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_DECIMAL.getIRI(), OWL2Datatype.XSD_INTEGER.getIRI(), OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI(), OWL2Datatype.XSD_STRING.getIRI(), OWL2Datatype.XSD_NORMALIZED_STRING.getIRI(), OWL2Datatype.XSD_TOKEN.getIRI(), OWL2Datatype.XSD_NAME.getIRI(), OWL2Datatype.XSD_NCNAME.getIRI(), OWL2Datatype.XSD_NMTOKEN.getIRI(), OWL2Datatype.XSD_HEX_BINARY.getIRI(), OWL2Datatype.XSD_BASE_64_BINARY.getIRI(), OWL2Datatype.XSD_ANY_URI.getIRI(), OWL2Datatype.XSD_DATE_TIME.getIRI(), OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI()));

    @Override
    public String getName() {
        return "OWL 2 EL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet violations = new HashSet();
        violations.addAll(report.getViolations());
        OWLOntologyWalker ontologyWalker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2ELProfileObjectVisitor visitor = new OWL2ELProfileObjectVisitor(ontologyWalker, ontology.getOWLOntologyManager());
        ontologyWalker.walkStructure((OWLObjectVisitorEx)visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    protected class OWL2ELProfileObjectVisitor
    extends OWLOntologyWalkerVisitor<Object> {
        private final OWLOntologyManager man;
        private OWLObjectPropertyManager propertyManager;
        private final Set<OWLProfileViolation<?>> profileViolations;

        public OWL2ELProfileObjectVisitor(OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.profileViolations = new HashSet();
            this.man = man;
        }

        public Set<OWLProfileViolation<?>> getProfileViolations() {
            return new HashSet(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.propertyManager == null) {
                this.propertyManager = new OWLObjectPropertyManager(this.man, this.getCurrentOntology());
            }
            return this.propertyManager;
        }

        public Object visit(OWLDatatype node) {
            if (!allowedDatatypes.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            }
            return null;
        }

        public Object visit(OWLAnonymousIndividual individual) {
            this.profileViolations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            return null;
        }

        public Object visit(OWLObjectInverseOf property) {
            this.profileViolations.add(new UseOfObjectPropertyInverse(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObjectPropertyExpression)property));
            return null;
        }

        public Object visit(OWLDataAllValuesFrom desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLDataExactCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLDataMaxCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLDataMinCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectAllValuesFrom desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectComplementOf desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectExactCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectMaxCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectMinCardinality desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLObjectOneOf desc) {
            if (desc.getIndividuals().size() != 1) {
                this.profileViolations.add(new UseOfObjectOneOfWithMultipleIndividuals(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        public Object visit(OWLObjectUnionOf desc) {
            this.profileViolations.add(new UseOfIllegalClassExpression(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLClassExpression)desc));
            return null;
        }

        public Object visit(OWLDataComplementOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataOneOf node) {
            if (node.getValues().size() != 1) {
                this.profileViolations.add(new UseOfDataOneOfWithMultipleLiterals(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        public Object visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLDataRange)node));
            return null;
        }

        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLHasKeyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)axiom));
            return null;
        }

        public Object visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), (OWLAxiom)rule));
            return super.visit(rule);
        }

        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            Set rangeAxioms = this.getCurrentOntology().getAxioms(AxiomType.OBJECT_PROPERTY_RANGE, true);
            if (rangeAxioms.isEmpty()) {
                return Boolean.FALSE;
            }
            for (OWLObjectPropertyRangeAxiom rngAx : rangeAxioms) {
                if (!this.getPropertyManager().isSubPropertyOf(axiom.getSuperProperty(), (OWLObjectPropertyExpression)rngAx.getProperty())) continue;
                OWLClassExpression imposedRange = (OWLClassExpression)rngAx.getRange();
                List chain = axiom.getPropertyChain();
                if (chain.isEmpty()) continue;
                OWLObjectPropertyExpression lastProperty = (OWLObjectPropertyExpression)chain.get(chain.size() - 1);
                boolean rngPresent = false;
                block1: for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLObjectPropertyRangeAxiom lastPropRngAx : ont.getObjectPropertyRangeAxioms(lastProperty)) {
                        if (!((OWLClassExpression)lastPropRngAx.getRange()).equals(imposedRange)) continue;
                        rngPresent = true;
                        continue block1;
                    }
                }
                if (rngPresent) continue;
                this.profileViolations.add(new LastPropertyInChainNotInImposedRange(this.getCurrentOntology(), axiom, rngAx));
            }
            return null;
        }

        public Object visit(OWLOntology ontology) {
            this.propertyManager = null;
            return null;
        }
    }
}

