/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.profiles.OWL2Profile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.violations.CycleInDatatypeDefinition;
import org.semanticweb.owlapitools.profiles.violations.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapitools.profiles.violations.EmptyOneOfAxiom;
import org.semanticweb.owlapitools.profiles.violations.IllegalPunning;
import org.semanticweb.owlapitools.profiles.violations.InsufficientIndividuals;
import org.semanticweb.owlapitools.profiles.violations.InsufficientOperands;
import org.semanticweb.owlapitools.profiles.violations.InsufficientPropertyExpressions;
import org.semanticweb.owlapitools.profiles.violations.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapitools.profiles.violations.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredClass;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUnknownDatatype;

public class OWL2DLProfile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2 DL";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2Profile owl2Profile = new OWL2Profile();
        OWLProfileReport report = owl2Profile.checkOntology(ontology);
        LinkedHashSet violations = new LinkedHashSet();
        if (!report.isInProfile()) {
            violations.addAll(report.getViolations());
        }
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2DLProfileObjectVisitor visitor = new OWL2DLProfileObjectVisitor(walker, ontology.getOWLOntologyManager());
        walker.walkStructure((OWLObjectVisitorEx)visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    private static class OWL2DLProfileObjectVisitor
    extends OWLOntologyWalkerVisitor<Object> {
        private OWLObjectPropertyManager objectPropertyManager = null;
        private final OWLOntologyManager manager;
        private final Set<OWLProfileViolation<?>> profileViolations = new HashSet();

        OWL2DLProfileObjectVisitor(OWLOntologyWalker walker, OWLOntologyManager manager) {
            super(walker);
            this.manager = manager;
        }

        public Set<OWLProfileViolation<?>> getProfileViolations() {
            return new HashSet(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.objectPropertyManager == null) {
                this.objectPropertyManager = new OWLObjectPropertyManager(this.manager, this.getCurrentOntology());
            }
            return this.objectPropertyManager;
        }

        public Object visit(OWLDataOneOf node) {
            if (node.getValues().isEmpty()) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
            return null;
        }

        public Object visit(OWLDataUnionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLDataIntersectionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLObjectIntersectionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLObjectOneOf node) {
            if (node.getIndividuals().isEmpty()) {
                this.profileViolations.add(new EmptyOneOfAxiom(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
            return null;
        }

        public Object visit(OWLObjectUnionOf node) {
            if (node.getOperands().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLEquivalentClassesAxiom node) {
            if (node.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)node, (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLDisjointClassesAxiom node) {
            if (node.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)node, (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLDisjointUnionAxiom node) {
            if (node.getClassExpressions().size() < 2) {
                this.profileViolations.add(new InsufficientOperands(this.getCurrentOntology(), (OWLAxiom)node, (OWLObject)node));
            }
            return null;
        }

        public Object visit(OWLEquivalentObjectPropertiesAxiom node) {
            if (node.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLDisjointDataPropertiesAxiom node) {
            if (node.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLEquivalentDataPropertiesAxiom node) {
            if (node.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLHasKeyAxiom node) {
            if (node.getPropertyExpressions().size() < 1) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLSameIndividualAxiom node) {
            if (node.getIndividuals().size() < 2) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLDifferentIndividualsAxiom node) {
            if (node.getIndividuals().size() < 2) {
                this.profileViolations.add(new InsufficientIndividuals(this.getCurrentOntology(), (OWLAxiom)node));
            }
            return null;
        }

        public Object visit(OWLOntology ontology) {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            if (!ontologyID.isAnonymous()) {
                IRI versionIRI;
                if (ontologyID.getOntologyIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForOntologyIRI(this.getCurrentOntology()));
                }
                if ((versionIRI = ontologyID.getVersionIRI()) != null && versionIRI.isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForVersionIRI(this.getCurrentOntology()));
                }
            }
            this.objectPropertyManager = null;
            return super.visit(ontology);
        }

        public Object visit(OWLClass desc) {
            if (!desc.isBuiltIn() && desc.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            if (!desc.isBuiltIn() && !this.getCurrentOntology().isDeclared((OWLEntity)desc, true)) {
                this.profileViolations.add(new UseOfUndeclaredClass(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            if (this.getCurrentOntology().containsDatatypeInSignature(desc.getIRI())) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), desc.getIRI()));
            }
            return null;
        }

        public Object visit(OWLDatatype datatype) {
            if (!OWL2Datatype.isBuiltIn((IRI)datatype.getIRI())) {
                if (!datatype.getIRI().getNamespace().equals(Namespaces.XSD.toString()) && !datatype.isTopDatatype() && datatype.getIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfUnknownDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), datatype));
                }
                if (!(datatype.isTopDatatype() || datatype.isBuiltIn() || this.getCurrentOntology().isDeclared((OWLEntity)datatype, true))) {
                    this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), datatype));
                }
            }
            if (this.getCurrentOntology().containsClassInSignature(datatype.getIRI(), true)) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), datatype.getIRI()));
            }
            return null;
        }

        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            if (axiom.getDatatype().getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfBuiltInDatatypeInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
            HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
            LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
            axioms.add((OWLAxiom)axiom);
            this.getDatatypesInSignature(datatypes, (OWLObject)axiom.getDataRange(), axioms);
            if (datatypes.contains(axiom.getDatatype())) {
                this.profileViolations.add(new CycleInDatatypeDefinition(this.getCurrentOntology(), (OWLAxiom)axiom));
            }
            return null;
        }

        private void getDatatypesInSignature(Set<OWLDatatype> datatypes, OWLObject obj, Set<OWLAxiom> axioms) {
            for (OWLDatatype dt : obj.getDatatypesInSignature()) {
                if (!datatypes.add(dt)) continue;
                for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLDatatypeDefinitionAxiom ax : ont.getDatatypeDefinitions(dt)) {
                        axioms.add((OWLAxiom)ax);
                        this.getDatatypesInSignature(datatypes, (OWLObject)ax.getDataRange(), axioms);
                    }
                }
            }
        }

        public Object visit(OWLObjectProperty property) {
            if (!property.isOWLTopObjectProperty() && !property.isOWLBottomObjectProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForObjectPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared((OWLEntity)property, true)) {
                this.profileViolations.add(new UseOfUndeclaredObjectProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            return null;
        }

        public Object visit(OWLDataProperty property) {
            if (!property.isOWLTopDataProperty() && !property.isOWLBottomDataProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForDataPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared((OWLEntity)property, true)) {
                this.profileViolations.add(new UseOfUndeclaredDataProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            return null;
        }

        public Object visit(OWLAnnotationProperty property) {
            if (!property.isBuiltIn() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForAnnotationPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared((OWLEntity)property, true)) {
                this.profileViolations.add(new UseOfUndeclaredAnnotationProperty(this.getCurrentOntology(), this.getCurrentAxiom(), this.getCurrentAnnotation(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), true)) {
                this.profileViolations.add(new IllegalPunning(this.getCurrentOntology(), this.getCurrentAxiom(), property.getIRI()));
            }
            return null;
        }

        public Object visit(OWLNamedIndividual individual) {
            if (!individual.isAnonymous() && individual.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForIndividualIRI(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            }
            return null;
        }

        public Object visit(OWLSubDataPropertyOfAxiom axiom) {
            if (((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLTopDataProperty()) {
                this.profileViolations.add(new UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        public Object visit(OWLObjectMinCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObjectCardinalityRestriction)desc));
            }
            return null;
        }

        public Object visit(OWLObjectMaxCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObjectCardinalityRestriction)desc));
            }
            return null;
        }

        public Object visit(OWLObjectExactCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), (OWLObjectCardinalityRestriction)desc));
            }
            return null;
        }

        public Object visit(OWLObjectHasSelf desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInObjectHasSelf(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInFunctionalPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInIrreflexivePropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            if (axiom.getProperties().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)axiom));
            }
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!this.getPropertyManager().isNonSimple(prop)) continue;
                this.profileViolations.add(new UseOfNonSimplePropertyInDisjointPropertiesAxiom(this.getCurrentOntology(), axiom, prop));
            }
            return null;
        }

        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            OWLObjectPropertyExpression superProp;
            if (axiom.getPropertyChain().size() < 2) {
                this.profileViolations.add(new InsufficientPropertyExpressions(this.getCurrentOntology(), (OWLAxiom)axiom));
            }
            if ((superProp = axiom.getSuperProperty()).isOWLTopObjectProperty() || axiom.isEncodingOfTransitiveProperty()) {
                return null;
            }
            List chain = axiom.getPropertyChain();
            OWLObjectPropertyExpression first = (OWLObjectPropertyExpression)chain.get(0);
            OWLObjectPropertyExpression last = (OWLObjectPropertyExpression)chain.get(chain.size() - 1);
            for (int i = 1; i < chain.size() - 1; ++i) {
                if (!this.getPropertyManager().isLessThan(superProp, (OWLObjectPropertyExpression)chain.get(i))) continue;
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, (OWLObjectPropertyExpression)chain.get(i)));
            }
            if (first.equals(superProp)) {
                if (this.getPropertyManager().isLessThan(superProp, last)) {
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, last));
                }
            } else if (this.getPropertyManager().isLessThan(superProp, first)) {
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, first));
            }
            if (last.equals(superProp)) {
                if (this.getPropertyManager().isLessThan(superProp, first)) {
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, first));
                }
            } else if (this.getPropertyManager().isLessThan(superProp, last)) {
                this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, last));
            }
            return null;
        }
    }
}

