/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderLiteral
extends BaseBuilder<OWLLiteral, BuilderLiteral> {
    private String lang = null;
    private String literalForm = null;
    private Integer intValue = null;
    private Double doubleValue = null;
    private Float floatValue = null;
    private Boolean booleanValue = null;
    private OWLDatatype datatype;

    public BuilderLiteral(OWLLiteral expected) {
        this.withDatatype(expected.getDatatype()).withLanguage(expected.getLang());
        if (expected.isBoolean()) {
            this.withValue(expected.parseBoolean());
        } else if (expected.isDouble()) {
            this.withValue(expected.parseDouble());
        } else if (expected.isFloat()) {
            this.withValue(expected.parseFloat());
        } else if (expected.isInteger()) {
            this.withValue(expected.parseInteger());
        } else {
            this.withLiteralForm(expected.getLiteral());
        }
    }

    public BuilderLiteral() {
    }

    protected void clear() {
        this.literalForm = null;
        this.intValue = null;
        this.doubleValue = null;
        this.floatValue = null;
        this.booleanValue = null;
    }

    public BuilderLiteral withValue(int arg) {
        this.clear();
        this.intValue = arg;
        return this;
    }

    public BuilderLiteral withDatatype(OWL2Datatype arg) {
        return this.withDatatype(df.getOWLDatatype(arg.getIRI()));
    }

    public BuilderLiteral withDatatype(OWLDatatype arg) {
        this.lang = null;
        this.datatype = arg;
        return this;
    }

    public BuilderLiteral withValue(boolean arg) {
        this.clear();
        this.booleanValue = arg;
        return this;
    }

    public BuilderLiteral withValue(double arg) {
        this.clear();
        this.doubleValue = arg;
        return this;
    }

    public BuilderLiteral withValue(float arg) {
        this.clear();
        this.floatValue = Float.valueOf(arg);
        return this;
    }

    public BuilderLiteral withLiteralForm(String arg) {
        this.clear();
        this.literalForm = arg;
        return this;
    }

    public BuilderLiteral withLanguage(String arg) {
        this.datatype = null;
        this.lang = arg;
        return this;
    }

    @Override
    public OWLLiteral buildObject() {
        if (this.intValue != null) {
            return df.getOWLLiteral(this.intValue.intValue());
        }
        if (this.doubleValue != null) {
            return df.getOWLLiteral(this.doubleValue.doubleValue());
        }
        if (this.floatValue != null) {
            return df.getOWLLiteral(this.floatValue.floatValue());
        }
        if (this.booleanValue != null) {
            return df.getOWLLiteral(this.booleanValue.booleanValue());
        }
        if (this.lang != null) {
            return df.getOWLLiteral(this.literalForm, this.lang);
        }
        return df.getOWLLiteral(this.literalForm, this.datatype);
    }
}

