/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapitools.builders.Builder;
import org.semanticweb.owlapitools.profiles.OWL2DLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileReport;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public abstract class BaseBuilder<T extends OWLObject, Type>
implements Builder<T> {
    protected static final OWLDataFactory df = new OWLDataFactoryImpl();
    protected Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
    private OWLProfile profile = new OWL2DLProfile();

    public Type withAnnotation(OWLAnnotation arg) {
        this.annotations.add(arg);
        return (Type)this;
    }

    public Type withAnnotations(Collection<OWLAnnotation> arg) {
        this.annotations.addAll(arg);
        return (Type)this;
    }

    @Override
    public abstract T buildObject();

    @Override
    public final List<OWLOntologyChange> buildChanges(OWLOntology o) {
        T object = this.buildObject();
        if (!(object instanceof OWLAxiom)) {
            return Collections.emptyList();
        }
        AddAxiom change = new AddAxiom(o, (OWLAxiom)object);
        o.getOWLOntologyManager().applyChange((OWLOntologyChange)change);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLProfileReport report = this.profile.checkOntology(o);
        for (OWLProfileViolation<?> v : report.getViolations()) {
            changes.addAll(v.repair());
        }
        o.getOWLOntologyManager().applyChanges(changes);
        changes.add((OWLOntologyChange)change);
        return changes;
    }
}

