/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.profiles.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapitools.profiles.OWL2DLProfile;
import org.semanticweb.owlapitools.profiles.OWL2ELProfile;
import org.semanticweb.owlapitools.profiles.OWL2Profile;
import org.semanticweb.owlapitools.profiles.OWL2QLProfile;
import org.semanticweb.owlapitools.profiles.OWL2RLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfile;
import org.semanticweb.owlapitools.profiles.OWLProfileViolation;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitor;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitorAdapter;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitorEx;
import org.semanticweb.owlapitools.profiles.OWLProfileViolationVisitorExAdapter;
import org.semanticweb.owlapitools.profiles.test.Tests;
import org.semanticweb.owlapitools.profiles.violations.CycleInDatatypeDefinition;
import org.semanticweb.owlapitools.profiles.violations.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapitools.profiles.violations.EmptyOneOfAxiom;
import org.semanticweb.owlapitools.profiles.violations.IllegalPunning;
import org.semanticweb.owlapitools.profiles.violations.InsufficientIndividuals;
import org.semanticweb.owlapitools.profiles.violations.InsufficientOperands;
import org.semanticweb.owlapitools.profiles.violations.InsufficientPropertyExpressions;
import org.semanticweb.owlapitools.profiles.violations.LastPropertyInChainNotInImposedRange;
import org.semanticweb.owlapitools.profiles.violations.LexicalNotInLexicalSpace;
import org.semanticweb.owlapitools.profiles.violations.OntologyIRINotAbsolute;
import org.semanticweb.owlapitools.profiles.violations.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapitools.profiles.violations.UseOfAnonymousIndividual;
import org.semanticweb.owlapitools.profiles.violations.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapitools.profiles.violations.UseOfDataOneOfWithMultipleLiterals;
import org.semanticweb.owlapitools.profiles.violations.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalDataRange;
import org.semanticweb.owlapitools.profiles.violations.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonAtomicClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonEquivalentClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSubClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfNonSuperClassExpression;
import org.semanticweb.owlapitools.profiles.violations.UseOfObjectOneOfWithMultipleIndividuals;
import org.semanticweb.owlapitools.profiles.violations.UseOfObjectPropertyInverse;
import org.semanticweb.owlapitools.profiles.violations.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapitools.profiles.violations.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredClass;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapitools.profiles.violations.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapitools.profiles.violations.UseOfUnknownDatatype;

public class OWLProfileJUnitTest {
    private static final String START = OWLFunctionalSyntaxFactory.OWLThing().getIRI().getNamespace();
    private static final OWLClass cl = OWLFunctionalSyntaxFactory.Class((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#fakeclass"));
    private static final OWLDataProperty datap = OWLFunctionalSyntaxFactory.DataProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:datatype#fakedatatypeproperty"));
    private static final OWLDataPropertyRangeAxiom DATA_PROPERTY_RANGE2 = OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DatatypeRestriction((OWLDatatype)OWLFunctionalSyntaxFactory.Integer(), (OWLFacetRestriction[])new OWLFacetRestriction[]{OWLFunctionalSyntaxFactory.FacetRestriction((OWLFacet)OWLFacet.LANG_RANGE, (OWLLiteral)OWLFunctionalSyntaxFactory.Literal((int)1))}));
    private static final OWLDataPropertyRangeAxiom DATA_PROPERTY_RANGE = OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DatatypeRestriction((OWLDatatype)OWLFunctionalSyntaxFactory.Integer(), (OWLFacetRestriction[])new OWLFacetRestriction[]{OWLFunctionalSyntaxFactory.FacetRestriction((OWLFacet)OWLFacet.MAX_EXCLUSIVE, (OWLLiteral)OWLFunctionalSyntaxFactory.Literal((int)1))}));
    private static final OWLObjectProperty op = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:datatype#fakeobjectproperty"));
    private static final OWLDatatype unknownfakedatatype = OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)(START + "unknownfakedatatype")));
    private static final OWLDatatype fakeundeclareddatatype = OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:datatype#fakeundeclareddatatype"));
    private static final OWLDatatype fakedatatype = OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:datatype#fakedatatype"));
    private static final IRI onto = IRI.create((String)"urn:test#ontology");
    private static final OWLDataFactory df = OWLManager.getOWLDataFactory();
    private static final OWLObjectProperty p = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#objectproperty"));
    Comparator<Class> comp = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    };

    public void declare(OWLOntology o, OWLEntity ... entities) {
        OWLOntologyManager m = o.getOWLOntologyManager();
        for (OWLEntity e : entities) {
            m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.Declaration((OWLEntity)e));
        }
    }

    public void checkInCollection(List<OWLProfileViolation<?>> violations, Class[] _list) {
        ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(_list));
        ArrayList list1 = new ArrayList();
        for (OWLProfileViolation<?> v : violations) {
            list1.add(v.getClass());
        }
        Collections.sort(list, this.comp);
        Collections.sort(list1, this.comp);
        Assert.assertEquals((String)((Object)list1).toString(), list, list1);
    }

    public void runAssert(OWLOntology o, OWLProfile profile, int expected, Class[] expectedViolations) {
        List violations = profile.checkOntology(o).getViolations();
        Assert.assertEquals((long)expected, (long)violations.size());
        this.checkInCollection(violations, expectedViolations);
        for (OWLProfileViolation violation : violations) {
            o.getOWLOntologyManager().applyChanges(violation.repair());
            violation.accept((OWLProfileViolationVisitor)new OWLProfileViolationVisitorAdapter());
            violation.accept((OWLProfileViolationVisitorEx)new OWLProfileViolationVisitorExAdapter<String>(){

                protected String doDefault(OWLProfileViolation<?> v) {
                    return v.toString();
                }
            });
        }
        violations = profile.checkOntology(o).getViolations();
        Assert.assertEquals((long)0L, (long)violations.size());
    }

    @Test
    @Tests(method="public Object visit(OWLDatatype datatype)")
    public void shouldCreateViolationForOWLDatatypeInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{unknownfakedatatype, fakedatatype, OWLFunctionalSyntaxFactory.Class((IRI)fakedatatype.getIRI()), datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)fakeundeclareddatatype));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 4;
        Class[] expectedViolations = new Class[]{UseOfUnknownDatatype.class, UseOfUndeclaredDatatype.class, DatatypeIRIAlsoUsedAsClassIRI.class, DatatypeIRIAlsoUsedAsClassIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeDefinitionAxiom axiom)")
    public void shouldCreateViolationForOWLDatatypeDefinitionAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.Integer(), OWLFunctionalSyntaxFactory.Boolean(), fakedatatype});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)OWLFunctionalSyntaxFactory.Boolean(), (OWLDataRange)OWLFunctionalSyntaxFactory.Integer()));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)fakedatatype, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer()));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)OWLFunctionalSyntaxFactory.Integer(), (OWLDataRange)fakedatatype));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 4;
        Class[] expectedViolations = new Class[]{CycleInDatatypeDefinition.class, CycleInDatatypeDefinition.class, UseOfBuiltInDatatypeInDatatypeDefinition.class, UseOfBuiltInDatatypeInDatatypeDefinition.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeDefinitionAxiom axiom)")
    public void shouldCreateViolationForOWLDatatypeDefinitionAxiomInOWL2DLProfile_cycles() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLDatatype d = OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)(START + "test")));
        this.declare(o, new OWLEntity[]{d, OWLFunctionalSyntaxFactory.Integer(), OWLFunctionalSyntaxFactory.Boolean(), fakedatatype});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)d, (OWLDataRange)OWLFunctionalSyntaxFactory.Boolean()));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)OWLFunctionalSyntaxFactory.Boolean(), (OWLDataRange)d));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)fakedatatype, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer()));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)OWLFunctionalSyntaxFactory.Integer(), (OWLDataRange)fakedatatype));
        int expected = 10;
        Class[] expectedViolations = new Class[]{CycleInDatatypeDefinition.class, CycleInDatatypeDefinition.class, CycleInDatatypeDefinition.class, CycleInDatatypeDefinition.class, UseOfBuiltInDatatypeInDatatypeDefinition.class, UseOfBuiltInDatatypeInDatatypeDefinition.class, UseOfBuiltInDatatypeInDatatypeDefinition.class, UseOfUnknownDatatype.class, UseOfUnknownDatatype.class, UseOfUnknownDatatype.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectProperty property)")
    public void shouldCreateViolationForOWLObjectPropertyInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        IRI iri = OWLFunctionalSyntaxFactory.IRI((String)(START + "test"));
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.ObjectProperty((IRI)iri), OWLFunctionalSyntaxFactory.DataProperty((IRI)iri), OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)iri)});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubObjectPropertyOf((OWLObjectPropertyExpression)op, (OWLObjectPropertyExpression)OWLFunctionalSyntaxFactory.ObjectProperty((IRI)iri)));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 13;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForObjectPropertyIRI.class, UseOfReservedVocabularyForAnnotationPropertyIRI.class, UseOfReservedVocabularyForDataPropertyIRI.class, UseOfReservedVocabularyForObjectPropertyIRI.class, UseOfUndeclaredObjectProperty.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataProperty property)")
    public void shouldCreateViolationForOWLDataPropertyInOWL2DLProfile1() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.DataProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)(START + "fail")))});
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForDataPropertyIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataProperty property)")
    public void shouldCreateViolationForOWLDataPropertyInOWL2DLProfile2() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalDataProperty((OWLDataPropertyExpression)datap));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfUndeclaredDataProperty.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataProperty property)")
    public void shouldCreateViolationForOWLDataPropertyInOWL2DLProfile3() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{datap, OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)datap.getIRI())});
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{IllegalPunning.class, IllegalPunning.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataProperty property)")
    public void shouldCreateViolationForOWLDataPropertyInOWL2DLProfile4() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{datap, OWLFunctionalSyntaxFactory.ObjectProperty((IRI)datap.getIRI())});
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{IllegalPunning.class, IllegalPunning.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLAnnotationProperty property)")
    public void shouldCreateViolationForOWLAnnotationPropertyInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        IRI iri = OWLFunctionalSyntaxFactory.IRI((String)(START + "test"));
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.ObjectProperty((IRI)iri), OWLFunctionalSyntaxFactory.DataProperty((IRI)iri), OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)iri)});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubAnnotationPropertyOf((OWLAnnotationProperty)OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#t")), (OWLAnnotationProperty)OWLFunctionalSyntaxFactory.AnnotationProperty((IRI)iri)));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 13;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForAnnotationPropertyIRI.class, UseOfReservedVocabularyForAnnotationPropertyIRI.class, UseOfReservedVocabularyForObjectPropertyIRI.class, UseOfReservedVocabularyForDataPropertyIRI.class, UseOfUndeclaredAnnotationProperty.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class, IllegalPunning.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLOntology ontology)")
    public void shouldCreateViolationForOWLOntologyInOWL2DLProfile() throws Exception {
        OWLOntology o = OWLManager.createOWLOntologyManager().createOntology(new OWLOntologyID(OWLFunctionalSyntaxFactory.IRI((String)(START + "test")), OWLFunctionalSyntaxFactory.IRI((String)(START + "test1"))));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForOntologyIRI.class, UseOfReservedVocabularyForVersionIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLClass desc)")
    public void shouldCreateViolationForOWLClassInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.Class((IRI)OWLFunctionalSyntaxFactory.IRI((String)(START + "test"))), fakedatatype});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.Class((IRI)fakedatatype.getIRI()), (OWLIndividual)OWLFunctionalSyntaxFactory.AnonymousIndividual()));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 4;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForClassIRI.class, UseOfUndeclaredClass.class, DatatypeIRIAlsoUsedAsClassIRI.class, DatatypeIRIAlsoUsedAsClassIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataOneOf node)")
    public void shouldCreateViolationForOWLDataOneOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataOneOf((OWLLiteral[])new OWLLiteral[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{EmptyOneOfAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataUnionOf node)")
    public void shouldCreateViolationForOWLDataUnionOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataUnionOf((OWLDataRange[])new OWLDataRange[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataIntersectionOf node)")
    public void shouldCreateViolationForOWLDataIntersectionOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataIntersectionOf((OWLDataRange[])new OWLDataRange[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectIntersectionOf node)")
    public void shouldCreateViolationForOWLObjectIntersectionOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectIntersectionOf((OWLClassExpression[])new OWLClassExpression[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectOneOf node)")
    public void shouldCreateViolationForOWLObjectOneOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectOneOf((OWLIndividual[])new OWLIndividual[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{EmptyOneOfAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectUnionOf node)")
    public void shouldCreateViolationForOWLObjectUnionOfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[0])));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentClassesAxiom node)")
    public void shouldCreateViolationForOWLEquivalentClassesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentClasses((OWLClassExpression[])new OWLClassExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointClassesAxiom node)")
    public void shouldCreateViolationForOWLDisjointClassesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointClasses((OWLClassExpression[])new OWLClassExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointUnionAxiom node)")
    public void shouldCreateViolationForOWLDisjointUnionAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        OWLClass otherfakeclass = OWLFunctionalSyntaxFactory.Class((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#otherfakeclass"));
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        set.add(otherfakeclass);
        this.declare(o, new OWLEntity[]{cl});
        this.declare(o, new OWLEntity[]{otherfakeclass});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointUnion((OWLClass)cl, (OWLClassExpression[])new OWLClassExpression[]{otherfakeclass}));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientOperands.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentObjectPropertiesAxiom node)")
    public void shouldCreateViolationForOWLEquivalentObjectPropertiesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentObjectProperties((OWLObjectPropertyExpression[])new OWLObjectPropertyExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointDataPropertiesAxiom node)")
    public void shouldCreateViolationForOWLDisjointDataPropertiesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointDataProperties((OWLDataPropertyExpression[])new OWLDataPropertyExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentDataPropertiesAxiom node)")
    public void shouldCreateViolationForOWLEquivalentDataPropertiesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentDataProperties((OWLDataPropertyExpression[])new OWLDataPropertyExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLHasKeyAxiom node)")
    public void shouldCreateViolationForOWLHasKeyAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.HasKey((OWLClassExpression)cl, (OWLPropertyExpression[])new OWLPropertyExpression[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSameIndividualAxiom node)")
    public void shouldCreateViolationForOWLSameIndividualAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SameIndividual((OWLIndividual[])new OWLIndividual[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientIndividuals.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDifferentIndividualsAxiom node)")
    public void shouldCreateViolationForOWLDifferentIndividualsAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DifferentIndividuals((OWLIndividual[])new OWLIndividual[0]));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{InsufficientIndividuals.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLNamedIndividual individual)")
    public void shouldCreateViolationForOWLNamedIndividualInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing(), (OWLIndividual)OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)(START + "i")))));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfReservedVocabularyForIndividualIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubDataPropertyOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubDataPropertyOfAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubDataPropertyOf((OWLDataPropertyExpression)df.getOWLTopDataProperty(), (OWLDataPropertyExpression)df.getOWLTopDataProperty()));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectMinCardinality desc)")
    public void shouldCreateViolationForOWLObjectMinCardinalityInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInCardinalityRestriction.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectMaxCardinality desc)")
    public void shouldCreateViolationForOWLObjectMaxCardinalityInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMaxCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInCardinalityRestriction.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectExactCardinality desc)")
    public void shouldCreateViolationForOWLObjectExactCardinalityInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectExactCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInCardinalityRestriction.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectHasSelf desc)")
    public void shouldCreateViolationForOWLObjectHasSelfInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectHasSelf((OWLObjectPropertyExpression)op)));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInObjectHasSelf.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLFunctionalObjectPropertyAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalObjectProperty((OWLObjectPropertyExpression)op));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInFunctionalPropertyAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLInverseFunctionalObjectPropertyAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.InverseFunctionalObjectProperty((OWLObjectPropertyExpression)op));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLIrreflexiveObjectPropertyAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.IrreflexiveObjectProperty((OWLObjectPropertyExpression)op));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInIrreflexivePropertyAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLAsymmetricObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLAsymmetricObjectPropertyAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.AsymmetricObjectProperty((OWLObjectPropertyExpression)op));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointObjectPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointObjectPropertiesAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointObjectProperties((OWLObjectPropertyExpression[])new OWLObjectPropertyExpression[]{op}));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class, UseOfNonSimplePropertyInDisjointPropertiesAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubPropertyChainOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubPropertyChainOfAxiomInOWL2DLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLObjectProperty op1 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#op"));
        this.declare(o, new OWLEntity[]{op, op1});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op1), (OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op, op1, op), (OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op, op1), (OWLObjectPropertyExpression)op));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op1, op, op1, op), (OWLObjectPropertyExpression)op));
        OWL2DLProfile profile = new OWL2DLProfile();
        int expected = 4;
        Class[] expectedViolations = new Class[]{InsufficientPropertyExpressions.class, UseOfPropertyInChainCausesCycle.class, UseOfPropertyInChainCausesCycle.class, UseOfPropertyInChainCausesCycle.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLOntology ont)")
    public void shouldCreateViolationForOWLOntologyInOWL2Profile() throws Exception {
        OWLOntology o = OWLManager.createOWLOntologyManager().createOntology(new OWLOntologyID(OWLFunctionalSyntaxFactory.IRI((String)"test"), OWLFunctionalSyntaxFactory.IRI((String)"test1")));
        OWL2Profile profile = new OWL2Profile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{OntologyIRINotAbsolute.class, OntologyVersionIRINotAbsolute.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(IRI iri)")
    public void shouldCreateViolationForIRIInOWL2Profile() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.Class((IRI)OWLFunctionalSyntaxFactory.IRI((String)"test"))});
        OWL2Profile profile = new OWL2Profile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonAbsoluteIRI.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLLiteral node)")
    public void shouldCreateViolationForOWLLiteralInOWL2Profile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyAssertion((OWLDataPropertyExpression)datap, (OWLIndividual)OWLFunctionalSyntaxFactory.AnonymousIndividual(), (OWLLiteral)OWLFunctionalSyntaxFactory.Literal((String)"wrong", (OWL2Datatype)OWL2Datatype.XSD_INTEGER)));
        OWL2Profile profile = new OWL2Profile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{LexicalNotInLexicalSpace.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeRestriction node)")
    public void shouldCreateViolationForOWLDatatypeRestrictionInOWL2Profile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)OWLFunctionalSyntaxFactory.Integer(), (OWLDataRange)OWLFunctionalSyntaxFactory.Boolean()));
        m.addAxiom(o, (OWLAxiom)DATA_PROPERTY_RANGE2);
        OWL2Profile profile = new OWL2Profile();
        int expected = 3;
        Class[] expectedViolations = new Class[]{UseOfDefinedDatatypeInDatatypeRestriction.class, UseOfIllegalFacetRestriction.class, UseOfUndeclaredDatatype.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeDefinitionAxiom axiom)")
    public void shouldCreateViolationForOWLDatatypeDefinitionAxiomInOWL2Profile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)fakedatatype, (OWLDataRange)OWLFunctionalSyntaxFactory.Boolean()));
        OWL2Profile profile = new OWL2Profile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfUndeclaredDatatype.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatype node)")
    public void shouldCreateViolationForOWLDatatypeInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.Boolean()});
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLAnonymousIndividual individual)")
    public void shouldCreateViolationForOWLAnonymousIndividualInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing(), (OWLIndividual)df.getOWLAnonymousIndividual()));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfAnonymousIndividual.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectInverseOf property)")
    public void shouldCreateViolationForOWLObjectInverseOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubObjectPropertyOf((OWLObjectPropertyExpression)op, (OWLObjectPropertyExpression)OWLFunctionalSyntaxFactory.ObjectInverseOf((OWLObjectPropertyExpression)op)));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfObjectPropertyInverse.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataAllValuesFrom desc)")
    public void shouldCreateViolationForOWLDataAllValuesFromInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.DataAllValuesFrom((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataExactCardinality desc)")
    public void shouldCreateViolationForOWLDataExactCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, cl, OWLFunctionalSyntaxFactory.Integer()});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.DataExactCardinality((int)1, (OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataMaxCardinality desc)")
    public void shouldCreateViolationForOWLDataMaxCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, cl, OWLFunctionalSyntaxFactory.Integer()});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.DataMaxCardinality((int)1, (OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataMinCardinality desc)")
    public void shouldCreateViolationForOWLDataMinCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, cl, OWLFunctionalSyntaxFactory.Integer()});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.DataMinCardinality((int)1, (OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.Integer())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectAllValuesFrom desc)")
    public void shouldCreateViolationForOWLObjectAllValuesFromInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectAllValuesFrom((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectComplementOf desc)")
    public void shouldCreateViolationForOWLObjectComplementOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLNothing())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectExactCardinality desc)")
    public void shouldCreateViolationForOWLObjectExactCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectExactCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectMaxCardinality desc)")
    public void shouldCreateViolationForOWLObjectMaxCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMaxCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectMinCardinality desc)")
    public void shouldCreateViolationForOWLObjectMinCardinalityInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)cl, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectOneOf desc)")
    public void shouldCreateViolationForOWLObjectOneOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectOneOf((OWLIndividual[])new OWLIndividual[]{OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i1")), OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i2"))})));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfObjectOneOfWithMultipleIndividuals.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectUnionOf desc)")
    public void shouldCreateViolationForOWLObjectUnionOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLThing(), OWLFunctionalSyntaxFactory.OWLNothing()})));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataComplementOf node)")
    public void shouldCreateViolationForOWLDataComplementOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataComplementOf((OWLDataRange)OWLFunctionalSyntaxFactory.Double())));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class, UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataOneOf node)")
    public void shouldCreateViolationForOWLDataOneOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataOneOf((OWLLiteral[])new OWLLiteral[]{OWLFunctionalSyntaxFactory.Literal((int)1), OWLFunctionalSyntaxFactory.Literal((int)2)})));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfDataOneOfWithMultipleLiterals.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeRestriction node)")
    public void shouldCreateViolationForOWLDatatypeRestrictionInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)DATA_PROPERTY_RANGE);
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataUnionOf node)")
    public void shouldCreateViolationForOWLDataUnionOfInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataUnionOf((OWLDataRange[])new OWLDataRange[]{OWLFunctionalSyntaxFactory.Double(), OWLFunctionalSyntaxFactory.Integer()})));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class, UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLAsymmetricObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLAsymmetricObjectPropertyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.AsymmetricObjectProperty((OWLObjectPropertyExpression)op));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointDataPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointDataPropertiesAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLDataProperty dp = OWLFunctionalSyntaxFactory.DataProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#other"));
        this.declare(o, new OWLEntity[]{datap, dp});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointDataProperties((OWLDataPropertyExpression[])new OWLDataPropertyExpression[]{datap, dp}));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointObjectPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointObjectPropertiesAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLObjectProperty op1 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#test"));
        this.declare(o, new OWLEntity[]{op, op1});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointObjectProperties((OWLObjectPropertyExpression[])new OWLObjectPropertyExpression[]{op1, op}));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointUnionAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointUnionAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointUnion((OWLClass)cl, (OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLThing(), OWLFunctionalSyntaxFactory.OWLNothing()}));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLFunctionalObjectPropertyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalObjectProperty((OWLObjectPropertyExpression)op));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLHasKeyAxiom axiom)")
    public void shouldCreateViolationForOWLHasKeyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.HasKey((OWLClassExpression)cl, (OWLPropertyExpression[])new OWLPropertyExpression[]{op}));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLInverseFunctionalObjectPropertyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{p});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.InverseFunctionalObjectProperty((OWLObjectPropertyExpression)p));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLInverseObjectPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLInverseObjectPropertiesAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{p});
        OWLObjectProperty p1 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#objectproperty"));
        this.declare(o, new OWLEntity[]{p1});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.InverseObjectProperties((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)p1));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLIrreflexiveObjectPropertyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{p});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.IrreflexiveObjectProperty((OWLObjectPropertyExpression)p));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSymmetricObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLSymmetricObjectPropertyAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{p});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SymmetricObjectProperty((OWLObjectPropertyExpression)p));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(SWRLRule rule)")
    public void shouldCreateViolationForSWRLRuleInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)df.getSWRLRule(new HashSet(), new HashSet()));
        OWL2ELProfile profile = new OWL2ELProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubPropertyChainOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubPropertyChainOfAxiomInOWL2ELProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWL2ELProfile profile = new OWL2ELProfile();
        OWLObjectProperty op1 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#op1"));
        OWLObjectProperty op2 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#op"));
        this.declare(o, new OWLEntity[]{op1, op, op2, cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)cl));
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op2, op1), (OWLObjectPropertyExpression)op));
        int expected = 1;
        Class[] expectedViolations = new Class[]{LastPropertyInChainNotInImposedRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatype node)")
    public void shouldCreateViolationForOWLDatatypeInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{fakedatatype});
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLAnonymousIndividual individual)")
    public void shouldCreateViolationForOWLAnonymousIndividualInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWL2QLProfile profile = new OWL2QLProfile();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing(), (OWLIndividual)df.getOWLAnonymousIndividual()));
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfAnonymousIndividual.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLHasKeyAxiom axiom)")
    public void shouldCreateViolationForOWLHasKeyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.HasKey((OWLClassExpression)cl, (OWLPropertyExpression[])new OWLPropertyExpression[]{op}));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubClassOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubClassOfAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLNothing()), (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLThing(), OWLFunctionalSyntaxFactory.OWLNothing()})));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class, UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentClassesAxiom axiom)")
    public void shouldCreateViolationForOWLEquivalentClassesAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentClasses((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLNothing(), OWLFunctionalSyntaxFactory.OWLThing()}), OWLFunctionalSyntaxFactory.OWLNothing()}));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointClassesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointClassesAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWL2QLProfile profile = new OWL2QLProfile();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointClasses((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), OWLFunctionalSyntaxFactory.OWLThing()}));
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectPropertyDomainAxiom axiom)")
    public void shouldCreateViolationForOWLObjectPropertyDomainAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyDomain((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLNothing(), OWLFunctionalSyntaxFactory.OWLThing()})));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectPropertyRangeAxiom axiom)")
    public void shouldCreateViolationForOWLObjectPropertyRangeAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectUnionOf((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLNothing(), OWLFunctionalSyntaxFactory.OWLThing()})));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubPropertyChainOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubPropertyChainOfAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLObjectProperty op1 = OWLFunctionalSyntaxFactory.ObjectProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#op"));
        this.declare(o, new OWLEntity[]{op, op1});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubPropertyChainOf(Arrays.asList(op, op1), (OWLObjectPropertyExpression)op));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLFunctionalObjectPropertyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalObjectProperty((OWLObjectPropertyExpression)op));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLInverseFunctionalObjectPropertyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.InverseFunctionalObjectProperty((OWLObjectPropertyExpression)op));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLTransitiveObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLTransitiveObjectPropertyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.TransitiveObjectProperty((OWLObjectPropertyExpression)op));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLFunctionalDataPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLFunctionalDataPropertyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalDataProperty((OWLDataPropertyExpression)datap));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataPropertyDomainAxiom axiom)")
    public void shouldCreateViolationForOWLDataPropertyDomainAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyDomain((OWLDataPropertyExpression)datap, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMaxCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLNothing())));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLClassAssertionAxiom axiom)")
    public void shouldCreateViolationForOWLClassAssertionAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLNamedIndividual i = OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i"));
        this.declare(o, new OWLEntity[]{op, i});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectSomeValuesFrom((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), (OWLIndividual)i));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonAtomicClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSameIndividualAxiom axiom)")
    public void shouldCreateViolationForOWLSameIndividualAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SameIndividual((OWLIndividual[])new OWLIndividual[]{OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#individual1")), OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#individual2"))}));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLNegativeObjectPropertyAssertionAxiom axiom)")
    public void shouldCreateViolationForOWLNegativeObjectPropertyAssertionAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        OWLNamedIndividual i = OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i"));
        OWLNamedIndividual i1 = OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i"));
        this.declare(o, new OWLEntity[]{i, i1});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.NegativeObjectPropertyAssertion((OWLObjectPropertyExpression)op, (OWLIndividual)i, (OWLIndividual)i1));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLNegativeDataPropertyAssertionAxiom axiom)")
    public void shouldCreateViolationForOWLNegativeDataPropertyAssertionAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        OWLNamedIndividual i = OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i"));
        this.declare(o, new OWLEntity[]{i});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.NegativeDataPropertyAssertion((OWLDataPropertyExpression)datap, (OWLIndividual)i, (OWLLiteral)OWLFunctionalSyntaxFactory.Literal((int)1)));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointUnionAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointUnionAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointUnion((OWLClass)cl, (OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLThing(), OWLFunctionalSyntaxFactory.OWLNothing()}));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLIrreflexiveObjectPropertyAxiomInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.IrreflexiveObjectProperty((OWLObjectPropertyExpression)op));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(SWRLRule rule)")
    public void shouldCreateViolationForSWRLRuleInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)df.getSWRLRule(new HashSet(), new HashSet()));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataComplementOf node)")
    public void shouldCreateViolationForOWLDataComplementOfInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataComplementOf((OWLDataRange)OWLFunctionalSyntaxFactory.Integer())));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataOneOf node)")
    public void shouldCreateViolationForOWLDataOneOfInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataOneOf((OWLLiteral[])new OWLLiteral[]{OWLFunctionalSyntaxFactory.Literal((int)1), OWLFunctionalSyntaxFactory.Literal((int)2)})));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeRestriction node)")
    public void shouldCreateViolationForOWLDatatypeRestrictionInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)DATA_PROPERTY_RANGE);
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataUnionOf node)")
    public void shouldCreateViolationForOWLDataUnionOfInOWL2QLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataUnionOf((OWLDataRange[])new OWLDataRange[]{OWLFunctionalSyntaxFactory.Integer(), OWLFunctionalSyntaxFactory.Boolean()})));
        OWL2QLProfile profile = new OWL2QLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class, UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLClassAssertionAxiom axiom)")
    public void shouldCreateViolationForOWLClassAssertionAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ClassAssertion((OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), (OWLIndividual)OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#i"))));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataPropertyDomainAxiom axiom)")
    public void shouldCreateViolationForOWLDataPropertyDomainAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyDomain((OWLDataPropertyExpression)datap, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointClassesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointClassesAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointClasses((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), OWLFunctionalSyntaxFactory.OWLThing()}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class, UseOfNonSubClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointDataPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointDataPropertiesAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLDataProperty dp = OWLFunctionalSyntaxFactory.DataProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#dproperty"));
        this.declare(o, new OWLEntity[]{datap, dp});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointDataProperties((OWLDataPropertyExpression[])new OWLDataPropertyExpression[]{datap, dp}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDisjointUnionAxiom axiom)")
    public void shouldCreateViolationForOWLDisjointUnionAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DisjointUnion((OWLClass)cl, (OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.OWLThing(), OWLFunctionalSyntaxFactory.OWLNothing()}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentClassesAxiom axiom)")
    public void shouldCreateViolationForOWLEquivalentClassesAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentClasses((OWLClassExpression[])new OWLClassExpression[]{OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), OWLFunctionalSyntaxFactory.OWLNothing()}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonEquivalentClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLEquivalentDataPropertiesAxiom axiom)")
    public void shouldCreateViolationForOWLEquivalentDataPropertiesAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLDataProperty dp = OWLFunctionalSyntaxFactory.DataProperty((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#test"));
        this.declare(o, new OWLEntity[]{datap, dp});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.EquivalentDataProperties((OWLDataPropertyExpression[])new OWLDataPropertyExpression[]{datap, dp}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Ignore
    @Test
    @Tests(method="public Object visit(OWLFunctionalDataPropertyAxiom axiom)")
    public void shouldCreateViolationForOWLFunctionalDataPropertyAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.FunctionalDataProperty((OWLDataPropertyExpression)datap));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{Object.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLHasKeyAxiom axiom)")
    public void shouldCreateViolationForOWLHasKeyAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{cl, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.HasKey((OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)cl), (OWLPropertyExpression[])new OWLPropertyExpression[]{op}));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectPropertyDomainAxiom axiom)")
    public void shouldCreateViolationForOWLObjectPropertyDomainAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op, op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyDomain((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLObjectPropertyRangeAxiom axiom)")
    public void shouldCreateViolationForOWLObjectPropertyRangeAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{op});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.ObjectPropertyRange((OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectMinCardinality((int)1, (OWLObjectPropertyExpression)op, (OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing())));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLSubClassOfAxiom axiom)")
    public void shouldCreateViolationForOWLSubClassOfAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.SubClassOf((OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectComplementOf((OWLClassExpression)OWLFunctionalSyntaxFactory.OWLThing()), (OWLClassExpression)OWLFunctionalSyntaxFactory.ObjectOneOf((OWLIndividual[])new OWLIndividual[]{OWLFunctionalSyntaxFactory.NamedIndividual((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#test"))})));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{UseOfNonSubClassExpression.class, UseOfNonSuperClassExpression.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(SWRLRule rule)")
    public void shouldCreateViolationForSWRLRuleInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        m.addAxiom(o, (OWLAxiom)df.getSWRLRule(new HashSet(), new HashSet()));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Ignore
    @Test
    @Tests(method="public Object visit(OWLDataComplementOf node)")
    public void shouldCreateViolationForOWLDataComplementOfInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 2;
        Class[] expectedViolations = new Class[]{Object.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataIntersectionOf node)")
    public void shouldCreateViolationForOWLDataIntersectionOfInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataIntersectionOf((OWLDataRange[])new OWLDataRange[]{OWLFunctionalSyntaxFactory.Integer(), OWLFunctionalSyntaxFactory.Boolean()})));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataOneOf node)")
    public void shouldCreateViolationForOWLDataOneOfInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataOneOf((OWLLiteral[])new OWLLiteral[]{OWLFunctionalSyntaxFactory.Literal((int)1), OWLFunctionalSyntaxFactory.Literal((int)2)})));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatype node)")
    public void shouldCreateViolationForOWLDatatypeInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        this.declare(o, new OWLEntity[]{OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#test"))});
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeRestriction node)")
    public void shouldCreateViolationForOWLDatatypeRestrictionInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)DATA_PROPERTY_RANGE);
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDataUnionOf node)")
    public void shouldCreateViolationForOWLDataUnionOfInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        this.declare(o, new OWLEntity[]{datap});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DataPropertyRange((OWLDataPropertyExpression)datap, (OWLDataRange)OWLFunctionalSyntaxFactory.DataUnionOf((OWLDataRange[])new OWLDataRange[]{OWLFunctionalSyntaxFactory.Double(), OWLFunctionalSyntaxFactory.Integer()})));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 1;
        Class[] expectedViolations = new Class[]{UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    @Test
    @Tests(method="public Object visit(OWLDatatypeDefinitionAxiom axiom)")
    public void shouldCreateViolationForOWLDatatypeDefinitionAxiomInOWL2RLProfile() throws Exception {
        OWLOntology o = this.createOnto();
        OWLOntologyManager m = o.getOWLOntologyManager();
        OWLDatatype datatype = OWLFunctionalSyntaxFactory.Datatype((IRI)OWLFunctionalSyntaxFactory.IRI((String)"urn:test#datatype"));
        this.declare(o, new OWLEntity[]{datatype});
        m.addAxiom(o, (OWLAxiom)OWLFunctionalSyntaxFactory.DatatypeDefinition((OWLDatatype)datatype, (OWLDataRange)OWLFunctionalSyntaxFactory.Boolean()));
        OWL2RLProfile profile = new OWL2RLProfile();
        int expected = 3;
        Class[] expectedViolations = new Class[]{UseOfIllegalAxiom.class, UseOfIllegalDataRange.class, UseOfIllegalDataRange.class};
        this.runAssert(o, (OWLProfile)profile, expected, expectedViolations);
    }

    private OWLOntology createOnto() throws OWLOntologyCreationException {
        return OWLManager.createOWLOntologyManager().createOntology(onto);
    }
}

