/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapitools.builders.BuilderAnnotation;
import org.semanticweb.owlapitools.builders.BuilderAnnotationAssertion;
import org.semanticweb.owlapitools.builders.BuilderAnnotationProperty;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderAnonymousIndividual;
import org.semanticweb.owlapitools.builders.BuilderAsymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderClass;
import org.semanticweb.owlapitools.builders.BuilderClassAssertion;
import org.semanticweb.owlapitools.builders.BuilderComplementOf;
import org.semanticweb.owlapitools.builders.BuilderDataAllValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderDataComplementOf;
import org.semanticweb.owlapitools.builders.BuilderDataExactCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataHasValue;
import org.semanticweb.owlapitools.builders.BuilderDataIntersectionOf;
import org.semanticweb.owlapitools.builders.BuilderDataMaxCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataMinCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataOneOf;
import org.semanticweb.owlapitools.builders.BuilderDataProperty;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderDataSomeValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderDataUnionOf;
import org.semanticweb.owlapitools.builders.BuilderDatatype;
import org.semanticweb.owlapitools.builders.BuilderDatatypeDefinition;
import org.semanticweb.owlapitools.builders.BuilderDatatypeRestriction;
import org.semanticweb.owlapitools.builders.BuilderDeclaration;
import org.semanticweb.owlapitools.builders.BuilderDifferentIndividuals;
import org.semanticweb.owlapitools.builders.BuilderDisjointClasses;
import org.semanticweb.owlapitools.builders.BuilderDisjointDataProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointUnion;
import org.semanticweb.owlapitools.builders.BuilderEntity;
import org.semanticweb.owlapitools.builders.BuilderEquivalentClasses;
import org.semanticweb.owlapitools.builders.BuilderEquivalentDataProperties;
import org.semanticweb.owlapitools.builders.BuilderEquivalentObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderFacetRestriction;
import org.semanticweb.owlapitools.builders.BuilderFunctionalDataProperty;
import org.semanticweb.owlapitools.builders.BuilderFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderHasKey;
import org.semanticweb.owlapitools.builders.BuilderImportsDeclaration;
import org.semanticweb.owlapitools.builders.BuilderInverseFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderInverseObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderIrreflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderLiteral;
import org.semanticweb.owlapitools.builders.BuilderNamedIndividual;
import org.semanticweb.owlapitools.builders.BuilderNegativeDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderNegativeObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectAllValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderObjectExactCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectHasSelf;
import org.semanticweb.owlapitools.builders.BuilderObjectHasValue;
import org.semanticweb.owlapitools.builders.BuilderObjectIntersectionOf;
import org.semanticweb.owlapitools.builders.BuilderObjectInverseOf;
import org.semanticweb.owlapitools.builders.BuilderObjectMaxCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectMinCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderObjectSomeValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderOneOf;
import org.semanticweb.owlapitools.builders.BuilderPropertyChain;
import org.semanticweb.owlapitools.builders.BuilderReflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSWRLBuiltInAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLClassAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDataPropertyAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDataRangeAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDifferentIndividualsAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLIndividualArgument;
import org.semanticweb.owlapitools.builders.BuilderSWRLLiteralArgument;
import org.semanticweb.owlapitools.builders.BuilderSWRLObjectPropertyAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLRule;
import org.semanticweb.owlapitools.builders.BuilderSWRLSameIndividualAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLVariable;
import org.semanticweb.owlapitools.builders.BuilderSameIndividual;
import org.semanticweb.owlapitools.builders.BuilderSubAnnotationPropertyOf;
import org.semanticweb.owlapitools.builders.BuilderSubClass;
import org.semanticweb.owlapitools.builders.BuilderSubDataProperty;
import org.semanticweb.owlapitools.builders.BuilderSubObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderTransitiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderUnionOf;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class BuildersTestCase {
    private OWLDataFactory df = new OWLDataFactoryImpl();
    private OWLAnnotationProperty ap = this.df.getOWLAnnotationProperty(IRI.create((String)"urn:test#ann"));
    private OWLObjectProperty op = this.df.getOWLObjectProperty(IRI.create((String)"urn:test#op"));
    private OWLDataProperty dp = this.df.getOWLDataProperty(IRI.create((String)"urn:test#dp"));
    private OWLLiteral lit = this.df.getOWLLiteral(false);
    private IRI iri = IRI.create((String)"urn:test#iri");
    private Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(Arrays.asList(this.df.getOWLAnnotation(this.ap, (OWLAnnotationValue)this.df.getOWLLiteral("test"))));
    private OWLClass ce = this.df.getOWLClass(IRI.create((String)"urn:test#c"));
    private OWLNamedIndividual i = this.df.getOWLNamedIndividual(IRI.create((String)"urn:test#i"));
    private OWLDatatype d = this.df.getBooleanOWLDatatype();
    private Set<OWLDataProperty> dps = new HashSet<OWLDataProperty>(Arrays.asList(this.df.getOWLDataProperty(this.iri), this.dp));
    private Set<OWLObjectProperty> ops = new HashSet<OWLObjectProperty>(Arrays.asList(this.df.getOWLObjectProperty(this.iri), this.op));
    private Set<OWLClass> classes = new HashSet<OWLClass>(Arrays.asList(this.df.getOWLClass(this.iri), this.ce));
    private Set<OWLIndividual> inds = new HashSet<OWLNamedIndividual>(Arrays.asList(this.i, this.df.getOWLNamedIndividual(this.iri)));
    private SWRLDArgument var1 = this.df.getSWRLVariable(IRI.create((String)"var1"));
    private SWRLIArgument var2 = this.df.getSWRLVariable(IRI.create((String)"var2"));
    private SWRLAtom v1 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v1"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var3")), this.df.getSWRLVariable(IRI.create((String)"var4"))));
    private SWRLAtom v2 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v2"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var5")), this.df.getSWRLVariable(IRI.create((String)"var6"))));
    private Set<SWRLAtom> body = new HashSet<SWRLAtom>(Arrays.asList(this.v1));
    private Set<SWRLAtom> head = new HashSet<SWRLAtom>(Arrays.asList(this.v2));

    @Test
    public void shouldBuildAnnotation() {
        BuilderAnnotation builder = ((BuilderAnnotation)new BuilderAnnotation().withProperty(this.ap)).withValue((OWLAnnotationValue)this.lit);
        OWLAnnotation expected = this.df.getOWLAnnotation(this.ap, (OWLAnnotationValue)this.lit);
        OWLAnnotation built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationAssertion() {
        BuilderAnnotationAssertion builder = ((BuilderAnnotationAssertion)((BuilderAnnotationAssertion)new BuilderAnnotationAssertion().withAnnotations(this.annotations)).withProperty(this.ap)).withSubject((OWLAnnotationSubject)this.iri).withValue((OWLAnnotationValue)this.lit);
        OWLAnnotationAssertionAxiom expected = this.df.getOWLAnnotationAssertionAxiom(this.ap, (OWLAnnotationSubject)this.iri, (OWLAnnotationValue)this.lit, this.annotations);
        OWLAnnotationAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationProperty() {
        BuilderAnnotationProperty builder = (BuilderAnnotationProperty)new BuilderAnnotationProperty().withIRI(this.iri);
        OWLAnnotationProperty expected = this.df.getOWLAnnotationProperty(this.iri);
        OWLAnnotationProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationPropertyDomain() {
        BuilderAnnotationPropertyDomain builder = (BuilderAnnotationPropertyDomain)((BuilderAnnotationPropertyDomain)new BuilderAnnotationPropertyDomain().withProperty(this.ap)).withDomain(this.iri).withAnnotations(this.annotations);
        OWLAnnotationPropertyDomainAxiom expected = this.df.getOWLAnnotationPropertyDomainAxiom(this.ap, this.iri, this.annotations);
        OWLAnnotationPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationPropertyRange() {
        BuilderAnnotationPropertyRange builder = (BuilderAnnotationPropertyRange)((BuilderAnnotationPropertyRange)new BuilderAnnotationPropertyRange().withProperty(this.ap)).withRange(this.iri).withAnnotations(this.annotations);
        OWLAnnotationPropertyRangeAxiom expected = this.df.getOWLAnnotationPropertyRangeAxiom(this.ap, this.iri, this.annotations);
        OWLAnnotationPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnonymousIndividual() {
        BuilderAnonymousIndividual builder = new BuilderAnonymousIndividual().withId("id");
        OWLAnonymousIndividual expected = this.df.getOWLAnonymousIndividual("id");
        OWLAnonymousIndividual built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAsymmetricObjectProperty() {
        BuilderAsymmetricObjectProperty builder = (BuilderAsymmetricObjectProperty)((BuilderAsymmetricObjectProperty)new BuilderAsymmetricObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLAsymmetricObjectPropertyAxiom expected = this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLAsymmetricObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildClass() {
        BuilderClass builder = (BuilderClass)new BuilderClass().withIRI(this.iri);
        OWLClass expected = this.df.getOWLClass(this.iri);
        OWLClass built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildClassAssertion() {
        BuilderClassAssertion builder = (BuilderClassAssertion)new BuilderClassAssertion().withClass((OWLClassExpression)this.ce).withIndividual((OWLIndividual)this.i).withAnnotations(this.annotations);
        OWLClassAssertionAxiom expected = this.df.getOWLClassAssertionAxiom((OWLClassExpression)this.ce, (OWLIndividual)this.i, this.annotations);
        OWLClassAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildComplementOf() {
        BuilderComplementOf builder = new BuilderComplementOf().withClass((OWLClassExpression)this.ce);
        OWLObjectComplementOf expected = this.df.getOWLObjectComplementOf((OWLClassExpression)this.ce);
        OWLObjectComplementOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataAllValuesFrom() {
        BuilderDataAllValuesFrom builder = (BuilderDataAllValuesFrom)((BuilderDataAllValuesFrom)new BuilderDataAllValuesFrom().withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d);
        OWLDataAllValuesFrom expected = this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        OWLDataAllValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataComplementOf() {
        BuilderDataComplementOf builder = new BuilderDataComplementOf().withRange((OWLDataRange)this.d);
        OWLDataComplementOf expected = this.df.getOWLDataComplementOf((OWLDataRange)this.d);
        OWLDataComplementOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataExactCardinality() {
        BuilderDataExactCardinality builder = (BuilderDataExactCardinality)((BuilderDataExactCardinality)new BuilderDataExactCardinality().withCardinality(1).withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d);
        OWLDataExactCardinality expected = this.df.getOWLDataExactCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        OWLDataExactCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataHasValue() {
        BuilderDataHasValue builder = ((BuilderDataHasValue)new BuilderDataHasValue().withProperty((OWLDataPropertyExpression)this.dp)).withLiteral(this.lit);
        OWLDataHasValue expected = this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.dp, this.lit);
        OWLDataHasValue built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataIntersectionOf() {
        BuilderDataIntersectionOf builder = (BuilderDataIntersectionOf)((BuilderDataIntersectionOf)new BuilderDataIntersectionOf().withItem((Object)this.d)).withItem((Object)this.df.getFloatOWLDatatype());
        OWLDataIntersectionOf expected = this.df.getOWLDataIntersectionOf(new OWLDataRange[]{this.d, this.df.getFloatOWLDatatype()});
        OWLDataIntersectionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataMaxCardinality() {
        BuilderDataMaxCardinality builder = (BuilderDataMaxCardinality)((BuilderDataMaxCardinality)new BuilderDataMaxCardinality().withCardinality(1).withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d);
        OWLDataMaxCardinality expected = this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        OWLDataMaxCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataMinCardinality() {
        BuilderDataMinCardinality builder = (BuilderDataMinCardinality)((BuilderDataMinCardinality)new BuilderDataMinCardinality().withCardinality(1).withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d);
        OWLDataMinCardinality expected = this.df.getOWLDataMinCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        OWLDataMinCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataOneOf() {
        BuilderDataOneOf builder = (BuilderDataOneOf)new BuilderDataOneOf().withItem((Object)this.lit);
        OWLDataOneOf expected = this.df.getOWLDataOneOf(new OWLLiteral[]{this.lit});
        OWLDataOneOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataProperty() {
        BuilderDataProperty builder = (BuilderDataProperty)new BuilderDataProperty().withIRI(this.iri);
        OWLDataProperty expected = this.df.getOWLDataProperty(this.iri);
        OWLDataProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyAssertion() {
        BuilderDataPropertyAssertion builder = (BuilderDataPropertyAssertion)((BuilderDataPropertyAssertion)new BuilderDataPropertyAssertion().withProperty((OWLDataPropertyExpression)this.dp)).withSubject((OWLIndividual)this.i).withValue(this.lit).withAnnotations(this.annotations);
        OWLDataPropertyAssertionAxiom expected = this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        OWLDataPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyDomain() {
        BuilderDataPropertyDomain builder = (BuilderDataPropertyDomain)((BuilderDataPropertyDomain)((BuilderDataPropertyDomain)new BuilderDataPropertyDomain().withProperty((Object)this.dp)).withDomain((OWLClassExpression)this.ce)).withAnnotations(this.annotations);
        OWLDataPropertyDomainAxiom expected = this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.dp, (OWLClassExpression)this.ce, this.annotations);
        OWLDataPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyRange() {
        BuilderDataPropertyRange builder = (BuilderDataPropertyRange)((BuilderDataPropertyRange)((BuilderDataPropertyRange)new BuilderDataPropertyRange().withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d)).withAnnotations(this.annotations);
        OWLDataPropertyRangeAxiom expected = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d, this.annotations);
        OWLDataPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataSomeValuesFrom() {
        BuilderDataSomeValuesFrom builder = (BuilderDataSomeValuesFrom)((BuilderDataSomeValuesFrom)new BuilderDataSomeValuesFrom().withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d);
        OWLDataSomeValuesFrom expected = this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        OWLDataSomeValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatype() {
        BuilderDatatype builder = (BuilderDatatype)((BuilderDatatype)new BuilderDatatype().withIRI(this.iri)).withAnnotations(this.annotations);
        OWLDatatype expected = this.df.getOWLDatatype(this.iri);
        OWLDatatype built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatypeDefinition() {
        BuilderDatatypeDefinition builder = (BuilderDatatypeDefinition)new BuilderDatatypeDefinition().with(this.d).withType((OWLDataRange)this.df.getDoubleOWLDatatype()).withAnnotations(this.annotations);
        OWLDatatypeDefinitionAxiom expected = this.df.getOWLDatatypeDefinitionAxiom(this.d, (OWLDataRange)this.df.getDoubleOWLDatatype(), this.annotations);
        OWLDatatypeDefinitionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatypeRestriction() {
        OWLFacetRestriction r = this.df.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, this.lit);
        BuilderDatatypeRestriction builder = ((BuilderDatatypeRestriction)new BuilderDatatypeRestriction().withItem((Object)r)).withDatatype(this.d);
        OWLDatatypeRestriction expected = this.df.getOWLDatatypeRestriction(this.d, new OWLFacetRestriction[]{r});
        OWLDatatypeRestriction built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataUnionOf() {
        BuilderDataUnionOf builder = (BuilderDataUnionOf)((BuilderDataUnionOf)new BuilderDataUnionOf().withItem((Object)this.d)).withItem((Object)this.df.getDoubleOWLDatatype());
        OWLDataUnionOf expected = this.df.getOWLDataUnionOf(new OWLDataRange[]{this.d, this.df.getDoubleOWLDatatype()});
        OWLDataUnionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDeclaration() {
        BuilderDeclaration builder = (BuilderDeclaration)new BuilderDeclaration().withEntity((OWLEntity)this.ce).withAnnotations(this.annotations);
        OWLDeclarationAxiom expected = this.df.getOWLDeclarationAxiom((OWLEntity)this.ce, this.annotations);
        OWLDeclarationAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDifferentIndividuals() {
        BuilderDifferentIndividuals builder = (BuilderDifferentIndividuals)((BuilderDifferentIndividuals)new BuilderDifferentIndividuals().withItem((Object)this.i)).withItem((Object)this.df.getOWLNamedIndividual(this.iri));
        OWLDifferentIndividualsAxiom expected = this.df.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{this.i, this.df.getOWLNamedIndividual(this.iri)});
        OWLDifferentIndividualsAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointClasses() {
        BuilderDisjointClasses builder = (BuilderDisjointClasses)((BuilderDisjointClasses)new BuilderDisjointClasses().withItem((Object)this.ce)).withItem((Object)this.df.getOWLClass(this.iri));
        OWLDisjointClassesAxiom expected = this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{this.ce, this.df.getOWLClass(this.iri)});
        OWLDisjointClassesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointDataProperties() {
        BuilderDisjointDataProperties builder = (BuilderDisjointDataProperties)((BuilderDisjointDataProperties)new BuilderDisjointDataProperties().withItems(this.dps)).withAnnotations(this.annotations);
        OWLDisjointDataPropertiesAxiom expected = this.df.getOWLDisjointDataPropertiesAxiom(this.dps, this.annotations);
        OWLDisjointDataPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointObjectProperties() {
        BuilderDisjointObjectProperties builder = (BuilderDisjointObjectProperties)((BuilderDisjointObjectProperties)new BuilderDisjointObjectProperties().withItems(this.ops)).withAnnotations(this.annotations);
        OWLDisjointObjectPropertiesAxiom expected = this.df.getOWLDisjointObjectPropertiesAxiom(this.ops, this.annotations);
        OWLDisjointObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointUnion() {
        BuilderDisjointUnion builder = (BuilderDisjointUnion)((BuilderDisjointUnion)new BuilderDisjointUnion().withClass(this.ce).withItems(this.classes)).withAnnotations(this.annotations);
        OWLDisjointUnionAxiom expected = this.df.getOWLDisjointUnionAxiom(this.ce, this.classes, this.annotations);
        OWLDisjointUnionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEntity() {
        BuilderEntity builder = ((BuilderEntity)new BuilderEntity().withIRI(this.iri)).withType(EntityType.CLASS);
        OWLClass expected = this.df.getOWLClass(this.iri);
        OWLEntity built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentClasses() {
        BuilderEquivalentClasses builder = (BuilderEquivalentClasses)((BuilderEquivalentClasses)new BuilderEquivalentClasses().withItems(this.classes)).withAnnotations(this.annotations);
        OWLEquivalentClassesAxiom expected = this.df.getOWLEquivalentClassesAxiom(this.classes, this.annotations);
        OWLEquivalentClassesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentDataProperties() {
        BuilderEquivalentDataProperties builder = (BuilderEquivalentDataProperties)((BuilderEquivalentDataProperties)new BuilderEquivalentDataProperties().withItems(this.dps)).withAnnotations(this.annotations);
        OWLEquivalentDataPropertiesAxiom expected = this.df.getOWLEquivalentDataPropertiesAxiom(this.dps, this.annotations);
        OWLEquivalentDataPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentObjectProperties() {
        BuilderEquivalentObjectProperties builder = (BuilderEquivalentObjectProperties)((BuilderEquivalentObjectProperties)new BuilderEquivalentObjectProperties().withItems(this.ops)).withAnnotations(this.annotations);
        OWLEquivalentObjectPropertiesAxiom expected = this.df.getOWLEquivalentObjectPropertiesAxiom(this.ops, this.annotations);
        OWLEquivalentObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFacetRestriction() {
        BuilderFacetRestriction builder = new BuilderFacetRestriction().withLiteral(this.lit).withFacet(OWLFacet.MAX_EXCLUSIVE);
        OWLFacetRestriction expected = this.df.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, this.lit);
        OWLFacetRestriction built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFunctionalDataProperty() {
        BuilderFunctionalDataProperty builder = (BuilderFunctionalDataProperty)((BuilderFunctionalDataProperty)new BuilderFunctionalDataProperty().withProperty((OWLDataPropertyExpression)this.dp)).withAnnotations(this.annotations);
        OWLFunctionalDataPropertyAxiom expected = this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.dp, this.annotations);
        OWLFunctionalDataPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFunctionalObjectProperty() {
        BuilderFunctionalObjectProperty builder = (BuilderFunctionalObjectProperty)((BuilderFunctionalObjectProperty)new BuilderFunctionalObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLFunctionalObjectPropertyAxiom expected = this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLFunctionalObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildHasKey() {
        BuilderHasKey builder = (BuilderHasKey)((BuilderHasKey)new BuilderHasKey().withAnnotations(this.annotations)).withClass((OWLClassExpression)this.ce).withItems(this.ops);
        OWLHasKeyAxiom expected = this.df.getOWLHasKeyAxiom((OWLClassExpression)this.ce, this.ops, this.annotations);
        OWLHasKeyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildImportsDeclarationProperty() {
        BuilderImportsDeclaration builder = new BuilderImportsDeclaration().withImportedOntology(this.iri);
        OWLImportsDeclaration expected = this.df.getOWLImportsDeclaration(this.iri);
        OWLImportsDeclaration built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildInverseFunctionalObjectProperty() {
        BuilderInverseFunctionalObjectProperty builder = (BuilderInverseFunctionalObjectProperty)((BuilderInverseFunctionalObjectProperty)new BuilderInverseFunctionalObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLInverseFunctionalObjectPropertyAxiom expected = this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLInverseFunctionalObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildInverseObjectProperties() {
        BuilderInverseObjectProperties builder = (BuilderInverseObjectProperties)((BuilderInverseObjectProperties)new BuilderInverseObjectProperties().withProperty((OWLObjectPropertyExpression)this.op)).withInverseProperty((OWLObjectPropertyExpression)this.op).withAnnotations(this.annotations);
        OWLInverseObjectPropertiesAxiom expected = this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.op, this.annotations);
        OWLInverseObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildIrreflexiveObjectProperty() {
        BuilderIrreflexiveObjectProperty builder = (BuilderIrreflexiveObjectProperty)((BuilderIrreflexiveObjectProperty)new BuilderIrreflexiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLIrreflexiveObjectPropertyAxiom expected = this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLIrreflexiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildLiteral() {
        BuilderLiteral builder = (BuilderLiteral)new BuilderLiteral().withValue(true).withAnnotations(this.annotations);
        OWLLiteral expected = this.df.getOWLLiteral(true);
        OWLLiteral built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNamedIndividual() {
        BuilderNamedIndividual builder = (BuilderNamedIndividual)new BuilderNamedIndividual().withIRI(this.iri);
        OWLNamedIndividual expected = this.df.getOWLNamedIndividual(this.iri);
        OWLNamedIndividual built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNegativeDataPropertyAssertion() {
        BuilderNegativeDataPropertyAssertion builder = ((BuilderNegativeDataPropertyAssertion)((BuilderNegativeDataPropertyAssertion)new BuilderNegativeDataPropertyAssertion().withAnnotations(this.annotations)).withProperty((OWLDataPropertyExpression)this.dp)).withValue(this.lit).withSubject((OWLIndividual)this.i);
        OWLNegativeDataPropertyAssertionAxiom expected = this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        OWLNegativeDataPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNegativeObjectPropertyAssertion() {
        BuilderNegativeObjectPropertyAssertion builder = ((BuilderNegativeObjectPropertyAssertion)((BuilderNegativeObjectPropertyAssertion)new BuilderNegativeObjectPropertyAssertion().withAnnotations(this.annotations)).withProperty((OWLObjectPropertyExpression)this.op)).withValue((OWLIndividual)this.i).withSubject((OWLIndividual)this.i);
        OWLNegativeObjectPropertyAssertionAxiom expected = this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        OWLNegativeObjectPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectAllValuesFrom() {
        BuilderObjectAllValuesFrom builder = (BuilderObjectAllValuesFrom)((BuilderObjectAllValuesFrom)new BuilderObjectAllValuesFrom().withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce);
        OWLObjectAllValuesFrom expected = this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        OWLObjectAllValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectExactCardinality() {
        BuilderObjectExactCardinality builder = (BuilderObjectExactCardinality)((BuilderObjectExactCardinality)new BuilderObjectExactCardinality().withCardinality(1).withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce);
        OWLObjectExactCardinality expected = this.df.getOWLObjectExactCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        OWLObjectExactCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectHasSelf() {
        BuilderObjectHasSelf builder = (BuilderObjectHasSelf)new BuilderObjectHasSelf().withProperty((OWLObjectPropertyExpression)this.op);
        OWLObjectHasSelf expected = this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.op);
        OWLObjectHasSelf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectHasValue() {
        BuilderObjectHasValue builder = ((BuilderObjectHasValue)new BuilderObjectHasValue().withProperty((OWLObjectPropertyExpression)this.op)).withValue((OWLIndividual)this.i);
        OWLObjectHasValue expected = this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i);
        OWLObjectHasValue built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectIntersectionOf() {
        BuilderObjectIntersectionOf builder = (BuilderObjectIntersectionOf)new BuilderObjectIntersectionOf().withItems(this.classes);
        OWLObjectIntersectionOf expected = this.df.getOWLObjectIntersectionOf(this.classes);
        OWLObjectIntersectionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectInverseOf() {
        BuilderObjectInverseOf builder = (BuilderObjectInverseOf)new BuilderObjectInverseOf().withProperty((OWLObjectPropertyExpression)this.op);
        OWLObjectInverseOf expected = this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.op);
        OWLObjectInverseOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectMaxCardinality() {
        BuilderObjectMaxCardinality builder = (BuilderObjectMaxCardinality)((BuilderObjectMaxCardinality)new BuilderObjectMaxCardinality().withCardinality(1).withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce);
        OWLObjectMaxCardinality expected = this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        OWLObjectMaxCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectMinCardinality() {
        BuilderObjectMinCardinality builder = (BuilderObjectMinCardinality)((BuilderObjectMinCardinality)new BuilderObjectMinCardinality().withCardinality(1).withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce);
        OWLObjectMinCardinality expected = this.df.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        OWLObjectMinCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectProperty() {
        BuilderObjectProperty builder = (BuilderObjectProperty)new BuilderObjectProperty().withIRI(this.iri);
        OWLObjectProperty expected = this.df.getOWLObjectProperty(this.iri);
        OWLObjectProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyAssertion() {
        BuilderObjectPropertyAssertion builder = (BuilderObjectPropertyAssertion)((BuilderObjectPropertyAssertion)new BuilderObjectPropertyAssertion().withProperty((OWLObjectPropertyExpression)this.op)).withSubject((OWLIndividual)this.i).withValue((OWLIndividual)this.i).withAnnotations(this.annotations);
        OWLObjectPropertyAssertionAxiom expected = this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        OWLObjectPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyDomain() {
        BuilderObjectPropertyDomain builder = (BuilderObjectPropertyDomain)new BuilderObjectPropertyDomain().withAnnotations(this.annotations);
        OWLObjectPropertyDomainAxiom expected = this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        ((BuilderObjectPropertyDomain)((BuilderObjectPropertyDomain)builder.withDomain((OWLClassExpression)this.ce)).withProperty((Object)this.op)).withAnnotations(this.annotations);
        OWLObjectPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyRange() {
        BuilderObjectPropertyRange builder = (BuilderObjectPropertyRange)((BuilderObjectPropertyRange)((BuilderObjectPropertyRange)new BuilderObjectPropertyRange().withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce)).withAnnotations(this.annotations);
        OWLObjectPropertyRangeAxiom expected = this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        OWLObjectPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectSomeValuesFrom() {
        BuilderObjectSomeValuesFrom builder = (BuilderObjectSomeValuesFrom)((BuilderObjectSomeValuesFrom)new BuilderObjectSomeValuesFrom().withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce);
        OWLObjectSomeValuesFrom expected = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        OWLObjectSomeValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildOneOf() {
        BuilderOneOf builder = (BuilderOneOf)new BuilderOneOf().withItem((Object)this.i);
        OWLObjectOneOf expected = this.df.getOWLObjectOneOf(new OWLIndividual[]{this.i});
        OWLObjectOneOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildPropertyChain() {
        ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>(this.ops);
        BuilderPropertyChain builder = (BuilderPropertyChain)((BuilderPropertyChain)new BuilderPropertyChain().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : chain) {
            builder.withPropertyInChain(oWLObjectPropertyExpression);
        }
        OWLSubPropertyChainOfAxiom expected = this.df.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)this.op, this.annotations);
        OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)oWLSubPropertyChainOfAxiom);
    }

    @Test
    public void shouldBuildReflexiveObjectProperty() {
        BuilderReflexiveObjectProperty builder = (BuilderReflexiveObjectProperty)((BuilderReflexiveObjectProperty)new BuilderReflexiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLReflexiveObjectPropertyAxiom expected = this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLReflexiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSameIndividual() {
        BuilderSameIndividual builder = (BuilderSameIndividual)((BuilderSameIndividual)new BuilderSameIndividual().withItems(this.inds)).withAnnotations(this.annotations);
        OWLSameIndividualAxiom expected = this.df.getOWLSameIndividualAxiom(this.inds, this.annotations);
        OWLSameIndividualAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubAnnotationPropertyOf() {
        BuilderSubAnnotationPropertyOf builder = (BuilderSubAnnotationPropertyOf)((BuilderSubAnnotationPropertyOf)((BuilderSubAnnotationPropertyOf)new BuilderSubAnnotationPropertyOf().withSub((Object)this.ap)).withSup((Object)this.df.getRDFSLabel())).withAnnotations(this.annotations);
        OWLSubAnnotationPropertyOfAxiom expected = this.df.getOWLSubAnnotationPropertyOfAxiom(this.ap, this.df.getRDFSLabel(), this.annotations);
        OWLSubAnnotationPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubClass() {
        BuilderSubClass builder = (BuilderSubClass)((BuilderSubClass)((BuilderSubClass)new BuilderSubClass().withAnnotations(this.annotations)).withSub((Object)this.ce)).withSup((Object)this.df.getOWLThing());
        OWLSubClassOfAxiom expected = this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ce, (OWLClassExpression)this.df.getOWLThing(), this.annotations);
        OWLSubClassOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubDataProperty() {
        BuilderSubDataProperty builder = (BuilderSubDataProperty)((BuilderSubDataProperty)new BuilderSubDataProperty().withSub((Object)this.dp)).withSup((Object)this.df.getOWLTopDataProperty());
        OWLSubDataPropertyOfAxiom expected = this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.dp, (OWLDataPropertyExpression)this.df.getOWLTopDataProperty());
        OWLSubDataPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubObjectProperty() {
        BuilderSubObjectProperty builder = (BuilderSubObjectProperty)((BuilderSubObjectProperty)((BuilderSubObjectProperty)new BuilderSubObjectProperty().withSub((Object)this.op)).withSup((Object)this.df.getOWLTopObjectProperty())).withAnnotations(this.annotations);
        OWLSubObjectPropertyOfAxiom expected = this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty(), this.annotations);
        OWLSubObjectPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLBuiltInAtom() {
        BuilderSWRLBuiltInAtom builder = new BuilderSWRLBuiltInAtom().with(this.iri).with(this.var1);
        SWRLBuiltInAtom expected = this.df.getSWRLBuiltInAtom(this.iri, Arrays.asList(this.var1));
        SWRLBuiltInAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLClassAtom() {
        BuilderSWRLClassAtom builder = new BuilderSWRLClassAtom().with((OWLClassExpression)this.ce).with(this.var2);
        SWRLClassAtom expected = this.df.getSWRLClassAtom((OWLClassExpression)this.ce, this.var2);
        SWRLClassAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDataPropertyAtom() {
        BuilderSWRLDataPropertyAtom builder = ((BuilderSWRLDataPropertyAtom)new BuilderSWRLDataPropertyAtom().withProperty((OWLDataPropertyExpression)this.dp)).with(this.var2).with(this.var1);
        SWRLDataPropertyAtom expected = this.df.getSWRLDataPropertyAtom((OWLDataPropertyExpression)this.dp, this.var2, this.var1);
        SWRLDataPropertyAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDataRangeAtom() {
        BuilderSWRLDataRangeAtom builder = new BuilderSWRLDataRangeAtom().with((OWLDataRange)this.d).with(this.var1);
        SWRLDataRangeAtom expected = this.df.getSWRLDataRangeAtom((OWLDataRange)this.d, this.var1);
        SWRLDataRangeAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDifferentIndividualsAtom() {
        BuilderSWRLDifferentIndividualsAtom builder = (BuilderSWRLDifferentIndividualsAtom)new BuilderSWRLDifferentIndividualsAtom().withArg0(this.var2).withArg1(this.var2).withAnnotations(this.annotations);
        SWRLDifferentIndividualsAtom expected = this.df.getSWRLDifferentIndividualsAtom(this.var2, this.var2);
        SWRLDifferentIndividualsAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLIndividualArgument() {
        BuilderSWRLIndividualArgument builder = new BuilderSWRLIndividualArgument().with((OWLIndividual)this.i);
        SWRLIndividualArgument expected = this.df.getSWRLIndividualArgument((OWLIndividual)this.i);
        SWRLIndividualArgument built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLLiteralArgument() {
        BuilderSWRLLiteralArgument builder = new BuilderSWRLLiteralArgument().with(this.lit);
        SWRLLiteralArgument expected = this.df.getSWRLLiteralArgument(this.lit);
        SWRLLiteralArgument built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLObjectPropertyAtom() {
        BuilderSWRLObjectPropertyAtom builder = ((BuilderSWRLObjectPropertyAtom)new BuilderSWRLObjectPropertyAtom().withProperty((OWLObjectPropertyExpression)this.op)).withArg0(this.var2).withArg1(this.var2);
        SWRLObjectPropertyAtom expected = this.df.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)this.op, this.var2, this.var2);
        SWRLObjectPropertyAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLRule() {
        BuilderSWRLRule builder = new BuilderSWRLRule().withBody(this.v1).withHead(this.v2);
        SWRLRule expected = this.df.getSWRLRule(this.body, this.head);
        SWRLRule built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLSameIndividualAtom() {
        BuilderSWRLSameIndividualAtom builder = new BuilderSWRLSameIndividualAtom().withArg0((SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i)).withArg1((SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i));
        SWRLSameIndividualAtom expected = this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i), (SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i));
        SWRLSameIndividualAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLVariable() {
        BuilderSWRLVariable builder = new BuilderSWRLVariable().with(this.iri);
        SWRLVariable expected = this.df.getSWRLVariable(this.iri);
        SWRLVariable built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSymmetricObjectProperty() {
        BuilderSymmetricObjectProperty builder = (BuilderSymmetricObjectProperty)((BuilderSymmetricObjectProperty)new BuilderSymmetricObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLSymmetricObjectPropertyAxiom expected = this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLSymmetricObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildTransitiveObjectProperty() {
        BuilderTransitiveObjectProperty builder = (BuilderTransitiveObjectProperty)((BuilderTransitiveObjectProperty)new BuilderTransitiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLTransitiveObjectPropertyAxiom expected = this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLTransitiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildUnionOf() {
        BuilderUnionOf builder = (BuilderUnionOf)new BuilderUnionOf().withItems(this.classes);
        OWLObjectUnionOf expected = this.df.getOWLObjectUnionOf(this.classes);
        OWLObjectUnionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }
}

