/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapitools.builders.BuilderAnnotationAssertion;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderAsymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderClassAssertion;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderDatatypeDefinition;
import org.semanticweb.owlapitools.builders.BuilderDeclaration;
import org.semanticweb.owlapitools.builders.BuilderDifferentIndividuals;
import org.semanticweb.owlapitools.builders.BuilderDisjointClasses;
import org.semanticweb.owlapitools.builders.BuilderDisjointDataProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointUnion;
import org.semanticweb.owlapitools.builders.BuilderEquivalentClasses;
import org.semanticweb.owlapitools.builders.BuilderEquivalentDataProperties;
import org.semanticweb.owlapitools.builders.BuilderEquivalentObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderFunctionalDataProperty;
import org.semanticweb.owlapitools.builders.BuilderFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderHasKey;
import org.semanticweb.owlapitools.builders.BuilderInverseFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderInverseObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderIrreflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderNegativeDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderNegativeObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderPropertyChain;
import org.semanticweb.owlapitools.builders.BuilderReflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSWRLRule;
import org.semanticweb.owlapitools.builders.BuilderSameIndividual;
import org.semanticweb.owlapitools.builders.BuilderSubAnnotationPropertyOf;
import org.semanticweb.owlapitools.builders.BuilderSubClass;
import org.semanticweb.owlapitools.builders.BuilderSubDataProperty;
import org.semanticweb.owlapitools.builders.BuilderSubObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderTransitiveObjectProperty;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class BuildersOntologyTestCase {
    private OWLDataFactory df = new OWLDataFactoryImpl();
    private OWLAnnotationProperty ap = this.df.getOWLAnnotationProperty(IRI.create((String)"urn:test#ann"));
    private OWLObjectProperty op = this.df.getOWLObjectProperty(IRI.create((String)"urn:test#op"));
    private OWLDataProperty dp = this.df.getOWLDataProperty(IRI.create((String)"urn:test#dp"));
    private OWLLiteral lit = this.df.getOWLLiteral(false);
    private IRI iri = IRI.create((String)"urn:test#iri");
    private Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(Arrays.asList(this.df.getOWLAnnotation(this.ap, (OWLAnnotationValue)this.df.getOWLLiteral("test"))));
    private OWLClass ce = this.df.getOWLClass(IRI.create((String)"urn:test#c"));
    private OWLNamedIndividual i = this.df.getOWLNamedIndividual(IRI.create((String)"urn:test#i"));
    private OWLDatatype d = this.df.getOWLDatatype(IRI.create((String)"urn:test#datatype"));
    private Set<OWLDataProperty> dps = new HashSet<OWLDataProperty>(Arrays.asList(this.df.getOWLDataProperty(this.iri), this.dp));
    private Set<OWLObjectProperty> ops = new HashSet<OWLObjectProperty>(Arrays.asList(this.df.getOWLObjectProperty(this.iri), this.op));
    private Set<OWLClass> classes = new HashSet<OWLClass>(Arrays.asList(this.df.getOWLClass(this.iri), this.ce));
    private Set<OWLIndividual> inds = new HashSet<OWLNamedIndividual>(Arrays.asList(this.i, this.df.getOWLNamedIndividual(this.iri)));
    private SWRLAtom v1 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v1"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var3")), this.df.getSWRLVariable(IRI.create((String)"var4"))));
    private SWRLAtom v2 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v2"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var5")), this.df.getSWRLVariable(IRI.create((String)"var6"))));
    private Set<SWRLAtom> body = new HashSet<SWRLAtom>(Arrays.asList(this.v1));
    private Set<SWRLAtom> head = new HashSet<SWRLAtom>(Arrays.asList(this.v2));
    private OWLOntologyManager m = OWLManager.createOWLOntologyManager();

    @Test
    public void shouldBuildAnnotationAssertion() throws OWLOntologyCreationException {
        BuilderAnnotationAssertion builder = ((BuilderAnnotationAssertion)((BuilderAnnotationAssertion)new BuilderAnnotationAssertion().withAnnotations(this.annotations)).withProperty(this.ap)).withSubject((OWLAnnotationSubject)this.iri).withValue((OWLAnnotationValue)this.lit);
        OWLAnnotationAssertionAxiom expected = this.df.getOWLAnnotationAssertionAxiom(this.ap, (OWLAnnotationSubject)this.iri, (OWLAnnotationValue)this.lit, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildAnnotationPropertyDomain() throws OWLOntologyCreationException {
        BuilderAnnotationPropertyDomain builder = (BuilderAnnotationPropertyDomain)((BuilderAnnotationPropertyDomain)new BuilderAnnotationPropertyDomain().withProperty(this.ap)).withDomain(this.iri).withAnnotations(this.annotations);
        OWLAnnotationPropertyDomainAxiom expected = this.df.getOWLAnnotationPropertyDomainAxiom(this.ap, this.iri, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildAnnotationPropertyRange() throws OWLOntologyCreationException {
        BuilderAnnotationPropertyRange builder = (BuilderAnnotationPropertyRange)((BuilderAnnotationPropertyRange)new BuilderAnnotationPropertyRange().withProperty(this.ap)).withRange(this.iri).withAnnotations(this.annotations);
        OWLAnnotationPropertyRangeAxiom expected = this.df.getOWLAnnotationPropertyRangeAxiom(this.ap, this.iri, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildAsymmetricObjectProperty() throws OWLOntologyCreationException {
        BuilderAsymmetricObjectProperty builder = (BuilderAsymmetricObjectProperty)((BuilderAsymmetricObjectProperty)new BuilderAsymmetricObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLAsymmetricObjectPropertyAxiom expected = this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildClassAssertion() throws OWLOntologyCreationException {
        BuilderClassAssertion builder = (BuilderClassAssertion)new BuilderClassAssertion().withClass((OWLClassExpression)this.ce).withIndividual((OWLIndividual)this.i).withAnnotations(this.annotations);
        OWLClassAssertionAxiom expected = this.df.getOWLClassAssertionAxiom((OWLClassExpression)this.ce, (OWLIndividual)this.i, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDataPropertyAssertion() throws OWLOntologyCreationException {
        BuilderDataPropertyAssertion builder = (BuilderDataPropertyAssertion)((BuilderDataPropertyAssertion)new BuilderDataPropertyAssertion().withProperty((OWLDataPropertyExpression)this.dp)).withSubject((OWLIndividual)this.i).withValue(this.lit).withAnnotations(this.annotations);
        OWLDataPropertyAssertionAxiom expected = this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDataPropertyDomain() throws OWLOntologyCreationException {
        BuilderDataPropertyDomain builder = (BuilderDataPropertyDomain)((BuilderDataPropertyDomain)((BuilderDataPropertyDomain)new BuilderDataPropertyDomain().withProperty((Object)this.dp)).withDomain((OWLClassExpression)this.ce)).withAnnotations(this.annotations);
        OWLDataPropertyDomainAxiom expected = this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.dp, (OWLClassExpression)this.ce, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDataPropertyRange() throws OWLOntologyCreationException {
        BuilderDataPropertyRange builder = (BuilderDataPropertyRange)((BuilderDataPropertyRange)((BuilderDataPropertyRange)new BuilderDataPropertyRange().withProperty((OWLDataPropertyExpression)this.dp)).withRange((OWLDataRange)this.d)).withAnnotations(this.annotations);
        OWLDataPropertyRangeAxiom expected = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDatatypeDefinition() throws OWLOntologyCreationException {
        BuilderDatatypeDefinition builder = (BuilderDatatypeDefinition)new BuilderDatatypeDefinition().with(this.d).withType((OWLDataRange)this.df.getDoubleOWLDatatype()).withAnnotations(this.annotations);
        OWLDatatypeDefinitionAxiom expected = this.df.getOWLDatatypeDefinitionAxiom(this.d, (OWLDataRange)this.df.getDoubleOWLDatatype(), this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDeclaration() throws OWLOntologyCreationException {
        BuilderDeclaration builder = (BuilderDeclaration)new BuilderDeclaration().withEntity((OWLEntity)this.ce).withAnnotations(this.annotations);
        OWLDeclarationAxiom expected = this.df.getOWLDeclarationAxiom((OWLEntity)this.ce, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDifferentIndividuals() throws OWLOntologyCreationException {
        BuilderDifferentIndividuals builder = (BuilderDifferentIndividuals)((BuilderDifferentIndividuals)new BuilderDifferentIndividuals().withItem((Object)this.i)).withItem((Object)this.df.getOWLNamedIndividual(this.iri));
        OWLDifferentIndividualsAxiom expected = this.df.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{this.i, this.df.getOWLNamedIndividual(this.iri)});
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDisjointClasses() throws OWLOntologyCreationException {
        BuilderDisjointClasses builder = (BuilderDisjointClasses)((BuilderDisjointClasses)new BuilderDisjointClasses().withItem((Object)this.ce)).withItem((Object)this.df.getOWLClass(this.iri));
        OWLDisjointClassesAxiom expected = this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{this.ce, this.df.getOWLClass(this.iri)});
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDisjointDataProperties() throws OWLOntologyCreationException {
        BuilderDisjointDataProperties builder = (BuilderDisjointDataProperties)((BuilderDisjointDataProperties)new BuilderDisjointDataProperties().withItems(this.dps)).withAnnotations(this.annotations);
        OWLDisjointDataPropertiesAxiom expected = this.df.getOWLDisjointDataPropertiesAxiom(this.dps, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDisjointObjectProperties() throws OWLOntologyCreationException {
        BuilderDisjointObjectProperties builder = (BuilderDisjointObjectProperties)((BuilderDisjointObjectProperties)new BuilderDisjointObjectProperties().withItems(this.ops)).withAnnotations(this.annotations);
        OWLDisjointObjectPropertiesAxiom expected = this.df.getOWLDisjointObjectPropertiesAxiom(this.ops, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildDisjointUnion() throws OWLOntologyCreationException {
        BuilderDisjointUnion builder = (BuilderDisjointUnion)((BuilderDisjointUnion)new BuilderDisjointUnion().withClass(this.ce).withItems(this.classes)).withAnnotations(this.annotations);
        OWLDisjointUnionAxiom expected = this.df.getOWLDisjointUnionAxiom(this.ce, this.classes, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildEquivalentClasses() throws OWLOntologyCreationException {
        BuilderEquivalentClasses builder = (BuilderEquivalentClasses)((BuilderEquivalentClasses)new BuilderEquivalentClasses().withItems(this.classes)).withAnnotations(this.annotations);
        OWLEquivalentClassesAxiom expected = this.df.getOWLEquivalentClassesAxiom(this.classes, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildEquivalentDataProperties() throws OWLOntologyCreationException {
        BuilderEquivalentDataProperties builder = (BuilderEquivalentDataProperties)((BuilderEquivalentDataProperties)new BuilderEquivalentDataProperties().withItems(this.dps)).withAnnotations(this.annotations);
        OWLEquivalentDataPropertiesAxiom expected = this.df.getOWLEquivalentDataPropertiesAxiom(this.dps, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildEquivalentObjectProperties() throws OWLOntologyCreationException {
        BuilderEquivalentObjectProperties builder = (BuilderEquivalentObjectProperties)((BuilderEquivalentObjectProperties)new BuilderEquivalentObjectProperties().withItems(this.ops)).withAnnotations(this.annotations);
        OWLEquivalentObjectPropertiesAxiom expected = this.df.getOWLEquivalentObjectPropertiesAxiom(this.ops, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildFunctionalDataProperty() throws OWLOntologyCreationException {
        BuilderFunctionalDataProperty builder = (BuilderFunctionalDataProperty)((BuilderFunctionalDataProperty)new BuilderFunctionalDataProperty().withProperty((OWLDataPropertyExpression)this.dp)).withAnnotations(this.annotations);
        OWLFunctionalDataPropertyAxiom expected = this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.dp, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildFunctionalObjectProperty() throws OWLOntologyCreationException {
        BuilderFunctionalObjectProperty builder = (BuilderFunctionalObjectProperty)((BuilderFunctionalObjectProperty)new BuilderFunctionalObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLFunctionalObjectPropertyAxiom expected = this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildHasKey() throws OWLOntologyCreationException {
        BuilderHasKey builder = (BuilderHasKey)((BuilderHasKey)new BuilderHasKey().withAnnotations(this.annotations)).withClass((OWLClassExpression)this.ce).withItems(this.ops);
        OWLHasKeyAxiom expected = this.df.getOWLHasKeyAxiom((OWLClassExpression)this.ce, this.ops, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildInverseFunctionalObjectProperty() throws OWLOntologyCreationException {
        BuilderInverseFunctionalObjectProperty builder = (BuilderInverseFunctionalObjectProperty)((BuilderInverseFunctionalObjectProperty)new BuilderInverseFunctionalObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLInverseFunctionalObjectPropertyAxiom expected = this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildInverseObjectProperties() throws OWLOntologyCreationException {
        BuilderInverseObjectProperties builder = (BuilderInverseObjectProperties)((BuilderInverseObjectProperties)new BuilderInverseObjectProperties().withProperty((OWLObjectPropertyExpression)this.op)).withInverseProperty((OWLObjectPropertyExpression)this.op).withAnnotations(this.annotations);
        OWLInverseObjectPropertiesAxiom expected = this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildIrreflexiveObjectProperty() throws OWLOntologyCreationException {
        BuilderIrreflexiveObjectProperty builder = (BuilderIrreflexiveObjectProperty)((BuilderIrreflexiveObjectProperty)new BuilderIrreflexiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLIrreflexiveObjectPropertyAxiom expected = this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildNegativeDataPropertyAssertion() throws OWLOntologyCreationException {
        BuilderNegativeDataPropertyAssertion builder = ((BuilderNegativeDataPropertyAssertion)((BuilderNegativeDataPropertyAssertion)new BuilderNegativeDataPropertyAssertion().withAnnotations(this.annotations)).withProperty((OWLDataPropertyExpression)this.dp)).withValue(this.lit).withSubject((OWLIndividual)this.i);
        OWLNegativeDataPropertyAssertionAxiom expected = this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildNegativeObjectPropertyAssertion() throws OWLOntologyCreationException {
        BuilderNegativeObjectPropertyAssertion builder = ((BuilderNegativeObjectPropertyAssertion)((BuilderNegativeObjectPropertyAssertion)new BuilderNegativeObjectPropertyAssertion().withAnnotations(this.annotations)).withProperty((OWLObjectPropertyExpression)this.op)).withValue((OWLIndividual)this.i).withSubject((OWLIndividual)this.i);
        OWLNegativeObjectPropertyAssertionAxiom expected = this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildObjectPropertyAssertion() throws OWLOntologyCreationException {
        BuilderObjectPropertyAssertion builder = (BuilderObjectPropertyAssertion)((BuilderObjectPropertyAssertion)new BuilderObjectPropertyAssertion().withProperty((OWLObjectPropertyExpression)this.op)).withSubject((OWLIndividual)this.i).withValue((OWLIndividual)this.i).withAnnotations(this.annotations);
        OWLObjectPropertyAssertionAxiom expected = this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildObjectPropertyDomain() throws OWLOntologyCreationException {
        BuilderObjectPropertyDomain builder = (BuilderObjectPropertyDomain)new BuilderObjectPropertyDomain().withAnnotations(this.annotations);
        OWLObjectPropertyDomainAxiom expected = this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        ((BuilderObjectPropertyDomain)((BuilderObjectPropertyDomain)builder.withDomain((OWLClassExpression)this.ce)).withProperty((Object)this.op)).withAnnotations(this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildObjectPropertyRange() throws OWLOntologyCreationException {
        BuilderObjectPropertyRange builder = (BuilderObjectPropertyRange)((BuilderObjectPropertyRange)((BuilderObjectPropertyRange)new BuilderObjectPropertyRange().withProperty((OWLObjectPropertyExpression)this.op)).withRange((OWLClassExpression)this.ce)).withAnnotations(this.annotations);
        OWLObjectPropertyRangeAxiom expected = this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildPropertyChain() throws OWLOntologyCreationException {
        ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>(this.ops);
        BuilderPropertyChain builder = (BuilderPropertyChain)((BuilderPropertyChain)new BuilderPropertyChain().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : chain) {
            builder.withPropertyInChain(oWLObjectPropertyExpression);
        }
        OWLSubPropertyChainOfAxiom expected = this.df.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology oWLOntology = this.m.createOntology();
        builder.buildChanges(oWLOntology);
        Assert.assertTrue((boolean)oWLOntology.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildReflexiveObjectProperty() throws OWLOntologyCreationException {
        BuilderReflexiveObjectProperty builder = (BuilderReflexiveObjectProperty)((BuilderReflexiveObjectProperty)new BuilderReflexiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLReflexiveObjectPropertyAxiom expected = this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSameIndividual() throws OWLOntologyCreationException {
        BuilderSameIndividual builder = (BuilderSameIndividual)((BuilderSameIndividual)new BuilderSameIndividual().withItems(this.inds)).withAnnotations(this.annotations);
        OWLSameIndividualAxiom expected = this.df.getOWLSameIndividualAxiom(this.inds, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSubAnnotationPropertyOf() throws OWLOntologyCreationException {
        BuilderSubAnnotationPropertyOf builder = (BuilderSubAnnotationPropertyOf)((BuilderSubAnnotationPropertyOf)((BuilderSubAnnotationPropertyOf)new BuilderSubAnnotationPropertyOf().withSub((Object)this.ap)).withSup((Object)this.df.getRDFSLabel())).withAnnotations(this.annotations);
        OWLSubAnnotationPropertyOfAxiom expected = this.df.getOWLSubAnnotationPropertyOfAxiom(this.ap, this.df.getRDFSLabel(), this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSubClass() throws OWLOntologyCreationException {
        BuilderSubClass builder = (BuilderSubClass)((BuilderSubClass)((BuilderSubClass)new BuilderSubClass().withAnnotations(this.annotations)).withSub((Object)this.ce)).withSup((Object)this.df.getOWLThing());
        OWLSubClassOfAxiom expected = this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ce, (OWLClassExpression)this.df.getOWLThing(), this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSubDataProperty() throws OWLOntologyCreationException {
        BuilderSubDataProperty builder = (BuilderSubDataProperty)((BuilderSubDataProperty)new BuilderSubDataProperty().withSub((Object)this.dp)).withSup((Object)this.df.getOWLTopDataProperty());
        OWLSubDataPropertyOfAxiom expected = this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.dp, (OWLDataPropertyExpression)this.df.getOWLTopDataProperty());
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSubObjectProperty() throws OWLOntologyCreationException {
        BuilderSubObjectProperty builder = (BuilderSubObjectProperty)((BuilderSubObjectProperty)((BuilderSubObjectProperty)new BuilderSubObjectProperty().withSub((Object)this.op)).withSup((Object)this.df.getOWLTopObjectProperty())).withAnnotations(this.annotations);
        OWLSubObjectPropertyOfAxiom expected = this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty(), this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSWRLRule() throws OWLOntologyCreationException {
        BuilderSWRLRule builder = new BuilderSWRLRule().withBody(this.v1).withHead(this.v2);
        SWRLRule expected = this.df.getSWRLRule(this.body, this.head);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildSymmetricObjectProperty() throws OWLOntologyCreationException {
        BuilderSymmetricObjectProperty builder = (BuilderSymmetricObjectProperty)((BuilderSymmetricObjectProperty)new BuilderSymmetricObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLSymmetricObjectPropertyAxiom expected = this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }

    @Test
    public void shouldBuildTransitiveObjectProperty() throws OWLOntologyCreationException {
        BuilderTransitiveObjectProperty builder = (BuilderTransitiveObjectProperty)((BuilderTransitiveObjectProperty)new BuilderTransitiveObjectProperty().withProperty((OWLObjectPropertyExpression)this.op)).withAnnotations(this.annotations);
        OWLTransitiveObjectPropertyAxiom expected = this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        OWLOntology o = this.m.createOntology();
        builder.buildChanges(o);
        Assert.assertTrue((boolean)o.containsAxiom((OWLAxiom)expected));
    }
}

