/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapitools.builders.BuilderAnnotation;
import org.semanticweb.owlapitools.builders.BuilderAnnotationAssertion;
import org.semanticweb.owlapitools.builders.BuilderAnnotationProperty;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderAnnotationPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderAnonymousIndividual;
import org.semanticweb.owlapitools.builders.BuilderAsymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderClass;
import org.semanticweb.owlapitools.builders.BuilderClassAssertion;
import org.semanticweb.owlapitools.builders.BuilderComplementOf;
import org.semanticweb.owlapitools.builders.BuilderDataAllValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderDataComplementOf;
import org.semanticweb.owlapitools.builders.BuilderDataExactCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataHasValue;
import org.semanticweb.owlapitools.builders.BuilderDataIntersectionOf;
import org.semanticweb.owlapitools.builders.BuilderDataMaxCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataMinCardinality;
import org.semanticweb.owlapitools.builders.BuilderDataOneOf;
import org.semanticweb.owlapitools.builders.BuilderDataProperty;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderDataPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderDataSomeValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderDataUnionOf;
import org.semanticweb.owlapitools.builders.BuilderDatatype;
import org.semanticweb.owlapitools.builders.BuilderDatatypeDefinition;
import org.semanticweb.owlapitools.builders.BuilderDatatypeRestriction;
import org.semanticweb.owlapitools.builders.BuilderDeclaration;
import org.semanticweb.owlapitools.builders.BuilderDifferentIndividuals;
import org.semanticweb.owlapitools.builders.BuilderDisjointClasses;
import org.semanticweb.owlapitools.builders.BuilderDisjointDataProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderDisjointUnion;
import org.semanticweb.owlapitools.builders.BuilderEntity;
import org.semanticweb.owlapitools.builders.BuilderEquivalentClasses;
import org.semanticweb.owlapitools.builders.BuilderEquivalentDataProperties;
import org.semanticweb.owlapitools.builders.BuilderEquivalentObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderFacetRestriction;
import org.semanticweb.owlapitools.builders.BuilderFunctionalDataProperty;
import org.semanticweb.owlapitools.builders.BuilderFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderHasKey;
import org.semanticweb.owlapitools.builders.BuilderImportsDeclaration;
import org.semanticweb.owlapitools.builders.BuilderInverseFunctionalObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderInverseObjectProperties;
import org.semanticweb.owlapitools.builders.BuilderIrreflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderLiteral;
import org.semanticweb.owlapitools.builders.BuilderNamedIndividual;
import org.semanticweb.owlapitools.builders.BuilderNegativeDataPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderNegativeObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectAllValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderObjectExactCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectHasSelf;
import org.semanticweb.owlapitools.builders.BuilderObjectHasValue;
import org.semanticweb.owlapitools.builders.BuilderObjectIntersectionOf;
import org.semanticweb.owlapitools.builders.BuilderObjectInverseOf;
import org.semanticweb.owlapitools.builders.BuilderObjectMaxCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectMinCardinality;
import org.semanticweb.owlapitools.builders.BuilderObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyAssertion;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyDomain;
import org.semanticweb.owlapitools.builders.BuilderObjectPropertyRange;
import org.semanticweb.owlapitools.builders.BuilderObjectSomeValuesFrom;
import org.semanticweb.owlapitools.builders.BuilderOneOf;
import org.semanticweb.owlapitools.builders.BuilderPropertyChain;
import org.semanticweb.owlapitools.builders.BuilderReflexiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSWRLBuiltInAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLClassAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDataPropertyAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDataRangeAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLDifferentIndividualsAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLIndividualArgument;
import org.semanticweb.owlapitools.builders.BuilderSWRLLiteralArgument;
import org.semanticweb.owlapitools.builders.BuilderSWRLObjectPropertyAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLRule;
import org.semanticweb.owlapitools.builders.BuilderSWRLSameIndividualAtom;
import org.semanticweb.owlapitools.builders.BuilderSWRLVariable;
import org.semanticweb.owlapitools.builders.BuilderSameIndividual;
import org.semanticweb.owlapitools.builders.BuilderSubAnnotationPropertyOf;
import org.semanticweb.owlapitools.builders.BuilderSubClass;
import org.semanticweb.owlapitools.builders.BuilderSubDataProperty;
import org.semanticweb.owlapitools.builders.BuilderSubObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderSymmetricObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderTransitiveObjectProperty;
import org.semanticweb.owlapitools.builders.BuilderUnionOf;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class BuildersEqualTestCase {
    private OWLDataFactory df = new OWLDataFactoryImpl();
    private OWLAnnotationProperty ap = this.df.getOWLAnnotationProperty(IRI.create((String)"urn:test#ann"));
    private OWLObjectProperty op = this.df.getOWLObjectProperty(IRI.create((String)"urn:test#op"));
    private OWLDataProperty dp = this.df.getOWLDataProperty(IRI.create((String)"urn:test#dp"));
    private OWLLiteral lit = this.df.getOWLLiteral(false);
    private IRI iri = IRI.create((String)"urn:test#iri");
    private Set<OWLAnnotation> annotations = new HashSet<OWLAnnotation>(Arrays.asList(this.df.getOWLAnnotation(this.ap, (OWLAnnotationValue)this.df.getOWLLiteral("test"))));
    private OWLClass ce = this.df.getOWLClass(IRI.create((String)"urn:test#c"));
    private OWLNamedIndividual i = this.df.getOWLNamedIndividual(IRI.create((String)"urn:test#i"));
    private OWLDatatype d = this.df.getBooleanOWLDatatype();
    private Set<OWLDataProperty> dps = new HashSet<OWLDataProperty>(Arrays.asList(this.df.getOWLDataProperty(this.iri), this.dp));
    private Set<OWLObjectProperty> ops = new HashSet<OWLObjectProperty>(Arrays.asList(this.df.getOWLObjectProperty(this.iri), this.op));
    private Set<OWLClass> classes = new HashSet<OWLClass>(Arrays.asList(this.df.getOWLClass(this.iri), this.ce));
    private Set<OWLIndividual> inds = new HashSet<OWLNamedIndividual>(Arrays.asList(this.i, this.df.getOWLNamedIndividual(this.iri)));
    private SWRLDArgument var1 = this.df.getSWRLVariable(IRI.create((String)"var1"));
    private SWRLIArgument var2 = this.df.getSWRLVariable(IRI.create((String)"var2"));
    private SWRLAtom v1 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v1"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var3")), this.df.getSWRLVariable(IRI.create((String)"var4"))));
    private SWRLAtom v2 = this.df.getSWRLBuiltInAtom(IRI.create((String)"v2"), Arrays.asList(this.df.getSWRLVariable(IRI.create((String)"var5")), this.df.getSWRLVariable(IRI.create((String)"var6"))));
    private Set<SWRLAtom> body = new HashSet<SWRLAtom>(Arrays.asList(this.v1));
    private Set<SWRLAtom> head = new HashSet<SWRLAtom>(Arrays.asList(this.v2));

    @Test
    public void shouldBuildAnnotation() {
        OWLAnnotation expected = this.df.getOWLAnnotation(this.ap, (OWLAnnotationValue)this.lit);
        BuilderAnnotation builder = new BuilderAnnotation(expected);
        OWLAnnotation built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationAssertion() {
        OWLAnnotationAssertionAxiom expected = this.df.getOWLAnnotationAssertionAxiom(this.ap, (OWLAnnotationSubject)this.iri, (OWLAnnotationValue)this.lit, this.annotations);
        BuilderAnnotationAssertion builder = new BuilderAnnotationAssertion(expected);
        OWLAnnotationAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationProperty() {
        OWLAnnotationProperty expected = this.df.getOWLAnnotationProperty(this.iri);
        BuilderAnnotationProperty builder = new BuilderAnnotationProperty(expected);
        OWLAnnotationProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationPropertyDomain() {
        OWLAnnotationPropertyDomainAxiom expected = this.df.getOWLAnnotationPropertyDomainAxiom(this.ap, this.iri, this.annotations);
        BuilderAnnotationPropertyDomain builder = new BuilderAnnotationPropertyDomain(expected);
        OWLAnnotationPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnnotationPropertyRange() {
        OWLAnnotationPropertyRangeAxiom expected = this.df.getOWLAnnotationPropertyRangeAxiom(this.ap, this.iri, this.annotations);
        BuilderAnnotationPropertyRange builder = new BuilderAnnotationPropertyRange(expected);
        OWLAnnotationPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAnonymousIndividual() {
        OWLAnonymousIndividual expected = this.df.getOWLAnonymousIndividual("id");
        BuilderAnonymousIndividual builder = new BuilderAnonymousIndividual(expected);
        OWLAnonymousIndividual built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildAsymmetricObjectProperty() {
        OWLAsymmetricObjectPropertyAxiom expected = this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderAsymmetricObjectProperty builder = new BuilderAsymmetricObjectProperty(expected);
        OWLAsymmetricObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildClass() {
        OWLClass expected = this.df.getOWLClass(this.iri);
        BuilderClass builder = new BuilderClass(expected);
        OWLClass built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildClassAssertion() {
        OWLClassAssertionAxiom expected = this.df.getOWLClassAssertionAxiom((OWLClassExpression)this.ce, (OWLIndividual)this.i, this.annotations);
        BuilderClassAssertion builder = new BuilderClassAssertion(expected);
        OWLClassAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildComplementOf() {
        OWLObjectComplementOf expected = this.df.getOWLObjectComplementOf((OWLClassExpression)this.ce);
        BuilderComplementOf builder = new BuilderComplementOf(expected);
        OWLObjectComplementOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataAllValuesFrom() {
        OWLDataAllValuesFrom expected = this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        BuilderDataAllValuesFrom builder = new BuilderDataAllValuesFrom(expected);
        OWLDataAllValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataComplementOf() {
        OWLDataComplementOf expected = this.df.getOWLDataComplementOf((OWLDataRange)this.d);
        BuilderDataComplementOf builder = new BuilderDataComplementOf(expected);
        OWLDataComplementOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataExactCardinality() {
        OWLDataExactCardinality expected = this.df.getOWLDataExactCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        BuilderDataExactCardinality builder = new BuilderDataExactCardinality(expected);
        OWLDataExactCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataHasValue() {
        OWLDataHasValue expected = this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.dp, this.lit);
        BuilderDataHasValue builder = new BuilderDataHasValue(expected);
        OWLDataHasValue built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataIntersectionOf() {
        OWLDataIntersectionOf expected = this.df.getOWLDataIntersectionOf(new OWLDataRange[]{this.d, this.df.getFloatOWLDatatype()});
        BuilderDataIntersectionOf builder = new BuilderDataIntersectionOf(expected);
        OWLDataIntersectionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataMaxCardinality() {
        OWLDataMaxCardinality expected = this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        BuilderDataMaxCardinality builder = new BuilderDataMaxCardinality(expected);
        OWLDataMaxCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataMinCardinality() {
        OWLDataMinCardinality expected = this.df.getOWLDataMinCardinality(1, (OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        BuilderDataMinCardinality builder = new BuilderDataMinCardinality(expected);
        OWLDataMinCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataOneOf() {
        OWLDataOneOf expected = this.df.getOWLDataOneOf(new OWLLiteral[]{this.lit});
        BuilderDataOneOf builder = new BuilderDataOneOf(expected);
        OWLDataOneOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataProperty() {
        OWLDataProperty expected = this.df.getOWLDataProperty(this.iri);
        BuilderDataProperty builder = new BuilderDataProperty(expected);
        OWLDataProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyAssertion() {
        OWLDataPropertyAssertionAxiom expected = this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        BuilderDataPropertyAssertion builder = new BuilderDataPropertyAssertion(expected);
        OWLDataPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyDomain() {
        OWLDataPropertyDomainAxiom expected = this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.dp, (OWLClassExpression)this.ce, this.annotations);
        BuilderDataPropertyDomain builder = new BuilderDataPropertyDomain(expected);
        OWLDataPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataPropertyRange() {
        OWLDataPropertyRangeAxiom expected = this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d, this.annotations);
        BuilderDataPropertyRange builder = new BuilderDataPropertyRange(expected);
        OWLDataPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataSomeValuesFrom() {
        OWLDataSomeValuesFrom expected = this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.d);
        BuilderDataSomeValuesFrom builder = new BuilderDataSomeValuesFrom(expected);
        OWLDataSomeValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatype() {
        OWLDatatype expected = this.df.getOWLDatatype(this.iri);
        BuilderDatatype builder = new BuilderDatatype(expected);
        OWLDatatype built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatypeDefinition() {
        OWLDatatypeDefinitionAxiom expected = this.df.getOWLDatatypeDefinitionAxiom(this.d, (OWLDataRange)this.df.getDoubleOWLDatatype(), this.annotations);
        BuilderDatatypeDefinition builder = new BuilderDatatypeDefinition(expected);
        OWLDatatypeDefinitionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDatatypeRestriction() {
        OWLFacetRestriction r = this.df.getOWLFacetRestriction(OWLFacet.MAX_LENGTH, this.lit);
        OWLDatatypeRestriction expected = this.df.getOWLDatatypeRestriction(this.d, new OWLFacetRestriction[]{r});
        BuilderDatatypeRestriction builder = new BuilderDatatypeRestriction(expected);
        OWLDatatypeRestriction built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDataUnionOf() {
        OWLDataUnionOf expected = this.df.getOWLDataUnionOf(new OWLDataRange[]{this.d, this.df.getDoubleOWLDatatype()});
        BuilderDataUnionOf builder = new BuilderDataUnionOf(expected);
        OWLDataUnionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDeclaration() {
        OWLDeclarationAxiom expected = this.df.getOWLDeclarationAxiom((OWLEntity)this.ce, this.annotations);
        BuilderDeclaration builder = new BuilderDeclaration(expected);
        OWLDeclarationAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDifferentIndividuals() {
        OWLDifferentIndividualsAxiom expected = this.df.getOWLDifferentIndividualsAxiom(new OWLIndividual[]{this.i, this.df.getOWLNamedIndividual(this.iri)});
        BuilderDifferentIndividuals builder = new BuilderDifferentIndividuals(expected);
        OWLDifferentIndividualsAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointClasses() {
        OWLDisjointClassesAxiom expected = this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{this.ce, this.df.getOWLClass(this.iri)});
        BuilderDisjointClasses builder = new BuilderDisjointClasses(expected);
        OWLDisjointClassesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointDataProperties() {
        OWLDisjointDataPropertiesAxiom expected = this.df.getOWLDisjointDataPropertiesAxiom(this.dps, this.annotations);
        BuilderDisjointDataProperties builder = new BuilderDisjointDataProperties(expected);
        OWLDisjointDataPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointObjectProperties() {
        OWLDisjointObjectPropertiesAxiom expected = this.df.getOWLDisjointObjectPropertiesAxiom(this.ops, this.annotations);
        BuilderDisjointObjectProperties builder = new BuilderDisjointObjectProperties(expected);
        OWLDisjointObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildDisjointUnion() {
        OWLDisjointUnionAxiom expected = this.df.getOWLDisjointUnionAxiom(this.ce, this.classes, this.annotations);
        BuilderDisjointUnion builder = new BuilderDisjointUnion(expected);
        OWLDisjointUnionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEntity() {
        OWLClass expected = this.df.getOWLClass(this.iri);
        BuilderEntity builder = new BuilderEntity(expected);
        OWLEntity built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentClasses() {
        OWLEquivalentClassesAxiom expected = this.df.getOWLEquivalentClassesAxiom(this.classes, this.annotations);
        BuilderEquivalentClasses builder = new BuilderEquivalentClasses(expected);
        OWLEquivalentClassesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentDataProperties() {
        OWLEquivalentDataPropertiesAxiom expected = this.df.getOWLEquivalentDataPropertiesAxiom(this.dps, this.annotations);
        BuilderEquivalentDataProperties builder = new BuilderEquivalentDataProperties(expected);
        OWLEquivalentDataPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildEquivalentObjectProperties() {
        OWLEquivalentObjectPropertiesAxiom expected = this.df.getOWLEquivalentObjectPropertiesAxiom(this.ops, this.annotations);
        BuilderEquivalentObjectProperties builder = new BuilderEquivalentObjectProperties(expected);
        OWLEquivalentObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFacetRestriction() {
        OWLFacetRestriction expected = this.df.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, this.lit);
        BuilderFacetRestriction builder = new BuilderFacetRestriction(expected);
        OWLFacetRestriction built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFunctionalDataProperty() {
        OWLFunctionalDataPropertyAxiom expected = this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.dp, this.annotations);
        BuilderFunctionalDataProperty builder = new BuilderFunctionalDataProperty(expected);
        OWLFunctionalDataPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildFunctionalObjectProperty() {
        OWLFunctionalObjectPropertyAxiom expected = this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderFunctionalObjectProperty builder = new BuilderFunctionalObjectProperty(expected);
        OWLFunctionalObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildHasKey() {
        OWLHasKeyAxiom expected = this.df.getOWLHasKeyAxiom((OWLClassExpression)this.ce, this.ops, this.annotations);
        BuilderHasKey builder = new BuilderHasKey(expected);
        OWLHasKeyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildImportsDeclarationProperty() {
        OWLImportsDeclaration expected = this.df.getOWLImportsDeclaration(this.iri);
        BuilderImportsDeclaration builder = new BuilderImportsDeclaration(expected);
        OWLImportsDeclaration built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildInverseFunctionalObjectProperty() {
        OWLInverseFunctionalObjectPropertyAxiom expected = this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderInverseFunctionalObjectProperty builder = new BuilderInverseFunctionalObjectProperty(expected);
        OWLInverseFunctionalObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildInverseObjectProperties() {
        OWLInverseObjectPropertiesAxiom expected = this.df.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderInverseObjectProperties builder = new BuilderInverseObjectProperties(expected);
        OWLInverseObjectPropertiesAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildIrreflexiveObjectProperty() {
        OWLIrreflexiveObjectPropertyAxiom expected = this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderIrreflexiveObjectProperty builder = new BuilderIrreflexiveObjectProperty(expected);
        OWLIrreflexiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildLiteral() {
        OWLLiteral expected = this.df.getOWLLiteral(true);
        BuilderLiteral builder = new BuilderLiteral(expected);
        OWLLiteral built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNamedIndividual() {
        OWLNamedIndividual expected = this.df.getOWLNamedIndividual(this.iri);
        BuilderNamedIndividual builder = new BuilderNamedIndividual(expected);
        OWLNamedIndividual built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNegativeDataPropertyAssertion() {
        OWLNegativeDataPropertyAssertionAxiom expected = this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.dp, (OWLIndividual)this.i, this.lit, this.annotations);
        BuilderNegativeDataPropertyAssertion builder = new BuilderNegativeDataPropertyAssertion(expected);
        OWLNegativeDataPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildNegativeObjectPropertyAssertion() {
        OWLNegativeObjectPropertyAssertionAxiom expected = this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        BuilderNegativeObjectPropertyAssertion builder = new BuilderNegativeObjectPropertyAssertion(expected);
        OWLNegativeObjectPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectAllValuesFrom() {
        OWLObjectAllValuesFrom expected = this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        BuilderObjectAllValuesFrom builder = new BuilderObjectAllValuesFrom(expected);
        OWLObjectAllValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectExactCardinality() {
        OWLObjectExactCardinality expected = this.df.getOWLObjectExactCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        BuilderObjectExactCardinality builder = new BuilderObjectExactCardinality(expected);
        OWLObjectExactCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectHasSelf() {
        OWLObjectHasSelf expected = this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.op);
        BuilderObjectHasSelf builder = new BuilderObjectHasSelf(expected);
        OWLObjectHasSelf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectHasValue() {
        OWLObjectHasValue expected = this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i);
        BuilderObjectHasValue builder = new BuilderObjectHasValue(expected);
        OWLObjectHasValue built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectIntersectionOf() {
        OWLObjectIntersectionOf expected = this.df.getOWLObjectIntersectionOf(this.classes);
        BuilderObjectIntersectionOf builder = new BuilderObjectIntersectionOf(expected);
        OWLObjectIntersectionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectInverseOf() {
        OWLObjectInverseOf expected = this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.op);
        BuilderObjectInverseOf builder = new BuilderObjectInverseOf(expected);
        OWLObjectInverseOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectMaxCardinality() {
        OWLObjectMaxCardinality expected = this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        BuilderObjectMaxCardinality builder = new BuilderObjectMaxCardinality(expected);
        OWLObjectMaxCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectMinCardinality() {
        OWLObjectMinCardinality expected = this.df.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        BuilderObjectMinCardinality builder = new BuilderObjectMinCardinality(expected);
        OWLObjectMinCardinality built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectProperty() {
        OWLObjectProperty expected = this.df.getOWLObjectProperty(this.iri);
        BuilderObjectProperty builder = new BuilderObjectProperty(expected);
        OWLObjectProperty built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyAssertion() {
        OWLObjectPropertyAssertionAxiom expected = this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.op, (OWLIndividual)this.i, (OWLIndividual)this.i, this.annotations);
        BuilderObjectPropertyAssertion builder = new BuilderObjectPropertyAssertion(expected);
        OWLObjectPropertyAssertionAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyDomain() {
        OWLObjectPropertyDomainAxiom expected = this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        BuilderObjectPropertyDomain builder = new BuilderObjectPropertyDomain(expected);
        OWLObjectPropertyDomainAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectPropertyRange() {
        OWLObjectPropertyRangeAxiom expected = this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce, this.annotations);
        BuilderObjectPropertyRange builder = new BuilderObjectPropertyRange(expected);
        OWLObjectPropertyRangeAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildObjectSomeValuesFrom() {
        OWLObjectSomeValuesFrom expected = this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.op, (OWLClassExpression)this.ce);
        BuilderObjectSomeValuesFrom builder = new BuilderObjectSomeValuesFrom(expected);
        OWLObjectSomeValuesFrom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildOneOf() {
        OWLObjectOneOf expected = this.df.getOWLObjectOneOf(new OWLIndividual[]{this.i});
        BuilderOneOf builder = new BuilderOneOf(expected);
        OWLObjectOneOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildPropertyChain() {
        ArrayList<OWLObjectProperty> chain = new ArrayList<OWLObjectProperty>(this.ops);
        OWLSubPropertyChainOfAxiom expected = this.df.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderPropertyChain builder = new BuilderPropertyChain(expected);
        OWLSubPropertyChainOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildReflexiveObjectProperty() {
        OWLReflexiveObjectPropertyAxiom expected = this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderReflexiveObjectProperty builder = new BuilderReflexiveObjectProperty(expected);
        OWLReflexiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSameIndividual() {
        OWLSameIndividualAxiom expected = this.df.getOWLSameIndividualAxiom(this.inds, this.annotations);
        BuilderSameIndividual builder = new BuilderSameIndividual(expected);
        OWLSameIndividualAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubAnnotationPropertyOf() {
        OWLSubAnnotationPropertyOfAxiom expected = this.df.getOWLSubAnnotationPropertyOfAxiom(this.ap, this.df.getRDFSLabel(), this.annotations);
        BuilderSubAnnotationPropertyOf builder = new BuilderSubAnnotationPropertyOf(expected);
        OWLSubAnnotationPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubClass() {
        OWLSubClassOfAxiom expected = this.df.getOWLSubClassOfAxiom((OWLClassExpression)this.ce, (OWLClassExpression)this.df.getOWLThing(), this.annotations);
        BuilderSubClass builder = new BuilderSubClass(expected);
        OWLSubClassOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubDataProperty() {
        OWLSubDataPropertyOfAxiom expected = this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.dp, (OWLDataPropertyExpression)this.df.getOWLTopDataProperty());
        BuilderSubDataProperty builder = new BuilderSubDataProperty(expected);
        OWLSubDataPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSubObjectProperty() {
        OWLSubObjectPropertyOfAxiom expected = this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.op, (OWLObjectPropertyExpression)this.df.getOWLTopObjectProperty(), this.annotations);
        BuilderSubObjectProperty builder = new BuilderSubObjectProperty(expected);
        OWLSubObjectPropertyOfAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLBuiltInAtom() {
        SWRLBuiltInAtom expected = this.df.getSWRLBuiltInAtom(this.iri, Arrays.asList(this.var1));
        BuilderSWRLBuiltInAtom builder = new BuilderSWRLBuiltInAtom(expected);
        SWRLBuiltInAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLClassAtom() {
        SWRLClassAtom expected = this.df.getSWRLClassAtom((OWLClassExpression)this.ce, this.var2);
        BuilderSWRLClassAtom builder = new BuilderSWRLClassAtom(expected);
        SWRLClassAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDataPropertyAtom() {
        SWRLDataPropertyAtom expected = this.df.getSWRLDataPropertyAtom((OWLDataPropertyExpression)this.dp, this.var2, this.var1);
        BuilderSWRLDataPropertyAtom builder = new BuilderSWRLDataPropertyAtom(expected);
        SWRLDataPropertyAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDataRangeAtom() {
        SWRLDataRangeAtom expected = this.df.getSWRLDataRangeAtom((OWLDataRange)this.d, this.var1);
        BuilderSWRLDataRangeAtom builder = new BuilderSWRLDataRangeAtom(expected);
        SWRLDataRangeAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLDifferentIndividualsAtom() {
        SWRLDifferentIndividualsAtom expected = this.df.getSWRLDifferentIndividualsAtom(this.var2, this.var2);
        BuilderSWRLDifferentIndividualsAtom builder = new BuilderSWRLDifferentIndividualsAtom(expected);
        SWRLDifferentIndividualsAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLIndividualArgument() {
        SWRLIndividualArgument expected = this.df.getSWRLIndividualArgument((OWLIndividual)this.i);
        BuilderSWRLIndividualArgument builder = new BuilderSWRLIndividualArgument(expected);
        SWRLIndividualArgument built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLLiteralArgument() {
        SWRLLiteralArgument expected = this.df.getSWRLLiteralArgument(this.lit);
        BuilderSWRLLiteralArgument builder = new BuilderSWRLLiteralArgument(expected);
        SWRLLiteralArgument built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLObjectPropertyAtom() {
        SWRLObjectPropertyAtom expected = this.df.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)this.op, this.var2, this.var2);
        BuilderSWRLObjectPropertyAtom builder = new BuilderSWRLObjectPropertyAtom(expected);
        SWRLObjectPropertyAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLRule() {
        SWRLRule expected = this.df.getSWRLRule(this.body, this.head);
        BuilderSWRLRule builder = new BuilderSWRLRule(expected);
        SWRLRule built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLSameIndividualAtom() {
        SWRLSameIndividualAtom expected = this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i), (SWRLIArgument)this.df.getSWRLIndividualArgument((OWLIndividual)this.i));
        BuilderSWRLSameIndividualAtom builder = new BuilderSWRLSameIndividualAtom(expected);
        SWRLSameIndividualAtom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSWRLVariable() {
        SWRLVariable expected = this.df.getSWRLVariable(this.iri);
        BuilderSWRLVariable builder = new BuilderSWRLVariable(expected);
        SWRLVariable built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildSymmetricObjectProperty() {
        OWLSymmetricObjectPropertyAxiom expected = this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderSymmetricObjectProperty builder = new BuilderSymmetricObjectProperty(expected);
        OWLSymmetricObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildTransitiveObjectProperty() {
        OWLTransitiveObjectPropertyAxiom expected = this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.op, this.annotations);
        BuilderTransitiveObjectProperty builder = new BuilderTransitiveObjectProperty(expected);
        OWLTransitiveObjectPropertyAxiom built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }

    @Test
    public void shouldBuildUnionOf() {
        OWLObjectUnionOf expected = this.df.getOWLObjectUnionOf(this.classes);
        BuilderUnionOf builder = new BuilderUnionOf(expected);
        OWLObjectUnionOf built = builder.buildObject();
        Assert.assertEquals((Object)expected, (Object)built);
    }
}

