/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import uk.ac.manchester.cs.factplusplusad.LocalityChecker;
import uk.ac.manchester.cs.factplusplusad.Signature;

class SigIndex {
    private Map<OWLEntity, Collection<AxiomWrapper>> base = new HashMap<OWLEntity, Collection<AxiomWrapper>>();
    private LocalityChecker checker;
    private Signature emptySig = new Signature();
    private Collection<AxiomWrapper> topNonLocal = new ArrayList<AxiomWrapper>();
    private Collection<AxiomWrapper> bottomNonLocal = new ArrayList<AxiomWrapper>();
    private int nRegistered = 0;
    private int nUnregistered = 0;

    public SigIndex(LocalityChecker c) {
        this.checker = c;
    }

    private void checkNonLocal(AxiomWrapper ax, boolean top) {
        this.emptySig.setLocality(top);
        this.checker.setSignatureValue(this.emptySig);
        if (!this.checker.local(ax.getAxiom())) {
            if (top) {
                this.topNonLocal.add(ax);
            } else {
                this.bottomNonLocal.add(ax);
            }
        }
    }

    public void clear() {
        this.base.clear();
        this.topNonLocal.clear();
        this.bottomNonLocal.clear();
    }

    public Collection<AxiomWrapper> getAxioms(OWLEntity entity) {
        return this.base.get(entity);
    }

    public Collection<AxiomWrapper> getNonLocal(boolean top) {
        return top ? this.topNonLocal : this.bottomNonLocal;
    }

    public int nProcessedAx() {
        return this.nRegistered;
    }

    int nRegisteredAx() {
        return this.nRegistered - this.nUnregistered;
    }

    public void preprocessOntology(Collection<AxiomWrapper> axioms) {
        axioms.forEach(this::processAx);
    }

    public void processAx(AxiomWrapper ax) {
        if (ax.isUsed()) {
            this.registerAx(ax);
        } else {
            this.unregisterAx(ax);
        }
    }

    private void registerAx(AxiomWrapper ax) {
        ax.signature().forEach(a -> this.base.computeIfAbsent((OWLEntity)a, x -> new HashSet()).add(ax));
        this.checkNonLocal(ax, false);
        this.checkNonLocal(ax, true);
        ++this.nRegistered;
    }

    private void unregisterAx(AxiomWrapper ax) {
        ax.signature().forEach(p -> ((Collection)this.base.getOrDefault(p, Collections.emptySet())).remove(ax));
        this.topNonLocal.remove(ax);
        this.bottomNonLocal.remove(ax);
        ++this.nUnregistered;
    }
}

