/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.Signature;

public class SemanticLocalityChecker
implements OWLAxiomVisitor,
LocalityChecker {
    OWLReasoner kernel;
    OWLDataFactory df;
    OWLReasonerFactory factory;
    Multimap<OWLAxiom, OWLClassExpression> exprMap = LinkedHashMultimap.create();
    private Signature sig = new Signature();
    boolean isLocal;
    private OWLOntologyManager manager;

    public SemanticLocalityChecker(OWLReasonerFactory f, OWLOntologyManager m) {
        this.factory = f;
        this.manager = m;
        this.df = this.manager.getOWLDataFactory();
        this.isLocal = true;
    }

    public SemanticLocalityChecker(OWLReasoner r) {
        this.kernel = r;
        this.manager = r.getRootOntology().getOWLOntologyManager();
        this.df = this.manager.getOWLDataFactory();
        this.isLocal = true;
    }

    protected Stream<OWLClassExpression> getExpr(OWLAxiom axiom) {
        return axiom.nestedClassExpressions();
    }

    @Override
    public Signature getSignature() {
        return this.sig;
    }

    @Override
    public void setSignatureValue(Signature sig) {
        this.sig = sig;
    }

    @Override
    public boolean local(OWLAxiom axiom) {
        axiom.accept((OWLAxiomVisitor)this);
        return this.isLocal;
    }

    @Override
    public void preprocessOntology(Collection<AxiomWrapper> axioms) {
        this.exprMap.clear();
        Signature s = new Signature();
        for (AxiomWrapper axiomWrapper : axioms) {
            if (!axiomWrapper.isUsed()) continue;
            this.exprMap.putAll((Object)axiomWrapper.getAxiom(), (Iterable)OWLAPIStreamUtils.asList(this.getExpr(axiomWrapper.getAxiom())));
            s.addAll(axiomWrapper.getAxiom().signature());
        }
        HashSet<OWLDeclarationAxiom> declarationAxioms = new HashSet<OWLDeclarationAxiom>();
        for (OWLEntity p : s.getSignature()) {
            declarationAxioms.add(this.df.getOWLDeclarationAxiom(p));
        }
        try {
            this.kernel = this.factory.createReasoner(this.manager.createOntology(declarationAxioms));
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            throw new OWLRuntimeException((Throwable)oWLOntologyCreationException);
        }
        this.kernel.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.isLocal = true;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isLocal = false;
        List arguments = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
        int size = arguments.size();
        OWLClassExpression c = (OWLClassExpression)arguments.get(0);
        for (int i = 1; i < size; ++i) {
            OWLClassExpression p = (OWLClassExpression)arguments.get(i);
            if (this.kernel.isEntailed((OWLAxiom)this.df.getOWLEquivalentClassesAxiom(c, p))) continue;
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.isLocal = false;
        List arguments = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            OWLClassExpression p = (OWLClassExpression)arguments.get(i);
            for (int j = i + 1; j < size; ++j) {
                OWLClassExpression q = (OWLClassExpression)arguments.get(j);
                if (this.kernel.isEntailed((OWLAxiom)this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{p, q}))) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.isLocal = false;
        if (!this.kernel.isEntailed((OWLAxiom)this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)this.df.getOWLObjectIntersectionOf(axiom.classExpressions())))) {
            return;
        }
        List arguments = OWLAPIStreamUtils.asList((Stream)axiom.classExpressions());
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (this.kernel.isEntailed((OWLAxiom)this.df.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)arguments.get(i), (OWLClassExpression)arguments.get(j)}))) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isLocal = false;
        List arguments = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        int size = arguments.size();
        OWLObjectPropertyExpression r = (OWLObjectPropertyExpression)arguments.get(0);
        for (int i = 1; i < size; ++i) {
            if (this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(r, (OWLObjectPropertyExpression)arguments.get(i))) && this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)arguments.get(i), r))) continue;
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isLocal = false;
        List arguments = OWLAPIStreamUtils.asList((Stream)axiom.properties());
        OWLDataPropertyExpression r = (OWLDataPropertyExpression)arguments.get(0);
        for (int i = 1; i < arguments.size(); ++i) {
            if (this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubDataPropertyOfAxiom(r, (OWLDataPropertyExpression)arguments.get(i))) && this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)arguments.get(i), r))) continue;
            return;
        }
        this.isLocal = true;
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.isLocal = false;
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isLocal = false;
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty(), axiom.getSecondProperty().getInverseProperty())) && this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty().getInverseProperty(), axiom.getSecondProperty()));
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get((Object)axiom)) {
            this.isLocal &= this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(e, (OWLClassExpression)axiom.getDomain()));
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get((Object)axiom)) {
            this.isLocal &= this.kernel.isEntailed((OWLAxiom)this.df.getOWLSubClassOfAxiom(e, (OWLClassExpression)axiom.getDomain()));
        }
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get((Object)axiom)) {
            this.isLocal &= !this.kernel.isSatisfiable(e);
        }
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isLocal = true;
        for (OWLClassExpression e : this.exprMap.get((Object)axiom)) {
            this.isLocal &= !this.kernel.isSatisfiable(e);
        }
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.kernel.isEntailed((OWLAxiom)axiom);
    }

    @Override
    public boolean isTopEquivalent(OWLObject expr) {
        return false;
    }

    @Override
    public boolean isBotEquivalent(OWLObject expr) {
        return false;
    }
}

