/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.ExplanationGenerator;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.MultipleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class DefaultExplanationGenerator
implements ExplanationGenerator {
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final MultipleExplanationGenerator gen;

    public DefaultExplanationGenerator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory, OWLOntology ontology, ExplanationProgressMonitor progressMonitor) {
        this(man, reasonerFactory, ontology, ((OWLReasonerFactory)OWLAPIPreconditions.checkNotNull((Object)reasonerFactory, (String)"reasonerFactory cannot be null")).createNonBufferingReasoner(ontology), progressMonitor);
    }

    public DefaultExplanationGenerator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory, OWLOntology ontology, OWLReasoner reasoner, @Nullable ExplanationProgressMonitor progressMonitor) {
        this.dataFactory = ((OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)man, (String)"man cannot be null")).getOWLDataFactory();
        BlackBoxExplanation singleGen = new BlackBoxExplanation((OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null"), (OWLReasonerFactory)OWLAPIPreconditions.checkNotNull((Object)reasonerFactory, (String)"reasonerFactory cannot be null"), (OWLReasoner)OWLAPIPreconditions.checkNotNull((Object)reasoner, (String)"reasoner cannot be null"));
        this.gen = new HSTExplanationGenerator(singleGen);
        if (progressMonitor != null) {
            this.gen.setProgressMonitor(progressMonitor);
        }
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        return this.gen.getExplanation(unsatClass);
    }

    public Set<OWLAxiom> getExplanation(OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanation(converter.convert((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass) {
        return this.gen.getExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getExplanations(OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass, int maxExplanations) {
        return this.gen.getExplanations(unsatClass, maxExplanations);
    }

    public Set<Set<OWLAxiom>> getExplanations(OWLAxiom axiom, int maxExplanations) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert((OWLAxiom)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")), maxExplanations);
    }
}

