/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class AxiomConverter
implements OWLAxiomVisitorEx<OWLClassExpression> {
    private final OWLDataFactory factory;

    AxiomConverter(OWLDataFactory df) {
        this.factory = df;
    }

    private OWLObjectIntersectionOf and(OWLClassExpression desc1, OWLClassExpression desc2) {
        return this.factory.getOWLObjectIntersectionOf(AxiomConverter.set(desc1, desc2));
    }

    private OWLObjectIntersectionOf and(Stream<OWLClassExpression> set) {
        return this.factory.getOWLObjectIntersectionOf((Collection)OWLAPIStreamUtils.asList(set));
    }

    private OWLObjectComplementOf not(OWLClassExpression desc) {
        return this.factory.getOWLObjectComplementOf(desc);
    }

    private OWLObjectOneOf oneOf(OWLIndividual ind) {
        return this.factory.getOWLObjectOneOf((Collection)CollectionFactory.createSet((Object)ind));
    }

    private OWLObjectUnionOf or(OWLClassExpression desc1, OWLClassExpression desc2) {
        return this.factory.getOWLObjectUnionOf(AxiomConverter.set(desc1, desc2));
    }

    private static <T> Set<T> set(T desc1, T desc2) {
        HashSet<T> set = new HashSet<T>();
        set.add(desc1);
        set.add(desc2);
        return set;
    }

    public OWLClassExpression doDefault(Object object) {
        throw new OWLRuntimeException("Not implemented: Cannot generate explanation for " + object);
    }

    public OWLClassExpression visit(OWLClassAssertionAxiom axiom) {
        OWLIndividual ind = axiom.getIndividual();
        OWLClassExpression c = axiom.getClassExpression();
        return this.and((OWLClassExpression)this.oneOf(ind), (OWLClassExpression)this.not(c));
    }

    public OWLClassExpression visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLDataHasValue sup = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        OWLSubClassOfAxiom ax = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)sup);
        return (OWLClassExpression)ax.accept((OWLAxiomVisitorEx)this);
    }

    public OWLClassExpression visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeValuesFrom sub = this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)this.factory.getTopDatatype());
        return this.and((OWLClassExpression)sub, (OWLClassExpression)this.not((OWLClassExpression)axiom.getDomain()));
    }

    public OWLClassExpression visit(OWLDataPropertyRangeAxiom axiom) {
        return this.factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)axiom.getRange()));
    }

    public OWLClassExpression visit(OWLDifferentIndividualsAxiom axiom) {
        HashSet nominals = new HashSet();
        axiom.individuals().forEach(ind -> nominals.add(this.oneOf((OWLIndividual)ind)));
        return this.factory.getOWLObjectIntersectionOf(nominals);
    }

    public OWLClassExpression visit(OWLDisjointClassesAxiom axiom) {
        return this.and(axiom.classExpressions());
    }

    public OWLClassExpression visit(OWLEquivalentClassesAxiom axiom) {
        Iterator classes = axiom.classExpressions().iterator();
        OWLClassExpression c1 = (OWLClassExpression)classes.next();
        OWLClassExpression c2 = (OWLClassExpression)classes.next();
        if (c1.isOWLNothing()) {
            return (OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)c2);
        }
        if (c2.isOWLNothing()) {
            return c1;
        }
        if (c1.isOWLThing()) {
            return this.not(c2);
        }
        if (c2.isOWLThing()) {
            return this.not(c1);
        }
        return this.or((OWLClassExpression)this.and(c1, (OWLClassExpression)this.not(c2)), (OWLClassExpression)this.and((OWLClassExpression)this.not(c1), c2));
    }

    public OWLClassExpression visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLDataHasValue sup = this.factory.getOWLDataHasValue((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject());
        return (OWLClassExpression)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)this.not((OWLClassExpression)sup)).accept((OWLAxiomVisitorEx)this);
    }

    public OWLClassExpression visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLObjectHasValue sup = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
        return (OWLClassExpression)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)this.not((OWLClassExpression)sup)).accept((OWLAxiomVisitorEx)this);
    }

    public OWLClassExpression visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.oneOf(axiom.getSubject());
        OWLObjectHasValue sup = this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getProperty(), (OWLIndividual)axiom.getObject());
        OWLSubClassOfAxiom ax = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)sub, (OWLClassExpression)sup);
        return (OWLClassExpression)ax.accept((OWLAxiomVisitorEx)this);
    }

    public OWLClassExpression visit(OWLObjectPropertyDomainAxiom axiom) {
        return this.and((OWLClassExpression)this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.factory.getOWLThing()), (OWLClassExpression)this.not((OWLClassExpression)axiom.getDomain()));
    }

    public OWLClassExpression visit(OWLObjectPropertyRangeAxiom axiom) {
        return this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.not((OWLClassExpression)axiom.getRange()));
    }

    public OWLClassExpression visit(OWLSameIndividualAxiom axiom) {
        return this.and(axiom.individuals().map(ind -> this.not((OWLClassExpression)this.oneOf((OWLIndividual)ind))));
    }

    public OWLClassExpression visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression sub = axiom.getSubClass();
        OWLClassExpression sup = axiom.getSuperClass();
        if (sup.isOWLNothing()) {
            return sub;
        }
        if (sub.isOWLThing()) {
            return this.not(sup);
        }
        return this.and(sub, (OWLClassExpression)this.not(sup));
    }
}

