/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.DoubleValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.Searcher;

public class AverageAssertedNamedSuperclassCount
extends DoubleValuedMetric {
    public AverageAssertedNamedSuperclassCount(@Nonnull OWLOntology o) {
        super(o);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Average number of named superclasses";
    }

    @Override
    public Double recomputeMetric() {
        int total = 0;
        int count = 0;
        HashSet<OWLClass> processedClasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                assert (cls != null);
                if (processedClasses.contains(cls)) continue;
                ++count;
                int prevTotal = total;
                processedClasses.add(cls);
                for (OWLClassExpression desc : Searcher.sup((Collection)ont.getSubClassAxiomsForSubClass(cls), OWLClassExpression.class)) {
                    if (desc.isAnonymous()) continue;
                    ++total;
                }
                if (prevTotal != total) continue;
                ++total;
            }
        }
        return (double)total / (double)count;
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

