/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.debugging.AbstractOWLDebugger;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackBoxOWLDebugger
extends AbstractOWLDebugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlackBoxOWLDebugger.class);
    private OWLClass currentClass;
    private OWLOntology debuggingOntology;
    @Nonnull
    private final Set<OWLAxiom> debuggingAxioms = new LinkedHashSet<OWLAxiom>();
    @Nonnull
    private final Set<OWLEntity> objectsExpandedWithDefiningAxioms = new HashSet<OWLEntity>();
    @Nonnull
    private final Set<OWLEntity> objectsExpandedWithReferencingAxioms = new HashSet<OWLEntity>();
    @Nonnull
    private final Set<OWLAxiom> expandedWithDefiningAxioms = new HashSet<OWLAxiom>();
    @Nonnull
    private final Set<OWLAxiom> expandedWithReferencingAxioms = new HashSet<OWLAxiom>();
    @Nonnull
    private final OWLReasonerFactory reasonerFactory;
    @Nonnull
    private final Set<OWLAxiom> temporaryAxioms = new HashSet<OWLAxiom>();
    private static final int DEFAULT_INITIAL_EXPANSION_LIMIT = 50;
    private final int initialExpansionLimit = 50;
    private int expansionLimit = 50;
    private static final int DEFAULT_FAST_PRUNING_WINDOW_SIZE = 10;
    private final int fastPruningWindowSize;
    private int satTestCount = 0;

    public BlackBoxOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLReasonerFactory reasonerFactory) {
        this(owlOntologyManager, ontology, reasonerFactory, Math.max(ontology.getLogicalAxiomCount() / 100, 10));
    }

    public BlackBoxOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology, OWLReasonerFactory reasonerFactory, int fastPruningWindowSize) {
        super(owlOntologyManager, ontology);
        this.reasonerFactory = (OWLReasonerFactory)OWLAPIPreconditions.checkNotNull((Object)reasonerFactory, (String)"reasonerFactory cannot be null");
        this.fastPruningWindowSize = fastPruningWindowSize;
    }

    @Override
    public void dispose() {
        this.reset();
    }

    private void reset() {
        this.currentClass = null;
        this.debuggingOntology = null;
        this.debuggingAxioms.clear();
        this.objectsExpandedWithDefiningAxioms.clear();
        this.objectsExpandedWithReferencingAxioms.clear();
        this.expandedWithDefiningAxioms.clear();
        this.expandedWithReferencingAxioms.clear();
        this.temporaryAxioms.clear();
        this.expansionLimit = 50;
    }

    @Override
    protected OWLClassExpression getCurrentClass() {
        if (this.currentClass == null) {
            throw new IllegalStateException("currentClass is null; it is not possible to use it at this point.");
        }
        return this.currentClass;
    }

    @Nonnull
    private OWLClass setupDebuggingClass(@Nonnull OWLClassExpression cls) {
        if (!cls.isAnonymous()) {
            return (OWLClass)cls;
        }
        OWLClass curCls = this.owlOntologyManager.getOWLDataFactory().getOWLClass(BlackBoxOWLDebugger.createIRI());
        HashSet<Object> operands = new HashSet<Object>();
        operands.add(curCls);
        operands.add(cls);
        this.temporaryAxioms.add((OWLAxiom)this.owlOntologyManager.getOWLDataFactory().getOWLEquivalentClassesAxiom(operands));
        for (OWLAxiom ax : this.temporaryAxioms) {
            assert (ax != null);
            this.owlOntologyManager.applyChange((OWLOntologyChange)new AddAxiom(this.getOWLOntology(), ax));
        }
        return curCls;
    }

    @Override
    public Set<OWLAxiom> getSOSForInconsistentClass(OWLClassExpression cls) throws OWLException {
        this.reset();
        this.currentClass = this.setupDebuggingClass(cls);
        this.generateSOSAxioms();
        for (OWLAxiom ax : this.temporaryAxioms) {
            assert (ax != null);
            this.owlOntologyManager.applyChange((OWLOntologyChange)new RemoveAxiom(this.getOWLOntology(), ax));
        }
        this.debuggingAxioms.removeAll(this.temporaryAxioms);
        return new HashSet<OWLAxiom>(this.debuggingAxioms);
    }

    private int expandAxioms() {
        int added;
        int axiomsAdded = 0;
        int remainingSpace = this.expansionLimit;
        double expansionFactor = 1.25;
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithDefiningAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                assert (curObj != null);
                if (this.objectsExpandedWithDefiningAxioms.contains(curObj)) continue;
                added = this.expandWithDefiningAxioms(curObj, remainingSpace);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithDefiningAxioms.add(curObj);
            }
            this.expandedWithDefiningAxioms.add(ax);
        }
        if (axiomsAdded > 0) {
            return axiomsAdded;
        }
        for (OWLAxiom ax : new ArrayList<OWLAxiom>(this.debuggingAxioms)) {
            if (this.expandedWithReferencingAxioms.contains(ax)) continue;
            for (OWLEntity curObj : ax.getSignature()) {
                assert (curObj != null);
                if (this.objectsExpandedWithReferencingAxioms.contains(curObj)) continue;
                added = this.expandWithReferencingAxioms(curObj, this.expansionLimit);
                axiomsAdded += added;
                if ((remainingSpace -= added) == 0) {
                    this.expansionLimit = (int)((double)this.expansionLimit * expansionFactor);
                    return axiomsAdded;
                }
                this.objectsExpandedWithReferencingAxioms.add(curObj);
            }
            this.expandedWithReferencingAxioms.add(ax);
        }
        return axiomsAdded;
    }

    private int expandWithDefiningAxioms(@Nonnull OWLEntity obj, int limit) {
        HashSet expansionAxioms = new HashSet();
        if (obj instanceof OWLClass) {
            expansionAxioms.addAll(this.getOWLOntology().getAxioms((OWLClass)obj, Imports.INCLUDED));
        } else if (obj instanceof OWLObjectProperty) {
            expansionAxioms.addAll(this.getOWLOntology().getAxioms((OWLObjectPropertyExpression)((OWLObjectProperty)obj), Imports.INCLUDED));
        } else if (obj instanceof OWLDataProperty) {
            expansionAxioms.addAll(this.getOWLOntology().getAxioms((OWLDataProperty)obj, Imports.INCLUDED));
        } else if (obj instanceof OWLIndividual) {
            expansionAxioms.addAll(this.getOWLOntology().getAxioms((OWLIndividual)obj, Imports.INCLUDED));
        }
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private int expandWithReferencingAxioms(@Nonnull OWLEntity obj, int limit) {
        HashSet expansionAxioms = new HashSet();
        expansionAxioms.addAll(this.getOWLOntology().getReferencingAxioms((OWLPrimitive)obj, Imports.INCLUDED));
        expansionAxioms.removeAll(this.debuggingAxioms);
        return BlackBoxOWLDebugger.addMax(expansionAxioms, this.debuggingAxioms, limit);
    }

    private static <N extends OWLAxiom> int addMax(@Nonnull Set<N> source, @Nonnull Set<N> dest, int limit) {
        int count = 0;
        for (OWLAxiom obj : source) {
            if (count == limit) break;
            if (obj instanceof OWLAnnotationAxiom || !dest.add(obj)) continue;
            ++count;
        }
        return count;
    }

    private void performFastPruning() throws OWLException {
        HashSet<OWLAxiom> axiomWindow = new HashSet<OWLAxiom>();
        Object[] axioms = this.debuggingAxioms.toArray();
        LOGGER.info("Fast pruning: ");
        LOGGER.info("     - Window size: {}", (Object)this.fastPruningWindowSize);
        int windowCount = this.debuggingAxioms.size() / this.fastPruningWindowSize;
        for (int currentWindow = 0; currentWindow < windowCount; ++currentWindow) {
            axiomWindow.clear();
            int startIndex = currentWindow * this.fastPruningWindowSize;
            int endIndex = startIndex + this.fastPruningWindowSize;
            for (int axiomIndex = startIndex; axiomIndex < endIndex; ++axiomIndex) {
                OWLAxiom currentAxiom = (OWLAxiom)axioms[axiomIndex];
                axiomWindow.add(currentAxiom);
                this.debuggingAxioms.remove(currentAxiom);
            }
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.addAll(axiomWindow);
        }
        axiomWindow.clear();
        int remainingAxiomsCount = this.debuggingAxioms.size() % this.fastPruningWindowSize;
        if (remainingAxiomsCount > 0) {
            for (int fragmentIndex = windowCount * this.fastPruningWindowSize; fragmentIndex < axioms.length; ++fragmentIndex) {
                OWLAxiom curAxiom = (OWLAxiom)axioms[fragmentIndex];
                axiomWindow.add(curAxiom);
                this.debuggingAxioms.remove(curAxiom);
            }
            if (this.isSatisfiable()) {
                this.debuggingAxioms.addAll(axiomWindow);
            }
        }
        LOGGER.info("    - End of fast pruning");
    }

    private void performSlowPruning() throws OWLException {
        ArrayList<OWLAxiom> axiomsCopy = new ArrayList<OWLAxiom>(this.debuggingAxioms);
        for (OWLAxiom ax : axiomsCopy) {
            this.debuggingAxioms.remove(ax);
            if (!this.isSatisfiable()) continue;
            this.debuggingAxioms.add(ax);
        }
    }

    @Nonnull
    protected OWLOntology getDebuggingOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.debuggingOntology);
    }

    private boolean isSatisfiable() throws OWLException {
        this.createDebuggingOntology();
        OWLReasoner reasoner = this.reasonerFactory.createNonBufferingReasoner(this.getDebuggingOntology());
        ++this.satTestCount;
        boolean sat = reasoner.isSatisfiable((OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.currentClass));
        reasoner.dispose();
        return sat;
    }

    private void createDebuggingOntology() throws OWLException {
        OWLAxiom ax2;
        if (this.debuggingOntology != null) {
            this.owlOntologyManager.removeOntology((OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.debuggingOntology));
        }
        IRI iri = BlackBoxOWLDebugger.createIRI();
        SimpleIRIMapper mapper = new SimpleIRIMapper(iri, iri);
        this.owlOntologyManager.getIRIMappers().add((Serializable)mapper);
        this.debuggingOntology = this.owlOntologyManager.createOntology(iri);
        this.owlOntologyManager.getIRIMappers().remove((Serializable)mapper);
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom ax2 : this.debuggingAxioms) {
            assert (ax2 != null);
            changes.add(new AddAxiom(this.getDebuggingOntology(), ax2));
        }
        for (OWLAxiom ax2 : this.temporaryAxioms) {
            assert (ax2 != null);
            changes.add(new AddAxiom(this.getDebuggingOntology(), ax2));
        }
        OWLDataFactory factory = this.owlOntologyManager.getOWLDataFactory();
        ax2 = factory.getOWLSubClassOfAxiom((OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.currentClass), (OWLClassExpression)factory.getOWLThing());
        changes.add(new AddAxiom(this.getDebuggingOntology(), ax2));
        this.owlOntologyManager.applyChanges(changes);
    }

    private void resetSatisfiabilityTestCounter() {
        this.satTestCount = 0;
    }

    private void generateSOSAxioms() throws OWLException {
        this.resetSatisfiabilityTestCounter();
        this.expandWithDefiningAxioms((OWLEntity)((OWLClass)this.getCurrentClass()), this.expansionLimit);
        LOGGER.info("Initial axiom count: {}", (Object)this.debuggingAxioms.size());
        int totalAdded = 0;
        int expansionCount = 0;
        while (this.isSatisfiable()) {
            LOGGER.info("Expanding axioms (expansion {})", (Object)expansionCount);
            ++expansionCount;
            int numberAdded = this.expandAxioms();
            totalAdded += numberAdded;
            LOGGER.info("    ... expanded by {}", (Object)numberAdded);
            if (numberAdded != 0) continue;
            LOGGER.info("ERROR! Cannot find SOS axioms!");
            this.debuggingAxioms.clear();
            return;
        }
        LOGGER.info("Total number of axioms added: {}", (Object)totalAdded);
        LOGGER.info("FOUND CLASH! Pruning {} axioms...", (Object)this.debuggingAxioms.size());
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Fast pruning...");
        this.performFastPruning();
        LOGGER.info("... end of fast pruning. Axioms remaining: {}", (Object)this.debuggingAxioms.size());
        LOGGER.info("Performed {} satisfiability tests during fast pruning", (Object)this.satTestCount);
        int totalSatTests = this.satTestCount;
        this.resetSatisfiabilityTestCounter();
        LOGGER.info("Slow pruning...");
        this.performSlowPruning();
        LOGGER.info("... end of slow pruning");
        LOGGER.info("Performed {} satisfiability tests during slow pruning", (Object)this.satTestCount);
        LOGGER.info("Total number of satisfiability tests performed: {}", (Object)(totalSatTests += this.satTestCount));
    }

    @Nonnull
    private static IRI createIRI() {
        return OWLOntologyDocumentSourceBase.getNextDocumentIRI((String)"http://debugging.blackbox#A");
    }
}

