/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.normalform;

import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.normalform.NormalFormRewriter;
import org.semanticweb.owlapi.normalform.OWLObjectComplementOfExtractor;
import org.semanticweb.owlapi.util.NNF;

public class NegationalNormalFormConverter
implements NormalFormRewriter {
    private final NNF nnf;
    private final OWLObjectComplementOfExtractor extractor;

    public NegationalNormalFormConverter(OWLDataFactory dataFactory) {
        this.nnf = new NNF(dataFactory);
        this.extractor = new OWLObjectComplementOfExtractor();
    }

    @Override
    public boolean isInNormalForm(OWLClassExpression classExpression) {
        this.extractor.getComplementedClassExpressions(classExpression);
        for (OWLClassExpression desc : this.extractor.getComplementedClassExpressions(classExpression)) {
            if (!desc.isAnonymous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OWLClassExpression convertToNormalForm(OWLClassExpression classExpression) {
        this.nnf.reset();
        return (OWLClassExpression)classExpression.accept((OWLClassExpressionVisitorEx)this.nnf);
    }
}

