/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.metrics.DoubleValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class AverageAssertedNamedSuperclassCount
extends DoubleValuedMetric {
    public AverageAssertedNamedSuperclassCount(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    public String getName() {
        return "Average number of named superclasses";
    }

    @Override
    public Double recomputeMetric() {
        int total = 0;
        int count = 0;
        HashSet<OWLClass> processedClasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                if (processedClasses.contains(cls)) continue;
                ++count;
                int prevTotal = total;
                processedClasses.add(cls);
                for (OWLClassExpression desc : cls.getSuperClasses(ont)) {
                    if (desc.isAnonymous()) continue;
                    ++total;
                }
                if (prevTotal != total) continue;
                ++total;
            }
        }
        return (double)total / (double)count;
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

