/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class SplitSubClassAxioms
extends AbstractCompositeOntologyChange {
    private final List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public SplitSubClassAxioms(Set<OWLOntology> ontologies, OWLDataFactory dataFactory) {
        super(dataFactory);
        for (OWLOntology ont : ontologies) {
            for (OWLSubClassOfAxiom ax : ont.getAxioms(AxiomType.SUBCLASS_OF)) {
                ConjunctSplitter splitter = new ConjunctSplitter();
                ax.getSuperClass().accept((OWLClassExpressionVisitor)splitter);
                if (splitter.result.size() <= 1) continue;
                this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
                for (OWLClassExpression desc : splitter.result) {
                    OWLSubClassOfAxiom replAx = this.getDataFactory().getOWLSubClassOfAxiom(ax.getSubClass(), desc);
                    this.changes.add((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)replAx));
                }
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    private static class ConjunctSplitter
    implements OWLClassExpressionVisitor {
        Set<OWLClassExpression> result = new HashSet<OWLClassExpression>();

        public void visit(OWLClass desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataExactCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataMinCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLDataHasValue desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectComplementOf desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression op : desc.getOperands()) {
                op.accept((OWLClassExpressionVisitor)this);
            }
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectOneOf desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectHasSelf desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectUnionOf desc) {
            this.result.add((OWLClassExpression)desc);
        }

        public void visit(OWLObjectHasValue desc) {
            this.result.add((OWLClassExpression)desc);
        }
    }
}

