/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class AddClassExpressionClosureAxiom
extends AbstractCompositeOntologyChange {
    private final OWLClass cls;
    protected final OWLObjectPropertyExpression property;
    private final Set<OWLOntology> ontologies;
    private final OWLOntology targetOntology;
    private final List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();

    public AddClassExpressionClosureAxiom(OWLDataFactory dataFactory, OWLClass cls, OWLObjectPropertyExpression property, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        super(dataFactory);
        this.cls = cls;
        this.property = property;
        this.ontologies = ontologies;
        this.targetOntology = targetOntology;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes.clear();
        FillerCollector collector = new FillerCollector();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(this.cls)) {
                ax.getSuperClass().accept((OWLClassExpressionVisitor)collector);
            }
        }
        Set<OWLClassExpression> fillers = collector.getFillers();
        if (fillers.isEmpty()) {
            return;
        }
        OWLObjectUnionOf closureAxiomFiller = this.getDataFactory().getOWLObjectUnionOf(fillers);
        OWLObjectAllValuesFrom closureAxiomDesc = this.getDataFactory().getOWLObjectAllValuesFrom(this.property, (OWLClassExpression)closureAxiomFiller);
        this.changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, (OWLAxiom)this.getDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)this.cls, (OWLClassExpression)closureAxiomDesc)));
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }

    private class FillerCollector
    extends OWLClassExpressionVisitorAdapter {
        private Set<OWLClassExpression> fillers = new HashSet<OWLClassExpression>();

        public Set<OWLClassExpression> getFillers() {
            return this.fillers;
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            if (((OWLObjectPropertyExpression)desc.getProperty()).equals(AddClassExpressionClosureAxiom.this.property)) {
                this.fillers.add((OWLClassExpression)desc.getFiller());
            }
        }

        public void visit(OWLObjectHasValue desc) {
            if (((OWLObjectPropertyExpression)desc.getProperty()).equals(AddClassExpressionClosureAxiom.this.property)) {
                this.fillers.add((OWLClassExpression)AddClassExpressionClosureAxiom.this.getDataFactory().getOWLObjectOneOf(CollectionFactory.createSet((Object[])new OWLIndividual[]{(OWLIndividual)desc.getValue()})));
            }
        }
    }
}

