/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.MultipleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import com.clarkparsia.owlapi.explanation.util.OntologyUtils;
import com.clarkparsia.owlapi.explanation.util.SilentExplanationProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class HSTExplanationGenerator
implements MultipleExplanationGenerator {
    private static final Logger log = Logger.getLogger(HSTExplanationGenerator.class.getName());
    private final TransactionAwareSingleExpGen singleExplanationGenerator;
    private ExplanationProgressMonitor progressMonitor = new SilentExplanationProgressMonitor();

    public HSTExplanationGenerator(TransactionAwareSingleExpGen singleExplanationGenerator) {
        this.singleExplanationGenerator = singleExplanationGenerator;
    }

    @Override
    public void setProgressMonitor(ExplanationProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    @Override
    public OWLOntologyManager getOntologyManager() {
        return this.singleExplanationGenerator.getOntologyManager();
    }

    @Override
    public OWLOntology getOntology() {
        return this.singleExplanationGenerator.getOntology();
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.singleExplanationGenerator.getReasoner();
    }

    @Override
    public OWLReasonerFactory getReasonerFactory() {
        return this.singleExplanationGenerator.getReasonerFactory();
    }

    public TransactionAwareSingleExpGen getSingleExplanationGenerator() {
        return this.singleExplanationGenerator;
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        return this.singleExplanationGenerator.getExplanation(unsatClass);
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass) {
        return this.getExplanations(unsatClass, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass, int maxExplanations) {
        if (maxExplanations < 0) {
            throw new IllegalArgumentException();
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Get " + (maxExplanations == 0 ? "all" : Integer.valueOf(maxExplanations)) + " explanation(s) for: " + unsatClass);
        }
        try {
            Set<OWLAxiom> firstMups = this.getExplanation(unsatClass);
            if (firstMups.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<Set<OWLAxiom>> allMups = new LinkedHashSet<Set<OWLAxiom>>();
            this.progressMonitor.foundExplanation(firstMups);
            allMups.add(firstMups);
            HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
            HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
            this.singleExplanationGenerator.beginTransaction();
            try {
                this.constructHittingSetTree(unsatClass, firstMups, allMups, satPaths, currentPathContents, maxExplanations);
            }
            finally {
                this.singleExplanationGenerator.endTransaction();
            }
            this.progressMonitor.foundAllExplanations();
            return allMups;
        }
        catch (OWLException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private static List<OWLAxiom> getOrderedMUPS(List<OWLAxiom> mups, final Set<Set<OWLAxiom>> allMups) {
        Comparator<OWLAxiom> mupsComparator = new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                int occ1 = HSTExplanationGenerator.getOccurrences(o1, allMups);
                int occ2 = HSTExplanationGenerator.getOccurrences(o2, allMups);
                return -occ1 + occ2;
            }
        };
        Collections.sort(mups, mupsComparator);
        return mups;
    }

    protected static int getOccurrences(OWLAxiom ax, Set<Set<OWLAxiom>> axiomSets) {
        int count = 0;
        for (Set<OWLAxiom> axioms : axiomSets) {
            if (!axioms.contains(ax)) continue;
            ++count;
        }
        return count;
    }

    private Set<OWLEntity> getSignature(OWLAxiom axiom) {
        HashSet<OWLEntity> toReturn = new HashSet<OWLEntity>();
        OWLEntityCollector collector = new OWLEntityCollector(toReturn);
        collector.setCollectDatatypes(false);
        axiom.accept((OWLObjectVisitor)collector);
        return toReturn;
    }

    private void constructHittingSetTree(OWLClassExpression unsatClass, Set<OWLAxiom> mups, Set<Set<OWLAxiom>> allMups, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents, int maxExplanations) throws OWLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("MUPS " + allMups.size() + ": " + mups);
        }
        if (this.progressMonitor.isCancelled()) {
            return;
        }
        List<OWLAxiom> orderedMups = HSTExplanationGenerator.getOrderedMUPS(new ArrayList<OWLAxiom>(mups), allMups);
        while (!orderedMups.isEmpty()) {
            if (this.progressMonitor.isCancelled()) {
                return;
            }
            OWLAxiom axiom = orderedMups.get(0);
            orderedMups.remove(0);
            if (allMups.size() == maxExplanations) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Computed " + maxExplanations + "explanations");
                }
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removing axiom: " + axiom + " " + currentPathContents.size() + " more removed: " + currentPathContents);
            }
            Set<OWLOntology> ontologies = OntologyUtils.removeAxiom(axiom, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
            Set<OWLEntity> sig = this.getSignature(axiom);
            ArrayList<OWLDeclarationAxiom> temporaryDeclarations = new ArrayList<OWLDeclarationAxiom>(sig.size());
            for (OWLEntity e : sig) {
                boolean referenced = false;
                Iterator<OWLOntology> i = ontologies.iterator();
                while (!referenced && i.hasNext()) {
                    Iterator j = i.next().getReferencingAxioms(e).iterator();
                    while (!referenced && j.hasNext()) {
                        OWLAxiom a = (OWLAxiom)j.next();
                        referenced = a.isLogicalAxiom() || a instanceof OWLDeclarationAxiom;
                    }
                }
                if (referenced) continue;
                OWLDeclarationAxiom declaration = this.getOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(e);
                temporaryDeclarations.add(declaration);
            }
            for (OWLDeclarationAxiom decl : temporaryDeclarations) {
                OntologyUtils.addAxiom((OWLAxiom)decl, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
            }
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!currentPathContents.containsAll(satPath)) continue;
                earlyTermination = true;
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("Stop - satisfiable (early termination)");
                break;
            }
            if (!earlyTermination) {
                Set<OWLAxiom> newMUPS = null;
                for (Set<OWLAxiom> foundMUPS : allMups) {
                    HashSet<OWLAxiom> foundMUPSCopy = new HashSet<OWLAxiom>(foundMUPS);
                    foundMUPSCopy.retainAll(currentPathContents);
                    if (!foundMUPSCopy.isEmpty()) continue;
                    newMUPS = foundMUPS;
                    break;
                }
                if (newMUPS == null) {
                    newMUPS = this.getExplanation(unsatClass);
                }
                if (newMUPS.contains(axiom)) {
                    throw new OWLRuntimeException("Explanation contains removed axiom: " + axiom);
                }
                if (!newMUPS.isEmpty()) {
                    allMups.add(newMUPS);
                    this.progressMonitor.foundExplanation(newMUPS);
                    this.constructHittingSetTree(unsatClass, newMUPS, allMups, satPaths, currentPathContents, maxExplanations);
                    orderedMups = HSTExplanationGenerator.getOrderedMUPS(orderedMups, allMups);
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Stop - satisfiable");
                    }
                    satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
                }
            }
            currentPathContents.remove(axiom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Restoring axiom: " + axiom);
            }
            for (OWLDeclarationAxiom decl : temporaryDeclarations) {
                OntologyUtils.removeAxiom((OWLAxiom)decl, this.getReasoner().getRootOntology().getImportsClosure(), this.getOntologyManager());
            }
            OntologyUtils.addAxiom(axiom, ontologies, this.getOntologyManager());
        }
    }
}

