/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RioUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RioUtils.class);

    private RioUtils() {
    }

    @Nullable
    public static Statement tripleAsStatement(RDFTriple triple) {
        Collection<Statement> statements = RioUtils.tripleAsStatements(triple, new Resource[0]);
        if (!statements.isEmpty()) {
            return statements.iterator().next();
        }
        return null;
    }

    public static Collection<Statement> tripleAsStatements(RDFTriple triple, Resource ... contexts) {
        Object object;
        URI subject;
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ValueFactoryImpl vf = ValueFactoryImpl.getInstance();
        if (triple.getSubject() instanceof RDFResourceIRI) {
            try {
                subject = vf.createURI(triple.getSubject().getIRI().toString());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Subject URI was invalid: {}", (Object)triple);
                return Collections.emptyList();
            }
        } else {
            subject = triple.getSubject().getIRI().toString().startsWith("_:") ? vf.createBNode(triple.getSubject().getIRI().toString().substring(2)) : vf.createBNode(triple.getSubject().getIRI().toString());
        }
        URI predicate = vf.createURI(triple.getPredicate().getIRI().toString());
        if (triple.getObject() instanceof RDFResourceIRI) {
            try {
                object = vf.createURI(triple.getObject().getIRI().toString());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Object URI was invalid: {}", (Object)triple);
                return Collections.emptyList();
            }
        } else {
            RDFLiteral literalObject;
            object = triple.getObject() instanceof RDFLiteral ? ((literalObject = (RDFLiteral)triple.getObject()).isPlainLiteral() ? (literalObject.hasLang() ? vf.createLiteral(literalObject.getLexicalValue(), literalObject.getLang()) : vf.createLiteral(literalObject.getLexicalValue())) : vf.createLiteral(literalObject.getLexicalValue(), vf.createURI(literalObject.getDatatype().toString()))) : (triple.getObject().getIRI().toString().startsWith("_:") ? vf.createBNode(triple.getObject().getIRI().toString().substring(2)) : vf.createBNode(triple.getObject().getIRI().toString()));
        }
        if (contexts == null || contexts.length == 0) {
            return Collections.singletonList(vf.createStatement((Resource)subject, predicate, (Value)object));
        }
        ArrayList<Statement> results = new ArrayList<Statement>(contexts.length);
        Resource[] resourceArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Resource nextContext = resourceArray[n2];
            results.add(vf.createStatement((Resource)subject, predicate, (Value)object, nextContext));
            ++n2;
        }
        return results;
    }
}

