/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rio.utils.RioUtils;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioRenderer
extends RDFRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(RioRenderer.class);
    private final RDFHandler writer;
    private final DefaultPrefixManager pm;
    @Nonnull
    private final Set<RDFResource> pending = new LinkedHashSet<RDFResource>();
    @Nonnull
    private final Set<RDFTriple> renderedStatements = new LinkedHashSet<RDFTriple>();
    private final Resource[] contexts;

    public RioRenderer(@Nonnull OWLOntology ontology, RDFHandler writer, OWLDocumentFormat format, Resource ... contexts) {
        super(ontology, format);
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = contexts;
        this.writer = writer;
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous()) {
            String ontologyIRIString;
            String defaultPrefix = ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (!ontologyIRIString.endsWith("/") && !ontologyIRIString.endsWith("#")) {
                defaultPrefix = String.valueOf(ontologyIRIString) + '#';
            }
            this.pm.setDefaultPrefix(defaultPrefix);
        }
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)format;
            this.pm.copyPrefixesFrom((PrefixManager)prefixFormat);
            this.pm.setPrefixComparator(prefixFormat.getPrefixComparator());
        }
    }

    protected void beginDocument() throws IOException {
        this.pending.clear();
        this.renderedStatements.clear();
        try {
            this.writer.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        this.writeNamespaces();
    }

    protected void endDocument() throws IOException {
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        try {
            this.writer.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("pendingNodes={}", (Object)this.pending.size());
            logger.trace("renderedStatements={}", (Object)this.renderedStatements.size());
        }
        this.pending.clear();
        this.renderedStatements.clear();
    }

    protected void endObject() throws IOException {
        this.writeComment("");
    }

    protected void renderOntologyHeader() throws IOException {
        super.renderOntologyHeader();
        this.triplesWithRemappedNodes = this.graph.computeRemappingForSharedNodes();
    }

    protected void createGraph(Set<? extends OWLObject> objects) {
        super.createGraph(objects);
        this.triplesWithRemappedNodes = this.graph.computeRemappingForSharedNodes();
    }

    public void render(RDFResource node, boolean root) throws IOException {
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        Collection triples = this.graph.getTriplesForSubject((RDFNode)node);
        if (logger.isTraceEnabled()) {
            logger.trace("triples.size()={}", (Object)triples.size());
            if (!triples.isEmpty()) {
                logger.trace("triples={}", (Object)triples);
            }
        }
        for (RDFTriple triple : triples) {
            RDFTriple tripleToRender = this.remapNodesIfNecessary(node, triple);
            try {
                if (!this.renderedStatements.contains(tripleToRender)) {
                    this.renderedStatements.add(tripleToRender);
                    for (Statement statement : RioUtils.tripleAsStatements(tripleToRender, this.contexts)) {
                        this.writer.handleStatement(statement);
                        if (!(tripleToRender.getObject() instanceof RDFResource)) continue;
                        this.render((RDFResource)tripleToRender.getObject(), false);
                    }
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("not printing duplicate statement, or recursing on its object: {}", (Object)tripleToRender);
            }
            catch (RDFHandlerException e) {
                throw new IOException(e);
            }
        }
        this.pending.remove(node);
    }

    protected void writeAnnotationPropertyComment(@Nonnull OWLAnnotationProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }

    protected void writeBanner(String name) throws IOException {
        this.writeComment("");
        this.writeComment("");
        this.writeComment("#################################################################");
        this.writeComment("#");
        this.writeComment("#    " + name);
        this.writeComment("#");
        this.writeComment("#################################################################");
        this.writeComment("");
        this.writeComment("");
    }

    protected void writeClassComment(@Nonnull OWLClass cls) throws IOException {
        this.writeComment(cls.getIRI().toString());
    }

    private void writeComment(String comment) throws IOException {
        try {
            this.writer.handleComment(comment);
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
    }

    protected void writeDataPropertyComment(@Nonnull OWLDataProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }

    protected void writeDatatypeComment(@Nonnull OWLDatatype datatype) throws IOException {
        this.writeComment(datatype.getIRI().toString());
    }

    protected void writeIndividualComments(@Nonnull OWLNamedIndividual ind) throws IOException {
        this.writeComment(ind.getIRI().toString());
    }

    private void writeNamespaces() throws IOException {
        for (String prefixName : this.pm.getPrefixName2PrefixMap().keySet()) {
            assert (prefixName != null);
            String prefix = this.pm.getPrefix(prefixName);
            if (prefixName.endsWith(":")) {
                prefixName = prefixName.substring(0, prefixName.length() - 1);
            }
            try {
                this.writer.handleNamespace(prefixName, prefix);
            }
            catch (RDFHandlerException e) {
                throw new IOException(e);
            }
        }
    }

    protected void writeObjectPropertyComment(@Nonnull OWLObjectProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }
}

