/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import javax.annotation.Nonnull;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.formats.RDFDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioOWLRDFConsumerAdapter
extends OWLRDFConsumer
implements RDFHandler {
    private static final Logger logger = LoggerFactory.getLogger(RioOWLRDFConsumerAdapter.class);

    public RioOWLRDFConsumerAdapter(@Nonnull OWLOntology ontology, @Nonnull AnonymousNodeChecker checker, @Nonnull OWLOntologyLoaderConfiguration configuration) {
        super(ontology, checker, configuration);
    }

    public void endRDF() {
        this.endModel();
    }

    public void handleComment(String comment) {
    }

    public void handleNamespace(String prefix, String uri) {
        RDFDocumentFormat format = this.getOntologyFormat();
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixDocumentFormat = (PrefixDocumentFormat)format;
            prefixDocumentFormat.setPrefix(String.valueOf(prefix) + ':', uri);
        }
    }

    public void handleStatement(Statement st) {
        String objectString;
        String subjectString;
        if (st.getSubject() instanceof BNode) {
            subjectString = st.getSubject().stringValue();
            subjectString = "_:genid-nodeid-" + subjectString;
        } else {
            subjectString = st.getSubject().stringValue();
        }
        if (st.getObject() instanceof BNode) {
            objectString = st.getObject().stringValue();
            objectString = "_:genid-nodeid-" + objectString;
        } else {
            objectString = st.getObject().stringValue();
        }
        if (st.getObject() instanceof Resource) {
            logger.trace("statement with resource value");
            this.statementWithResourceValue(subjectString, st.getPredicate().stringValue(), objectString);
        } else {
            Literal literalObject = (Literal)st.getObject();
            String literalDatatype = null;
            String literalLanguage = literalObject.getLanguage();
            if (literalObject.getDatatype() != null) {
                literalDatatype = literalObject.getDatatype().stringValue();
            }
            logger.trace("statement with literal value");
            this.statementWithLiteralValue(subjectString, st.getPredicate().stringValue(), objectString, literalLanguage, literalDatatype);
        }
    }

    public void startRDF() {
        this.startModel(IRI.create((String)"urn:unused"));
    }
}

