/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.dlsyntax.parser.DLSyntaxParserConstants;
import org.semanticweb.owlapi.dlsyntax.parser.DLSyntaxParserTokenManager;
import org.semanticweb.owlapi.dlsyntax.parser.JavaCharStream;
import org.semanticweb.owlapi.dlsyntax.parser.ParseException;
import org.semanticweb.owlapi.dlsyntax.parser.Provider;
import org.semanticweb.owlapi.dlsyntax.parser.StringProvider;
import org.semanticweb.owlapi.dlsyntax.parser.Token;
import org.semanticweb.owlapi.dlsyntax.parser.TokenMgrException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class DLSyntaxParser
implements DLSyntaxParserConstants {
    private String defaultNamespace = IRI.getNextDocumentIRI((String)"http://www.semanticweb.org/ontologies/Ontology").toString();
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private OWLDataFactory factory;
    private Map<String, IRI> iriMap = new HashMap<String, IRI>();
    private Map<String, IRI> qnameIRIMap = new HashMap<String, IRI>();
    private Set<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
    public DLSyntaxParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[23];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[14];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public void setOWLDataFactory(OWLDataFactory factory) {
        this.factory = factory;
    }

    public void setPrefixMapping(String prefix, String namespace) {
        this.namespaceMap.put(prefix, namespace);
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public IRI getIRI(String val) {
        IRI iri = this.iriMap.get(val);
        if (iri == null) {
            iri = IRI.create((String)val);
            this.iriMap.put(val, iri);
        }
        return iri;
    }

    public IRI getIRIFromId(String qname) {
        if (qname.equals("top") || qname.equals("\u22a4")) {
            return OWLRDFVocabulary.OWL_THING.getIRI();
        }
        if (qname.equals("bottom") || qname.equals("\u22a5")) {
            return OWLRDFVocabulary.OWL_NOTHING.getIRI();
        }
        IRI iri = this.qnameIRIMap.get(qname);
        if (iri == null) {
            iri = this.getIRI(this.defaultNamespace + "#" + qname);
            this.qnameIRIMap.put(qname, iri);
        }
        return iri;
    }

    private void addAxiom(OWLAxiom ax) {
        if (ax == null) {
            return;
        }
        this.axioms.add(ax);
    }

    public final OWLClassExpression parseDescription() throws ParseException {
        OWLClassExpression desc = this.parseClassDescription();
        this.jj_consume_token(0);
        return desc;
    }

    public final Set<OWLAxiom> parseAxioms() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 16: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 29: 
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                }
            }
            OWLAxiom ax = this.parseAxiom();
            this.addAxiom(ax);
        }
        this.jj_consume_token(0);
        return this.axioms;
    }

    public final OWLAxiom parseAxiom() throws ParseException {
        OWLAxiom ax;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                ax = this.parsePropertyAxiom();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                if (this.jj_2_1(3)) {
                    ax = this.parseClassAxiom();
                    break;
                }
                if (this.jj_2_2(3)) {
                    ax = this.parseIndividualAxiom();
                    break;
                }
                if (this.jj_2_3(3)) {
                    ax = this.parseObjectPropertyAssertion();
                    break;
                }
                if (this.jj_2_4(3)) {
                    ax = this.parseDataPropertyAssertion();
                    break;
                }
                if (this.jj_2_5(2)) {
                    ax = this.parseDifferentIndividualsAxiom();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ax;
    }

    public final OWLAxiom parseIndividualAxiom() throws ParseException {
        OWLAxiom ax;
        if (this.jj_2_6(2)) {
            ax = this.parseClassAssertion();
        } else if (this.jj_2_7(2)) {
            ax = this.parseSameIndividual();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLAxiom parseDifferentIndividualsAxiom() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.parseIndividualId();
        inds.add(ind);
        this.jj_consume_token(6);
        ind = this.parseIndividualId();
        inds.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            ind = this.parseIndividualId();
            inds.add(ind);
        }
        return this.factory.getOWLDifferentIndividualsAxiom(inds);
    }

    public final OWLAxiom parseObjectPropertyAssertion() throws ParseException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        this.jj_consume_token(10);
        OWLIndividual subj = this.parseIndividualId();
        this.jj_consume_token(31);
        OWLIndividual obj = this.parseIndividualId();
        this.jj_consume_token(11);
        return this.factory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj);
    }

    public final OWLAxiom parseDataPropertyAssertion() throws ParseException {
        OWLDataPropertyExpression prop = this.parseDataPropertyId();
        this.jj_consume_token(10);
        OWLIndividual subj = this.parseIndividualId();
        this.jj_consume_token(31);
        OWLLiteral obj = this.parseLiteral();
        this.jj_consume_token(11);
        return this.factory.getOWLDataPropertyAssertionAxiom(prop, subj, obj);
    }

    public final OWLAxiom parseSameIndividual() throws ParseException {
        OWLIndividual indA = this.parseIndividualId();
        this.jj_consume_token(24);
        OWLIndividual indB = this.parseIndividualId();
        return this.factory.getOWLSameIndividualAxiom(new OWLIndividual[]{indA, indB});
    }

    public final OWLAxiom parseClassAssertion() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_8(3)) {
            this.jj_consume_token(10);
            desc = this.parseDescription();
            this.jj_consume_token(11);
        } else if (this.jj_2_9(3)) {
            desc = this.parseClassDescription();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(10);
        OWLIndividual ind = this.parseIndividualId();
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                this.jj_input_stream.backup(1);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.factory.getOWLClassAssertionAxiom(desc, ind);
    }

    public final OWLAxiom parseClassAxiom() throws ParseException {
        boolean subClassAxiom = false;
        OWLEquivalentClassesAxiom ax = null;
        OWLClassExpression lhs = this.parseClassDescription();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                OWLClassExpression rhs = this.parseClassDescription();
                if (lhs.isOWLThing()) {
                    OWLObjectMaxCardinality r;
                    if (rhs instanceof OWLObjectAllValuesFrom) {
                        OWLObjectAllValuesFrom r2 = (OWLObjectAllValuesFrom)rhs;
                        ax = this.factory.getOWLObjectPropertyRangeAxiom(r2.getProperty(), (OWLClassExpression)r2.getFiller());
                        break;
                    }
                    if (!(rhs instanceof OWLObjectMaxCardinality) || (r = (OWLObjectMaxCardinality)rhs).getCardinality() != 1 || !((OWLClassExpression)r.getFiller()).isOWLThing()) break;
                    ax = this.factory.getOWLFunctionalObjectPropertyAxiom(r.getProperty());
                    break;
                }
                if (lhs instanceof OWLObjectSomeValuesFrom) {
                    OWLObjectSomeValuesFrom restriction = (OWLObjectSomeValuesFrom)lhs;
                    if (!((OWLClassExpression)restriction.getFiller()).isOWLThing()) break;
                    ax = this.factory.getOWLObjectPropertyDomainAxiom(restriction.getProperty(), rhs);
                    break;
                }
                if (rhs instanceof OWLObjectComplementOf && !rhs.isAnonymous()) {
                    ax = this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{lhs, ((OWLObjectComplementOf)rhs).getOperand()});
                    break;
                }
                ax = this.factory.getOWLSubClassOfAxiom(lhs, rhs);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                OWLClassExpression rhs = this.parseClassDescription();
                ax = this.factory.getOWLEquivalentClassesAxiom(lhs, rhs);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ax;
    }

    public final OWLAxiom parsePropertyChain() throws ParseException {
        ArrayList<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        props.add(prop);
        this.jj_consume_token(7);
        prop = this.parseObjectPropertyId();
        props.add(prop);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            prop = this.parseObjectPropertyId();
            props.add(prop);
        }
        this.jj_consume_token(4);
        OWLObjectPropertyExpression supProp = this.parseObjectPropertyId();
        return this.factory.getOWLSubPropertyChainOfAxiom(props, supProp);
    }

    public final OWLAxiom parsePropertyAxiom() throws ParseException {
        OWLAxiom ax;
        block10: {
            block9: {
                if (!this.jj_2_10(3)) break block9;
                OWLObjectPropertyExpression lhs = this.parseObjectPropertyId();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                        ax = this.factory.getOWLSubObjectPropertyOfAxiom(lhs, rhs);
                        break block10;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                        if (rhs instanceof OWLObjectInverseOf) {
                            OWLObjectInverseOf inv = (OWLObjectInverseOf)rhs;
                            ax = this.factory.getOWLInverseObjectPropertiesAxiom(lhs, inv.getInverse());
                        } else {
                            ax = this.factory.getOWLEquivalentObjectPropertiesAxiom((Collection)CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{lhs, rhs}));
                        }
                        break block10;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        this.jj_consume_token(26);
                        ax = this.factory.getOWLTransitiveObjectPropertyAxiom(lhs);
                        break block10;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (this.jj_2_11(3)) {
                ax = this.parsePropertyChain();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ax;
    }

    public final OWLClassExpression parseClassDescription() throws ParseException {
        OWLClassExpression desc = this.Or();
        return desc;
    }

    public final OWLClassExpression Or() throws ParseException {
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        OWLClassExpression desc = this.And();
        operands.add(desc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(18);
            desc = this.And();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectUnionOf(operands);
    }

    public final OWLClassExpression And() throws ParseException {
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        OWLClassExpression desc = this.NonNaryBooleanDescription();
        operands.add(desc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(17);
            desc = this.NonNaryBooleanDescription();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectIntersectionOf(operands);
    }

    public final OWLClassExpression NonNaryBooleanDescription() throws ParseException {
        OWLClassExpression desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                desc = this.parseRestriction();
                break;
            }
            case 19: {
                desc = this.parseObjectComplementOf();
                break;
            }
            case 10: 
            case 14: 
            case 29: {
                desc = this.NamedClassOrNestedDescription();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLObjectPropertyExpression parseObjectPropertyId() throws ParseException {
        boolean inverse = false;
        IRI iri = this.parseId();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                inverse = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        if (inverse) {
            return this.factory.getOWLObjectInverseOf(this.factory.getOWLObjectProperty(iri));
        }
        return this.factory.getOWLObjectProperty(iri);
    }

    public final OWLDataPropertyExpression parseDataPropertyId() throws ParseException {
        IRI iri = this.parseId();
        return this.factory.getOWLDataProperty(iri);
    }

    public final OWLClassExpression parseRestriction() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_12(3)) {
            desc = this.parseSomeRestriction();
        } else if (this.jj_2_13(3)) {
            desc = this.parseDataSomeRestriction();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 21: {
                    desc = this.parseAllRestriction();
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    desc = this.parseCardinalityRestriction();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return desc;
    }

    public final OWLClassExpression parseSomeRestriction() throws ParseException {
        this.jj_consume_token(20);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        OWLClassExpression filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseDataSomeRestriction() throws ParseException {
        this.jj_consume_token(20);
        OWLDataPropertyExpression prop = this.parseDataPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        OWLDataRange filler = this.parseDataOneOf();
        return this.factory.getOWLDataSomeValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseAllRestriction() throws ParseException {
        this.jj_consume_token(21);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        OWLClassExpression filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectAllValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseCardinalityRestriction() throws ParseException {
        OWLClass filler = null;
        boolean min = false;
        boolean exactly = false;
        boolean max = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                min = true;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                exactly = true;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                max = true;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token t = this.jj_consume_token(27);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        if (this.jj_2_14(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    this.jj_consume_token(8);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            filler = this.NamedClassOrNestedDescription();
        }
        int card = Integer.parseInt(t.image);
        if (filler == null) {
            filler = this.factory.getOWLThing();
        }
        if (min) {
            return this.factory.getOWLObjectMinCardinality(card, prop, (OWLClassExpression)filler);
        }
        if (exactly) {
            return this.factory.getOWLObjectExactCardinality(card, prop, (OWLClassExpression)filler);
        }
        return this.factory.getOWLObjectMaxCardinality(card, prop, (OWLClassExpression)filler);
    }

    public final OWLIndividual parseIndividualId() throws ParseException {
        IRI iri = this.parseId();
        return this.factory.getOWLNamedIndividual(iri);
    }

    public final OWLClassExpression parseObjectComplementOf() throws ParseException {
        this.jj_consume_token(19);
        OWLClassExpression op = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectComplementOf(op);
    }

    public final OWLClassExpression parseObjectOneOf() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(14);
        OWLIndividual ind = this.parseIndividualId();
        inds.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            ind = this.parseIndividualId();
            inds.add(ind);
        }
        this.jj_consume_token(15);
        return this.factory.getOWLObjectOneOf(inds);
    }

    public final OWLDataRange parseDataOneOf() throws ParseException {
        HashSet<OWLLiteral> values = new HashSet<OWLLiteral>();
        this.jj_consume_token(14);
        OWLLiteral val = this.parseLiteral();
        values.add(val);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            val = this.parseLiteral();
            values.add(val);
        }
        this.jj_consume_token(15);
        return this.factory.getOWLDataOneOf(values);
    }

    public final OWLClassExpression NamedClassOrNestedDescription() throws ParseException {
        OWLClass desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                desc = this.parseClassId();
                break;
            }
            case 10: 
            case 14: {
                desc = this.NestedClassDescription();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLClass parseClassId() throws ParseException {
        IRI iri = this.parseId();
        return this.factory.getOWLClass(iri);
    }

    public final OWLClassExpression NestedClassDescription() throws ParseException {
        OWLClassExpression desc;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                desc = this.Or();
                this.jj_consume_token(11);
                break;
            }
            case 14: {
                desc = this.parseObjectOneOf();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return desc;
    }

    public final OWLLiteral parseLiteral() throws ParseException {
        OWLLiteral l;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                Token t = this.jj_consume_token(27);
                l = this.factory.getOWLLiteral(Integer.parseInt(t.image));
                break;
            }
            case 28: {
                Token t = this.jj_consume_token(28);
                l = this.factory.getOWLLiteral(Double.parseDouble(t.image));
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return l;
    }

    public final IRI parseId() throws ParseException {
        Token t = this.jj_consume_token(29);
        return this.getIRIFromId(t.image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    private boolean jj_3_11() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_23() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_28()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_11() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_19() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_18() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_40() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_39();
    }

    private boolean jj_3R_34() {
        return this.jj_3R_38();
    }

    private boolean jj_3_10() {
        if (this.jj_3R_17()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_20()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_10() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_41() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_29()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_49() {
        return this.jj_3R_51();
    }

    private boolean jj_3_13() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_12() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_13()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_49()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_50()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_21() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_37() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_33() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_34()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        return this.jj_3R_30();
    }

    private boolean jj_3_6() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_32() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_7()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3_5() {
        return this.jj_3R_12();
    }

    private boolean jj_3_4() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_17() {
        if (this.jj_3R_30()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_36() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_35();
    }

    private boolean jj_3_3() {
        return this.jj_3R_10();
    }

    private boolean jj_3_2() {
        return this.jj_3R_9();
    }

    private boolean jj_3_1() {
        return this.jj_3R_8();
    }

    private boolean jj_3R_46() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_56());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_45() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_44() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_43() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_45()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_scan_token(0);
    }

    private boolean jj_3R_27() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_35() {
        Token xsp;
        if (this.jj_3R_39()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_40());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3R_8() {
        if (this.jj_3R_16()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_26()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_55() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_54() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_55()) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_29() {
        Token xsp;
        if (this.jj_3R_35()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_36());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_9() {
        return this.jj_3R_16();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_42() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                return true;
            }
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_16() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_56() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_51() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_14() {
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_7() {
        return this.jj_3R_14();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1643725824, 0x40000000, 65536, 64, 0x40000001, 48, 128, 0x2000030, 262144, 131072, 569918464, 512, 0x1E00000, 256, 256, 256, 0x1C00000, 256, 0x20000000, 0x18000000, 0x20004400, 17408, 0x18000000};
    }

    public DLSyntaxParser(Provider stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DLSyntaxParser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DLSyntaxParser(DLSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DLSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 23; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 23; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 32; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : DLSyntaxParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 14; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DLSyntaxParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

