/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.renderer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class TurtleRenderer
extends RDFRendererBase {
    protected final Deque<Integer> tabs = new LinkedList<Integer>();
    private final PrintWriter writer;
    private final PrefixManager pm;
    private final String base;
    private final OWLDocumentFormat format;
    int bufferLength = 0;
    int lastNewLineIndex = 0;
    int level = 0;

    public TurtleRenderer(OWLOntology ontology, Writer writer, OWLDocumentFormat format) {
        super(ontology, format, ontology.getOWLOntologyManager().getOntologyWriterConfiguration());
        this.format = (OWLDocumentFormat)OWLAPIPreconditions.checkNotNull((Object)format, (String)"format cannot be null");
        this.writer = new PrintWriter(writer);
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous()) {
            String ontologyIRIString;
            String defaultPrefix = ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (!ontologyIRIString.endsWith("/") && !ontologyIRIString.endsWith("#")) {
                defaultPrefix = ontologyIRIString + '#';
            }
            this.pm.setDefaultPrefix(defaultPrefix);
        }
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)format;
            this.pm.copyPrefixesFrom((PrefixManager)prefixFormat);
            this.pm.setPrefixComparator(prefixFormat.getPrefixComparator());
        }
        this.base = "";
    }

    private void writeNamespaces() {
        this.pm.getPrefixName2PrefixMap().forEach((k, v) -> {
            this.write("@prefix ");
            this.write((String)k);
            this.writeSpace();
            this.writeAsURI((String)v);
            this.write(" .");
            this.writeNewLine();
        });
    }

    protected void pushTab() {
        this.tabs.push(this.getIndent());
    }

    protected void popTab() {
        if (!this.tabs.isEmpty()) {
            this.tabs.pop();
        }
    }

    private void write(String s) {
        int newLineIndex = s.indexOf(10);
        if (newLineIndex != -1) {
            this.lastNewLineIndex = this.bufferLength + newLineIndex;
        }
        this.writer.write(s);
        this.bufferLength += s.length();
    }

    private int getCurrentPos() {
        return this.bufferLength;
    }

    private Integer getIndent() {
        return this.getCurrentPos() - this.lastNewLineIndex;
    }

    private void writeAsURI(String s) {
        this.write("<");
        if (s.startsWith(this.base)) {
            this.write(s.substring(this.base.length()));
        } else {
            this.write(s);
        }
        this.write(">");
    }

    private void write(IRI iri) {
        if (NodeID.isAnonymousNodeIRI((IRI)iri)) {
            this.write(iri.toString());
        } else if (iri.equals(this.ontology.getOntologyID().getOntologyIRI().orElse(null))) {
            this.writeAsURI(iri.toString());
        } else {
            String name = this.pm.getPrefixIRIIgnoreQName(iri);
            if (name == null) {
                name = this.forceSplitIfPrefixExists(iri);
            }
            if (name == null) {
                this.writeAsURI(iri.toString());
            } else if (name.endsWith(".")) {
                this.writeAsURI(iri.toString());
            } else if (name.indexOf(58) != -1) {
                this.write(name);
            } else {
                this.write(":");
                this.write(name);
            }
        }
    }

    @Nullable
    private String forceSplitIfPrefixExists(IRI iri) {
        ArrayList prefixName2PrefixMap = new ArrayList(this.pm.getPrefixName2PrefixMap().entrySet());
        Collections.sort(prefixName2PrefixMap, (o1, o2) -> ((String)o2.getValue()).compareTo((String)o1.getValue()));
        String actualIRI = iri.toString();
        for (Map.Entry entry : prefixName2PrefixMap) {
            if (!actualIRI.startsWith((String)entry.getValue()) || !TurtleRenderer.noSplits(actualIRI)) continue;
            return (String)entry.getKey() + actualIRI.substring(((String)entry.getValue()).length());
        }
        return null;
    }

    private static boolean noSplits(String s) {
        char[] reservedChars;
        for (char c : reservedChars = new char[]{'~', '.', '-', '!', '$', '&', '(', ')', '*', '+', ',', ';', '=', '/', '?', '#', '@', '%', '_'}) {
            if (s.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    private void writeNewLine() {
        this.write("\n");
        int tabIndent = 0;
        if (!this.tabs.isEmpty()) {
            tabIndent = this.tabs.peek();
        }
        for (int i = 1; i < tabIndent; ++i) {
            this.writeSpace();
        }
    }

    protected void writeAt() {
        this.write("@");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    private void write(RDFNode node) {
        if (node.isLiteral()) {
            this.write((RDFLiteral)node);
        } else {
            this.write((RDFResource)node);
        }
    }

    private void write(RDFLiteral node) {
        if (!node.isPlainLiteral()) {
            if (node.getDatatype().equals((Object)XSDVocabulary.INTEGER.getIRI())) {
                this.write(node.getLexicalValue());
            } else if (node.getDatatype().equals((Object)XSDVocabulary.DECIMAL.getIRI())) {
                this.write(node.getLexicalValue());
            } else {
                this.writeStringLiteral(node.getLexicalValue());
                if (node.hasLang()) {
                    this.writeAt();
                    this.write(node.getLang());
                } else if (!OWL2Datatype.XSD_STRING.getIRI().equals((Object)node.getDatatype())) {
                    this.write("^^");
                    this.write(node.getDatatype());
                }
            }
        } else {
            this.writeStringLiteral(node.getLexicalValue());
            if (node.hasLang()) {
                this.writeAt();
                this.write(node.getLang());
            }
        }
    }

    private void writeStringLiteral(String literal) {
        String escapedLiteral = EscapeUtils.escapeString((String)literal);
        if (escapedLiteral.indexOf(10) != -1) {
            this.write("\"\"\"");
            this.write(escapedLiteral);
            this.write("\"\"\"");
        } else {
            this.write("\"");
            this.write(escapedLiteral);
            this.write("\"");
        }
    }

    private void write(RDFResource node) {
        if (!node.isAnonymous()) {
            this.write(node.getIRI());
        } else {
            this.pushTab();
            if (!this.isObjectList(node)) {
                this.render(node, false);
            } else {
                ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                this.toJavaList((RDFNode)node, list);
                this.pushTab();
                this.write("(");
                this.writeSpace();
                this.pushTab();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    this.write((RDFNode)OWLAPIPreconditions.verifyNotNull(it.next()));
                    if (!it.hasNext()) continue;
                    this.writeNewLine();
                }
                this.popTab();
                this.writeNewLine();
                this.write(")");
                this.popTab();
            }
            this.popTab();
        }
    }

    @Override
    protected void beginDocument() {
        this.pending.clear();
        this.writeNamespaces();
        this.write("@base ");
        this.write("<");
        if (!this.ontology.isAnonymous()) {
            this.write(((IRI)this.ontology.getOntologyID().getOntologyIRI().get()).toString());
        } else {
            this.write(Namespaces.OWL.toString());
        }
        this.write("> .\n\n");
    }

    @Override
    protected void endDocument() {
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        if (!this.format.isAddMissingTypes()) {
            this.writeComment("Warning: type declarations were not added automatically.");
        }
        this.writer.flush();
        this.pending.clear();
    }

    @Override
    protected void writeClassComment(OWLClass cls) {
        this.writeComment(cls.getIRI().toString());
    }

    @Override
    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeIndividualComments(OWLNamedIndividual ind) {
        this.writeComment(ind.getIRI().toString());
    }

    @Override
    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDatatypeComment(OWLDatatype datatype) {
        this.writeComment(datatype.getIRI().toString());
    }

    private void writeComment(String comment) {
        this.write("###  ");
        this.write(comment);
        this.writeNewLine();
    }

    @Override
    protected void endObject() {
        this.writeNewLine();
    }

    @Override
    protected void writeBanner(String name) {
        this.writer.print("#################################################################\n#    ");
        this.writer.println(name);
        this.writer.println("#################################################################\n");
    }

    @Override
    protected void render(RDFResource node, boolean root) {
        ++this.level;
        Collection<Object> triples = this.pending.contains(node) ? Collections.emptyList() : this.getRDFGraph().getTriplesForSubject((RDFNode)node);
        this.pending.add(node);
        RDFResource lastSubject = null;
        RDFResourceIRI lastPredicate = null;
        boolean first = true;
        for (RDFTriple rDFTriple : triples) {
            RDFResource subj = rDFTriple.getSubject();
            RDFResourceIRI pred = rDFTriple.getPredicate();
            RDFNode object = rDFTriple.getObject();
            if (lastSubject != null && (subj.equals(lastSubject) || subj.isAnonymous())) {
                if (lastPredicate != null && pred.equals(lastPredicate)) {
                    this.write(" ,");
                    this.writeNewLine();
                    this.renderObject(object);
                } else {
                    this.write(" ;");
                    this.popTab();
                    this.writeNewLine();
                    this.write((RDFResource)rDFTriple.getPredicate());
                    this.writeSpace();
                    this.pushTab();
                    this.renderObject(object);
                }
            } else {
                if (!first) {
                    this.popTab();
                    this.popTab();
                    this.writeNewLine();
                }
                if (!node.isAnonymous()) {
                    this.write(subj);
                    this.writeSpace();
                } else if (node.idRequired()) {
                    this.write(subj.getIRI());
                    this.writeSpace();
                } else {
                    this.pushTab();
                    this.write("[");
                    this.writeSpace();
                }
                this.pushTab();
                this.write((RDFResource)rDFTriple.getPredicate());
                this.writeSpace();
                this.pushTab();
                this.renderObject(object);
            }
            lastSubject = subj;
            lastPredicate = pred;
            first = false;
        }
        if (node.isAnonymous()) {
            this.popTab();
            this.popTab();
            if (!node.idRequired()) {
                if (triples.isEmpty()) {
                    this.write("[ ");
                } else {
                    this.writeNewLine();
                }
                this.write("]");
            }
            this.popTab();
        } else {
            this.popTab();
            this.popTab();
        }
        if (this.level == 1 && !triples.isEmpty()) {
            this.write(" .\n\n");
        }
        this.writer.flush();
        --this.level;
        if (root) {
            this.deferredRendering();
        }
        this.pending.remove(node);
    }

    protected void renderObject(RDFNode object) {
        if (object.idRequired()) {
            if (!this.pending.contains(object)) {
                this.defer(object);
            }
            this.write(object.getIRI());
        } else {
            this.write(object);
        }
    }
}

