/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterOWLSyntaxPrefixNameShortFormProvider
implements ShortFormProvider {
    private final DefaultPrefixManager prefixManager;

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(OWLOntology ont) {
        this(ont.getFormat());
    }

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(@Nullable OWLDocumentFormat format) {
        this.prefixManager = new DefaultPrefixManager();
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat ontFormat = (PrefixDocumentFormat)format;
            this.prefixManager.copyPrefixesFrom((PrefixManager)ontFormat);
            this.prefixManager.setPrefixComparator(ontFormat.getPrefixComparator());
        }
    }

    public ManchesterOWLSyntaxPrefixNameShortFormProvider(DefaultPrefixManager prefixManager) {
        this.prefixManager = prefixManager;
    }

    public static String getShortForm(IRI iri) {
        return iri.toQuotedString();
    }

    public Map<String, String> getPrefixName2PrefixMap() {
        return this.prefixManager.getPrefixName2PrefixMap();
    }

    public String getShortForm(OWLEntity entity) {
        IRI iri = entity.getIRI();
        String sf = this.prefixManager.getPrefixIRIIgnoreQName(iri);
        if (sf == null || Objects.equals(iri.toString(), sf)) {
            sf = iri.toQuotedString();
        }
        if (sf.startsWith(":")) {
            return sf.substring(1);
        }
        return sf;
    }
}

