/* KRSS2Parser.java */
/* Generated By:JavaCC: Do not edit this line. KRSS2Parser.java */
package org.semanticweb.owlapi.krss2.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.krss1.parser.NameResolverStrategy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

// Suppress warnings in auto-generated code
@SuppressWarnings("all")
public class KRSS2Parser implements KRSS2ParserConstants {

    static private int[] jj_la1_0;
    static private int[] jj_la1_1;
    static private int[] jj_la1_2;

    static {
        jj_la1_init_0();
        jj_la1_init_1();
        jj_la1_init_2();
    }

    final private int[] jj_la1 = new int[32];
    final private JJCalls[] jj_2_rtns = new JJCalls[34];
    final private LookaheadSuccess jj_ls = new LookaheadSuccess();
    /**
     * Generated Token Manager.
     */
    public KRSS2ParserTokenManager token_source;
    /**
     * Current token.
     */
    public Token token;
    /**
     * Next token.
     */
    public Token jj_nt;
    JavaCharStream jj_input_stream;
    private OWLOntology ontology;
    private OWLDataFactory df;
    private Map<String, IRI> string2IRI;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private String base;
    private NameResolverStrategy nameResolution;
    //all fields for the adaptive strategy
    private int adaptiveMaxRuns = 10;
    private boolean alwaysIRIs = false;
    private boolean alwaysNames = false;
    //
    private String[] splitted = new String[2];
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent = 0;
    private boolean trace_enabled;

    /**
     * Constructor.
     */
    public KRSS2Parser(Provider stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new KRSS2ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 32; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor.
     */
    public KRSS2Parser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    /**
     * Constructor with generated Token Manager.
     */
    public KRSS2Parser(KRSS2ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 32; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x4c000, 0x0, 0x0, 0x0, 0x4c000, 0x4c000, 0x0, 0x4c000, 0x4c000, 0x0,
            0x30000, 0x0, 0x30000, 0x0, 0x30000, 0x0, 0x50000, 0x1c000, 0x0, 0x0, 0xc000, 0x4c000,
            0x4c000, 0x4c000, 0x4c000, 0x4c000, 0xc000, 0x4c000, 0x30000, 0x0, 0xc000, 0xc000,};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x0, 0x80000, 0x2000, 0x1000, 0x0, 0x0, 0x100, 0x0, 0x0, 0x20000, 0x0,
            0x2000000, 0x0, 0x800000, 0x0, 0x40000, 0x0, 0x0, 0xc000, 0xc000, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0x6, 0x0, 0x0, 0x0, 0x6, 0x6, 0x0, 0x6, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x6, 0x0, 0x6, 0x0,
            0x6,};
    }

    public KRSS2Parser setOntology(OWLOntology ontology) {
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.string2IRI = new HashMap<String, IRI>();
        OWLOntologyID id = ontology.getOntologyID();
        if (!id.isAnonymous()) {
            this.base = id.getOntologyIRI().toString() + "#";
        } else {
            this.base = id.toString() + "#";
        }
        this.nameResolution = NameResolverStrategy.CHECK;
        return this;
    }

    protected void addAxiom(OWLAxiom ax) throws KRSS2OWLParserException {
        try {
            ontology.addAxiom(ax);
        } catch (OWLOntologyChangeException e) {
            throw new KRSS2OWLParserException(e);
        }
    }

    public IRI getIRI(final String s) {
        IRI iri = string2IRI.get(s);
        if (iri == null) {
            switch (nameResolution) {
                case IRI:
                    iri = IRI.create(s);
                    break;
                case NAME:
                    iri = IRI.create(base + s);
                    break;
                case ADAPTIVE:
                    if (adaptiveMaxRuns <= 1) {
                        if (alwaysIRIs && !alwaysNames) {
                            this.nameResolution = NameResolverStrategy.IRI;
                        } else if (alwaysNames && !alwaysIRIs) {
                            this.nameResolution = NameResolverStrategy.NAME;
                        } else {
                            this.nameResolution = NameResolverStrategy.CHECK;
                        }
                    }
                    adaptiveMaxRuns--;
                case CHECK:
                    String ns = XMLUtils.getNCNamePrefix(s);
                    if (ns.equals("")) {
                        iri = IRI.create(base + s);
                    } else {
                        iri = IRI.create(s);
                    }
                    break;
            }
            string2IRI.put(s, iri);
        }
        return iri;
    }

    public void setNameResolution(NameResolverStrategy nameResolution) {
        this.nameResolution = nameResolution;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    final public void parse() throws ParseException, KRSS2OWLParserException {
        label_1:
        while (true) {
            if (jj_2_1(2)) {
                ;
            } else {
                break label_1;
            }
            TBoxStatement();
        }
        if (jj_2_2(2)) {
            jj_consume_token(ENDTBOX);
        } else {
            ;
        }
        label_2:
        while (true) {
            if (jj_2_3(2)) {
                ;
            } else {
                break label_2;
            }
            ABoxStatement();
        }
        if (jj_2_4(2)) {
            jj_consume_token(ENDABOX);
        } else {
            ;
        }
        jj_consume_token(0);
    }

    final public void TBoxStatement() throws ParseException, KRSS2OWLParserException {
        if (jj_2_5(2)) {
            DefinePrimitiveConcept();
        } else if (jj_2_6(2)) {
            DefineConcept();
        } else if (jj_2_7(2)) {
            Implies();
        } else if (jj_2_8(2)) {
            Equivalent();
        } else if (jj_2_9(2)) {
            Disjoint();
        } else if (jj_2_10(2)) {
            ComplexRoleInclusion();
        } else if (jj_2_11(2)) {
            DefinePrimitiveRole();
        } else if (jj_2_12(2)) {
            DefineRole();
        } else if (jj_2_13(2)) {
            DisjointRoles();
        } else if (jj_2_14(2)) {
            RolesEquivalent();
        } else if (jj_2_15(2)) {
            ImpliesRole();
        } else if (jj_2_16(2)) {
            Inverses();
        } else if (jj_2_17(2)) {
            Range();
        } else if (jj_2_18(2)) {
            Transitive();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // Concepts
    final public void DefinePrimitiveConcept() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression subClass, superClass = null;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVECONCEPT);
        subClass = ConceptName();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TOP:
            case BOTTOM:
            case OPENPAR:
            case INT:
            case NAME: {
                superClass = ConceptExpression();
                break;
            }
            default:
                jj_la1[0] = jj_gen;
                ;
        }
        jj_consume_token(CLOSEPAR);
        if (superClass == null) {
            superClass = df.getOWLThing();
        }
        addAxiom(df.getOWLSubClassOfAxiom(subClass, superClass));
    }

    final public void DefineConcept() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression clsA, clsB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINECONCEPT);
        clsA = ConceptName();
        clsB = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        if (clsB == null) {
            clsB = df.getOWLThing();
        }
        addAxiom(df.getOWLEquivalentClassesAxiom(clsA, clsB));
    }

    final public void Disjoint() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc1, desc2;
        jj_consume_token(OPENPAR);
        jj_consume_token(DISJOINT);
        desc1 = ConceptExpression();
        desc2 = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLDisjointClassesAxiom(desc1, desc2));
    }

    final public void Equivalent() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc1, desc2;
        jj_consume_token(OPENPAR);
        jj_consume_token(EQUIVALENT);
        desc1 = ConceptExpression();
        desc2 = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLEquivalentClassesAxiom(desc1, desc2));
    }

    final public void Implies() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression subDescription, superDescription;
        jj_consume_token(OPENPAR);
        jj_consume_token(IMPLIES);
        subDescription = ConceptExpression();
        superDescription = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLSubClassOfAxiom(subDescription, superDescription));
    }

    // Roles
    final public void DefineRole() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression propA, propB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEROLE);
        propA = RoleExpression();
        propB = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLEquivalentObjectPropertiesAxiom(propA, propB));
    }

    final public void DefinePrimitiveRole() throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty subProp;
        OWLObjectProperty superProp;
        OWLClassExpression desc;
        Set<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVEROLE);
        subProp = RoleName();
        addAxiom(df.getOWLDeclarationAxiom(subProp));
        Parent(subProp);
        RightIdentity(subProp);
        Parents(subProp);
        DomainAttribute(subProp);
        RangeAttribute(subProp);
        TransitiveAttribute(subProp);
        SymmetricAttribute(subProp);
        ReflexiveAttribute(subProp);
        InverseProperty(subProp);
        jj_consume_token(CLOSEPAR);
    }

    final public void RightIdentity(OWLObjectProperty r)
        throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty s;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case RIGHT_IDENTITY_ATTRIBUTE: {
                jj_consume_token(RIGHT_IDENTITY_ATTRIBUTE);
                s = RoleName();
                addAxiom(df.getOWLSubPropertyChainOfAxiom(java.util.Arrays.asList(r, s), r));
                break;
            }
            default:
                jj_la1[1] = jj_gen;
                ;
        }
    }

    final public void LeftIdentity(OWLObjectProperty r)
        throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty s;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case LEFT_IDENTITY_ATTRIBUTE: {
                jj_consume_token(LEFT_IDENTITY_ATTRIBUTE);
                s = RoleName();
                addAxiom(df.getOWLSubPropertyChainOfAxiom(java.util.Arrays.asList(s, r), r));
                break;
            }
            default:
                jj_la1[2] = jj_gen;
                ;
        }
    }

    final public void InverseProperty(OWLObjectProperty subProp)
        throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression superProp;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case INVERSE_ATTRIBUTE: {
                jj_consume_token(INVERSE_ATTRIBUTE);
                superProp = RoleExpression();
                addAxiom(df.getOWLInverseObjectPropertiesAxiom(subProp, superProp));
                break;
            }
            default:
                jj_la1[3] = jj_gen;
                ;
        }
    }

    final public void DomainAttribute(OWLObjectProperty subProp)
        throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc;
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case DOMAIN_ATTRIBUTE: {
                jj_consume_token(DOMAIN_ATTRIBUTE);
                if (jj_2_19(2)) {
                    jj_consume_token(OPENPAR);
                    label_3:
                    while (true) {
                        desc = ConceptExpression();
                        if (desc != null) {
                            descs.add(desc);
                        }
                        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                            case TOP:
                            case BOTTOM:
                            case OPENPAR:
                            case INT:
                            case NAME: {
                                ;
                                break;
                            }
                            default:
                                jj_la1[4] = jj_gen;
                                break label_3;
                        }
                    }
                    jj_consume_token(CLOSEPAR);
                } else {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case TOP:
                        case BOTTOM:
                        case OPENPAR:
                        case INT:
                        case NAME: {
                            desc = ConceptExpression();
                            descs.add(desc);
                            break;
                        }
                        default:
                            jj_la1[5] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                }
                for (OWLClassExpression eachDescription : descs) {
                    addAxiom(df.getOWLObjectPropertyDomainAxiom(subProp, eachDescription));
                }
                break;
            }
            default:
                jj_la1[6] = jj_gen;
                ;
        }
    }

    final public void RangeAttribute(OWLObjectProperty subProp)
        throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc;
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case RANGE_ATTRIBUTE: {
                jj_consume_token(RANGE_ATTRIBUTE);
                if (jj_2_20(2)) {
                    jj_consume_token(OPENPAR);
                    label_4:
                    while (true) {
                        desc = ConceptExpression();
                        descs.add(desc);
                        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                            case TOP:
                            case BOTTOM:
                            case OPENPAR:
                            case INT:
                            case NAME: {
                                ;
                                break;
                            }
                            default:
                                jj_la1[7] = jj_gen;
                                break label_4;
                        }
                    }
                    jj_consume_token(CLOSEPAR);
                } else {
                    switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                        case TOP:
                        case BOTTOM:
                        case OPENPAR:
                        case INT:
                        case NAME: {
                            desc = ConceptExpression();
                            descs.add(desc);
                            break;
                        }
                        default:
                            jj_la1[8] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                    }
                }
                for (OWLClassExpression eachDescription : descs) {
                    addAxiom(df.getOWLObjectPropertyRangeAxiom(subProp, eachDescription));
                }
                break;
            }
            default:
                jj_la1[9] = jj_gen;
                ;
        }
    }

    final public void TransitiveAttribute(OWLObjectProperty property)
        throws ParseException, KRSS2OWLParserException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TRANSITIVE_ATTRIBUTE: {
                jj_consume_token(TRANSITIVE_ATTRIBUTE);
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case NIL: {
                        jj_consume_token(NIL);
                        break;
                    }
                    case TRUE: {
                        jj_consume_token(TRUE);
                        addAxiom(df.getOWLTransitiveObjectPropertyAxiom(property));
                        break;
                    }
                    default:
                        jj_la1[10] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[11] = jj_gen;
                ;
        }
    }

    final public void SymmetricAttribute(OWLObjectProperty property)
        throws ParseException, KRSS2OWLParserException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case SYMMETRIC_ATTRIBUTE: {
                jj_consume_token(SYMMETRIC_ATTRIBUTE);
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case NIL: {
                        jj_consume_token(NIL);
                        break;
                    }
                    case TRUE: {
                        jj_consume_token(TRUE);
                        addAxiom(df.getOWLSymmetricObjectPropertyAxiom(property));
                        break;
                    }
                    default:
                        jj_la1[12] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[13] = jj_gen;
                ;
        }
    }

    final public void ReflexiveAttribute(OWLObjectProperty property)
        throws ParseException, KRSS2OWLParserException {
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case REFLEXIVE_ATTRIBUTE: {
                jj_consume_token(REFLEXIVE_ATTRIBUTE);
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case NIL: {
                        jj_consume_token(NIL);
                        break;
                    }
                    case TRUE: {
                        jj_consume_token(TRUE);
                        addAxiom(df.getOWLReflexiveObjectPropertyAxiom(property));
                        break;
                    }
                    default:
                        jj_la1[14] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[15] = jj_gen;
                ;
        }
    }

    final public void Parents(OWLObjectProperty subProp)
        throws ParseException, KRSS2OWLParserException {
        Set<OWLObjectProperty> roles;
        OWLObjectProperty superProp;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case PARENT:
            case PARENTS: {
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case PARENTS: {
                        jj_consume_token(PARENTS);
                        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                            case NIL: {
                                jj_consume_token(NIL);
                                break;
                            }
                            case OPENPAR: {
                                jj_consume_token(OPENPAR);
                                roles = RoleNameSet();
                                jj_consume_token(CLOSEPAR);
                                for (OWLObjectProperty prop : roles) {
                                    addAxiom(df.getOWLSubObjectPropertyOfAxiom(subProp, prop));
                                }
                                break;
                            }
                            default:
                                jj_la1[16] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                        }
                        break;
                    }
                    case PARENT: {
                        jj_consume_token(PARENT);
                        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                            case NIL: {
                                jj_consume_token(NIL);
                                break;
                            }
                            case TOP:
                            case BOTTOM:
                            case INT:
                            case NAME: {
                                superProp = RoleName();
                                addAxiom(df.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
                                break;
                            }
                            default:
                                jj_la1[17] = jj_gen;
                                jj_consume_token(-1);
                                throw new ParseException();
                        }
                        break;
                    }
                    default:
                        jj_la1[18] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[19] = jj_gen;
                ;
        }
    }

    final public void Parent(OWLObjectProperty subProp)
        throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty superProp;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TOP:
            case BOTTOM:
            case INT:
            case NAME: {
                superProp = RoleName();
                addAxiom(df.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
                break;
            }
            default:
                jj_la1[20] = jj_gen;
                ;
        }
    }

    final public void DisjointRoles() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression exp1;
        OWLObjectPropertyExpression exp2;
        jj_consume_token(OPENPAR);
        jj_consume_token(DISJOINTROLES);
        exp1 = RoleExpression();
        exp2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLDisjointObjectPropertiesAxiom(exp1, exp2));
    }

    final public void ImpliesRole() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression subProp;
        OWLObjectPropertyExpression superProp;
        jj_consume_token(OPENPAR);
        jj_consume_token(IMPLIESROLE);
        subProp = RoleExpression();
        superProp = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLSubObjectPropertyOfAxiom(subProp, superProp));
    }

    final public void Inverses() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop1;
        OWLObjectPropertyExpression prop2;
        jj_consume_token(OPENPAR);
        jj_consume_token(INVERSE);
        prop1 = RoleExpression();
        prop2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLInverseObjectPropertiesAxiom(prop1, prop2));
    }

    final public void RolesEquivalent() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression exp1;
        OWLObjectPropertyExpression exp2;
        jj_consume_token(OPENPAR);
        jj_consume_token(ROLESEQUIVALENT);
        exp1 = RoleExpression();
        exp2 = RoleExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLEquivalentObjectPropertiesAxiom(exp1, exp2));
    }

    final public void ComplexRoleInclusion() throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty superProp;
        List<OWLObjectPropertyExpression> chain;
        jj_consume_token(OPENPAR);
        jj_consume_token(ROLE_INCLUSION);
        chain = propertyChain();
        superProp = RoleName();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLSubPropertyChainOfAxiom(chain, superProp));
    }

    final public List<OWLObjectPropertyExpression> propertyChain()
        throws ParseException, KRSS2OWLParserException {
        List<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
        List<OWLObjectPropertyExpression> subChain;
        OWLObjectPropertyExpression prop;
        jj_consume_token(OPENPAR);
        jj_consume_token(COMPOSE);
        prop = RoleExpression();
        chain.add(prop);
        if (jj_2_21(2)) {
            subChain = propertyChain();
            chain.addAll(subChain);
        } else {
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case TOP:
                case BOTTOM:
                case OPENPAR:
                case INT:
                case NAME: {
                    prop = RoleExpression();
                    chain.add(prop);
                    break;
                }
                default:
                    jj_la1[21] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
            }
        }
        jj_consume_token(CLOSEPAR);
        return chain;
    }

    final public void Transitive() throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty prop;
        jj_consume_token(OPENPAR);
        jj_consume_token(TRANSITIVE);
        prop = RoleName();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLTransitiveObjectPropertyAxiom(prop));
    }

    final public void Range() throws ParseException, KRSS2OWLParserException {
        OWLObjectProperty prop;
        OWLClassExpression rng;
        jj_consume_token(OPENPAR);
        jj_consume_token(RANGE);
        prop = RoleName();
        rng = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLObjectPropertyRangeAxiom(prop, rng));
    }

    final public OWLClassExpression ConceptExpression()
        throws ParseException, KRSS2OWLParserException {
        OWLClassExpression desc;
        if (jj_2_22(2)) {
            desc = ConceptName();
        } else if (jj_2_23(2)) {
            desc = And();
        } else if (jj_2_24(2)) {
            desc = Or();
        } else if (jj_2_25(2)) {
            desc = Not();
        } else if (jj_2_26(2)) {
            desc = All();
        } else if (jj_2_27(2)) {
            desc = Some();
        } else if (jj_2_28(2)) {
            desc = AtLeast();
        } else if (jj_2_29(2)) {
            desc = AtMost();
        } else if (jj_2_30(2)) {
            desc = Exactly();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    final public OWLClassExpression ConceptName() throws ParseException, KRSS2OWLParserException {
        IRI iri;
        iri = Name();
        return df.getOWLClass(iri);
    }

    final public Set<OWLClassExpression> ConceptSet()
        throws ParseException, KRSS2OWLParserException {
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        OWLClassExpression desc;
        label_5:
        while (true) {
            desc = ConceptExpression();
            descs.add(desc);
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case TOP:
                case BOTTOM:
                case OPENPAR:
                case INT:
                case NAME: {
                    ;
                    break;
                }
                default:
                    jj_la1[22] = jj_gen;
                    break label_5;
            }
        }
        return descs;
    }

    final public OWLClassExpression And() throws ParseException, KRSS2OWLParserException {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(AND);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return df.getOWLObjectIntersectionOf(operands);
    }

    final public OWLClassExpression Or() throws ParseException, KRSS2OWLParserException {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(OR);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return df.getOWLObjectUnionOf(operands);
    }

    final public OWLClassExpression Not() throws ParseException, KRSS2OWLParserException {
        OWLClassExpression operand;
        jj_consume_token(OPENPAR);
        jj_consume_token(NOT);
        operand = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return df.getOWLObjectComplementOf(operand);
    }

    final public OWLClassExpression All() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(ALL);
        prop = RoleExpression();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return df.getOWLObjectAllValuesFrom(prop, filler);
    }

    final public OWLClassExpression Some() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(SOME);
        prop = RoleExpression();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return df.getOWLObjectSomeValuesFrom(prop, filler);
    }

    final public OWLClassExpression AtLeast() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATLEAST);
        card = Integer();
        prop = RoleExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TOP:
            case BOTTOM:
            case OPENPAR:
            case INT:
            case NAME: {
                filler = ConceptExpression();
                break;
            }
            default:
                jj_la1[23] = jj_gen;
                ;
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return df.getOWLObjectMinCardinality(card, prop);
        }
        return df.getOWLObjectMinCardinality(card, prop, filler);
    }

    final public OWLClassExpression AtMost() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATMOST);
        card = Integer();
        prop = RoleExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TOP:
            case BOTTOM:
            case OPENPAR:
            case INT:
            case NAME: {
                filler = ConceptExpression();
                break;
            }
            default:
                jj_la1[24] = jj_gen;
                ;
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return df.getOWLObjectMaxCardinality(card, prop);
        }
        return df.getOWLObjectMaxCardinality(card, prop, filler);
    }

    final public OWLClassExpression Exactly() throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler = null;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(EXACTLY);
        card = Integer();
        prop = RoleExpression();
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TOP:
            case BOTTOM:
            case OPENPAR:
            case INT:
            case NAME: {
                filler = ConceptExpression();
                break;
            }
            default:
                jj_la1[25] = jj_gen;
                ;
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return df.getOWLObjectExactCardinality(card, prop);
        }
        return df.getOWLObjectExactCardinality(card, prop, filler);
    }

    final public OWLObjectProperty RoleName() throws ParseException, KRSS2OWLParserException {
        IRI iri;
        iri = Name();
        return df.getOWLObjectProperty(iri);
    }

    final public Set<OWLObjectProperty> RoleNameSet()
        throws ParseException, KRSS2OWLParserException {
        Set<OWLObjectProperty> roles = new HashSet<OWLObjectProperty>();
        OWLObjectProperty role;
        label_6:
        while (true) {
            role = RoleName();
            roles.add(role);
            switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                case TOP:
                case BOTTOM:
                case INT:
                case NAME: {
                    ;
                    break;
                }
                default:
                    jj_la1[26] = jj_gen;
                    break label_6;
            }
        }
        return roles;
    }

    final public OWLObjectPropertyExpression RoleExpression()
        throws ParseException, KRSS2OWLParserException {
        OWLObjectPropertyExpression exp;
        OWLObjectProperty p;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case OPENPAR: {
                jj_consume_token(OPENPAR);
                jj_consume_token(INV);
                p = RoleName();
                jj_consume_token(CLOSEPAR);
                exp = df.getOWLObjectInverseOf(p);
                break;
            }
            case TOP:
            case BOTTOM:
            case INT:
            case NAME: {
                exp = RoleName();
                break;
            }
            default:
                jj_la1[27] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        return exp;
    }

    final public void ABoxStatement() throws ParseException, KRSS2OWLParserException {
        if (jj_2_31(2)) {
            Instance();
        } else if (jj_2_32(2)) {
            Related();
        } else if (jj_2_33(2)) {
            Equal();
        } else if (jj_2_34(2)) {
            Distinct();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void Instance() throws ParseException, KRSS2OWLParserException {
        OWLIndividual ind;
        OWLClassExpression type;
        jj_consume_token(OPENPAR);
        jj_consume_token(INSTANCE);
        ind = IndividualName();
        type = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLClassAssertionAxiom(type, ind));
    }

    final public void Related() throws ParseException, KRSS2OWLParserException {
        OWLIndividual subj;
        OWLObjectProperty prop;
        OWLIndividual obj;
        jj_consume_token(OPENPAR);
        jj_consume_token(RELATED);
        subj = IndividualName();
        prop = RoleName();
        obj = IndividualName();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLObjectPropertyAssertionAxiom(prop, subj, obj));
    }

    final public void Equal() throws ParseException, KRSS2OWLParserException {
        OWLIndividual indA, indB;
        jj_consume_token(OPENPAR);
        jj_consume_token(EQUAL);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLSameIndividualAxiom(indA, indB));
    }

    final public void Distinct() throws ParseException, KRSS2OWLParserException {
        OWLIndividual indA, indB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DISTINCT);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        addAxiom(df.getOWLDifferentIndividualsAxiom(indA, indB));
    }

    final public OWLIndividual IndividualName() throws ParseException, KRSS2OWLParserException {
        IRI name;
        name = Name();
        return df.getOWLNamedIndividual(name);
    }

    final public int Integer() throws ParseException, KRSS2OWLParserException {
        Token t;
        t = jj_consume_token(INT);
        return Integer.parseInt(t.image);
    }

    final public boolean parseBoolean() throws ParseException {
        boolean b;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case TRUE: {
                jj_consume_token(TRUE);
                b = true;
                break;
            }
            case NIL: {
                jj_consume_token(NIL);
                b = false;
                break;
            }
            default:
                jj_la1[28] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        return b;
    }

    final public IRI Name() throws ParseException {
        IRI i;
        Token t;
        switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
            case INT:
            case NAME: {
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case NAME: {
                        t = jj_consume_token(NAME);
                        break;
                    }
                    case INT: {
                        t = jj_consume_token(INT);
                        break;
                    }
                    default:
                        jj_la1[29] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                i = getIRI(t.image);
                break;
            }
            case TOP:
            case BOTTOM: {
                switch ((jj_ntk == -1) ? jj_ntk_f() : jj_ntk) {
                    case TOP: {
                        t = jj_consume_token(TOP);
                        i = OWLRDFVocabulary.OWL_THING.getIRI();
                        break;
                    }
                    case BOTTOM: {
                        t = jj_consume_token(BOTTOM);
                        i = OWLRDFVocabulary.OWL_NOTHING.getIRI();
                        break;
                    }
                    default:
                        jj_la1[30] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jj_la1[31] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
        }
        return i;
    }

    private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_1());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_2());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_3());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_4());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_5());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_6());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_7());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_8());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_9());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_10());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_11());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_12());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_13());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_14());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_15());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    private boolean jj_2_16(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_16());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(15, xla);
        }
    }

    private boolean jj_2_17(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_17());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(16, xla);
        }
    }

    private boolean jj_2_18(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_18());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(17, xla);
        }
    }

    private boolean jj_2_19(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_19());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(18, xla);
        }
    }

    private boolean jj_2_20(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_20());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(19, xla);
        }
    }

    private boolean jj_2_21(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_21());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(20, xla);
        }
    }

    private boolean jj_2_22(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_22());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(21, xla);
        }
    }

    private boolean jj_2_23(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_23());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(22, xla);
        }
    }

    private boolean jj_2_24(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_24());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(23, xla);
        }
    }

    private boolean jj_2_25(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_25());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(24, xla);
        }
    }

    private boolean jj_2_26(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_26());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(25, xla);
        }
    }

    private boolean jj_2_27(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_27());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(26, xla);
        }
    }

    private boolean jj_2_28(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_28());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(27, xla);
        }
    }

    private boolean jj_2_29(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_29());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(28, xla);
        }
    }

    private boolean jj_2_30(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_30());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(29, xla);
        }
    }

    private boolean jj_2_31(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_31());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(30, xla);
        }
    }

    private boolean jj_2_32(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_32());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(31, xla);
        }
    }

    private boolean jj_2_33(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_33());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(32, xla);
        }
    }

    private boolean jj_2_34(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return (!jj_3_34());
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(33, xla);
        }
    }

    private boolean jj_3R_26() {
        if (jj_3R_40()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_30() {
        if (jj_3R_34()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_26() {
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_22() {
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_43() {
        if (jj_scan_token(TOP)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_39() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_22()) {
            jj_scanpos = xsp;
            if (jj_3_23()) {
                jj_scanpos = xsp;
                if (jj_3_24()) {
                    jj_scanpos = xsp;
                    if (jj_3_25()) {
                        jj_scanpos = xsp;
                        if (jj_3_26()) {
                            jj_scanpos = xsp;
                            if (jj_3_27()) {
                                jj_scanpos = xsp;
                                if (jj_3_28()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_29()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_30()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_42() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_43()) {
            jj_scanpos = xsp;
            if (jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RANGE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(TRANSITIVE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_25() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(COMPOSE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_34() {
        if (jj_3R_38()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_14() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ROLE_INCLUSION)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_18() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ROLESEQUIVALENT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_20() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INVERSE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_33() {
        if (jj_3R_37()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_19() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(IMPLIESROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_41() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(66)) {
            jj_scanpos = xsp;
            if (jj_scan_token(65)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_41()) {
            jj_scanpos = xsp;
            if (jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (jj_3R_39()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_17() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISJOINTROLES)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_23() {
        if (jj_3R_39()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_32() {
        if (jj_3R_36()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_38() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISTINCT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_20() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        Token xsp;
        if (jj_3R_24()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_24()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EQUAL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_36() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RELATED)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_19() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        Token xsp;
        if (jj_3R_23()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3R_23()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj_3R_35() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INSTANCE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_15() {
        if (jj_3R_19()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_11() {
        if (jj_3R_15()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (jj_scan_token(ENDABOX)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_31() {
        if (jj_3R_35()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_8() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_31()) {
            jj_scanpos = xsp;
            if (jj_3_32()) {
                jj_scanpos = xsp;
                if (jj_3_33()) {
                    jj_scanpos = xsp;
                    if (jj_3_34()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        if (jj_3R_11()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_29() {
        if (jj_3R_33()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_25() {
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_34() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EXACTLY)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_14() {
        if (jj_3R_18()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_3() {
        if (jj_3R_8()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_15() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVEROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_10() {
        if (jj_3R_14()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_18() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_33() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATMOST)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_16() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEROLE)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_6() {
        if (jj_3R_10()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_24() {
        if (jj_3R_28()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_11() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(IMPLIES)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_44() {
        if (jj_scan_token(BOTTOM)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_28() {
        if (jj_3R_32()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EQUIVALENT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATLEAST)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_2() {
        if (jj_scan_token(ENDTBOX)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_13() {
        if (jj_3R_17()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_13() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISJOINT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_9() {
        if (jj_3R_13()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_17() {
        if (jj_3R_21()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_21() {
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_10() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINECONCEPT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(SOME)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_9() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVECONCEPT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_23() {
        if (jj_3R_27()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ALL)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_27() {
        if (jj_3R_31()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(NOT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_12() {
        if (jj_3R_16()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_16() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_8() {
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_28() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(OR)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_5() {
        if (jj_3R_9()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_7() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_5()) {
            jj_scanpos = xsp;
            if (jj_3_6()) {
                jj_scanpos = xsp;
                if (jj_3_7()) {
                    jj_scanpos = xsp;
                    if (jj_3_8()) {
                        jj_scanpos = xsp;
                        if (jj_3_9()) {
                            jj_scanpos = xsp;
                            if (jj_3_10()) {
                                jj_scanpos = xsp;
                                if (jj_3_11()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_12()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_13()) {
                                            jj_scanpos = xsp;
                                            if (jj_3_14()) {
                                                jj_scanpos = xsp;
                                                if (jj_3_15()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3_16()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3_17()) {
                                                            jj_scanpos = xsp;
                                                            if (jj_3_18()) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_1() {
        if (jj_3R_7()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_27() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(AND)) {
            return true;
        }
        return false;
    }

    public void ReInit(String s) {
        ReInit(new StringProvider(s));
    }

    /**
     * Reinitialise.
     */
    public void ReInit(Provider stream) {
        if (jj_input_stream == null) {
            jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            jj_input_stream.ReInit(stream, 1, 1);
        }
        if (token_source == null) {
            token_source = new KRSS2ParserTokenManager(jj_input_stream);
        }

        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 32; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     */
    public void ReInit(KRSS2ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 32; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    /**
     * Get the next Token.
     */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    /**
     * Get the specific Token.
     */
    final public Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    private int jj_ntk_f() {
        if ((jj_nt = token.next) == null) {
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        } else {
            return (jj_ntk = jj_nt.kind);
        }
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }

        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];

            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }

            for (int[] oldentry : jj_expentries) {
                if (oldentry.length == jj_expentry.length) {
                    boolean isMatched = true;

                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            isMatched = false;
                            break;
                        }

                    }
                    if (isMatched) {
                        jj_expentries.add(jj_expentry);
                        break;
                    }
                }
            }

            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /**
     * Generate ParseException.
     */
    public ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[70];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 32; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & (1 << j)) != 0) {
                        la1tokens[64 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 70; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage, token_source == null ? null
            : KRSS2ParserTokenManager.lexStateNames[token_source.curLexState]);
    }

    /**
     * Trace enabled.
     */
    final public boolean trace_enabled() {
        return trace_enabled;
    }

    /**
     * Enable tracing.
     */
    final public void enable_tracing() {
    }

    /**
     * Disable tracing.
     */
    final public void disable_tracing() {
    }

    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 34; i++) {
            try {
                JJCalls p = jj_2_rtns[i];

                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                            case 12:
                                jj_3_13();
                                break;
                            case 13:
                                jj_3_14();
                                break;
                            case 14:
                                jj_3_15();
                                break;
                            case 15:
                                jj_3_16();
                                break;
                            case 16:
                                jj_3_17();
                                break;
                            case 17:
                                jj_3_18();
                                break;
                            case 18:
                                jj_3_19();
                                break;
                            case 19:
                                jj_3_20();
                                break;
                            case 20:
                                jj_3_21();
                                break;
                            case 21:
                                jj_3_22();
                                break;
                            case 22:
                                jj_3_23();
                                break;
                            case 23:
                                jj_3_24();
                                break;
                            case 24:
                                jj_3_25();
                                break;
                            case 25:
                                jj_3_26();
                                break;
                            case 26:
                                jj_3_27();
                                break;
                            case 27:
                                jj_3_28();
                                break;
                            case 28:
                                jj_3_29();
                                break;
                            case 29:
                                jj_3_30();
                                break;
                            case 30:
                                jj_3_31();
                                break;
                            case 31:
                                jj_3_32();
                                break;
                            case 32:
                                jj_3_33();
                                break;
                            case 33:
                                jj_3_34();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);

            } catch (LookaheadSuccess ls) {
            }
        }
        jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }

        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    @SuppressWarnings("serial")
    static private final class LookaheadSuccess extends java.lang.RuntimeException {

    }

    static final class JJCalls {

        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

}
