/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFGraph
implements Serializable {
    private static final Set<IRI> skippedPredicates = Sets.newHashSet((Object[])new IRI[]{OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI()});
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final Map<RDFResource, Set<RDFTriple>> triplesBySubject = new HashMap<RDFResource, Set<RDFTriple>>();
    @Nonnull
    private final Set<RDFResourceBlankNode> rootAnonymousNodes = new HashSet<RDFResourceBlankNode>();
    @Nonnull
    private final Set<RDFTriple> triples = new HashSet<RDFTriple>();
    @Nonnull
    private final Map<RDFNode, RDFNode> remappedNodes = new HashMap<RDFNode, RDFNode>();

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public void addTriple(@Nonnull RDFTriple triple) {
        OWLAPIPreconditions.checkNotNull((Object)triple, (String)"triple cannot be null");
        this.rootAnonymousNodes.clear();
        this.triples.add(triple);
        Set<RDFTriple> tripleSet = this.triplesBySubject.get(triple.getSubject());
        if (tripleSet == null) {
            tripleSet = new LinkedHashSet<RDFTriple>();
            this.triplesBySubject.put(triple.getSubject(), tripleSet);
        }
        tripleSet.add(triple);
    }

    public Collection<RDFTriple> getTriplesForSubject(RDFNode subject) {
        Set<RDFTriple> set = this.triplesBySubject.get(subject);
        if (set == null) {
            RDFNode rdfNode = this.remappedNodes.get(subject);
            if (rdfNode == null) {
                return Collections.emptyList();
            }
            return this.getTriplesForSubject(rdfNode);
        }
        return set;
    }

    public Map<RDFTriple, RDFResourceBlankNode> computeRemappingForSharedNodes() {
        HashMap<RDFTriple, RDFResourceBlankNode> toReturn = new HashMap<RDFTriple, RDFResourceBlankNode>();
        HashMap<RDFNode, ArrayList<RDFTriple>> sharers = new HashMap<RDFNode, ArrayList<RDFTriple>>();
        for (RDFTriple rDFTriple : this.triples) {
            if (!rDFTriple.getObject().isAnonymous() || rDFTriple.getObject().isAxiom() || rDFTriple.getObject().isIndividual() || !RDFGraph.notInSkippedPredicates(rDFTriple.getPredicate())) continue;
            ArrayList<RDFTriple> list = (ArrayList<RDFTriple>)sharers.get(rDFTriple.getObject());
            if (list == null) {
                list = new ArrayList<RDFTriple>(2);
                sharers.put(rDFTriple.getObject(), list);
            }
            list.add(rDFTriple);
        }
        for (Map.Entry entry : sharers.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (RDFTriple t : (List)entry.getValue()) {
                RDFResourceBlankNode bnode = new RDFResourceBlankNode(IRI.create((String)NodeID.nextAnonymousIRI()), ((RDFNode)entry.getKey()).isIndividual(), ((RDFNode)entry.getKey()).shouldOutputId(), false);
                this.remappedNodes.put((RDFNode)bnode, (RDFNode)entry.getKey());
                toReturn.put(t, bnode);
            }
        }
        return toReturn;
    }

    private static boolean notInSkippedPredicates(RDFResourceIRI predicate) {
        return !skippedPredicates.contains(predicate.getIRI());
    }

    @Nonnull
    public Set<RDFResourceBlankNode> getRootAnonymousNodes() {
        if (this.rootAnonymousNodes.isEmpty()) {
            this.rebuildAnonRoots();
        }
        return this.rootAnonymousNodes;
    }

    private void rebuildAnonRoots() {
        this.rootAnonymousNodes.clear();
        for (RDFTriple triple : this.triples) {
            if (!triple.getSubject().isAnonymous()) continue;
            this.rootAnonymousNodes.add((RDFResourceBlankNode)triple.getSubject());
        }
        for (RDFTriple triple : this.triples) {
            if (!triple.getObject().isAnonymous() || triple.isSubjectSameAsObject()) continue;
            this.rootAnonymousNodes.remove(triple.getObject());
        }
    }

    public void dumpTriples(@Nonnull Writer w) throws IOException {
        OWLAPIPreconditions.checkNotNull((Object)w, (String)"w cannot be null");
        for (Set<RDFTriple> set : this.triplesBySubject.values()) {
            for (RDFTriple triple : set) {
                w.write(triple.toString());
                w.write("\n");
            }
        }
        w.flush();
    }

    public Set<RDFTriple> getAllTriples() {
        return Collections.unmodifiableSet(this.triples);
    }

    public String toString() {
        return this.triples.stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "triples            : ", "\n")) + this.triplesBySubject.entrySet().stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "triplesBySubject   : ", "\n")) + this.rootAnonymousNodes.stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "rootAnonymousNodes : ", "\n")) + this.remappedNodes.entrySet().stream().map(Object::toString).collect(Collectors.joining(",\n                     ", "remappedNodes      : ", ""));
    }

    public List<RDFResource> getSubjectsForObject(RDFResource node) {
        List<RDFResource> current = this.triples.stream().filter(p -> p.getObject().equals(node)).map(RDFTriple::getSubject).collect(Collectors.toList());
        HashSet<RDFResource> visited = new HashSet<RDFResource>();
        ArrayList<Object> next = new ArrayList<RDFResource>();
        boolean change = true;
        while (change) {
            change = false;
            for (RDFResource n : current) {
                if (!visited.add(n)) continue;
                List l = this.triples.stream().filter(p -> p.getObject().equals(n)).map(RDFTriple::getSubject).collect(Collectors.toList());
                if (l.size() > 0) {
                    change = true;
                    next.addAll(l);
                    continue;
                }
                next.add(n);
            }
            current = next;
            next = new ArrayList();
        }
        return current;
    }
}

