/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxOntologyHeader;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxTokenizer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public class ManchesterOWLSyntaxParserImpl
implements ManchesterOWLSyntaxParser {
    @Nonnull
    private Provider<OWLOntologyLoaderConfiguration> configProvider;
    @Nonnull
    private Optional<OWLOntologyLoaderConfiguration> config = Optional.absent();
    protected OWLDataFactory dataFactory;
    private List<ManchesterOWLSyntaxTokenizer.Token> tokens;
    private int tokenIndex;
    private OWLEntityChecker owlEntityChecker;
    private OWLOntologyChecker owlOntologyChecker = new OWLOntologyChecker(){

        @Nullable
        public OWLOntology getOntology(String name) {
            return null;
        }
    };
    @Nonnull
    protected final Set<String> classNames = new HashSet<String>();
    @Nonnull
    protected final Set<String> objectPropertyNames = new HashSet<String>();
    @Nonnull
    protected final Set<String> dataPropertyNames = new HashSet<String>();
    @Nonnull
    protected final Set<String> individualNames = new HashSet<String>();
    @Nonnull
    protected final Set<String> dataTypeNames = new HashSet<String>();
    @Nonnull
    protected final Set<String> annotationPropertyNames = new HashSet<String>();
    @Nonnull
    private final Map<String, SWRLBuiltInsVocabulary> ruleBuiltIns = new HashMap<String, SWRLBuiltInsVocabulary>();
    @Nonnull
    protected final DefaultPrefixManager pm = new DefaultPrefixManager();
    @Nonnull
    protected final Set<ManchesterOWLSyntax> potentialKeywords = new HashSet<ManchesterOWLSyntax>();
    private OWLOntology defaultOntology;
    private final boolean allowEmptyFrameSections = false;
    private final Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLDataProperty, ?>> dataPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    protected RemappingIndividualProvider anonProvider;
    private final Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLClass, ?>> classFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLObjectProperty, ?>> objectPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLAnnotationProperty, ?>> annotationPropertyFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<ManchesterOWLSyntax, AnnotatedListItemParser<OWLIndividual, ?>> individualFrameSections = new EnumMap(ManchesterOWLSyntax.class);
    private final Map<String, IRI> nameIRIMap = new HashMap<String, IRI>();

    @Inject
    public ManchesterOWLSyntaxParserImpl(@Nonnull Provider<OWLOntologyLoaderConfiguration> configurationProvider, @Nonnull OWLDataFactory dataFactory) {
        this.configProvider = configurationProvider;
        this.dataFactory = dataFactory;
        this.anonProvider = new RemappingIndividualProvider(this.dataFactory);
        this.pm.setPrefix("rdf:", Namespaces.RDF.toString());
        this.pm.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.pm.setPrefix("owl:", Namespaces.OWL.toString());
        this.pm.setPrefix("dc:", "http://purl.org/dc/elements/1.1/");
        NamespaceUtil u = new NamespaceUtil();
        this.initialiseClassFrameSections();
        this.initialiseObjectPropertyFrameSections();
        this.initialiseDataPropertyFrameSections();
        this.initialiseAnnotationPropertyFrameSections();
        this.initialiseIndividualFrameSections();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().toString());
            this.dataTypeNames.add(xSDVocabulary.getIRI().toQuotedString());
            this.dataTypeNames.add(xSDVocabulary.getPrefixedName());
        }
        for (XSDVocabulary xSDVocabulary : OWL2Datatype.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().toString());
            this.dataTypeNames.add(xSDVocabulary.getIRI().toQuotedString());
            this.dataTypeNames.add(xSDVocabulary.getPrefixedName());
        }
        this.dataTypeNames.add(OWLRDFVocabulary.RDFS_LITERAL.getPrefixedName());
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getShortForm());
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getPrefixedName());
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            String string = iri.toString();
            String string2 = XMLUtils.getNCNamePrefix((CharSequence)string);
            String fragment = XMLUtils.getNCNameSuffix((CharSequence)string);
            this.annotationPropertyNames.add(u.getPrefix(string2) + ':' + (fragment != null ? fragment : ""));
        }
        this.owlEntityChecker = new DefaultEntityChecker();
        for (SWRLBuiltInsVocabulary sWRLBuiltInsVocabulary : SWRLBuiltInsVocabulary.values()) {
            this.ruleBuiltIns.put(sWRLBuiltInsVocabulary.getShortForm(), sWRLBuiltInsVocabulary);
            this.ruleBuiltIns.put(sWRLBuiltInsVocabulary.getIRI().toQuotedString(), sWRLBuiltInsVocabulary);
        }
    }

    public PrefixManager getPrefixManager() {
        return this.pm;
    }

    @Nonnull
    public OWLOntologyLoaderConfiguration getOntologyLoaderConfiguration() {
        if (this.config.isPresent()) {
            return (OWLOntologyLoaderConfiguration)this.config.get();
        }
        this.config = Optional.of((Object)this.configProvider.get());
        return (OWLOntologyLoaderConfiguration)this.config.get();
    }

    public void setOntologyLoaderConfigurationProvider(Provider<OWLOntologyLoaderConfiguration> provider) {
        this.configProvider = provider;
    }

    public void setOntologyLoaderConfiguration(OWLOntologyLoaderConfiguration config) {
        this.config = Optional.fromNullable((Object)config);
    }

    public void setStringToParse(String s) {
        this.tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
        this.tokens.addAll(ManchesterOWLSyntaxParserImpl.getTokenizer(s).tokenize());
        this.tokenIndex = 0;
    }

    protected static ManchesterOWLSyntaxTokenizer getTokenizer(String s) {
        return new ManchesterOWLSyntaxTokenizer(s);
    }

    private void initialiseClassFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new EntityAnnotationsListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassSubClassOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassEquivalentToListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassDisjointWithListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassHasKeyListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassDisjointUnionOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassSuperClassOfListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassDisjointClassesListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ClassIndividualsListItemParser(), this.classFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseObjectPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new EntityAnnotationsListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertySubPropertyOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyEquivalentToListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyDisjointWithListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyDomainListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyRangeListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyInverseOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertyCharacteristicsItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertySubPropertyChainListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new ObjectPropertySuperPropertyOfListItemParser(), this.objectPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseDataPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertySubPropertyOfListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertyEquivalentToListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertyDisjointWithListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertyDomainListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertyRangeListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new DataPropertyCharacteristicsItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new EntityAnnotationsListItemParser(), this.dataPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseAnnotationPropertyFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnotationPropertySubPropertyOfListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnotationPropertyDomainListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new AnnotationPropertyRangeListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new EntityAnnotationsListItemParser(), this.annotationPropertyFrameSections, new ManchesterOWLSyntax[0]);
    }

    private void initialiseIndividualFrameSections() {
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualAnnotationItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualTypesItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualFactsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualSameAsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualDifferentFromItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
        ManchesterOWLSyntaxParserImpl.initialiseSection(new IndividualDifferentIndividualsItemParser(), this.individualFrameSections, new ManchesterOWLSyntax[0]);
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    private boolean isOntologyName(@Nonnull String name) {
        return this.owlOntologyChecker.getOntology(name) != null;
    }

    private boolean isClassName(@Nonnull String name) {
        return this.classNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name) != null;
    }

    private OWLOntology getOntology(String name) {
        return this.owlOntologyChecker.getOntology(name);
    }

    public void setOWLOntologyChecker(@Nonnull OWLOntologyChecker owlOntologyChecker) {
        this.owlOntologyChecker = owlOntologyChecker;
    }

    private boolean isObjectPropertyName(@Nonnull String name) {
        return this.objectPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name) != null;
    }

    private boolean isAnnotationPropertyName(@Nonnull String name) {
        return this.annotationPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLAnnotationProperty(name) != null;
    }

    private boolean isDataPropertyName(@Nonnull String name) {
        return this.dataPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name) != null;
    }

    private boolean isIndividualName(@Nonnull String name) {
        return this.individualNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name) != null;
    }

    private boolean isDatatypeName(@Nonnull String name) {
        return this.dataTypeNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDatatype(name) != null;
    }

    private boolean isSWRLBuiltin(@Nonnull String name) {
        return this.ruleBuiltIns.containsKey(name);
    }

    @Nonnull
    private OWLClass getOWLClass(@Nonnull String name) {
        OWLClass cls = this.owlEntityChecker.getOWLClass(name);
        if (cls == null && this.classNames.contains(name)) {
            cls = this.dataFactory.getOWLClass(this.getIRI(name));
        }
        if (cls == null) {
            throw new ExceptionBuilder().withKeyword(this.potentialKeywords).withClass().build();
        }
        return cls;
    }

    @Nonnull
    private OWLObjectProperty getOWLObjectProperty(@Nonnull String name) {
        OWLObjectProperty prop = this.owlEntityChecker.getOWLObjectProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLObjectProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withObject().build();
        }
        return prop;
    }

    @Nonnull
    private OWLIndividual getOWLIndividual(@Nonnull String name) {
        if (name.startsWith("_:")) {
            return this.anonProvider.getOWLAnonymousIndividual(name);
        }
        return this.getOWLNamedIndividual(name);
    }

    @Nonnull
    private OWLNamedIndividual getOWLNamedIndividual(@Nonnull String name) {
        OWLNamedIndividual ind = this.owlEntityChecker.getOWLIndividual(name);
        if (ind == null && this.individualNames.contains(name)) {
            ind = this.dataFactory.getOWLNamedIndividual(this.getIRI(name));
        }
        if (ind == null) {
            throw new ExceptionBuilder().withInd().build();
        }
        return ind;
    }

    @Nonnull
    private OWLDataProperty getOWLDataProperty(@Nonnull String name) {
        OWLDataProperty prop = this.owlEntityChecker.getOWLDataProperty(name);
        if (prop == null && this.dataPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLDataProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withData().build();
        }
        return prop;
    }

    @Nonnull
    private OWLDatatype getOWLDatatype(@Nonnull String name) {
        OWLDatatype dt = this.owlEntityChecker.getOWLDatatype(name);
        if (dt == null && this.dataTypeNames.contains(name)) {
            dt = this.dataFactory.getOWLDatatype(this.getIRI(name));
        }
        if (dt == null) {
            throw new ExceptionBuilder().withDt().build();
        }
        return dt;
    }

    @Nonnull
    private OWLAnnotationProperty getOWLAnnotationProperty(@Nonnull String name) {
        OWLAnnotationProperty prop = this.owlEntityChecker.getOWLAnnotationProperty(name);
        if (prop == null && this.annotationPropertyNames.contains(name)) {
            prop = this.dataFactory.getOWLAnnotationProperty(this.getIRI(name));
        }
        if (prop == null) {
            throw new ExceptionBuilder().withAnn().build();
        }
        return prop;
    }

    protected ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    @Nonnull
    private String peekToken() {
        return this.getToken().getToken();
    }

    @Nonnull
    private String consumeToken() {
        String token = this.getToken().getToken();
        if (this.tokenIndex < this.tokens.size()) {
            ++this.tokenIndex;
        }
        return token;
    }

    private void consumeToken(String expected) {
        String tok = this.consumeToken();
        if (!tok.equals(expected)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private void consumeToken(ManchesterOWLSyntax expected) {
        String tok = this.consumeToken();
        if (!expected.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    private ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex < this.tokens.size() ? this.tokenIndex : this.tokenIndex - 1);
    }

    @Nonnull
    public OWLClassExpression parseClassExpression() {
        OWLClassExpression desc = this.parseUnion();
        if (!ManchesterOWLSyntaxTokenizer.eof(this.consumeToken())) {
            throw new ExceptionBuilder().withKeyword("|EOF|").build();
        }
        return desc;
    }

    public OWLClassExpression parseClassExpression(String s) {
        this.setStringToParse(s);
        return this.parseClassExpression();
    }

    protected OWLClassExpression parseIntersection() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.AND.keyword();
        while (ManchesterOWLSyntax.AND.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.AND);
            ops.add(this.parseNonNaryClassExpression());
            this.potentialKeywords.add(ManchesterOWLSyntax.AND);
            kw = this.peekToken();
            if (ManchesterOWLSyntax.AND.matches(kw)) {
                kw = this.consumeToken();
                continue;
            }
            if (!ManchesterOWLSyntax.THAT.matches(kw)) continue;
            this.consumeToken();
            kw = ManchesterOWLSyntax.AND.keyword();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    @Nonnull
    protected OWLClassExpression parseUnion() {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = ManchesterOWLSyntax.OR.keyword();
        while (ManchesterOWLSyntax.OR.matches(kw)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.OR);
            ops.add(this.parseIntersection());
            this.potentialKeywords.add(ManchesterOWLSyntax.OR);
            kw = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(kw)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    @Nonnull
    protected OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) {
        String tok = this.consumeToken();
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            String close;
            String open = this.peekToken();
            boolean brackets = false;
            if (ManchesterOWLSyntax.OPEN.matches(open)) {
                this.consumeToken();
                brackets = true;
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            if (brackets && !ManchesterOWLSyntax.CLOSE.matches(close = this.consumeToken())) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return this.dataFactory.getOWLObjectInverseOf(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            throw new ExceptionBuilder().withObject().build();
        }
        return this.getOWLObjectProperty(tok);
    }

    private OWLPropertyExpression parsePropertyExpression() {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectPropertyExpression(false);
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataProperty();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    private OWLClassExpression parseNonNaryClassExpression() {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            this.consumeToken();
            OWLClassExpression complemented = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        if (this.isObjectPropertyName(tok) || ManchesterOWLSyntax.INVERSE.matches(tok)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            return this.parseNestedClassExpression(false);
        }
        this.consumeToken();
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT, ManchesterOWLSyntax.INVERSE).build();
    }

    private OWLClassExpression parseObjectRestriction() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            String possSelfToken = this.peekToken();
            if (ManchesterOWLSyntax.SELF.matches(possSelfToken)) {
                this.consumeToken();
                return this.dataFactory.getOWLObjectHasSelf(prop);
            }
            OWLClassExpression filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e) {
                e.getExpectedKeywords().add(ManchesterOWLSyntax.SELF.keyword());
                throw e;
            }
            return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                throw new ExceptionBuilder().withInd().build();
            }
            return this.dataFactory.getOWLObjectHasValue(prop, this.getOWLIndividual(indName));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.dataFactory.getOWLObjectMinCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            return this.dataFactory.getOWLObjectExactCardinality(card, prop, filler);
        }
        if (ManchesterOWLSyntax.ONLYSOME.matches(kw)) {
            String tok = this.peekToken();
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            if (!ManchesterOWLSyntax.OPENBRACKET.matches(tok)) {
                descs.add(this.parseUnion());
            } else {
                descs.addAll(this.parseClassExpressionList(ManchesterOWLSyntax.OPENBRACKET, ManchesterOWLSyntax.CLOSEBRACKET));
            }
            HashSet<Object> ops = new HashSet<Object>();
            for (OWLClassExpression desc : descs) {
                assert (desc != null);
                ops.add(this.dataFactory.getOWLObjectSomeValuesFrom(prop, desc));
            }
            Object filler = descs.size() == 1 ? (OWLClassExpression)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            assert (filler != null);
            ops.add(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        if (ManchesterOWLSyntax.SELF.matches(kw)) {
            return this.dataFactory.getOWLObjectHasSelf(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SELF).build();
    }

    private OWLClassExpression parseDataRestriction() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange rng = this.parseDataIntersectionOf(false);
            return this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange rng = this.parseDataIntersectionOf(false);
            return this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.VALUE.matches(kw)) {
            OWLLiteral con = this.parseLiteral(null);
            return this.dataFactory.getOWLDataHasValue((OWLDataPropertyExpression)prop, con);
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataIntersectionOf(true);
            return this.dataFactory.getOWLDataMinCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataIntersectionOf(true);
            return this.dataFactory.getOWLDataExactCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataIntersectionOf(true);
            return this.dataFactory.getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)prop, rng);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.VALUE, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.MAX).build();
    }

    private OWLFacet parseFacet() {
        String facet = this.consumeToken();
        if (ManchesterOWLSyntax.MIN_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MIN_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_INCLUSIVE_FACET.matches(facet, this.peekToken())) {
            this.consumeToken();
            return OWLFacet.MAX_INCLUSIVE;
        }
        if (ManchesterOWLSyntax.MIN_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (ManchesterOWLSyntax.MAX_EXCLUSIVE_FACET.matches(facet)) {
            return OWLFacet.MAX_EXCLUSIVE;
        }
        return OWLFacet.getFacetBySymbolicName((String)facet);
    }

    @Nonnull
    private OWLDatatype parseDatatype() {
        String name = this.consumeToken();
        return this.getOWLDatatype(name);
    }

    public OWLDataRange parseDataRange() {
        return this.parseDataIntersectionOf(false);
    }

    @Nonnull
    protected OWLDataRange parseDataIntersectionOf(boolean lookaheadCheck) {
        String sep = ManchesterOWLSyntax.AND.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.AND.matches(sep)) {
            ranges.add(this.parseDataUnionOf(lookaheadCheck));
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.AND.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.isEmpty()) {
            return this.dataFactory.getTopDatatype();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataIntersectionOf(ranges);
    }

    private OWLDataRange parseDataUnionOf(boolean lookaheadCheck) {
        String sep = ManchesterOWLSyntax.OR.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.OR.matches(sep)) {
            ranges.add(this.parseDataRangePrimary(lookaheadCheck));
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.OR.matches(sep)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.dataFactory.getOWLDataUnionOf(ranges);
    }

    @Nonnull
    private OWLDataRange parseDataRangePrimary(boolean lookaheadCheck) {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDatatype datatype = this.getOWLDatatype(tok);
            String next = this.peekToken();
            if (ManchesterOWLSyntax.OPENBRACKET.matches(next)) {
                this.consumeToken();
                String sep = ManchesterOWLSyntax.COMMA.keyword();
                HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
                while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                    OWLFacet fv = this.parseFacet();
                    if (fv == null) {
                        throw new ExceptionBuilder().withKeyword(OWLFacet.getFacets()).build();
                    }
                    OWLLiteral con = this.parseLiteral(datatype);
                    facetRestrictions.add(this.dataFactory.getOWLFacetRestriction(fv, con));
                    sep = this.consumeToken();
                }
                if (!ManchesterOWLSyntax.CLOSEBRACKET.matches(sep)) {
                    throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACKET).build();
                }
                return this.dataFactory.getOWLDatatypeRestriction(datatype, facetRestrictions);
            }
            return datatype;
        }
        if (ManchesterOWLSyntax.NOT.matches(tok)) {
            return this.parseDataComplementOf(false);
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseDataOneOf();
        }
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLDataRange rng = this.parseDataIntersectionOf(false);
            this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
            return rng;
        }
        for (ManchesterOWLSyntax x : ManchesterOWLSyntax.values()) {
            if (!x.matches(tok)) continue;
            return this.dataFactory.getTopDatatype();
        }
        if (ManchesterOWLSyntaxTokenizer.eof(tok) && lookaheadCheck) {
            return this.dataFactory.getTopDatatype();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withDt().withKeyword(ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.NOT).build();
    }

    @Nonnull
    public Set<OWLDataRange> parseDataRangeList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLDataRange rng = this.parseDataIntersectionOf(false);
            ranges.add(rng);
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return ranges;
    }

    @Nonnull
    private OWLDataRange parseDataOneOf() {
        this.consumeToken();
        HashSet<OWLLiteral> cons = new HashSet<OWLLiteral>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLLiteral con = this.parseLiteral(null);
            cons.add(con);
            sep = this.consumeToken();
        }
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(sep)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACE).build();
        }
        return this.dataFactory.getOWLDataOneOf(cons);
    }

    @Nonnull
    private OWLDataRange parseDataComplementOf(boolean lookaheadCheck) {
        String not = this.consumeToken();
        if (!ManchesterOWLSyntax.NOT.matches(not)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.NOT).build();
        }
        OWLDataRange complementedDataRange = this.parseDataRangePrimary(lookaheadCheck);
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    @Nonnull
    public OWLLiteral parseLiteral(OWLDatatype datatype) {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = this.unquoteLiteral(tok);
            if (this.peekToken().equals("^")) {
                this.consumeToken();
                if (!this.peekToken().equals("^")) {
                    throw new ExceptionBuilder().withKeyword("^").build();
                }
                this.consumeToken();
                return this.dataFactory.getOWLLiteral(lit, this.parseDatatype());
            }
            if (this.peekToken().startsWith("@")) {
                String lang = this.consumeToken().substring(1);
                return this.dataFactory.getOWLLiteral(lit, lang);
            }
            return this.dataFactory.getOWLLiteral(lit, "");
        }
        if (datatype != null) {
            return this.dataFactory.getOWLLiteral(tok, datatype);
        }
        try {
            int i = Integer.parseInt(tok);
            return this.dataFactory.getOWLLiteral(i);
        }
        catch (NumberFormatException i) {
            if (tok.endsWith("f") || tok.endsWith("F")) {
                try {
                    float f = Float.parseFloat(tok.replace("INF", "Infinity").replace("inf", "Infinity"));
                    return this.dataFactory.getOWLLiteral(ManchesterOWLSyntaxParserImpl.asFloat(f), OWL2Datatype.XSD_FLOAT);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                Double.parseDouble(tok);
                return this.dataFactory.getOWLLiteral(tok, OWL2Datatype.XSD_DECIMAL);
            }
            catch (NumberFormatException numberFormatException) {
                if (ManchesterOWLSyntax.LITERAL_TRUE.matches(tok)) {
                    return this.dataFactory.getOWLLiteral(true);
                }
                if (ManchesterOWLSyntax.LITERAL_FALSE.matches(tok)) {
                    return this.dataFactory.getOWLLiteral(false);
                }
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.LITERAL_TRUE, ManchesterOWLSyntax.LITERAL_FALSE, ManchesterOWLSyntax.LITERAL_INTEGER, ManchesterOWLSyntax.LITERAL_FLOAT, ManchesterOWLSyntax.LITERAL_DOUBLE, ManchesterOWLSyntax.LITERAL_LITERAL, ManchesterOWLSyntax.LITERAL_LIT_DATATYPE, ManchesterOWLSyntax.LITERAL_LIT_LANG).build();
            }
        }
    }

    @Nonnull
    private String unquoteLiteral(String tok) {
        String lit = "";
        if (!tok.endsWith("\"")) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword("\"").build();
        }
        if (tok.length() > 2) {
            lit = tok.substring(1, tok.length() - 1);
        }
        return (String)OWLAPIPreconditions.verifyNotNull((Object)lit);
    }

    @Nonnull
    private static String asFloat(float f) {
        return Float.toString(f).replace("Infinity", "INF");
    }

    private int parseInteger() {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ExceptionBuilder().withInt().build();
        }
    }

    @Nonnull
    private OWLClassExpression parseNestedClassExpression(boolean lookaheadCheck) {
        String tok = this.peekToken();
        if (ManchesterOWLSyntax.OPEN.matches(tok)) {
            this.consumeToken();
            OWLClassExpression desc = this.parseUnion();
            String closeBracket = this.consumeToken();
            if (!ManchesterOWLSyntax.CLOSE.matches(closeBracket)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSE).build();
            }
            return desc;
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(tok)) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.consumeToken();
            return this.getOWLClass(name);
        }
        for (ManchesterOWLSyntax x : ManchesterOWLSyntax.values()) {
            if (!x.matches(tok)) continue;
            return this.dataFactory.getOWLThing();
        }
        if (ManchesterOWLSyntaxTokenizer.eof(tok)) {
            return this.dataFactory.getOWLThing();
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(tok) || !lookaheadCheck) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE).withClass().build();
        }
        return this.dataFactory.getOWLThing();
    }

    @Nonnull
    private OWLClassExpression parseObjectOneOf() {
        String open = this.consumeToken();
        if (!ManchesterOWLSyntax.OPENBRACE.matches(open)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.OPENBRACE).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!ManchesterOWLSyntax.CLOSEBRACE.matches(close)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLOSEBRACE, ManchesterOWLSyntax.COMMA).build();
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    private static <F> void initialiseSection(AnnotatedListItemParser<F, ?> parser, Map<ManchesterOWLSyntax, AnnotatedListItemParser<F, ?>> map, ManchesterOWLSyntax ... synonyms) {
        map.put(parser.getFrameSectionKeyword(), parser);
        for (ManchesterOWLSyntax syn : synonyms) {
            map.put(syn, parser);
        }
    }

    @Nonnull
    public Set<OntologyAxiomPair> parseFrames() {
        String tok;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<ManchesterOWLSyntax> possible = new HashSet<ManchesterOWLSyntax>();
        ManchesterOWLSyntaxParserImpl.resetPossible(possible);
        while (true) {
            if (ManchesterOWLSyntax.CLASS.matches(tok = this.peekToken())) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseClassFrame());
                possible.addAll(this.classFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseObjectPropertyFrame());
                possible.addAll(this.objectPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseDataPropertyFrame());
                possible.addAll(this.dataPropertyFrameSections.keySet());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseAnnotationPropertyFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE));
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseIndividualFrame());
                possible.addAll(Arrays.asList(ManchesterOWLSyntax.TYPES, ManchesterOWLSyntax.FACTS, ManchesterOWLSyntax.DIFFERENT_FROM, ManchesterOWLSyntax.SAME_AS));
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                axioms.addAll(this.parseDatatypeFrame());
                possible.add(ManchesterOWLSyntax.EQUIVALENT_TO);
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(tok)) {
                this.potentialKeywords.clear();
                ManchesterOWLSyntaxParserImpl.resetPossible(possible);
                this.parseValuePartitionFrame();
                continue;
            }
            if (!ManchesterOWLSyntax.RULE.matches(tok)) break;
            this.potentialKeywords.clear();
            ManchesterOWLSyntaxParserImpl.resetPossible(possible);
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(tok)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(possible).build();
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDatatypeFrame() {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.DATATYPE.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATATYPE).build();
        }
        String subj = this.consumeToken();
        OWLDatatype datatype = this.getOWLDatatype(subj);
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)datatype)));
        block0: while (true) {
            String sect;
            if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(sect = this.peekToken())) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLOntology> onts = this.getOntologies();
                Set<OWLDataRange> drs = this.parseDataRangeList();
                Iterator<OWLOntology> iterator = onts.iterator();
                block1: while (true) {
                    if (!iterator.hasNext()) continue block0;
                    OWLOntology ont = iterator.next();
                    assert (ont != null);
                    Iterator<OWLDataRange> iterator2 = drs.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block1;
                        OWLDataRange dr = iterator2.next();
                        assert (dr != null);
                        axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr)));
                    }
                    break;
                }
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(sect)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations((OWLAnnotationSubject)datatype.getIRI()));
        }
        return axioms;
    }

    private static void resetPossible(Set<ManchesterOWLSyntax> possible) {
        possible.clear();
        possible.add(ManchesterOWLSyntax.ANNOTATIONS);
        possible.add(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
        possible.add(ManchesterOWLSyntax.CLASS);
        possible.add(ManchesterOWLSyntax.OBJECT_PROPERTY);
        possible.add(ManchesterOWLSyntax.DATATYPE);
        possible.add(ManchesterOWLSyntax.DATA_PROPERTY);
        possible.add(ManchesterOWLSyntax.INDIVIDUAL);
        possible.add(ManchesterOWLSyntax.VALUE_PARTITION);
        possible.add(ManchesterOWLSyntax.RULE);
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentClasses() {
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLEquivalentClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseNaryEquivalentProperties() {
        OWLEquivalentObjectPropertiesAxiom propertyAxiom;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression> properties = this.parsePropertyList();
        if (properties.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression pe : properties) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression pe : properties) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertyAxiom = this.dataFactory.getOWLEquivalentDataPropertiesAxiom(dpe, annotations);
        }
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)propertyAxiom));
        }
        return pairs;
    }

    @Nonnull
    private Set<OWLAnnotation> parseAnnotations() {
        String next = this.peekToken();
        Set<OWLAnnotation> annotations = CollectionFactory.emptySet();
        if (ManchesterOWLSyntax.ANNOTATIONS.matches(next)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        }
        return annotations;
    }

    private Set<OntologyAxiomPair> parseAnnotations(@Nonnull OWLAnnotationSubject s) {
        String header = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATIONS.matches(header)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        Set<OWLOntology> onts = this.getOntologies();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        Set<OWLAnnotation> annos = this.parseAnnotationList();
        for (OWLOntology ont : onts) {
            assert (ont != null);
            for (OWLAnnotation anno : annos) {
                assert (anno != null);
                if (!this.getOntologyLoaderConfiguration().isLoadAnnotationAxioms()) continue;
                pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom(s, anno)));
            }
        }
        return pairs;
    }

    @Nonnull
    private Set<OWLAnnotation> parseAnnotationList() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.clear();
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            OWLAnnotation anno = this.parseAnnotation();
            anno = anno.getAnnotatedAnnotation(annotations);
            annos.add(anno);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return annos;
    }

    @Nonnull
    protected OWLAnnotation parseAnnotation() {
        OWLAnnotationProperty annoProp = this.parseAnnotationProperty();
        String obj = this.peekToken();
        OWLAnnotation anno = null;
        if (this.isIndividualName(obj) || this.isClassName(obj) || this.isObjectPropertyName(obj) || this.isDataPropertyName(obj)) {
            this.consumeToken();
            Object value = obj.startsWith("_:") ? this.anonProvider.getOWLAnonymousIndividual(obj) : this.getIRI(obj);
            anno = this.dataFactory.getOWLAnnotation(annoProp, (OWLAnnotationValue)value);
        } else if (obj.startsWith("<")) {
            IRI value = this.parseIRI();
            anno = this.dataFactory.getOWLAnnotation(annoProp, (OWLAnnotationValue)value);
        } else {
            OWLLiteral con = this.parseLiteral(null);
            anno = this.dataFactory.getOWLAnnotation(annoProp, (OWLAnnotationValue)con);
        }
        return anno;
    }

    public Set<OntologyAxiomPair> parseClassFrame() {
        return this.parseClassFrame(false);
    }

    public Set<OntologyAxiomPair> parseClassFrameEOF() {
        return this.parseClassFrame(true);
    }

    @Nonnull
    private Set<OntologyAxiomPair> parseClassFrame(boolean eof) {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.CLASS.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS).build();
        }
        String subj = this.consumeToken();
        OWLClass cls = this.getOWLClass(subj);
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)cls)));
        this.parseFrameSections(eof, axioms, cls, this.classFrameSections);
        return axioms;
    }

    @Nonnull
    private Set<OWLOntology> parseOntologyList() {
        this.potentialKeywords.clear();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        this.consumeToken("in");
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String tok = this.consumeToken();
            if (this.isOntologyName(tok)) {
                OWLOntology ont = this.getOntology(tok);
                if (ont != null) {
                    onts.add(ont);
                }
            } else {
                throw new ExceptionBuilder().withOnto().build();
            }
            sep = this.consumeToken();
            if (sep.equals(ManchesterOWLSyntax.CLOSEBRACKET.keyword())) break;
            if (ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.COMMA, ManchesterOWLSyntax.CLOSEBRACKET).build();
        }
        return onts;
    }

    @Nonnull
    private Set<OWLOntology> getOntologies() {
        if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
            return this.parseOntologyList();
        }
        return CollectionFactory.createSet((Object)this.defaultOntology);
    }

    public void setDefaultOntology(@Nonnull OWLOntology defaultOntology) {
        this.defaultOntology = defaultOntology;
        for (OWLDeclarationAxiom d : defaultOntology.getAxioms(AxiomType.DECLARATION, Imports.INCLUDED)) {
            this.processDeclaredEntities(d);
        }
    }

    private boolean isEmptyFrameSection(Map<ManchesterOWLSyntax, ?> parsers) {
        return false;
    }

    private <F> void parseFrameSections(boolean eof, Set<OntologyAxiomPair> axioms, @Nonnull F frameSubject, Map<ManchesterOWLSyntax, AnnotatedListItemParser<F, ?>> sectionParsers) {
        String sect;
        AnnotatedListItemParser<F, ?> parser;
        while ((parser = sectionParsers.get((Object)ManchesterOWLSyntax.parse(sect = this.peekToken()))) != null) {
            this.consumeToken();
            Set<OWLOntology> onts = this.getOntologies();
            if (this.isEmptyFrameSection(sectionParsers)) continue;
            axioms.addAll(this.parseAnnotatedListItems(frameSubject, parser, onts));
        }
        if (eof && !ManchesterOWLSyntaxTokenizer.eof(sect)) {
            ArrayList<ManchesterOWLSyntax> expected = new ArrayList<ManchesterOWLSyntax>();
            expected.addAll(sectionParsers.keySet());
            if (frameSubject instanceof OWLAnnotationSubject || frameSubject instanceof OWLEntity) {
                expected.add(ManchesterOWLSyntax.ANNOTATIONS);
            }
            throw new ExceptionBuilder().withKeyword(expected).build();
        }
    }

    public Set<OntologyAxiomPair> parseObjectPropertyFrame() {
        return this.parseObjectPropertyFrame(false);
    }

    @Nonnull
    private Set<OntologyAxiomPair> parseObjectPropertyFrame(boolean eof) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        this.consumeToken(ManchesterOWLSyntax.OBJECT_PROPERTY);
        String token = this.consumeToken();
        OWLObjectProperty prop = this.getOWLObjectProperty(token);
        if (!prop.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)prop.asOWLObjectProperty())));
        }
        this.parseFrameSections(eof, axioms, prop, this.objectPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDataPropertyFrame() {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DATA_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DATA_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        axioms.add(new OntologyAxiomPair(this.defaultOntology, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)prop)));
        this.parseFrameSections(false, axioms, prop, this.dataPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseAnnotationPropertyFrame() {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ANNOTATION_PROPERTY).build();
        }
        String subj = this.consumeToken();
        OWLAnnotationProperty prop = this.getOWLAnnotationProperty(subj);
        for (OWLOntology ont : this.getOntologies()) {
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)prop)));
        }
        this.parseFrameSections(false, axioms, prop, this.annotationPropertyFrameSections);
        return axioms;
    }

    public Set<OntologyAxiomPair> parseIndividualFrame() {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!ManchesterOWLSyntax.INDIVIDUAL.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INDIVIDUAL).build();
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        if (!ind.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.getOntology(null), (OWLAxiom)this.dataFactory.getOWLDeclarationAxiom((OWLEntity)ind.asOWLNamedIndividual())));
        }
        this.parseFrameSections(false, axioms, ind, this.individualFrameSections);
        return axioms;
    }

    @Nonnull
    protected OWLPropertyAssertionAxiom<?, ?> parseFact(@Nonnull OWLIndividual ind) {
        String prop;
        boolean negative = false;
        if (ManchesterOWLSyntax.NOT.matches(this.peekToken())) {
            this.consumeToken();
            negative = true;
        }
        if (this.isDataPropertyName(prop = this.peekToken())) {
            OWLDataProperty p = this.parseDataProperty();
            OWLLiteral con = this.parseLiteral(null);
            if (!negative) {
                return this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
            }
            return this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con);
        }
        if (this.isObjectPropertyName(prop) || ManchesterOWLSyntax.INVERSE.matches(prop)) {
            OWLObjectPropertyExpression p = this.parseObjectPropertyExpression(false);
            if (!negative) {
                return this.dataFactory.getOWLObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
            }
            return this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(p, ind, this.parseIndividual());
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    public Set<OntologyAxiomPair> parseValuePartitionFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.VALUE_PARTITION).build();
        }
        Set<OWLOntology> onts = this.getOntologies();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String clsName = this.consumeToken();
        if (ManchesterOWLSyntaxTokenizer.eof(clsName)) {
            throw new ExceptionBuilder().withObject().build();
        }
        OWLClass cls = this.getOWLClass(clsName);
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.addAll(this.parseValuePartitionValues(onts, cls));
        for (OWLOntology ont : onts) {
            assert (ont != null);
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop)));
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, (OWLClassExpression)cls)));
        }
        return axioms;
    }

    @Nonnull
    private Set<OntologyAxiomPair> parseValuePartitionValues(@Nonnull Set<OWLOntology> onts, @Nonnull OWLClass superclass) {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        this.consumeToken(ManchesterOWLSyntax.OPENBRACKET.keyword());
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            siblings.add(cls);
            OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)superclass);
            for (OWLOntology ont : onts) {
                assert (ont != null);
                axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)ax));
            }
            if (this.peekToken().equals(ManchesterOWLSyntax.OPENBRACKET.keyword())) {
                axioms.addAll(this.parseValuePartitionValues(onts, cls));
            }
            if (!ManchesterOWLSyntax.COMMA.matches(sep = this.peekToken())) continue;
            this.consumeToken();
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSEBRACKET.keyword());
        OWLDisjointClassesAxiom ax = this.dataFactory.getOWLDisjointClassesAxiom(siblings);
        for (OWLOntology ont : onts) {
            assert (ont != null);
            axioms.add(new OntologyAxiomPair(ont, (OWLAxiom)ax));
        }
        return axioms;
    }

    public List<OntologyAxiomPair> parseRuleFrame() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.RULE.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.RULE).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        List<SWRLAtom> body = this.parseRuleAtoms();
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.DASH.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DASH, ManchesterOWLSyntax.COMMA).build();
        }
        this.consumeToken(">");
        List<SWRLAtom> head = this.parseRuleAtoms();
        SWRLRule rule = this.dataFactory.getSWRLRule(new LinkedHashSet<SWRLAtom>(body), new LinkedHashSet<SWRLAtom>(head));
        ArrayList<OntologyAxiomPair> pairs = new ArrayList<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)rule));
        }
        return pairs;
    }

    private List<SWRLAtom> parseRuleAtoms() {
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        ArrayList<SWRLAtom> atoms = new ArrayList<SWRLAtom>();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            SWRLAtom atom = this.parseRuleAtom();
            atoms.add(atom);
            sep = this.peekToken();
            if (ManchesterOWLSyntax.COMMA.matches(sep)) {
                this.consumeToken();
            }
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
        }
        return atoms;
    }

    private SWRLAtom parseRuleAtom() {
        String predicate = this.peekToken();
        if (this.isClassName(predicate)) {
            return this.parseClassAtom();
        }
        if (ManchesterOWLSyntax.OPEN.matches(predicate)) {
            return this.parseClassAtom();
        }
        if (this.isObjectPropertyName(predicate)) {
            return this.parseObjectPropertyAtom();
        }
        if (this.isDataPropertyName(predicate)) {
            return this.parseDataPropertyAtom();
        }
        if (this.isDatatypeName(predicate)) {
            return this.parseDataRangeAtom();
        }
        if (ManchesterOWLSyntax.DIFFERENT_FROM.matchesEitherForm(predicate)) {
            return this.parseDifferentFromAtom();
        }
        if (ManchesterOWLSyntax.SAME_AS.matchesEitherForm(predicate)) {
            return this.parseSameAsAtom();
        }
        if (this.isSWRLBuiltin(predicate) || predicate.startsWith("<")) {
            return this.parseBuiltInAtom();
        }
        this.consumeToken();
        ArrayList<String> kw = new ArrayList<String>(this.ruleBuiltIns.keySet());
        kw.add(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        kw.add(ManchesterOWLSyntax.SAME_AS.toString());
        Collections.sort(kw);
        throw new ExceptionBuilder().withKeyword(kw).withClass().withObject().withData().build();
    }

    private SWRLAtom parseDataPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isDataPropertyName(predicate)) {
            throw new ExceptionBuilder().withData().build();
        }
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLDArgument obj2 = this.parseDObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)this.getOWLDataProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseDataRangeAtom() {
        OWLDataRange range = this.parseDataIntersectionOf(false);
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLVariable obj1 = this.parseDVariable();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDataRangeAtom(range, (SWRLDArgument)obj1);
    }

    private SWRLAtom parseObjectPropertyAtom() {
        String predicate = this.consumeToken();
        if (!this.isObjectPropertyName(predicate)) {
            throw new ExceptionBuilder().withObject().build();
        }
        assert (predicate != null);
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)this.getOWLObjectProperty(predicate), obj1, obj2);
    }

    private SWRLAtom parseClassAtom() {
        OWLClassExpression predicate = this.parseUnion();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLClassAtom(predicate, obj);
    }

    private SWRLDifferentIndividualsAtom parseDifferentFromAtom() {
        this.consumeToken(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLDifferentIndividualsAtom(obj1, obj2);
    }

    private SWRLSameIndividualAtom parseSameAsAtom() {
        this.consumeToken(ManchesterOWLSyntax.SAME_AS.toString());
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLSameIndividualAtom(obj1, obj2);
    }

    @Nonnull
    private SWRLIArgument parseIObject() {
        String s = this.peekToken();
        if (this.isIndividualName(s)) {
            return this.parseIIndividualObject();
        }
        if (s.equals("?")) {
            return this.parseIVariable();
        }
        this.consumeToken();
        throw new ExceptionBuilder().withInd().withKeyword("?$var$").build();
    }

    @Nonnull
    private SWRLVariable parseIVariable() {
        return this.dataFactory.getSWRLVariable(this.parseVariable());
    }

    @Nonnull
    private SWRLIndividualArgument parseIIndividualObject() {
        return this.dataFactory.getSWRLIndividualArgument(this.parseIndividual());
    }

    public IRI parseVariable() {
        this.consumeToken("?");
        String fragment = this.peekToken();
        if (fragment.startsWith("<")) {
            IRI parseIRI = this.parseIRI();
            if ("urn:swrl#".equals(parseIRI.getNamespace())) {
                parseIRI = IRI.create((String)"urn:swrl:var#", (String)parseIRI.getFragment());
            }
            return parseIRI;
        }
        this.consumeToken();
        return IRI.create((String)"urn:swrl:var#", (String)fragment);
    }

    @Nonnull
    private SWRLDArgument parseDObject() {
        String s = this.peekToken();
        if (s.equals("?")) {
            return this.parseDVariable();
        }
        try {
            return this.parseLiteralObject();
        }
        catch (ParserException e) {
            e.getExpectedKeywords().add("?");
            throw e;
        }
    }

    @Nonnull
    private SWRLVariable parseDVariable() {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    @Nonnull
    private SWRLLiteralArgument parseLiteralObject() {
        OWLLiteral lit = this.parseLiteral(null);
        return this.dataFactory.getSWRLLiteralArgument(lit);
    }

    private SWRLBuiltInAtom parseBuiltInAtom() {
        String predicate = this.consumeToken();
        this.consumeToken(ManchesterOWLSyntax.OPEN.keyword());
        SWRLBuiltInsVocabulary v = null;
        IRI iri = null;
        if (!this.ruleBuiltIns.containsKey(predicate)) {
            iri = this.getIRI(predicate);
        } else {
            v = this.ruleBuiltIns.get(predicate);
            iri = v.getIRI();
        }
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        if (v != null && v.getMaxArity() >= 0) {
            for (int i = 0; i < v.getMaxArity(); ++i) {
                SWRLDArgument obj = this.parseDObject();
                args.add(obj);
                if (i < v.getMinArity() - 1) {
                    this.consumeToken(ManchesterOWLSyntax.COMMA.keyword());
                    continue;
                }
                if (i >= v.getMaxArity() - 1) continue;
                if (this.peekToken().equals(ManchesterOWLSyntax.COMMA.keyword())) {
                    this.consumeToken();
                    continue;
                }
                break;
            }
        } else {
            String sep = ManchesterOWLSyntax.COMMA.keyword();
            while (ManchesterOWLSyntax.COMMA.matches(sep)) {
                SWRLDArgument arg = this.parseDObject();
                args.add(arg);
                sep = this.peekToken();
                if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
                this.consumeToken();
            }
        }
        this.consumeToken(ManchesterOWLSyntax.CLOSE.keyword());
        return this.dataFactory.getSWRLBuiltInAtom(iri, args);
    }

    private Set<OntologyAxiomPair> parseDisjointClasses() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_CLASSES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLDisjointClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseSameIndividual() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)this.dataFactory.getOWLSameIndividualAxiom(individuals, annotations)));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDisjointProperties() {
        OWLDisjointObjectPropertiesAxiom propertiesAxiom;
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DISJOINT_PROPERTIES).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLPropertyExpression> props = this.parsePropertyList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (props.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression pe : props) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression pe : props) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertiesAxiom = this.dataFactory.getOWLDisjointDataPropertiesAxiom(dpe, annotations);
        }
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            pairs.add(new OntologyAxiomPair(ont, (OWLAxiom)propertiesAxiom));
        }
        return pairs;
    }

    private Set<OntologyAxiomPair> parseDifferentIndividuals() {
        String section = this.consumeToken();
        if (!ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS).build();
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<OWLAnnotation> annotations = this.parseAnnotations();
        Set<OWLIndividual> individuals = this.parseIndividualList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ontology : ontologies) {
            assert (ontology != null);
            pairs.add(new OntologyAxiomPair(ontology, (OWLAxiom)this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, annotations)));
        }
        return pairs;
    }

    @Nonnull
    protected OWLObjectPropertyCharacteristicAxiom parseObjectPropertyCharacteristic(@Nonnull OWLObjectPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(characteristic)) {
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.ANTI_SYMMETRIC.matches(characteristic) || ManchesterOWLSyntax.ASYMMETRIC.matches(characteristic)) {
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(characteristic)) {
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(characteristic)) {
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(characteristic)) {
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ANTI_SYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    @Nonnull
    protected OWLDataPropertyCharacteristicAxiom parseDataPropertyCharacteristic(@Nonnull OWLDataPropertyExpression prop) {
        String characteristic = this.consumeToken();
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(characteristic)) {
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
    }

    public Set<OWLClassExpression> parseClassExpressionList() {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            descs.add(this.parseUnion());
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    private Set<OWLClassExpression> parseClassExpressionList(ManchesterOWLSyntax expectedOpen, ManchesterOWLSyntax expectedClose) {
        String open = this.consumeToken();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (!expectedOpen.matches(open)) {
            throw new ExceptionBuilder().withKeyword(expectedOpen).build();
        }
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            this.potentialKeywords.remove((Object)ManchesterOWLSyntax.COMMA);
            OWLClassExpression desc = this.parseUnion();
            this.potentialKeywords.add(ManchesterOWLSyntax.COMMA);
            descs.add(desc);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!expectedClose.matches(close)) {
            throw new ExceptionBuilder().withKeyword(expectedClose).build();
        }
        return descs;
    }

    public Set<OWLPropertyExpression> parsePropertyList() {
        HashSet<OWLPropertyExpression> props = new HashSet<OWLPropertyExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLPropertyExpression prop = this.parsePropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLDataProperty> parseDataPropertyList() {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLDataProperty prop = this.parseDataProperty();
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLAnnotationProperty> parseAnnotationPropertyList() {
        HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            OWLAnnotationProperty prop = this.parseAnnotationProperty();
            props.add(prop);
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return props;
    }

    @Nonnull
    public Set<OWLIndividual> parseIndividualList() {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.consumeToken();
        }
        return properties;
    }

    @Nonnull
    protected OWLIndividual parseIndividual() {
        String name = this.consumeToken();
        if (!this.isIndividualName(name) && !name.startsWith("_:")) {
            throw new ExceptionBuilder().withInd().build();
        }
        return this.getOWLIndividual(name);
    }

    @Nonnull
    protected OWLDataProperty parseDataProperty() {
        String name = this.consumeToken();
        if (!this.isDataPropertyName(name)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(name);
    }

    @Nonnull
    protected OWLAnnotationProperty parseAnnotationProperty() {
        String name = this.consumeToken();
        if (!this.isAnnotationPropertyName(name)) {
            throw new ExceptionBuilder().withAnn().build();
        }
        return this.getOWLAnnotationProperty(name);
    }

    private Map<String, IRI> parsePrefixDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.PREFIX);
        HashMap<String, IRI> map = new HashMap<String, IRI>(2);
        String prefixName = this.consumeToken();
        if (this.peekToken().equals("=")) {
            this.consumeToken();
        }
        IRI iri = this.parseIRI();
        map.put(prefixName, iri);
        return map;
    }

    @Nonnull
    private OWLImportsDeclaration parseImportsDeclaration() {
        this.consumeToken(ManchesterOWLSyntax.IMPORT);
        return this.dataFactory.getOWLImportsDeclaration(this.parseIRI());
    }

    @Nonnull
    protected IRI parseIRI() {
        String iriString = this.consumeToken();
        if (!iriString.startsWith("<") || !iriString.endsWith(">")) {
            throw new ExceptionBuilder().withKeyword("<$IRI$>").build();
        }
        return IRI.create((String)iriString.substring(1, iriString.length() - 1));
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            String token = this.tokens.get(i).getToken();
            String name = null;
            if (i + 1 < this.tokens.size()) {
                name = this.tokens.get(i + 1).getToken();
            }
            if (ManchesterOWLSyntax.CLASS.matches(token)) {
                if (name == null) continue;
                this.classNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.objectPropertyNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.dataPropertyNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(token)) {
                if (name == null) continue;
                this.individualNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(token)) {
                if (name == null) continue;
                this.dataTypeNames.add(name);
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(token)) {
                if (name == null) continue;
                this.annotationPropertyNames.add(name);
                continue;
            }
            if (!ManchesterOWLSyntax.VALUE_PARTITION.matches(token)) continue;
            if (name != null) {
                this.objectPropertyNames.add(name);
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private void processDeclaredEntities(OWLDeclarationAxiom ax) {
        ax.getEntity().accept(new OWLEntityVisitor(){

            public void visit(OWLAnnotationProperty property) {
                ManchesterOWLSyntaxParserImpl.this.annotationPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
            }

            public void visit(OWLDatatype datatype) {
                ManchesterOWLSyntaxParserImpl.this.dataTypeNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(datatype.getIRI()));
            }

            public void visit(OWLNamedIndividual individual) {
                ManchesterOWLSyntaxParserImpl.this.individualNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(individual.getIRI()));
            }

            public void visit(OWLDataProperty property) {
                ManchesterOWLSyntaxParserImpl.this.dataPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
            }

            public void visit(OWLObjectProperty property) {
                ManchesterOWLSyntaxParserImpl.this.objectPropertyNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(property.getIRI()));
            }

            public void visit(OWLClass cls) {
                ManchesterOWLSyntaxParserImpl.this.classNames.add(ManchesterOWLSyntaxParserImpl.this.pm.getShortForm(cls.getIRI()));
            }
        });
    }

    public ManchesterSyntaxDocumentFormat parseOntology(@Nonnull OWLOntology ont) {
        String section;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        OWLOntologyID ontologyID = new OWLOntologyID();
        HashSet<AddImport> imports = new HashSet<AddImport>();
        HashSet<AddOntologyAnnotation> ontologyAnnotations = new HashSet<AddOntologyAnnotation>();
        this.defaultOntology = ont;
        this.processDeclaredEntities();
        block0: while (true) {
            OWLOntology imported;
            if (ManchesterOWLSyntax.ONTOLOGY.matches(section = this.peekToken())) {
                ManchesterOWLSyntaxOntologyHeader header = this.parseOntologyHeader(false);
                for (OWLImportsDeclaration oWLImportsDeclaration : header.getImportsDeclarations()) {
                    assert (oWLImportsDeclaration != null);
                    imports.add(new AddImport(ont, oWLImportsDeclaration));
                    ont.getOWLOntologyManager().makeLoadImportRequest(oWLImportsDeclaration, this.getOntologyLoaderConfiguration());
                    OWLOntology imported2 = ont.getOWLOntologyManager().getImportedOntology(oWLImportsDeclaration);
                    assert (imported2 != null);
                    for (OWLDeclarationAxiom declaration : imported2.getAxioms(AxiomType.DECLARATION)) {
                        this.processDeclaredEntities(declaration);
                    }
                }
                for (OWLAnnotation oWLAnnotation : header.getAnnotations()) {
                    assert (oWLAnnotation != null);
                    ontologyAnnotations.add(new AddOntologyAnnotation(ont, oWLAnnotation));
                }
                ontologyID = header.getOntologyID();
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_CLASSES.matches(section)) {
                axioms.addAll(this.parseDisjointClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_CLASSES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentClasses());
                continue;
            }
            if (ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseNaryEquivalentProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DISJOINT_PROPERTIES.matches(section)) {
                axioms.addAll(this.parseDisjointProperties());
                continue;
            }
            if (ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.matches(section)) {
                axioms.addAll(this.parseDifferentIndividuals());
                continue;
            }
            if (ManchesterOWLSyntax.SAME_INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseSameIndividual());
                continue;
            }
            if (ManchesterOWLSyntax.CLASS.matches(section)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (ManchesterOWLSyntax.OBJECT_PROPERTY.matches(section)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATA_PROPERTY.matches(section)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.INDIVIDUAL.matches(section)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (ManchesterOWLSyntax.DATATYPE.matches(section)) {
                axioms.addAll(this.parseDatatypeFrame());
                continue;
            }
            if (ManchesterOWLSyntax.ANNOTATION_PROPERTY.matches(section)) {
                axioms.addAll(this.parseAnnotationPropertyFrame());
                continue;
            }
            if (ManchesterOWLSyntax.VALUE_PARTITION.matches(section)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (ManchesterOWLSyntax.IMPORT.matches(section)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration();
                ont.getOWLOntologyManager().makeLoadImportRequest(decl, this.getOntologyLoaderConfiguration());
                imports.add(new AddImport(ont, decl));
                imported = ont.getOWLOntologyManager().getImportedOntology(decl);
                assert (imported != null);
                Iterator iterator = imported.getAxioms(AxiomType.DECLARATION).iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    OWLDeclarationAxiom declaration = (OWLDeclarationAxiom)iterator.next();
                    this.processDeclaredEntities(declaration);
                }
            }
            if (ManchesterOWLSyntax.PREFIX.matches(section)) {
                Map<String, IRI> nsMap = this.parsePrefixDeclaration();
                imported = nsMap.keySet().iterator();
                while (true) {
                    if (!imported.hasNext()) continue block0;
                    String string = imported.next();
                    assert (string != null);
                    this.pm.setPrefix(string, nsMap.get(string).toString());
                }
            }
            if (!ManchesterOWLSyntax.RULE.matches(section)) break;
            axioms.addAll(this.parseRuleFrame());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(section)) {
            this.consumeToken();
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.CLASS, ManchesterOWLSyntax.OBJECT_PROPERTY, ManchesterOWLSyntax.DATA_PROPERTY, ManchesterOWLSyntax.INDIVIDUAL, ManchesterOWLSyntax.DATATYPE, ManchesterOWLSyntax.ANNOTATION_PROPERTY, ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.VALUE_PARTITION, ManchesterOWLSyntax.PREFIX, ManchesterOWLSyntax.EQUIVALENT_CLASSES, ManchesterOWLSyntax.DISJOINT_CLASSES, ManchesterOWLSyntax.DISJOINT_PROPERTIES, ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ManchesterOWLSyntax.SAME_INDIVIDUAL).build();
        }
        ArrayList<Object> changes = new ArrayList<Object>(axioms.size());
        changes.addAll(imports);
        changes.addAll(ontologyAnnotations);
        for (OntologyAxiomPair pair : axioms) {
            changes.add(new AddAxiom(ont, pair.getAxiom()));
        }
        changes.add(new SetOntologyID(ont, ontologyID));
        ont.getOWLOntologyManager().applyChanges(changes);
        ManchesterSyntaxDocumentFormat format = new ManchesterSyntaxDocumentFormat();
        format.copyPrefixesFrom((PrefixManager)this.pm);
        return format;
    }

    private ManchesterOWLSyntaxOntologyHeader parseOntologyHeader(boolean toEOF) {
        String section;
        String tok = this.consumeToken();
        if (!ManchesterOWLSyntax.ONTOLOGY.matches(tok)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ONTOLOGY).build();
        }
        IRI ontologyIRI = null;
        IRI versionIRI = null;
        if (this.peekToken().startsWith("<")) {
            ontologyIRI = this.parseIRI();
            if (this.peekToken().startsWith("<")) {
                versionIRI = this.parseIRI();
            }
        }
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        HashSet<OWLImportsDeclaration> imports = new HashSet<OWLImportsDeclaration>();
        while (true) {
            if (ManchesterOWLSyntax.IMPORT.matches(section = this.peekToken())) {
                this.consumeToken();
                tok = this.peekToken();
                Optional importedIRI = Optional.absent();
                if (tok.startsWith("<")) {
                    importedIRI = Optional.of((Object)this.parseIRI());
                } else if (this.isOntologyName(tok)) {
                    this.consumeToken();
                    OWLOntology ont = this.getOntology(tok);
                    if (ont != null) {
                        importedIRI = ont.getOntologyID().getOntologyIRI();
                    }
                } else {
                    this.consumeToken();
                    throw new ExceptionBuilder().withOnto().withKeyword("<$ONTOLOGYYURI$>").build();
                }
                if (!importedIRI.isPresent()) {
                    throw new ExceptionBuilder().withOnto().withKeyword("Imported IRI is null").build();
                }
                IRI importedOntologyIRI = (IRI)importedIRI.get();
                assert (importedOntologyIRI != null);
                imports.add(this.dataFactory.getOWLImportsDeclaration(importedOntologyIRI));
                continue;
            }
            if (!ManchesterOWLSyntax.ANNOTATIONS.matches(section)) break;
            this.consumeToken();
            annotations.addAll(this.parseAnnotationList());
        }
        if (!ManchesterOWLSyntaxTokenizer.eof(section) && toEOF) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IMPORT, ManchesterOWLSyntax.ANNOTATIONS).build();
        }
        return new ManchesterOWLSyntaxOntologyHeader(ontologyIRI, versionIRI, annotations, imports);
    }

    protected List<String> getTokenSequence() {
        ArrayList<String> seq = new ArrayList<String>();
        int index = this.tokenIndex - 1;
        if (index < 0) {
            index = 0;
        }
        while (index < this.tokens.size() && seq.size() < 4 && !seq.contains("|EOF|")) {
            seq.add(this.tokens.get(index).getToken());
            ++index;
        }
        if (seq.isEmpty()) {
            seq.add("|EOF|");
        }
        return seq;
    }

    @Nonnull
    protected IRI getIRI(@Nonnull String inputName) {
        IRI uri;
        String name = inputName;
        boolean fullIRI = name.equals("<");
        if (fullIRI) {
            name = this.consumeToken();
            this.consumeToken();
        }
        if ((uri = this.nameIRIMap.get(name)) != null) {
            return uri;
        }
        if (fullIRI) {
            uri = IRI.create((String)name);
        } else {
            int colonIndex = name.indexOf(58);
            if (colonIndex == -1) {
                name = ":" + name;
            }
            uri = this.pm.getIRI(name);
        }
        this.nameIRIMap.put(name, uri);
        return uri;
    }

    public OWLAxiom parseAxiom() {
        String token = this.peekToken();
        if (this.isClassName(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (this.isObjectPropertyName(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (this.isDataPropertyName(token)) {
            return this.parseAxiomWithDataPropertyStart();
        }
        if (this.isIndividualName(token)) {
            return this.parseAxiomWithIndividualStart();
        }
        if (ManchesterOWLSyntax.INV.matches(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (ManchesterOWLSyntax.OPEN.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.OPENBRACE.matches(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (ManchesterOWLSyntax.FUNCTIONAL.matches(token)) {
            return this.parseFunctionPropertyAxiom();
        }
        if (ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(token)) {
            return this.parseInverseFunctionalPropertyAxiom();
        }
        if (ManchesterOWLSyntax.SYMMETRIC.matches(token)) {
            return this.parseSymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.ASYMMETRIC.matches(token)) {
            return this.parseAsymmetricPropertyAxiom();
        }
        if (ManchesterOWLSyntax.TRANSITIVE.matches(token)) {
            return this.parseTransitivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.REFLEXIVE.matches(token)) {
            return this.parseReflexivePropertyAxiom();
        }
        if (ManchesterOWLSyntax.IRREFLEXIVE.matches(token)) {
            return this.parseIrreflexivePropertyAxiom();
        }
        throw new ExceptionBuilder().withClass().withObject().withData().withKeyword(ManchesterOWLSyntax.OPEN, ManchesterOWLSyntax.OPENBRACE, ManchesterOWLSyntax.INV, ManchesterOWLSyntax.FUNCTIONAL, ManchesterOWLSyntax.INVERSE_FUNCTIONAL, ManchesterOWLSyntax.SYMMETRIC, ManchesterOWLSyntax.ASYMMETRIC, ManchesterOWLSyntax.TRANSITIVE, ManchesterOWLSyntax.REFLEXIVE, ManchesterOWLSyntax.IRREFLEXIVE).build();
    }

    public OWLClassAxiom parseClassAxiom() {
        return (OWLClassAxiom)this.parseAxiom();
    }

    @Nonnull
    private OWLAxiom parseAxiomWithIndividualStart() {
        OWLIndividual ind = this.parseIndividual();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.TYPE.matches(kw)) {
            OWLClassExpression type = this.parseClassExpression();
            return this.dataFactory.getOWLClassAssertionAxiom(type, ind);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TYPE).build();
    }

    @Nonnull
    private OWLAxiom parseAxiomWithDataPropertyStart() {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf(false);
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLDataRange dataRange = this.parseDataIntersectionOf(false);
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf(true);
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLDataMinCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf(true);
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLDataMaxCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLDataRange dataRange = this.parseDataIntersectionOf(true);
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLDataExactCardinality(cardi, (OWLDataPropertyExpression)prop, dataRange));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLDataPropertyExpression superProperty = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLDataPropertyExpression equivProp = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)prop, equivProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLDataPropertyExpression disjProp = this.parseDataPropertyExpression();
            return this.dataFactory.getOWLDisjointDataPropertiesAxiom(new OWLDataPropertyExpression[]{prop, disjProp});
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLDataRange range = this.parseDataIntersectionOf(true);
            return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)prop, range);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE).build();
    }

    @Nonnull
    private OWLDataPropertyExpression parseDataPropertyExpression() {
        String tok = this.consumeToken();
        if (!this.isDataPropertyName(tok)) {
            throw new ExceptionBuilder().withData().build();
        }
        return this.getOWLDataProperty(tok);
    }

    @Nonnull
    private OWLAxiom parseAxiomWithClassExpressionStart() {
        return this.parseClassAxiomRemainder(this.parseUnion());
    }

    @Nonnull
    private OWLAxiom parseClassAxiomRemainder(@Nonnull OWLClassExpression startExpression) {
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SUBCLASS_OF.matchesEitherForm(kw)) {
            OWLClassExpression superClass = this.parseClassExpression();
            return this.dataFactory.getOWLSubClassOfAxiom(startExpression, superClass);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matchesEitherForm(kw)) {
            OWLClassExpression disjointClass = this.parseClassExpression();
            return this.dataFactory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{startExpression, disjointClass});
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matchesEitherForm(kw)) {
            OWLClassExpression equivClass = this.parseClassExpression();
            return this.dataFactory.getOWLEquivalentClassesAxiom(startExpression, equivClass);
        }
        if (ManchesterOWLSyntax.AND.matchesEitherForm(kw)) {
            OWLClassExpression conjunct = this.parseIntersection();
            Set conjuncts = conjunct.asConjunctSet();
            conjuncts.add(startExpression);
            OWLObjectIntersectionOf ce = this.dataFactory.getOWLObjectIntersectionOf(conjuncts);
            return this.parseClassAxiomRemainder((OWLClassExpression)ce);
        }
        if (ManchesterOWLSyntax.OR.matchesEitherForm(kw)) {
            OWLClassExpression disjunct = this.parseUnion();
            Set disjuncts = disjunct.asDisjunctSet();
            disjuncts.add(startExpression);
            OWLObjectUnionOf ce = this.dataFactory.getOWLObjectUnionOf(disjuncts);
            return this.parseClassAxiomRemainder((OWLClassExpression)ce);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUBCLASS_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.AND, ManchesterOWLSyntax.OR).build();
    }

    @Nonnull
    private OWLAxiom parseAxiomWithObjectPropertyStart() {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        String kw = this.consumeToken();
        if (ManchesterOWLSyntax.SOME.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.ONLY.matches(kw)) {
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
        }
        if (ManchesterOWLSyntax.MIN.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLObjectMinCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.MAX.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLObjectMaxCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.EXACTLY.matches(kw)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseUnion();
            return this.parseClassAxiomRemainder((OWLClassExpression)this.dataFactory.getOWLObjectExactCardinality(cardi, prop, filler));
        }
        if (ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(kw)) {
            OWLObjectPropertyExpression superProperty = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLSubObjectPropertyOfAxiom(prop, superProperty);
        }
        if (ManchesterOWLSyntax.EQUIVALENT_TO.matches(kw)) {
            OWLObjectPropertyExpression equivProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(prop, equivProp);
        }
        if (ManchesterOWLSyntax.INVERSE_OF.matches(kw)) {
            OWLObjectPropertyExpression invProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, invProp);
        }
        if (ManchesterOWLSyntax.DISJOINT_WITH.matches(kw)) {
            OWLObjectPropertyExpression disjProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLDisjointObjectPropertiesAxiom(new OWLObjectPropertyExpression[]{prop, disjProp});
        }
        if (ManchesterOWLSyntax.DOMAIN.matches(kw)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, domain);
        }
        if (ManchesterOWLSyntax.RANGE.matches(kw)) {
            OWLClassExpression range = this.parseClassExpression();
            return this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, range);
        }
        if (ManchesterOWLSyntax.CHAIN_CONNECT.matches(kw)) {
            String sep = kw;
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(prop);
            while (sep.equals("o")) {
                OWLObjectPropertyExpression chainProp = this.parseObjectPropertyExpression(false);
                chain.add(chainProp);
                sep = this.consumeToken();
            }
            if (!ManchesterOWLSyntax.SUB_PROPERTY_OF.matches(sep)) {
                throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF).build();
            }
            OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLSubPropertyChainOfAxiom(chain, superProp);
        }
        throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SOME, ManchesterOWLSyntax.ONLY, ManchesterOWLSyntax.MIN, ManchesterOWLSyntax.MAX, ManchesterOWLSyntax.EXACTLY, ManchesterOWLSyntax.SUB_PROPERTY_OF, ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.INVERSE_OF, ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DOMAIN, ManchesterOWLSyntax.RANGE, ManchesterOWLSyntax.CHAIN_CONNECT).build();
    }

    @Nonnull
    private OWLAxiom parseInverseFunctionalPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.INVERSE_FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.INVERSE_FUNCTIONAL).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseSymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.SYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.SYMMETRIC).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseAsymmetricPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.ASYMMETRIC.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.ASYMMETRIC).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseTransitivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.TRANSITIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.TRANSITIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseReflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.REFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.REFLEXIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseIrreflexivePropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.IRREFLEXIVE.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.IRREFLEXIVE).build();
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
        return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
    }

    @Nonnull
    private OWLAxiom parseFunctionPropertyAxiom() {
        String kw = this.consumeToken();
        if (!ManchesterOWLSyntax.FUNCTIONAL.matches(kw)) {
            throw new ExceptionBuilder().withKeyword(ManchesterOWLSyntax.FUNCTIONAL).build();
        }
        String name = this.peekToken();
        if (this.isObjectPropertyName(name)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression(false);
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (this.isDataPropertyName(name)) {
            OWLDataProperty prop = this.parseDataProperty();
            return this.dataFactory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)prop);
        }
        this.consumeToken();
        throw new ExceptionBuilder().withObject().withData().build();
    }

    @Nonnull
    private <F, O> Set<OntologyAxiomPair> parseAnnotatedListItems(@Nonnull F s, @Nonnull AnnotatedListItemParser<F, O> itemParser, @Nonnull Set<OWLOntology> ontologies) {
        HashSet<OntologyAxiomPair> result = new HashSet<OntologyAxiomPair>();
        String sep = ManchesterOWLSyntax.COMMA.keyword();
        while (ManchesterOWLSyntax.COMMA.matches(sep)) {
            Set<OWLAnnotation> annotations = this.parseAnnotations();
            O item = itemParser.parseItem(s);
            OWLAxiom axiom = itemParser.createAxiom(s, item, annotations);
            for (OWLOntology ontology : ontologies) {
                result.add(new OntologyAxiomPair(ontology, axiom));
            }
            sep = this.peekToken();
            if (!ManchesterOWLSyntax.COMMA.matches(sep)) continue;
            this.consumeToken();
        }
        return result;
    }

    class AnnotationPropertyRangeListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        AnnotationPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, IRI o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationPropertyRangeAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    class AnnotationPropertyDomainListItemParser
    extends AnnotatedIRIListItemParser<OWLAnnotationProperty> {
        AnnotationPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, IRI o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationPropertyDomainAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class AnnotationPropertySubPropertyOfListItemParser
    implements AnnotatedListItemParser<OWLAnnotationProperty, OWLAnnotationProperty> {
        AnnotationPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAnnotationProperty parseItem(OWLAnnotationProperty s) {
            return ManchesterOWLSyntaxParserImpl.this.parseAnnotationProperty();
        }

        @Override
        public OWLAxiom createAxiom(OWLAnnotationProperty s, OWLAnnotationProperty o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class AnnotatedIRIListItemParser<F>
    implements AnnotatedListItemParser<F, IRI> {
        AnnotatedIRIListItemParser() {
        }

        @Override
        public IRI parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseIRI();
        }
    }

    class IndividualAnnotationItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLAnnotation> {
        IndividualAnnotationItemParser() {
        }

        @Override
        public OWLAnnotation parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxParserImpl.this.parseAnnotation();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLAnnotation o, Set<OWLAnnotation> anns) {
            if (s.isAnonymous()) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.asOWLAnonymousIndividual(), o, anns);
            }
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.asOWLNamedIndividual().getIRI(), o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.ANNOTATIONS;
        }
    }

    class IndividualDifferentIndividualsItemParser
    implements AnnotatedListItemParser<OWLIndividual, Set<OWLIndividual>> {
        IndividualDifferentIndividualsItemParser() {
        }

        @Override
        public Set<OWLIndividual> parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxParserImpl.this.parseIndividualList();
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, Set<OWLIndividual> o, Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.addAll(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS;
        }
    }

    class IndividualDifferentFromItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        IndividualDifferentFromItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLIndividual o, Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.add(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDifferentIndividualsAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DIFFERENT_FROM;
        }
    }

    class IndividualSameAsItemParser
    extends AnnotatedIndividualsListItemParser<OWLIndividual> {
        IndividualSameAsItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLIndividual o, @Nonnull Set<OWLAnnotation> anns) {
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            individuals.add(s);
            individuals.add(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSameIndividualAxiom(individuals, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SAME_AS;
        }
    }

    class IndividualFactsItemParser
    implements AnnotatedListItemParser<OWLIndividual, OWLPropertyAssertionAxiom<?, ?>> {
        IndividualFactsItemParser() {
        }

        @Override
        public OWLPropertyAssertionAxiom<?, ?> parseItem(OWLIndividual s) {
            return ManchesterOWLSyntaxParserImpl.this.parseFact(s);
        }

        @Override
        public OWLAxiom createAxiom(@Nonnull OWLIndividual s, OWLPropertyAssertionAxiom<?, ?> o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.FACTS;
        }
    }

    class IndividualTypesItemParser
    extends AnnotatedClassExpressionListItemParser<OWLIndividual> {
        IndividualTypesItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLIndividual s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLClassAssertionAxiom(o, s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.TYPES;
        }
    }

    class DataPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLDataProperty, OWLDataPropertyCharacteristicAxiom> {
        DataPropertyCharacteristicsItemParser() {
        }

        @Override
        public OWLDataPropertyCharacteristicAxiom parseItem(OWLDataProperty s) {
            return ManchesterOWLSyntaxParserImpl.this.parseDataPropertyCharacteristic((OWLDataPropertyExpression)s);
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyCharacteristicAxiom o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.CHARACTERISTICS;
        }
    }

    class DataPropertyRangeListItemParser
    extends AnnotatedDataRangeListItemParser<OWLDataProperty> {
        DataPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataRange o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    abstract class AnnotatedDataRangeListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataRange> {
        AnnotatedDataRangeListItemParser() {
        }

        @Override
        public OWLDataRange parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseDataIntersectionOf(false);
        }
    }

    class DataPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLDataProperty> {
        DataPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class DataPropertyDisjointWithListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertyDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            HashSet<Object> properties = new HashSet<Object>();
            properties.add(s);
            properties.add(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDisjointDataPropertiesAxiom(properties, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class DataPropertyEquivalentToListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertyEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class DataPropertySubPropertyOfListItemParser
    extends DataPropertyExpressionListItemParser<OWLDataProperty> {
        DataPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLDataProperty s, OWLDataPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class DataPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLDataPropertyExpression> {
        DataPropertyExpressionListItemParser() {
        }

        @Override
        public OWLDataProperty parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseDataProperty();
        }
    }

    class ObjectPropertyCharacteristicsItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, OWLObjectPropertyCharacteristicAxiom> {
        ObjectPropertyCharacteristicsItemParser() {
        }

        @Override
        public OWLObjectPropertyCharacteristicAxiom parseItem(@Nonnull OWLObjectProperty s) {
            return ManchesterOWLSyntaxParserImpl.this.parseObjectPropertyCharacteristic((OWLObjectPropertyExpression)s);
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyCharacteristicAxiom o, Set<OWLAnnotation> anns) {
            return o.getAnnotatedAxiom(anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.CHARACTERISTICS;
        }
    }

    class ObjectPropertySubPropertyChainListItemParser
    implements AnnotatedListItemParser<OWLObjectProperty, List<OWLObjectPropertyExpression>> {
        ObjectPropertySubPropertyChainListItemParser() {
        }

        @Override
        public List<OWLObjectPropertyExpression> parseItem(OWLObjectProperty s) {
            return ManchesterOWLSyntaxParserImpl.this.parseObjectPropertyChain();
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, List<OWLObjectPropertyExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubPropertyChainOfAxiom(o, (OWLObjectPropertyExpression)s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_CHAIN;
        }
    }

    class ObjectPropertyInverseOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyInverseOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.INVERSE_OF;
        }
    }

    class ObjectPropertyRangeListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyRangeListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.RANGE;
        }
    }

    class ObjectPropertyDomainListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyDomainListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DOMAIN;
        }
    }

    class ObjectPropertyDisjointWithListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            HashSet<Object> properties = new HashSet<Object>();
            properties.add(s);
            properties.add(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDisjointObjectPropertiesAxiom(properties, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class ObjectPropertyEquivalentToListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertyEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class ObjectPropertySuperPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertySuperPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubObjectPropertyOfAxiom(o, (OWLObjectPropertyExpression)s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUPER_PROPERTY_OF;
        }
    }

    class ObjectPropertySubPropertyOfListItemParser
    extends ObjectPropertyExpressionListItemParser<OWLObjectProperty> {
        ObjectPropertySubPropertyOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLObjectProperty s, OWLObjectPropertyExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUB_PROPERTY_OF;
        }
    }

    abstract class ObjectPropertyExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLObjectPropertyExpression> {
        ObjectPropertyExpressionListItemParser() {
        }

        @Override
        public OWLObjectPropertyExpression parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseObjectPropertyExpression(false);
        }
    }

    class EntityAnnotationsListItemParser<E extends OWLEntity>
    extends AnnotationListItemParser<E> {
        EntityAnnotationsListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(E s, OWLAnnotation o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)s.getIRI(), o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.ANNOTATIONS;
        }
    }

    class ClassIndividualsListItemParser
    extends AnnotatedIndividualsListItemParser<OWLClass> {
        ClassIndividualsListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLIndividual o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.INDIVIDUALS;
        }
    }

    class ClassSuperClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassSuperClassOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubClassOfAxiom(o, (OWLClassExpression)s, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUPERCLASS_OF;
        }
    }

    class ClassHasKeyListItemParser
    extends AnnotatedPropertyListListItemParser<OWLClass> {
        ClassHasKeyListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLPropertyExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLHasKeyAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.HAS_KEY;
        }
    }

    class ClassDisjointUnionOfListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        ClassDisjointUnionOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLClassExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDisjointUnionAxiom(s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_UNION_OF;
        }
    }

    class ClassDisjointClassesListItemParser
    extends AnnotatedClassExpressionSetListItemParser<OWLClass> {
        ClassDisjointClassesListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, Set<OWLClassExpression> o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDisjointClassesAxiom(o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_CLASSES;
        }
    }

    class ClassDisjointWithListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassDisjointWithListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            HashSet<Object> disjointClasses = new HashSet<Object>();
            disjointClasses.add(s);
            disjointClasses.add(o);
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDisjointClassesAxiom(disjointClasses, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.DISJOINT_WITH;
        }
    }

    class ClassEquivalentToListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassEquivalentToListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.EQUIVALENT_TO;
        }
    }

    class ClassSubClassOfListItemParser
    extends AnnotatedClassExpressionListItemParser<OWLClass> {
        ClassSubClassOfListItemParser() {
        }

        @Override
        public OWLAxiom createAxiom(OWLClass s, OWLClassExpression o, Set<OWLAnnotation> anns) {
            return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)s, o, anns);
        }

        @Override
        public ManchesterOWLSyntax getFrameSectionKeyword() {
            return ManchesterOWLSyntax.SUBCLASS_OF;
        }
    }

    abstract class AnnotationListItemParser<F>
    implements AnnotatedListItemParser<F, OWLAnnotation> {
        AnnotationListItemParser() {
        }

        @Override
        public OWLAnnotation parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseAnnotation();
        }
    }

    abstract class AnnotatedIndividualsListItemParser<F>
    implements AnnotatedListItemParser<F, OWLIndividual> {
        AnnotatedIndividualsListItemParser() {
        }

        @Override
        public OWLIndividual parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseIndividual();
        }
    }

    abstract class AnnotatedPropertyListListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLPropertyExpression>> {
        AnnotatedPropertyListListItemParser() {
        }

        @Override
        public Set<OWLPropertyExpression> parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parsePropertyList();
        }
    }

    abstract class AnnotatedClassExpressionSetListItemParser<F>
    implements AnnotatedListItemParser<F, Set<OWLClassExpression>> {
        AnnotatedClassExpressionSetListItemParser() {
        }

        @Override
        public Set<OWLClassExpression> parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseClassExpressionList();
        }
    }

    abstract class AnnotatedClassExpressionListItemParser<F>
    implements AnnotatedListItemParser<F, OWLClassExpression> {
        AnnotatedClassExpressionListItemParser() {
        }

        @Override
        public OWLClassExpression parseItem(F s) {
            return ManchesterOWLSyntaxParserImpl.this.parseUnion();
        }
    }

    static interface AnnotatedListItemParser<F, O> {
        @Nonnull
        public O parseItem(@Nonnull F var1);

        @Nonnull
        public OWLAxiom createAxiom(@Nonnull F var1, @Nonnull O var2, @Nonnull Set<OWLAnnotation> var3);

        public ManchesterOWLSyntax getFrameSectionKeyword();
    }

    class DefaultEntityChecker
    implements OWLEntityChecker {
        DefaultEntityChecker() {
        }

        public OWLClass getOWLClass(String name) {
            if (name.equals("Thing") || name.equals("owl:Thing")) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLThing();
            }
            if (name.equals("Nothing") || name.equals("owl:Nothing")) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLNothing();
            }
            if (ManchesterOWLSyntaxParserImpl.this.classNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLClass(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        public OWLNamedIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLNamedIndividual(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        public OWLDatatype getOWLDatatype(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.dataTypeNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLDatatype(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            if (ManchesterOWLSyntaxParserImpl.this.annotationPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxParserImpl.this.dataFactory.getOWLAnnotationProperty(ManchesterOWLSyntaxParserImpl.this.getIRI(name));
            }
            return null;
        }
    }

    protected class ExceptionBuilder {
        boolean ontologyNameExpected = false;
        boolean classNameExpected = false;
        boolean objectPropertyNameExpected = false;
        boolean dataPropertyNameExpected = false;
        boolean individualNameExpected = false;
        boolean datatypeNameExpected = false;
        boolean annotationPropertyNameExpected = false;
        boolean integerExpected = false;
        Set<String> keywords = new HashSet<String>();
        List<String> tokenSequence;
        int start = -1;
        int line = -1;
        int column = -1;

        ExceptionBuilder() {
            this.withKeyword(ManchesterOWLSyntaxParserImpl.this.potentialKeywords);
        }

        ExceptionBuilder(ParserException e) {
            this.ontologyNameExpected = e.isOntologyNameExpected();
            this.classNameExpected = e.isClassNameExpected();
            this.objectPropertyNameExpected = e.isObjectPropertyNameExpected();
            this.dataPropertyNameExpected = e.isDataPropertyNameExpected();
            this.individualNameExpected = e.isIndividualNameExpected();
            this.dataPropertyNameExpected = e.isDatatypeNameExpected();
            this.annotationPropertyNameExpected = e.isAnnotationPropertyNameExpected();
            this.integerExpected = e.isIntegerExpected();
            this.withKeyword(e.getExpectedKeywords());
            this.tokenSequence = e.getTokenSequence();
            this.start = e.getStartPos();
            this.line = e.getLineNumber();
            this.column = e.getColumnNumber();
        }

        public ExceptionBuilder withOnto() {
            this.ontologyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInt() {
            this.integerExpected = true;
            return this;
        }

        public ExceptionBuilder withClass() {
            this.classNameExpected = true;
            return this;
        }

        public ExceptionBuilder withObject() {
            this.objectPropertyNameExpected = true;
            this.withKeyword(ManchesterOWLSyntax.INVERSE);
            return this;
        }

        public ExceptionBuilder withData() {
            this.dataPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withInd() {
            this.individualNameExpected = true;
            return this;
        }

        public ExceptionBuilder withDt() {
            this.datatypeNameExpected = true;
            return this;
        }

        public ExceptionBuilder withAnn() {
            this.annotationPropertyNameExpected = true;
            return this;
        }

        public ExceptionBuilder withKeyword(String s) {
            this.keywords.add(s);
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax s) {
            this.keywords.add(s.keyword());
            return this;
        }

        public ExceptionBuilder withKeyword(String ... strings) {
            for (String s : strings) {
                this.keywords.add(s);
            }
            return this;
        }

        public ExceptionBuilder withKeyword(ManchesterOWLSyntax ... keys) {
            for (ManchesterOWLSyntax s : keys) {
                this.keywords.add(s.keyword());
            }
            return this;
        }

        public <T> ExceptionBuilder withKeyword(Collection<T> keys) {
            for (T s : keys) {
                if (s instanceof String) {
                    this.withKeyword((String)s);
                }
                if (!(s instanceof ManchesterOWLSyntax)) continue;
                this.withKeyword((ManchesterOWLSyntax)((Object)s));
            }
            return this;
        }

        public ParserException build() {
            if (this.tokenSequence == null) {
                ManchesterOWLSyntaxTokenizer.Token lastToken = ManchesterOWLSyntaxParserImpl.this.getLastToken();
                this.tokenSequence = ManchesterOWLSyntaxParserImpl.this.getTokenSequence();
                this.start = lastToken.getPos();
                this.line = lastToken.getRow();
                this.column = lastToken.getCol();
            }
            return new ParserException(this.tokenSequence, this.start, this.line, this.column, this.ontologyNameExpected, this.classNameExpected, this.objectPropertyNameExpected, this.dataPropertyNameExpected, this.individualNameExpected, this.datatypeNameExpected, this.annotationPropertyNameExpected, this.integerExpected, this.keywords);
        }
    }
}

