/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.renderer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class FunctionalSyntaxObjectRenderer
implements OWLObjectVisitor {
    @Nonnull
    private DefaultPrefixManager defaultPrefixManager = new DefaultPrefixManager();
    private PrefixManager prefixManager;
    protected final OWLOntology ont;
    private final Writer writer;
    private boolean writeEntitiesAsURIs = true;
    private OWLObject focusedObject;
    private boolean addMissingDeclarations = true;
    protected AnnotationValueShortFormProvider labelMaker = null;

    public FunctionalSyntaxObjectRenderer(@Nonnull OWLOntology ontology, Writer writer) {
        this.ont = ontology;
        this.writer = writer;
        this.prefixManager = this.defaultPrefixManager;
        OWLDocumentFormat ontologyFormat = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
        if (ontologyFormat != null) {
            this.addMissingDeclarations = ontologyFormat.isAddMissingTypes();
        }
        if (ontologyFormat instanceof PrefixDocumentFormat) {
            this.prefixManager.copyPrefixesFrom((PrefixManager)((PrefixDocumentFormat)ontologyFormat));
            this.prefixManager.setPrefixComparator(((PrefixDocumentFormat)ontologyFormat).getPrefixComparator());
        }
        if (!ontology.isAnonymous() && this.prefixManager.getDefaultPrefix() == null) {
            String existingDefault = this.prefixManager.getDefaultPrefix();
            String ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (existingDefault == null || !existingDefault.startsWith(ontologyIRIString)) {
                String defaultPrefix = ontologyIRIString;
                if (!ontologyIRIString.endsWith("/") && !ontologyIRIString.endsWith("#")) {
                    defaultPrefix = ontologyIRIString + '#';
                }
                this.prefixManager.setDefaultPrefix(defaultPrefix);
            }
        }
        HashMap prefLangMap = new HashMap();
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        OWLDataFactory df = manager.getOWLDataFactory();
        OWLAnnotationProperty labelProp = df.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.labelMaker = new AnnotationValueShortFormProvider(Collections.singletonList(labelProp), prefLangMap, (OWLOntologySetProvider)manager, (ShortFormProvider)this.defaultPrefixManager);
        this.focusedObject = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing();
    }

    public void setAddMissingDeclarations(boolean flag) {
        this.addMissingDeclarations = flag;
    }

    public void setPrefixManager(PrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        if (prefixManager instanceof DefaultPrefixManager) {
            this.defaultPrefixManager = (DefaultPrefixManager)prefixManager;
        }
    }

    protected void setFocusedObject(OWLObject focusedObject) {
        this.focusedObject = focusedObject;
    }

    protected void writePrefix(@Nonnull String prefix, @Nonnull String namespace) {
        this.write("Prefix");
        this.writeOpenBracket();
        this.write(prefix);
        this.write("=");
        this.write("<");
        this.write(namespace);
        this.write(">");
        this.writeCloseBracket();
        this.writeReturn();
    }

    protected void writePrefixes() {
        for (Map.Entry e : this.prefixManager.getPrefixName2PrefixMap().entrySet()) {
            this.writePrefix((String)e.getKey(), (String)e.getValue());
        }
    }

    private void write(@Nonnull OWLXMLVocabulary v) {
        this.write(v.getShortForm());
    }

    private void write(@Nonnull String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(@Nonnull IRI iri) {
        String qname = this.prefixManager.getPrefixIRIIgnoreQName(iri);
        if (qname != null) {
            boolean lastCharIsColon;
            boolean bl = lastCharIsColon = qname.charAt(qname.length() - 1) == ':';
            if (!lastCharIsColon) {
                this.write(qname);
                return;
            }
        }
        this.writeFullIRI(iri);
    }

    private void writeFullIRI(@Nonnull IRI iri) {
        this.write("<");
        this.write(iri.toString());
        this.write(">");
    }

    public void visit(@Nonnull OWLOntology ontology) {
        this.writePrefixes();
        this.writeReturn();
        this.writeReturn();
        this.write(OWLXMLVocabulary.ONTOLOGY);
        this.writeOpenBracket();
        if (!ontology.isAnonymous()) {
            this.writeFullIRI((IRI)ontology.getOntologyID().getOntologyIRI().get());
            Optional versionIRI = ontology.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeReturn();
                this.writeFullIRI((IRI)versionIRI.get());
            }
            this.writeReturn();
        }
        ontology.getImportsDeclarations().stream().sorted().forEach(decl -> {
            this.write(OWLXMLVocabulary.IMPORT);
            this.writeOpenBracket();
            this.writeFullIRI(decl.getIRI());
            this.writeCloseBracket();
            this.writeReturn();
        });
        for (OWLAnnotation ontologyAnnotation : FunctionalSyntaxObjectRenderer.getSortedAnnotations((HasAnnotations)ontology)) {
            ontologyAnnotation.accept((OWLObjectVisitor)this);
            this.writeReturn();
        }
        this.writeReturn();
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        Collection illegals = OWLDocumentFormatImpl.determineIllegalPunnings((boolean)this.addMissingDeclarations, (Collection)ontology.getSignature(), (Collection)this.ont.getPunnedIRIs(Imports.INCLUDED));
        for (OWLEntity ent : CollectionFactory.sortOptionally((Collection)ontology.getSignature())) {
            this.writeDeclarations(ent, writtenAxioms, illegals);
        }
        this.writeSortedEntities("Annotation Properties", "Annotation Property", ontology.getAnnotationPropertiesInSignature(Imports.EXCLUDED), writtenAxioms);
        this.writeSortedEntities("Object Properties", "Object Property", ontology.getObjectPropertiesInSignature(), writtenAxioms);
        this.writeSortedEntities("Data Properties", "Data Property", ontology.getDataPropertiesInSignature(), writtenAxioms);
        this.writeSortedEntities("Datatypes", "Datatype", ontology.getDatatypesInSignature(), writtenAxioms);
        this.writeSortedEntities("Classes", "Class", ontology.getClassesInSignature(), writtenAxioms);
        this.writeSortedEntities("Named Individuals", "Individual", ontology.getIndividualsInSignature(), writtenAxioms);
        Set otherAxioms = ontology.getAxioms();
        otherAxioms.removeAll(writtenAxioms);
        for (OWLAxiom ax : CollectionFactory.sortOptionally((Collection)otherAxioms)) {
            ax.accept((OWLObjectVisitor)this);
            this.writeReturn();
        }
        this.writeCloseBracket();
        this.flush();
    }

    private void writeSortedEntities(String bannerComment, String entityTypeName, Set<? extends OWLEntity> entities, Set<OWLAxiom> writtenAxioms) {
        if (entities.size() > 0) {
            this.writeEntities(bannerComment, entityTypeName, CollectionFactory.sortOptionally(entities), writtenAxioms);
            this.writeln();
        }
    }

    private void writeln() {
        this.writeReturn();
    }

    private void writeln(@Nonnull String s) {
        this.write(s);
        this.writeReturn();
    }

    private void writeEntities(String comment, String entityTypeName, List<? extends OWLEntity> entities, @Nonnull Set<OWLAxiom> writtenAxioms) {
        boolean haveWrittenBanner = false;
        for (OWLEntity oWLEntity : entities) {
            Set<? extends OWLAxiom> axiomsForEntity = this.getUnsortedAxiomsForEntity(oWLEntity);
            Iterator<? extends OWLAxiom> iterator = axiomsForEntity.iterator();
            while (iterator.hasNext()) {
                OWLAxiom axiom = iterator.next();
                if (!writtenAxioms.contains(axiom)) continue;
                iterator.remove();
            }
            Set annotationAssertionAxioms = this.ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)oWLEntity.getIRI());
            Iterator iterator2 = annotationAssertionAxioms.iterator();
            while (iterator2.hasNext()) {
                OWLAnnotationAssertionAxiom axiom = (OWLAnnotationAssertionAxiom)iterator2.next();
                if (!writtenAxioms.contains(axiom)) continue;
                iterator2.remove();
            }
            if (axiomsForEntity.size() == 0 && annotationAssertionAxioms.size() == 0) continue;
            if (!haveWrittenBanner) {
                this.writeln("############################");
                this.writeln("#   " + comment);
                this.writeln("############################");
                this.writeln();
                haveWrittenBanner = true;
            }
            this.writeEntity2(oWLEntity, entityTypeName, this.sortAxioms(axiomsForEntity), CollectionFactory.sortOptionally((Collection)annotationAssertionAxioms), writtenAxioms);
        }
    }

    @Nonnull
    private static List<OWLAnnotation> getSortedAnnotations(HasAnnotations annotationBearer) {
        return CollectionFactory.sortOptionally((Collection)annotationBearer.getAnnotations());
    }

    @Nonnull
    protected Set<OWLAxiom> writeEntity(@Nonnull OWLEntity entity) {
        HashSet<OWLAxiom> writtenAxioms = new HashSet<OWLAxiom>();
        this.writeEntity(entity, writtenAxioms);
        return writtenAxioms;
    }

    protected void writeEntity(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeEntity2(entity, "", this.sortAxioms(this.getUnsortedAxiomsForEntity(entity)), CollectionFactory.sortOptionally((Collection)this.ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI())), alreadyWrittenAxioms);
    }

    protected void writeEntity2(@Nonnull OWLEntity entity, String entityTypeName, @Nonnull List<? extends OWLAxiom> axiomsForEntity, @Nonnull List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        this.writeln("# " + entityTypeName + ": " + this.getIRIString(entity) + " (" + this.getEntityLabel(entity) + ")");
        this.writeln();
        this.setFocusedObject((OWLObject)entity);
        this.writeAnnotations2(entity, alreadyWrittenAxioms, annotationAssertionAxioms);
        List<? extends OWLAxiom> axs = axiomsForEntity;
        for (OWLAxiom oWLAxiom : axs) {
            if (oWLAxiom.getAxiomType().equals((Object)AxiomType.DIFFERENT_INDIVIDUALS) || oWLAxiom.getAxiomType().equals((Object)AxiomType.DISJOINT_CLASSES) && ((OWLDisjointClassesAxiom)oWLAxiom).getClassExpressions().size() > 2) continue;
            oWLAxiom.accept((OWLObjectVisitor)this);
            alreadyWrittenAxioms.add(oWLAxiom);
            this.writeReturn();
        }
        this.writeln();
    }

    @Nonnull
    private Set<? extends OWLAxiom> getUnsortedAxiomsForEntity(@Nonnull OWLEntity entity) {
        return (Set)entity.accept((OWLEntityVisitorEx)new OWLEntityVisitorEx<Set<? extends OWLAxiom>>(){

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLClass cls) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(cls, Imports.EXCLUDED);
            }

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLObjectProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED);
            }

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLDataProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(property, Imports.EXCLUDED);
            }

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLNamedIndividual individual) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms((OWLIndividual)individual, Imports.EXCLUDED);
            }

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLDatatype datatype) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(datatype, Imports.EXCLUDED);
            }

            @Nonnull
            public Set<? extends OWLAxiom> visit(@Nonnull OWLAnnotationProperty property) {
                return FunctionalSyntaxObjectRenderer.this.ont.getAxioms(property, Imports.EXCLUDED);
            }
        });
    }

    @Nonnull
    protected List<? extends OWLAxiom> sortAxioms(@Nonnull Set<? extends OWLAxiom> axioms) {
        return CollectionFactory.sortOptionally(axioms);
    }

    @Nonnull
    private String getIRIString(@Nonnull OWLEntity entity) {
        return this.defaultPrefixManager.getShortForm(entity);
    }

    private String getEntityLabel(@Nonnull OWLEntity entity) {
        return this.labelMaker.getShortForm(entity).replace("\n", "\n# ");
    }

    @Nonnull
    protected Set<OWLAxiom> writeDeclarations(@Nonnull OWLEntity entity) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        Set declarationAxioms = this.ont.getDeclarationAxioms(entity);
        for (OWLAxiom ax : CollectionFactory.sortOptionally((Collection)declarationAxioms)) {
            ax.accept((OWLObjectVisitor)this);
            axioms.add(ax);
            this.writeReturn();
        }
        return axioms;
    }

    private void writeDeclarations(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms, Collection<IRI> illegals) {
        Set axioms = this.ont.getDeclarationAxioms(entity);
        for (OWLDeclarationAxiom ax : CollectionFactory.sortOptionally((Collection)axioms)) {
            if (alreadyWrittenAxioms.contains(ax)) continue;
            ax.accept((OWLObjectVisitor)this);
            this.writeReturn();
        }
        if (this.addMissingDeclarations && axioms.isEmpty() && !entity.isBuiltIn() && !illegals.contains(entity.getIRI()) && !this.ont.isDeclared(entity, Imports.INCLUDED)) {
            OWLDeclarationAxiom declaration = this.ont.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity);
            declaration.accept((OWLObjectVisitor)this);
            this.writeReturn();
        }
        alreadyWrittenAxioms.addAll(axioms);
    }

    protected void writeAnnotations(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms) {
        List annotationAssertionAxioms = CollectionFactory.sortOptionally((Collection)this.ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)entity.getIRI()));
        this.writeAnnotations2(entity, alreadyWrittenAxioms, annotationAssertionAxioms);
    }

    protected void writeAnnotations2(@Nonnull OWLEntity entity, @Nonnull Set<OWLAxiom> alreadyWrittenAxioms, List<OWLAnnotationAssertionAxiom> annotationAssertionAxioms) {
        for (OWLAnnotationAxiom oWLAnnotationAxiom : annotationAssertionAxioms) {
            oWLAnnotationAxiom.accept((OWLObjectVisitor)this);
            this.writeReturn();
        }
        alreadyWrittenAxioms.addAll(annotationAssertionAxioms);
    }

    protected void write(@Nonnull OWLXMLVocabulary v, @Nonnull OWLObject o) {
        this.write(v);
        this.writeOpenBracket();
        o.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    private void write(@Nonnull Collection<? extends OWLObject> objects) {
        if (objects.size() > 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.writeSpace();
            }
        } else if (objects.size() == 2) {
            OWLObject rhs;
            OWLObject lhs;
            Iterator<? extends OWLObject> it = objects.iterator();
            OWLObject objA = it.next();
            OWLObject objB = it.next();
            if (objA.equals(this.focusedObject)) {
                lhs = objA;
                rhs = objB;
            } else {
                lhs = objB;
                rhs = objA;
            }
            lhs.accept((OWLObjectVisitor)this);
            this.writeSpace();
            rhs.accept((OWLObjectVisitor)this);
        } else if (objects.size() == 1) {
            objects.iterator().next().accept((OWLObjectVisitor)this);
        }
    }

    private void write(@Nonnull List<? extends OWLObject> objects) {
        if (objects.size() > 1) {
            Iterator<? extends OWLObject> it = objects.iterator();
            while (it.hasNext()) {
                it.next().accept((OWLObjectVisitor)this);
                if (!it.hasNext()) continue;
                this.writeSpace();
            }
        } else if (objects.size() == 1) {
            objects.iterator().next().accept((OWLObjectVisitor)this);
        }
    }

    protected void writeOpenBracket() {
        this.write("(");
    }

    protected void writeCloseBracket() {
        this.write(")");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void writeReturn() {
        this.write("\n");
    }

    protected void writeAnnotations(@Nonnull OWLAxiom ax) {
        for (OWLAnnotation anno : FunctionalSyntaxObjectRenderer.getSortedAnnotations((HasAnnotations)ax)) {
            anno.accept((OWLObjectVisitor)this);
            this.writeSpace();
        }
    }

    protected void writeAxiomStart(@Nonnull OWLXMLVocabulary v, @Nonnull OWLAxiom axiom) {
        this.write(v);
        this.writeOpenBracket();
        this.writeAnnotations(axiom);
    }

    protected void writeAxiomEnd() {
        this.writeCloseBracket();
    }

    protected void writePropertyCharacteristic(@Nonnull OWLXMLVocabulary v, @Nonnull OWLAxiom ax, @Nonnull OWLPropertyExpression prop) {
        this.writeAxiomStart(v, ax);
        prop.accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.CLASS_ASSERTION, (OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATA_PROPERTY_RANGE, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDeclarationAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DECLARATION, (OWLAxiom)axiom);
        this.writeEntitiesAsURIs = false;
        axiom.getEntity().accept((OWLObjectVisitor)this);
        this.writeEntitiesAsURIs = true;
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        Set individuals = axiom.getIndividuals();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS, (OWLAxiom)axiom);
        this.write(CollectionFactory.sortOptionally((Collection)individuals));
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        Set classExpressions = axiom.getClassExpressions();
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_CLASSES, (OWLAxiom)axiom);
        this.write(CollectionFactory.sortOptionally((Collection)classExpressions));
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES, (OWLAxiom)axiom);
        this.write(CollectionFactory.sortOptionally((Collection)properties));
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        this.write(CollectionFactory.sortOptionally((Collection)properties));
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DISJOINT_UNION, (OWLAxiom)axiom);
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        Set classExpressions = axiom.getClassExpressions();
        List expressionList = CollectionFactory.sortOptionally((Collection)classExpressions);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_ASSERTION, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getValue().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        Set classExpressions = axiom.getClassExpressions();
        if (classExpressions.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_CLASSES, (OWLAxiom)axiom);
        List expressionList = CollectionFactory.sortOptionally((Collection)classExpressions);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES, (OWLAxiom)axiom);
        List expressionList = CollectionFactory.sortOptionally((Collection)properties);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        Set properties = axiom.getProperties();
        if (properties.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        List expressionList = CollectionFactory.sortOptionally((Collection)properties);
        this.write(expressionList);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES, (OWLAxiom)axiom);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        this.writeOpenBracket();
        Iterator it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF, (OWLAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        Set individuals = axiom.getIndividuals();
        if (individuals.size() < 2) {
            return;
        }
        this.writeAxiomStart(OWLXMLVocabulary.SAME_INDIVIDUAL, (OWLAxiom)axiom);
        this.write(individuals);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_CLASS_OF, (OWLAxiom)axiom);
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY, (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLClass ce) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.CLASS);
            this.writeOpenBracket();
        }
        ce.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    private <F extends OWLPropertyRange> void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLCardinalityRestriction<F> restriction, @Nonnull OWLPropertyExpression p) {
        this.write(v);
        this.writeOpenBracket();
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        p.accept((OWLObjectVisitor)this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(v, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(v, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(@Nonnull OWLXMLVocabulary v, @Nonnull OWLPropertyExpression prop, @Nonnull OWLObject filler) {
        this.write(v);
        this.writeOpenBracket();
        prop.accept((OWLObjectVisitor)this);
        this.writeSpace();
        filler.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_ALL_VALUES_FROM, (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(@Nonnull OWLDataExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_EXACT_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MAX_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLDataMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_MIN_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_SOME_VALUES_FROM, (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(@Nonnull OWLDataHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.DATA_HAS_VALUE, (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM, (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF, (OWLObject)ce.getOperand());
    }

    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        if (ce.getOperands().size() == 1) {
            ((OWLClassExpression)ce.getOperands().iterator().next()).accept((OWLObjectVisitor)this);
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.writeOpenBracket();
        Set operands = ce.getOperands();
        List objects = CollectionFactory.sortOptionally((Collection)operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY, (OWLCardinalityRestriction)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectOneOf ce) {
        this.write(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.writeOpenBracket();
        Set individuals = ce.getIndividuals();
        List objects = CollectionFactory.sortOptionally((Collection)individuals);
        this.write(objects);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectHasSelf ce) {
        this.write(OWLXMLVocabulary.OBJECT_HAS_SELF, (OWLObject)ce.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM, (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(@Nonnull OWLObjectUnionOf ce) {
        if (ce.getOperands().size() == 1) {
            ((OWLClassExpression)ce.getOperands().iterator().next()).accept((OWLObjectVisitor)this);
            return;
        }
        this.write(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.writeOpenBracket();
        Set operands = ce.getOperands();
        List objects = CollectionFactory.sortOptionally((Collection)operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectHasValue ce) {
        this.writeRestriction(OWLXMLVocabulary.OBJECT_HAS_VALUE, (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(@Nonnull OWLDataComplementOf node) {
        this.write(OWLXMLVocabulary.DATA_COMPLEMENT_OF, (OWLObject)node.getDataRange());
    }

    public void visit(@Nonnull OWLDataOneOf node) {
        this.write(OWLXMLVocabulary.DATA_ONE_OF);
        this.writeOpenBracket();
        Set values = node.getValues();
        this.write(CollectionFactory.sortOptionally((Collection)values));
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLDatatype node) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATATYPE);
            this.writeOpenBracket();
        }
        node.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(@Nonnull OWLDatatypeRestriction node) {
        this.write(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        this.writeOpenBracket();
        node.getDatatype().accept((OWLObjectVisitor)this);
        Set facetRestrictions = node.getFacetRestrictions();
        List restrictionList = CollectionFactory.sortOptionally((Collection)facetRestrictions);
        for (OWLFacetRestriction restriction : restrictionList) {
            this.writeSpace();
            restriction.accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.writeSpace();
        node.getFacetValue().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLLiteral node) {
        this.write("\"");
        this.write(EscapeUtils.escapeString((String)node.getLiteral()));
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else if (!node.isRDFPlainLiteral()) {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    public void visit(@Nonnull OWLDataProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.DATA_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(@Nonnull OWLObjectProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.OBJECT_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.write(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        this.writeOpenBracket();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLNamedIndividual individual) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.NAMED_INDIVIDUAL);
            this.writeOpenBracket();
        }
        individual.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.HAS_KEY, (OWLAxiom)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.writeOpenBracket();
        Set objectPropertyExpressions = axiom.getObjectPropertyExpressions();
        List expressions = CollectionFactory.sortOptionally((Collection)objectPropertyExpressions);
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            OWLPropertyExpression prop = (OWLPropertyExpression)it.next();
            prop.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeSpace();
        this.writeOpenBracket();
        Set dataPropertyExpressions = axiom.getDataPropertyExpressions();
        List expressionList = CollectionFactory.sortOptionally((Collection)dataPropertyExpressions);
        Iterator it2 = expressionList.iterator();
        while (it2.hasNext()) {
            OWLPropertyExpression prop = (OWLPropertyExpression)it2.next();
            prop.accept((OWLObjectVisitor)this);
            if (!it2.hasNext()) continue;
            this.writeSpace();
        }
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE, (OWLAxiom)axiom);
        axiom.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getRange().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF, (OWLAxiom)axiom);
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull OWLDataIntersectionOf node) {
        if (node.getOperands().size() == 1) {
            ((OWLDataRange)node.getOperands().iterator().next()).accept((OWLObjectVisitor)this);
            return;
        }
        this.write(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.writeOpenBracket();
        Set operands = node.getOperands();
        List objects = CollectionFactory.sortOptionally((Collection)operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLDataUnionOf node) {
        if (node.getOperands().size() == 1) {
            ((OWLDataRange)node.getOperands().iterator().next()).accept((OWLObjectVisitor)this);
            return;
        }
        this.write(OWLXMLVocabulary.DATA_UNION_OF);
        this.writeOpenBracket();
        Set operands = node.getOperands();
        List objects = CollectionFactory.sortOptionally((Collection)operands);
        this.write(objects);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLAnnotationProperty property) {
        if (!this.writeEntitiesAsURIs) {
            this.write(OWLXMLVocabulary.ANNOTATION_PROPERTY);
            this.writeOpenBracket();
        }
        property.getIRI().accept((OWLObjectVisitor)this);
        if (!this.writeEntitiesAsURIs) {
            this.writeCloseBracket();
        }
    }

    public void visit(@Nonnull OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    public void visit(@Nonnull IRI iri) {
        this.write(iri);
    }

    public void visit(@Nonnull OWLAnnotation node) {
        this.write(OWLXMLVocabulary.ANNOTATION);
        this.writeOpenBracket();
        for (OWLAnnotation anno : FunctionalSyntaxObjectRenderer.getSortedAnnotations((HasAnnotations)node)) {
            anno.accept((OWLObjectVisitor)this);
            this.writeSpace();
        }
        node.getProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        node.getValue().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        this.writeAxiomStart(OWLXMLVocabulary.DATATYPE_DEFINITION, (OWLAxiom)axiom);
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        this.writeSpace();
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull SWRLRule rule) {
        this.writeAxiomStart(OWLXMLVocabulary.DL_SAFE_RULE, (OWLAxiom)rule);
        this.write(OWLXMLVocabulary.BODY);
        this.writeOpenBracket();
        this.write(rule.getBody());
        this.writeCloseBracket();
        this.write(OWLXMLVocabulary.HEAD);
        this.writeOpenBracket();
        this.write(rule.getHead());
        this.writeCloseBracket();
        this.writeAxiomEnd();
    }

    public void visit(@Nonnull SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull SWRLClassAtom node) {
        this.write(OWLXMLVocabulary.CLASS_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLDataRangeAtom node) {
        this.write(OWLXMLVocabulary.DATA_RANGE_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLObjectPropertyAtom node) {
        this.write(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLDataPropertyAtom node) {
        this.write(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLBuiltInAtom node) {
        this.write(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writeOpenBracket();
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(node.getArguments());
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLVariable node) {
        this.write(OWLXMLVocabulary.VARIABLE);
        this.writeOpenBracket();
        node.getIRI().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull SWRLDifferentIndividualsAtom node) {
        this.write(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(@Nonnull SWRLSameIndividualAtom node) {
        this.write(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        this.writeOpenBracket();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }
}

