/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.RDFDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFParserMetaData;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFResourceParseError;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAnonymousIndividualByIdProvider;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.rdfxml.parser.DeprecatedVocabulary;
import org.semanticweb.owlapi.rdf.rdfxml.parser.IRIProvider;
import org.semanticweb.owlapi.rdf.rdfxml.parser.LiteralTripleIterator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.ResourceTripleIterator;
import org.semanticweb.owlapi.rdf.rdfxml.parser.Translators;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TripleHandlers;
import org.semanticweb.owlapi.rdf.rdfxml.parser.TripleLogger;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;
import org.semanticweb.owlapi.util.AnonymousNodeCheckerImpl;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLRDFConsumer
implements RDFConsumer,
AnonymousNodeChecker,
OWLAnonymousIndividualByIdProvider {
    private static final String DAML_OIL = "http://www.daml.org/2001/03/daml+oil#";
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLRDFConsumer.class);
    @Nonnull
    final TripleLogger tripleLogger;
    @Nonnull
    private final OWLOntologyLoaderConfiguration configuration;
    private final OWLOntologyManager owlOntologyManager;
    private final Set<IRI> classExpressionIRIs;
    private final Set<IRI> objectPropertyExpressionIRIs;
    private final Set<IRI> dataPropertyExpressionIRIs;
    private final Set<IRI> propertyIRIs;
    private final Set<IRI> individualIRIs;
    private final Set<IRI> annotationPropertyIRIs;
    private final Set<IRI> annotationIRIs;
    private final Set<IRI> dataRangeIRIs;
    private IRI firstOntologyIRI;
    private final Set<IRI> ontologyIRIs;
    private final Set<IRI> restrictionIRIs;
    private final Map<IRI, IRI> listRestTripleMap;
    private final Map<IRI, IRI> listFirstResourceTripleMap;
    private final Map<IRI, OWLLiteral> listFirstLiteralTripleMap;
    private final Set<IRI> axioms = new HashSet<IRI>();
    private final Map<IRI, Object> sharedAnonymousNodes = new HashMap<IRI, Object>();
    private final Set<OWLAnnotation> pendingAnnotations = new HashSet<OWLAnnotation>();
    private final Map<IRI, Set<IRI>> annotatedAnonSource2AnnotationMap = new HashMap<IRI, Set<IRI>>();
    @Nonnull
    private final OWLOntology ontology;
    private int expectedAxioms = -1;
    private int parsedAxioms = 0;
    private RDFDocumentFormat ontologyFormat;
    private final OWLDataFactory dataFactory;
    private OWLAxiom lastAddedAxiom;
    private Map<IRI, IRI> synonymMap;
    private final Set<IRI> swrlRules;
    private final Set<IRI> swrlIndividualPropertyAtoms;
    private final Set<IRI> swrlDataValuedPropertyAtoms;
    private final Set<IRI> swrlClassAtoms;
    private final Set<IRI> swrlDataRangeAtoms;
    private final Set<IRI> swrlBuiltInAtoms;
    private final Set<IRI> swrlVariables;
    private final Set<IRI> swrlSameAsAtoms;
    private final Set<IRI> swrlDifferentFromAtoms;
    private IRIProvider iriProvider;
    private final Collection<OWLAnnotationAxiom> parsedAnnotationAxioms = new ArrayList<OWLAnnotationAxiom>();
    private final Collection<OWLAxiom> axiomsToBeRemoved = new ArrayList<OWLAxiom>();
    private boolean parsedAllTriples = false;
    final TripleHandlers.HandlerAccessor handlerAccessor;
    final Translators.TranslatorAccessor translatorAccessor;
    private final AnonymousNodeChecker nodeCheckerDelegate;
    @Nonnull
    private final ArrayListMultimap<IRI, Class<?>> guessedDeclarations = ArrayListMultimap.create();
    RemappingIndividualProvider anonProvider;
    private final Map<String, IRI> IRIMap = CollectionFactory.createMap();
    private int lastPercentParsed = 0;
    private final Map<IRI, OWLObjectPropertyExpression> translatedProperties = new HashMap<IRI, OWLObjectPropertyExpression>();
    @Nonnull
    private static final AtomicInteger ERRORCOUNTER = new AtomicInteger(0);
    private final Map<IRI, Map<IRI, Collection<IRI>>> resTriplesBySubject = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, IRI>> singleValuedResTriplesByPredicate = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, Collection<OWLLiteral>>> litTriplesBySubject = CollectionFactory.createMap();
    private final Map<IRI, Map<IRI, OWLLiteral>> singleValuedLitTriplesByPredicate = CollectionFactory.createMap();
    private final Map<IRI, IRI> remappedIRIs = CollectionFactory.createMap();
    private final Map<String, IRI> remappedIRIStrings = CollectionFactory.createMap();

    public OWLRDFConsumer(@Nonnull OWLOntology ontology, @Nonnull OWLOntologyLoaderConfiguration configuration) {
        this(ontology, (AnonymousNodeChecker)new AnonymousNodeCheckerImpl(), configuration);
    }

    public OWLRDFConsumer(@Nonnull OWLOntology ontology, @Nonnull AnonymousNodeChecker checker, @Nonnull OWLOntologyLoaderConfiguration configuration) {
        this.nodeCheckerDelegate = checker;
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.dataFactory = this.owlOntologyManager.getOWLDataFactory();
        this.anonProvider = new RemappingIndividualProvider(this.dataFactory);
        this.configuration = configuration;
        this.handlerAccessor = new TripleHandlers.HandlerAccessor(this);
        this.translatorAccessor = new Translators.TranslatorAccessor(this);
        this.classExpressionIRIs = CollectionFactory.createSet();
        this.objectPropertyExpressionIRIs = CollectionFactory.createSet();
        this.dataPropertyExpressionIRIs = CollectionFactory.createSet();
        this.individualIRIs = CollectionFactory.createSet();
        this.annotationPropertyIRIs = CollectionFactory.createSet();
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.annotationPropertyIRIs.add(iri);
        }
        this.annotationIRIs = new HashSet<IRI>();
        this.dataRangeIRIs = CollectionFactory.createSet();
        this.propertyIRIs = CollectionFactory.createSet();
        this.restrictionIRIs = CollectionFactory.createSet();
        this.ontologyIRIs = CollectionFactory.createSet();
        this.listFirstLiteralTripleMap = CollectionFactory.createMap();
        this.listFirstResourceTripleMap = CollectionFactory.createMap();
        this.listRestTripleMap = CollectionFactory.createMap();
        for (OWL2Datatype oWL2Datatype : OWL2Datatype.values()) {
            this.dataRangeIRIs.add(oWL2Datatype.getIRI());
        }
        this.dataRangeIRIs.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        if (!configuration.isStrict()) {
            for (OWL2Datatype oWL2Datatype : XSDVocabulary.values()) {
                this.dataRangeIRIs.add(oWL2Datatype.getIRI());
            }
        }
        this.swrlRules = new HashSet<IRI>();
        this.swrlIndividualPropertyAtoms = new HashSet<IRI>();
        this.swrlDataValuedPropertyAtoms = new HashSet<IRI>();
        this.swrlClassAtoms = new HashSet<IRI>();
        this.swrlDataRangeAtoms = new HashSet<IRI>();
        this.swrlBuiltInAtoms = new HashSet<IRI>();
        this.swrlVariables = new HashSet<IRI>();
        this.swrlSameAsAtoms = new HashSet<IRI>();
        this.swrlDifferentFromAtoms = new HashSet<IRI>();
        this.classExpressionIRIs.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.classExpressionIRIs.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.objectPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
        this.objectPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
        this.dataPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
        this.dataPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
        this.setupSynonymMap();
        this.setupSinglePredicateMaps();
        this.importsClosureChanged();
        if (this.ontology.getOntologyID().getOntologyIRI().isPresent()) {
            this.addOntology((IRI)this.ontology.getOntologyID().getOntologyIRI().get());
        }
        this.tripleLogger = new TripleLogger();
    }

    @Override
    public void addPrefix(String abbreviation, String value) {
        if (this.ontologyFormat.isPrefixOWLOntologyFormat()) {
            this.ontologyFormat.asPrefixOWLOntologyFormat().setPrefix(abbreviation, value);
        }
    }

    protected void setIRIProvider(IRIProvider iriProvider) {
        this.iriProvider = iriProvider;
    }

    private void addSingleValuedResPredicate(OWLRDFVocabulary v) {
        Map map = CollectionFactory.createMap();
        this.singleValuedResTriplesByPredicate.put(v.getIRI(), map);
    }

    private void setupSinglePredicateMaps() {
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_PROPERTY);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_CLASS);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_DATA_RANGE);
    }

    private void setupSynonymMap() {
        this.synonymMap = CollectionFactory.createMap();
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.getPrefixIRI(), (String)"valuesFrom"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        if (!this.configuration.isStrict()) {
            this.addDAMLOILVocabulary();
            this.addIntermediateOWLSpecVocabulary();
        }
    }

    private void addDAMLOILVocabulary() {
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"subClassOf"), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"imports"), OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"range"), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasValue"), OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"type"), OWLRDFVocabulary.RDF_TYPE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"domain"), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"versionInfo"), OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"comment"), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"onProperty"), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"toClass"), OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasClass"), OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Restriction"), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Class"), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Thing"), OWLRDFVocabulary.OWL_THING.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Nothing"), OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"minCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"cardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"maxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"inverseOf"), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"samePropertyAs"), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasClassQ"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"cardinalityQ"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"maxCardinalityQ"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"minCardinalityQ"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"complementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"unionOf"), OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"intersectionOf"), OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"label"), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"ObjectProperty"), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"DatatypeProperty"), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
    }

    private void addIntermediateOWLSpecVocabulary() {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            this.addLegacyMapping(oWLRDFVocabulary);
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLFacet.values()) {
            this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)oWLRDFVocabulary.getShortForm()), oWLRDFVocabulary.getIRI());
            this.synonymMap.put(IRI.create((String)Namespaces.OWL11.toString(), (String)oWLRDFVocabulary.getShortForm()), oWLRDFVocabulary.getIRI());
            this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)oWLRDFVocabulary.getShortForm()), oWLRDFVocabulary.getIRI());
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLFacet.values()) {
            this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)oWLRDFVocabulary.getShortForm()), oWLRDFVocabulary.getIRI());
        }
        this.synonymMap.put(DeprecatedVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_SUBJECT, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_PREDICATE, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_OBJECT, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)"cardinalityType"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)"dataComplementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_ANTI_SYMMETRIC_PROPERTY, OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_FUNCTIONAL_DATA_PROPERTY, OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_FUNCTIONAL_OBJECT_PROPERTY, OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_SUB_DATA_PROPERTY_OF, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_SUB_OBJECT_PROPERTY_OF, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_OBJECT_PROPERTY_RANGE, OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_DATA_PROPERTY_RANGE, OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_OBJECT_PROPERTY_DOMAIN, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_DATA_PROPERTY_DOMAIN, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_DISJOINT_DATA_PROPERTIES, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_DISJOINT_OBJECT_PROPERTIES, OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_EQUIVALENT_DATA_PROPERTIES, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_EQUIVALENT_OBJECT_PROPERTIES, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_OBJECT_RESTRICTION, OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_DATA_RESTRICTION, OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_SUBJECT, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_PREDICATE, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(DeprecatedVocabulary.OWL_OBJECT, OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
    }

    private void addLegacyMapping(OWLRDFVocabulary v) {
        this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)v.getShortForm()), v.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL11.toString(), (String)v.getShortForm()), v.getIRI());
    }

    @Nonnull
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Nonnull
    public RDFDocumentFormat getOntologyFormat() {
        return (RDFDocumentFormat)OWLAPIPreconditions.verifyNotNull((Object)this.ontologyFormat, (String)"ontology format has not been set yet");
    }

    public void setOntologyFormat(RDFDocumentFormat format) {
        this.ontologyFormat = format;
        if (this.ontologyFormat.isPrefixOWLOntologyFormat()) {
            this.tripleLogger.setPrefixManager((PrefixManager)this.ontologyFormat.asPrefixOWLOntologyFormat());
        }
    }

    public void setExpectedAxioms(int expectedAxioms) {
        this.expectedAxioms = expectedAxioms;
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Nonnull
    public Set<OWLAnnotation> getPendingAnnotations() {
        LinkedHashSet<OWLAnnotation> annos = new LinkedHashSet<OWLAnnotation>(this.pendingAnnotations);
        this.pendingAnnotations.clear();
        return annos;
    }

    protected void addPendingAnnotations(Set<OWLAnnotation> annotations) {
        this.pendingAnnotations.addAll(annotations);
    }

    @Nullable
    private IRI getIRINullable(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return this.getIRI(s);
    }

    @Nonnull
    private IRI getIRI(@Nonnull String s) {
        OWLAPIPreconditions.checkNotNull((Object)s, (String)"s cannot be null");
        IRI iri = null;
        if (this.iriProvider != null) {
            iri = this.iriProvider.getIRI(s);
        }
        if (iri != null) {
            return iri;
        }
        iri = this.IRIMap.get(s);
        if (iri == null) {
            iri = IRI.create((String)s);
            this.IRIMap.put(s, iri);
        }
        return iri;
    }

    protected final void importsClosureChanged() {
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            for (OWLAnnotationProperty prop : ont.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
                this.annotationPropertyIRIs.add(prop.getIRI());
            }
            for (OWLAnnotationProperty prop : ont.getDataPropertiesInSignature()) {
                this.dataPropertyExpressionIRIs.add(prop.getIRI());
            }
            for (OWLAnnotationProperty prop : ont.getObjectPropertiesInSignature()) {
                this.objectPropertyExpressionIRIs.add(prop.getIRI());
            }
            for (OWLClass cls : ont.getClassesInSignature()) {
                this.classExpressionIRIs.add(cls.getIRI());
            }
            for (OWLDatatype datatype : ont.getDatatypesInSignature()) {
                this.dataRangeIRIs.add(datatype.getIRI());
            }
            for (OWLNamedIndividual ind : ont.getIndividualsInSignature()) {
                this.individualIRIs.add(ind.getIRI());
            }
        }
    }

    public boolean isAnonymousNode(String iri) {
        return this.nodeCheckerDelegate.isAnonymousNode(iri);
    }

    public boolean isAnonymousSharedNode(String iri) {
        return this.nodeCheckerDelegate.isAnonymousSharedNode(iri);
    }

    public boolean isAnonymousNode(IRI iri) {
        return this.nodeCheckerDelegate.isAnonymousNode(iri);
    }

    protected void addSharedAnonymousNode(IRI iri, Object translation) {
        this.sharedAnonymousNodes.put(iri, translation);
    }

    protected Object getSharedAnonymousNode(IRI iri) {
        return this.sharedAnonymousNodes.get(iri);
    }

    protected void addAxiom(OWLAxiom axiom) {
        if (this.expectedAxioms > 0) {
            ++this.parsedAxioms;
            int percentParsed = (int)((double)this.parsedAxioms * 100.0 / (double)this.expectedAxioms);
            if (this.lastPercentParsed != percentParsed) {
                this.lastPercentParsed = percentParsed;
            }
        }
        if (axiom.isAnnotationAxiom()) {
            if (this.configuration.isLoadAnnotationAxioms()) {
                this.parsedAnnotationAxioms.add((OWLAnnotationAxiom)axiom);
            }
        } else {
            this.owlOntologyManager.addAxiom(this.ontology, axiom);
        }
        this.lastAddedAxiom = axiom;
    }

    protected void removeAxiom(OWLAxiom axiom) {
        this.axiomsToBeRemoved.add(axiom);
    }

    protected void checkForAndProcessAnnotatedDeclaration(IRI mainNode) {
        IRI annotatedPropertyObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false);
        if (annotatedPropertyObject == null) {
            return;
        }
        boolean rdfTypePredicate = annotatedPropertyObject.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI());
        if (!rdfTypePredicate) {
            return;
        }
        IRI annotatedTargetObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false);
        if (annotatedTargetObject == null) {
            return;
        }
        IRI annotatedSubjectObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE, false);
        if (annotatedSubjectObject == null) {
            return;
        }
        boolean isEntityType = OWLRDFConsumer.isEntityTypeIRI(annotatedTargetObject);
        if (isEntityType) {
            this.handlerAccessor.handle(annotatedSubjectObject, annotatedPropertyObject, annotatedTargetObject);
        }
    }

    private static boolean isEntityTypeIRI(IRI iri) {
        return iri.equals((Object)OWLRDFVocabulary.OWL_CLASS.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.RDFS_DATATYPE.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
    }

    protected void applyChange(@Nonnull OWLOntologyChange change) {
        this.owlOntologyManager.applyChange(change);
    }

    protected void setOntologyID(@Nonnull OWLOntologyID ontologyID) {
        this.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, ontologyID));
    }

    protected void addOntologyAnnotation(@Nonnull OWLAnnotation annotation) {
        this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, annotation));
    }

    protected void addImport(@Nonnull OWLImportsDeclaration declaration) {
        this.applyChange((OWLOntologyChange)new AddImport(this.ontology, declaration));
    }

    public OWLAxiom getLastAddedAxiom() {
        return this.lastAddedAxiom;
    }

    protected boolean isIndividual(IRI iri) {
        return this.individualIRIs.contains(iri);
    }

    protected void addRDFProperty(IRI iri) {
        this.propertyIRIs.add(iri);
    }

    protected boolean isRDFProperty(IRI iri) {
        return this.propertyIRIs.contains(iri);
    }

    public void addClassExpression(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLClass.class, explicitlyTyped);
        this.addType(iri, this.classExpressionIRIs, explicitlyTyped);
    }

    private void updateGuesses(IRI iri, Class<?> class1, boolean explicitlyTyped) {
        if (explicitlyTyped && this.guessedDeclarations.containsKey((Object)iri)) {
            this.guessedDeclarations.remove((Object)iri, class1);
        }
        if (!explicitlyTyped) {
            this.guessedDeclarations.put((Object)iri, class1);
        }
    }

    public boolean isClassExpression(IRI iri) {
        return this.classExpressionIRIs.contains(iri);
    }

    public void addObjectProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLObjectProperty.class, explicitlyTyped);
        this.addType(iri, this.objectPropertyExpressionIRIs, explicitlyTyped);
    }

    public void addDataProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLDataProperty.class, explicitlyTyped);
        this.addType(iri, this.dataPropertyExpressionIRIs, explicitlyTyped);
    }

    protected void addAnnotationProperty(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLAnnotationProperty.class, explicitlyTyped);
        this.addType(iri, this.annotationPropertyIRIs, explicitlyTyped);
    }

    public void addDataRange(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLDataRange.class, explicitlyTyped);
        this.addType(iri, this.dataRangeIRIs, explicitlyTyped);
    }

    protected void addOWLNamedIndividual(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLNamedIndividual.class, explicitlyTyped);
        this.addType(iri, this.individualIRIs, explicitlyTyped);
    }

    protected void addOWLRestriction(IRI iri, boolean explicitlyTyped) {
        this.updateGuesses(iri, OWLClassExpression.class, explicitlyTyped);
        this.addType(iri, this.restrictionIRIs, explicitlyTyped);
    }

    private void addType(IRI iri, Set<IRI> types, boolean explicitlyTyped) {
        if (this.configuration.isStrict() && !explicitlyTyped) {
            LOGGER.warn("STRICT: Not adding implicit type iri={} types={}", (Object)iri, types);
            return;
        }
        types.add(iri);
    }

    public boolean isRestriction(IRI iri) {
        return this.restrictionIRIs.contains(iri);
    }

    protected void addAnnotationIRI(IRI iri) {
        this.annotationIRIs.add(iri);
    }

    protected boolean isAnnotation(IRI iri) {
        return this.annotationIRIs.contains(iri);
    }

    protected boolean isObjectPropertyOnly(IRI iri) {
        return iri != null && !this.dataPropertyExpressionIRIs.contains(iri) && !this.annotationPropertyIRIs.contains(iri) && this.objectPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isObjectProperty(IRI iri) {
        return this.objectPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isDataPropertyOnly(IRI iri) {
        return iri != null && !this.objectPropertyExpressionIRIs.contains(iri) && !this.annotationPropertyIRIs.contains(iri) && this.dataPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isDataProperty(IRI iri) {
        return this.dataPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isAnnotationPropertyOnly(IRI iri) {
        return iri != null && !this.objectPropertyExpressionIRIs.contains(iri) && !this.dataPropertyExpressionIRIs.contains(iri) && this.annotationPropertyIRIs.contains(iri);
    }

    protected boolean isAnnotationProperty(IRI iri) {
        return this.annotationPropertyIRIs.contains(iri);
    }

    protected boolean isOntology(IRI iri) {
        return this.ontologyIRIs.contains(iri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public void addAnnotatedSource(IRI annotatedAnonSource, IRI annotationMainNode) {
        Set<IRI> annotationMainNodes = this.annotatedAnonSource2AnnotationMap.get(annotatedAnonSource);
        if (annotationMainNodes == null) {
            annotationMainNodes = new HashSet<IRI>();
            this.annotatedAnonSource2AnnotationMap.put(annotatedAnonSource, annotationMainNodes);
        }
        annotationMainNodes.add(annotationMainNode);
    }

    public Set<IRI> getAnnotatedSourceAnnotationMainNodes(IRI source) {
        Set<IRI> mainNodes = this.annotatedAnonSource2AnnotationMap.get(source);
        if (mainNodes != null) {
            return mainNodes;
        }
        return CollectionFactory.emptySet();
    }

    @Nonnull
    protected OWLClass getOWLClass(@Nonnull IRI iri) {
        return this.getDataFactory().getOWLClass(iri);
    }

    protected OWLObjectProperty getOWLObjectProperty(@Nonnull IRI iri) {
        return this.getDataFactory().getOWLObjectProperty(iri);
    }

    protected OWLDataProperty getOWLDataProperty(@Nonnull IRI iri) {
        return this.getDataFactory().getOWLDataProperty(iri);
    }

    @Nonnull
    protected OWLIndividual getOWLIndividual(@Nonnull IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return this.getOWLAnonymousIndividual(iri.toString());
        }
        return this.dataFactory.getOWLNamedIndividual(iri);
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        return this.anonProvider.getOWLAnonymousIndividual(nodeId);
    }

    protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
        LOGGER.trace("consuming triple");
        this.tripleLogger.justLog(subject, predicate, object);
        this.isTriplePresent(subject, predicate, object, true);
    }

    protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral con) {
        LOGGER.trace("consuming triple");
        this.tripleLogger.justLog(subject, predicate, con);
        this.isTriplePresent(subject, predicate, con, true);
    }

    protected void addSWRLRule(IRI iri) {
        this.swrlRules.add(iri);
    }

    protected boolean isSWRLRule(IRI iri) {
        return this.swrlRules.contains(iri);
    }

    protected void addSWRLIndividualPropertyAtom(IRI iri) {
        this.swrlIndividualPropertyAtoms.add(iri);
    }

    protected boolean isSWRLIndividualPropertyAtom(IRI iri) {
        return this.swrlIndividualPropertyAtoms.contains(iri);
    }

    protected void addSWRLDataPropertyAtom(IRI iri) {
        this.swrlDataValuedPropertyAtoms.add(iri);
    }

    protected boolean isSWRLDataValuedPropertyAtom(IRI iri) {
        return this.swrlDataValuedPropertyAtoms.contains(iri);
    }

    protected void addSWRLClassAtom(IRI iri) {
        this.swrlClassAtoms.add(iri);
    }

    protected boolean isSWRLClassAtom(IRI iri) {
        return this.swrlClassAtoms.contains(iri);
    }

    protected void addSWRLSameAsAtom(IRI iri) {
        this.swrlSameAsAtoms.add(iri);
    }

    protected boolean isSWRLSameAsAtom(IRI iri) {
        return this.swrlSameAsAtoms.contains(iri);
    }

    protected void addSWRLDifferentFromAtom(IRI iri) {
        this.swrlDifferentFromAtoms.add(iri);
    }

    protected boolean isSWRLDifferentFromAtom(IRI iri) {
        return this.swrlDifferentFromAtoms.contains(iri);
    }

    protected void addSWRLDataRangeAtom(IRI iri) {
        this.swrlDataRangeAtoms.add(iri);
    }

    protected boolean isSWRLDataRangeAtom(IRI iri) {
        return this.swrlDataRangeAtoms.contains(iri);
    }

    protected void addSWRLBuiltInAtom(IRI iri) {
        this.swrlBuiltInAtoms.add(iri);
    }

    protected boolean isSWRLBuiltInAtom(IRI iri) {
        return this.swrlBuiltInAtoms.contains(iri);
    }

    protected void addSWRLVariable(IRI iri) {
        this.swrlVariables.add(iri);
    }

    protected boolean isSWRLVariable(IRI iri) {
        return this.swrlVariables.contains(iri);
    }

    private static void printTriple(Object subject, Object predicate, Object object) {
        LOGGER.info("Unparsed triple: {} -> {} -> {}", new Object[]{subject, predicate, object});
    }

    protected void dumpRemainingTriples() {
        if (LOGGER.isInfoEnabled() && this.singleValuedResTriplesByPredicate.size() + this.singleValuedLitTriplesByPredicate.size() + this.resTriplesBySubject.size() + this.litTriplesBySubject.size() > 0) {
            Collection objects;
            IRI object;
            Map<IRI, Object> map;
            for (IRI predicate : this.singleValuedResTriplesByPredicate.keySet()) {
                map = this.singleValuedResTriplesByPredicate.get(predicate);
                for (IRI subject : map.keySet()) {
                    object = map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object);
                }
            }
            for (IRI predicate : this.singleValuedLitTriplesByPredicate.keySet()) {
                map = this.singleValuedLitTriplesByPredicate.get(predicate);
                for (IRI subject : map.keySet()) {
                    object = (OWLLiteral)map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object);
                }
            }
            for (IRI subject : new ArrayList<IRI>(this.resTriplesBySubject.keySet())) {
                map = this.resTriplesBySubject.get(subject);
                for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                    objects = (Collection)map.get(predicate);
                    for (IRI object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2);
                    }
                }
            }
            for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
                map = this.litTriplesBySubject.get(subject);
                for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                    objects = (Collection)map.get(predicate);
                    for (IRI object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2);
                    }
                }
            }
        }
    }

    @Override
    public void startModel(IRI physicalURI) {
    }

    public boolean isParsedAllTriples() {
        return this.parsedAllTriples;
    }

    @Override
    public void endModel() {
        this.parsedAllTriples = true;
        this.IRIMap.clear();
        this.tripleLogger.logNumberOfTriples();
        this.translatorAccessor.consumeSWRLRules(this.swrlRules);
        Set<RDFTriple> remainingTriples = this.handlerAccessor.mopUp();
        if (this.ontologyFormat != null) {
            RDFParserMetaData metaData = new RDFParserMetaData(RDFOntologyHeaderStatus.PARSED_ONE_HEADER, this.tripleLogger.count(), remainingTriples, this.guessedDeclarations);
            this.ontologyFormat.setOntologyLoaderMetaData((OWLOntologyLoaderMetaData)metaData);
        }
        this.chooseAndSetOntologyIRI();
        TripleLogger.logOntologyID(this.ontology.getOntologyID());
        this.dumpRemainingTriples();
        this.cleanup();
        this.addAnnotationAxioms();
        this.removeAxiomsScheduledForRemoval();
    }

    private void addAnnotationAxioms() {
        for (OWLAxiom oWLAxiom : this.parsedAnnotationAxioms) {
            assert (oWLAxiom != null);
            this.owlOntologyManager.addAxiom(this.ontology, oWLAxiom);
        }
    }

    private void removeAxiomsScheduledForRemoval() {
        for (OWLAxiom axiom : this.axiomsToBeRemoved) {
            assert (axiom != null);
            this.owlOntologyManager.removeAxiom(this.ontology, axiom);
        }
    }

    private void chooseAndSetOntologyIRI() {
        Optional ontologyIRIToSet = Optional.absent();
        if (!this.ontologyIRIs.isEmpty()) {
            if (this.ontologyIRIs.size() == 1) {
                IRI ontologyIRI = this.ontologyIRIs.iterator().next();
                assert (ontologyIRI != null);
                if (!this.isAnonymousNode(ontologyIRI)) {
                    ontologyIRIToSet = Optional.of((Object)ontologyIRI);
                }
            } else {
                HashSet<IRI> candidateIRIs = new HashSet<IRI>(this.ontologyIRIs);
                for (OWLAnnotation anno : this.ontology.getAnnotations()) {
                    IRI iri;
                    if (!(anno.getValue() instanceof IRI) || !this.ontologyIRIs.contains(iri = (IRI)anno.getValue())) continue;
                    candidateIRIs.remove(iri);
                }
                if (candidateIRIs.contains(this.firstOntologyIRI)) {
                    ontologyIRIToSet = Optional.of((Object)this.firstOntologyIRI);
                } else if (!candidateIRIs.isEmpty()) {
                    ontologyIRIToSet = Optional.of(candidateIRIs.iterator().next());
                }
            }
        }
        if (ontologyIRIToSet.isPresent() && !NodeID.isAnonymousNodeIRI((IRI)((IRI)ontologyIRIToSet.get()))) {
            Optional versionIRI = this.ontology.getOntologyID().getVersionIRI();
            OWLOntologyID ontologyID = new OWLOntologyID(ontologyIRIToSet, versionIRI);
            this.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, ontologyID));
        }
    }

    private void cleanup() {
        this.classExpressionIRIs.clear();
        this.objectPropertyExpressionIRIs.clear();
        this.dataPropertyExpressionIRIs.clear();
        this.dataRangeIRIs.clear();
        this.restrictionIRIs.clear();
        this.listFirstLiteralTripleMap.clear();
        this.listFirstResourceTripleMap.clear();
        this.listRestTripleMap.clear();
        this.translatorAccessor.cleanup();
        this.resTriplesBySubject.clear();
        this.litTriplesBySubject.clear();
        this.singleValuedLitTriplesByPredicate.clear();
        this.singleValuedResTriplesByPredicate.clear();
        this.guessedDeclarations.clear();
    }

    @Override
    public void includeModel(String logicalURI, String physicalURI) {
    }

    @Override
    public void logicalURI(IRI logicalURI) {
    }

    @Nonnull
    protected IRI getSynonym(@Nonnull IRI original) {
        IRI synonymIRI;
        if (!this.configuration.isStrict() && (synonymIRI = this.synonymMap.get(original)) != null) {
            return synonymIRI;
        }
        return original;
    }

    @Override
    public void statementWithLiteralValue(@Nonnull String subject, @Nonnull String predicate, @Nonnull String object, @Nullable String language, @Nullable String datatype) {
        this.tripleLogger.logTriple(subject, predicate, object, language, datatype);
        IRI subjectIRI = this.getIRI(this.remapOnlyIfRemapped(subject));
        IRI predicateIRI = this.getIRI(predicate);
        predicateIRI = this.getSynonym(predicateIRI);
        this.handlerAccessor.handleStreaming(subjectIRI, predicateIRI, object, this.getIRINullable(datatype), language);
    }

    @Override
    public void statementWithLiteralValue(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull String object, String language, IRI datatype) {
        this.tripleLogger.logTriple(subject, predicate, object, language, datatype);
        this.handlerAccessor.handleStreaming(subject, this.getSynonym(predicate), object, datatype, language);
    }

    @Override
    public void statementWithResourceValue(@Nonnull String subject, @Nonnull String predicate, @Nonnull String object) {
        this.tripleLogger.logTriple(subject, predicate, object);
        IRI subjectIRI = this.getIRI(subject);
        IRI predicateIRI = this.getIRI(predicate);
        predicateIRI = this.getSynonym(predicateIRI);
        IRI objectIRI = this.getSynonym(this.getIRI(object));
        this.handlerAccessor.handleStreaming(subjectIRI, predicateIRI, objectIRI);
    }

    @Override
    public void statementWithResourceValue(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
        this.tripleLogger.logTriple(subject, predicate, object);
        this.handlerAccessor.handleStreaming(subject, this.getSynonym(predicate), this.getSynonym(object));
    }

    @Nonnull
    OWLLiteral getOWLLiteral(@Nonnull String literal, @Nullable IRI datatype, @Nullable String lang) {
        if (datatype != null) {
            return this.dataFactory.getOWLLiteral(literal, this.dataFactory.getOWLDatatype(datatype));
        }
        return this.dataFactory.getOWLLiteral(literal, lang);
    }

    @Nonnull
    public OWLClassExpression translateClassExpression(@Nonnull IRI i) {
        return this.translatorAccessor.translateClassExpression(i);
    }

    @Nonnull
    public OWLDataRange translateDataRange(@Nonnull IRI mainNode) {
        if (!this.isDataRange(mainNode) && this.configuration.isStrict()) {
            return (OWLDataRange)this.generateAndLogParseError(EntityType.DATATYPE, mainNode);
        }
        if (!this.isAnonymousNode(mainNode) && this.isDataRange(mainNode)) {
            return this.dataFactory.getOWLDatatype(mainNode);
        }
        IRI intersectionOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF, true);
        if (intersectionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translatorAccessor.translateToDataRangeSet(intersectionOfObject);
            return this.dataFactory.getOWLDataIntersectionOf(dataRanges);
        }
        IRI unionOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_UNION_OF, true);
        if (unionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translatorAccessor.translateToDataRangeSet(unionOfObject);
            return this.dataFactory.getOWLDataUnionOf(dataRanges);
        }
        IRI complementOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF, true);
        if (!this.configuration.isStrict() && complementOfObject == null) {
            complementOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF, true);
        }
        if (complementOfObject != null) {
            OWLDataRange operand = this.translateDataRange(complementOfObject);
            return this.dataFactory.getOWLDataComplementOf(operand);
        }
        IRI oneOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF, true);
        if (oneOfObject != null) {
            Set<OWLLiteral> literals = this.translatorAccessor.translateToConstantSet(oneOfObject);
            return this.dataFactory.getOWLDataOneOf(literals);
        }
        IRI onDatatypeObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_TYPE, true);
        if (onDatatypeObject != null) {
            if (this.isAnonymousNode(onDatatypeObject)) {
                return this.dataFactory.getOWLDatatype(mainNode);
            }
            OWLDatatype restrictedDataRange = (OWLDatatype)this.translateDataRange(onDatatypeObject);
            Set<Object> restrictions = new HashSet();
            IRI facetRestrictionList = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS, true);
            if (facetRestrictionList != null) {
                restrictions = this.translatorAccessor.translateToFacetRestrictionSet(facetRestrictionList);
            } else if (!this.configuration.isStrict()) {
                for (IRI facetIRI : OWLFacet.FACET_IRIS) {
                    OWLLiteral val;
                    assert (facetIRI != null);
                    while ((val = this.getLiteralObject(mainNode, facetIRI, true)) != null) {
                        restrictions.add(this.dataFactory.getOWLFacetRestriction(OWLFacet.getFacet((IRI)facetIRI), val));
                    }
                }
            }
            return this.dataFactory.getOWLDatatypeRestriction(restrictedDataRange, restrictions);
        }
        return (OWLDataRange)this.generateAndLogParseError(EntityType.DATATYPE, mainNode);
    }

    @Nonnull
    public OWLDataPropertyExpression translateDataPropertyExpression(@Nonnull IRI iri) {
        return this.dataFactory.getOWLDataProperty(iri);
    }

    @Nonnull
    public OWLObjectPropertyExpression translateObjectPropertyExpression(@Nonnull IRI mainNode) {
        OWLObjectPropertyExpression prop = this.translatedProperties.get(mainNode);
        if (prop != null) {
            return prop;
        }
        if (!this.isAnonymousNode(mainNode)) {
            prop = this.dataFactory.getOWLObjectProperty(mainNode);
            this.translatedProperties.put(mainNode, prop);
        } else {
            IRI inverseOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INVERSE_OF, true);
            if (inverseOfObject != null) {
                OWLObjectPropertyExpression otherProperty = this.translateObjectPropertyExpression(inverseOfObject);
                prop = this.dataFactory.getOWLObjectInverseOf(otherProperty);
            } else {
                prop = this.dataFactory.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.dataFactory.getOWLObjectProperty(mainNode));
            }
            this.objectPropertyExpressionIRIs.add(mainNode);
            this.translatedProperties.put(mainNode, prop);
        }
        return prop;
    }

    @Nonnull
    public OWLIndividual translateIndividual(@Nonnull IRI node) {
        return this.getOWLIndividual(node);
    }

    @Nonnull
    public Set<OWLAnnotation> translateAnnotations(IRI mainNode) {
        HashMap<IRI, Set<OWLAnnotation>> anns = new HashMap<IRI, Set<OWLAnnotation>>();
        Set<IRI> annotationMainNodes = this.getAnnotatedSourceAnnotationMainNodes(mainNode);
        if (!annotationMainNodes.isEmpty()) {
            for (IRI annotationMainNode : annotationMainNodes) {
                anns.put(annotationMainNode, this.translateAnnotations(annotationMainNode));
            }
        }
        HashSet<OWLAnnotation> mainNodeAnnotations = new HashSet<OWLAnnotation>();
        Set<IRI> predicates = this.getPredicatesBySubject(mainNode);
        for (IRI predicate : predicates) {
            assert (predicate != null);
            if (!this.isAnnotationProperty(predicate)) continue;
            this.mapAnnotation(mainNode, anns, mainNodeAnnotations, predicate);
        }
        return mainNodeAnnotations;
    }

    protected void mapAnnotation(IRI mainNode, Map<IRI, Set<OWLAnnotation>> anns, Set<OWLAnnotation> mainNodeAnnotations, IRI predicate) {
        Set<OWLAnnotation> c;
        IRI annotation;
        IRI resVal = this.getResourceObject(mainNode, predicate, true);
        while (resVal != null) {
            OWLAnnotationProperty prop = this.dataFactory.getOWLAnnotationProperty(predicate);
            Object val = this.isAnonymousNode(resVal) ? this.dataFactory.getOWLAnonymousIndividual(resVal.toString()) : resVal;
            annotation = this.getSubjectForAnnotatedPropertyAndObject(mainNode, predicate, resVal);
            c = anns.get(annotation);
            mainNodeAnnotations.add(this.dataFactory.getOWLAnnotation(prop, (OWLAnnotationValue)val, c != null ? c : Collections.emptySet()));
            resVal = this.getResourceObject(mainNode, predicate, true);
        }
        OWLLiteral litVal = this.getLiteralObject(mainNode, predicate, true);
        while (litVal != null) {
            OWLAnnotationProperty prop = this.dataFactory.getOWLAnnotationProperty(predicate);
            annotation = this.getSubjectForAnnotatedPropertyAndObject(mainNode, predicate, litVal);
            c = anns.get(annotation);
            mainNodeAnnotations.add(this.dataFactory.getOWLAnnotation(prop, (OWLAnnotationValue)litVal, c != null ? c : Collections.emptySet()));
            litVal = this.getLiteralObject(mainNode, predicate, true);
        }
    }

    @Nullable
    private IRI getSubjectForAnnotatedPropertyAndObject(IRI n, IRI p, OWLLiteral v) {
        for (IRI i : this.getAnnotatedSourceAnnotationMainNodes(n)) {
            if (!p.equals((Object)this.getResourceObject(i, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false)) || !v.equals(this.getLiteralObject(i, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false))) continue;
            return i;
        }
        return null;
    }

    @Nullable
    private IRI getSubjectForAnnotatedPropertyAndObject(IRI n, IRI p, IRI v) {
        for (IRI i : this.getAnnotatedSourceAnnotationMainNodes(n)) {
            if (!p.equals((Object)this.getResourceObject(i, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false)) || !v.equals((Object)this.getResourceObject(i, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false))) continue;
            return i;
        }
        return null;
    }

    @Nonnull
    private <E extends OWLEntity> E getErrorEntity(@Nonnull EntityType<E> entityType) {
        IRI iri = IRI.create((String)"http://org.semanticweb.owlapi/error#", (String)("Error" + ERRORCOUNTER.incrementAndGet()));
        LOGGER.error("Entity not properly recognized, missing triples in input? {} for type {}", (Object)iri, entityType);
        if (this.configuration.isStrict()) {
            throw new OWLParserException("Entity not properly recognized, missing triples in input? " + iri + " for type " + entityType);
        }
        return (E)this.dataFactory.getOWLEntity(entityType, iri);
    }

    @Nonnull
    private RDFResource getRDFResource(@Nonnull IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return new RDFResourceBlankNode(iri, false, false);
        }
        return new RDFResourceIRI(iri);
    }

    @Nonnull
    private RDFTriple getRDFTriple(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull IRI object) {
        return new RDFTriple(this.getRDFResource(subject), new RDFResourceIRI(predicate), (RDFNode)this.getRDFResource(object));
    }

    @Nonnull
    private RDFTriple getRDFTriple(@Nonnull IRI subject, @Nonnull IRI predicate, @Nonnull OWLLiteral object) {
        return new RDFTriple(this.getRDFResource(subject), new RDFResourceIRI(predicate), (RDFNode)new RDFLiteral(object));
    }

    @Nonnull
    private Set<RDFTriple> getTriplesForMainNode(@Nonnull IRI mainNode, IRI ... augmentingTypes) {
        HashSet<RDFTriple> triples = new HashSet<RDFTriple>();
        for (IRI predicate : this.getPredicatesBySubject(mainNode)) {
            assert (predicate != null);
            for (IRI iRI : this.getResourceObjects(mainNode, predicate)) {
                assert (iRI != null);
                triples.add(this.getRDFTriple(mainNode, predicate, iRI));
            }
            for (OWLLiteral oWLLiteral : this.getLiteralObjects(mainNode, predicate)) {
                assert (oWLLiteral != null);
                triples.add(this.getRDFTriple(mainNode, predicate, oWLLiteral));
            }
        }
        for (IRI iRI : augmentingTypes) {
            assert (iRI != null);
            triples.add(this.getRDFTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), iRI));
        }
        return triples;
    }

    private void logError(RDFResourceParseError error) {
        this.ontologyFormat.addError(error);
    }

    @Nonnull
    public <E extends OWLEntity> E generateAndLogParseError(@Nonnull EntityType<E> entityType, @Nonnull IRI mainNode) {
        E entity = this.getErrorEntity(entityType);
        RDFResource mainNodeResource = this.getRDFResource(mainNode);
        Set<RDFTriple> mainNodeTriples = this.getTriplesForMainNode(mainNode, new IRI[0]);
        RDFResourceParseError error = new RDFResourceParseError(entity, (RDFNode)mainNodeResource, mainNodeTriples);
        this.logError(error);
        return entity;
    }

    protected Set<IRI> getPredicatesBySubject(IRI subject) {
        Map<IRI, Collection<OWLLiteral>> predObjMapLit;
        HashSet<IRI> iris = new HashSet<IRI>();
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null) {
            iris.addAll(predObjMap.keySet());
        }
        if ((predObjMapLit = this.litTriplesBySubject.get(subject)) != null) {
            iris.addAll(predObjMapLit.keySet());
        }
        return iris;
    }

    protected IRI getResourceObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getResourceObject(subject, predicate.getIRI(), consume);
    }

    protected IRI getResourceObject(IRI subject, IRI predicate, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            IRI object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            return object;
        }
        return null;
    }

    protected Set<IRI> getResourceObjects(IRI subject, IRI predicate) {
        Collection<IRI> objects;
        Map<IRI, Collection<IRI>> predObjMap;
        IRI obj;
        HashSet<IRI> result = new HashSet<IRI>();
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.resTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    protected OWLLiteral getLiteralObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getLiteralObject(subject, predicate.getIRI(), consume);
    }

    protected OWLLiteral getLiteralObject(IRI subject, IRI predicate, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            OWLLiteral object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
            }
            return object;
        }
        return null;
    }

    protected Set<OWLLiteral> getLiteralObjects(IRI subject, IRI predicate) {
        Collection<OWLLiteral> objects;
        Map<IRI, Collection<OWLLiteral>> predObjMap;
        OWLLiteral obj;
        HashSet<OWLLiteral> result = new HashSet<OWLLiteral>();
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.litTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    protected boolean isTriplePresent(IRI subject, IRI predicate, IRI object, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean isGeneralPredicate(IRI predicate) {
        return !predicate.isReservedVocabulary() || OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(predicate) || Namespaces.SWRL.inNamespace(predicate) || Namespaces.SWRLB.inNamespace(predicate);
    }

    protected boolean isTriplePresent(IRI subject, IRI predicate, OWLLiteral object, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.litTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean hasPredicate(IRI subject, IRI predicate) {
        boolean b;
        Map<IRI, IRI> resPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (resPredMap != null) {
            return resPredMap.containsKey(subject);
        }
        Map<IRI, OWLLiteral> litPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (litPredMap != null) {
            return litPredMap.containsKey(subject);
        }
        Map<IRI, Collection<IRI>> resPredObjMap = this.resTriplesBySubject.get(subject);
        if (resPredObjMap != null && (b = resPredObjMap.containsKey(predicate))) {
            return true;
        }
        Map<IRI, Collection<OWLLiteral>> litPredObjMap = this.litTriplesBySubject.get(subject);
        if (litPredObjMap != null) {
            return litPredObjMap.containsKey(predicate);
        }
        return false;
    }

    protected void addRest(IRI subject, IRI object) {
        this.listRestTripleMap.put(subject, object);
    }

    protected void addFirst(IRI subject, IRI object) {
        this.listFirstResourceTripleMap.put(subject, object);
    }

    protected IRI getFirstResource(IRI subject, boolean consume) {
        if (consume) {
            return this.listFirstResourceTripleMap.remove(subject);
        }
        return this.listFirstResourceTripleMap.get(subject);
    }

    protected OWLLiteral getFirstLiteral(IRI subject) {
        return this.listFirstLiteralTripleMap.get(subject);
    }

    protected IRI getRest(IRI subject, boolean consume) {
        if (consume) {
            return this.listRestTripleMap.remove(subject);
        }
        return this.listRestTripleMap.get(subject);
    }

    protected void addFirst(IRI subject, OWLLiteral object) {
        this.listFirstLiteralTripleMap.put(subject, object);
    }

    protected void addOntology(IRI iri) {
        if (this.ontologyIRIs.isEmpty()) {
            this.firstOntologyIRI = iri;
        }
        this.ontologyIRIs.add(iri);
    }

    protected Set<IRI> getOntologies() {
        return this.ontologyIRIs;
    }

    protected void addAxiom(IRI axiomIRI) {
        this.axioms.add(axiomIRI);
    }

    protected boolean isAxiom(IRI iri) {
        return this.axioms.contains(iri);
    }

    protected boolean isDataRange(IRI iri) {
        return this.dataRangeIRIs.contains(iri);
    }

    @Nonnull
    protected OWLOntologyLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void iterateResourceTriples(ResourceTripleIterator iterator) {
        for (IRI subject : this.resTriplesBySubject.keySet()) {
            Map<IRI, Collection<IRI>> map = this.resTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : map.keySet()) {
                Collection<IRI> objects = map.get(predicate);
                if (objects == null) continue;
                for (IRI object : objects.toArray(new IRI[objects.size()])) {
                    assert (subject != null);
                    assert (predicate != null);
                    assert (object != null);
                    iterator.handleResourceTriple(subject, predicate, object);
                }
            }
        }
    }

    protected void iterateLiteralTriples(LiteralTripleIterator iterator) {
        for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
            Map<IRI, Collection<OWLLiteral>> map = this.litTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                Collection<OWLLiteral> objects = map.get(predicate);
                for (OWLLiteral object : new ArrayList<OWLLiteral>(objects)) {
                    assert (subject != null);
                    assert (predicate != null);
                    assert (object != null);
                    iterator.handleLiteralTriple(subject, predicate, object);
                }
            }
        }
    }

    @Override
    @Nonnull
    public IRI remapIRI(@Nonnull IRI i) {
        if (this.nodeCheckerDelegate.isAnonymousNode(i)) {
            return i;
        }
        IRI computeIfAbsent = this.remappedIRIs.get(i);
        if (computeIfAbsent == null) {
            computeIfAbsent = IRI.create((String)NodeID.nextAnonymousIRI());
            this.remappedIRIs.put(i, computeIfAbsent);
        }
        this.remappedIRIStrings.put(i.toString(), computeIfAbsent);
        return computeIfAbsent;
    }

    @Override
    @Nonnull
    public String remapOnlyIfRemapped(@Nonnull String i) {
        if (this.nodeCheckerDelegate.isAnonymousNode(i) || this.nodeCheckerDelegate.isAnonymousSharedNode(i)) {
            return i;
        }
        IRI iri = this.remappedIRIStrings.get(i);
        return iri == null ? i : iri.toString();
    }

    protected void addTriple(IRI subject, IRI predicate, IRI object) {
        Map<IRI, IRI> subjObjMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, object);
        } else {
            HashSet<IRI> objects;
            Map map = this.resTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.resTriplesBySubject.put(subject, map);
            }
            if ((objects = (HashSet<IRI>)map.get(predicate)) == null) {
                objects = new HashSet<IRI>();
                map.put(predicate, objects);
            }
            objects.add(object);
        }
    }

    protected void addTriple(IRI subject, IRI predicate, OWLLiteral con) {
        Map<IRI, OWLLiteral> subjObjMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, con);
        } else {
            HashSet<OWLLiteral> objects;
            Map map = this.litTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.litTriplesBySubject.put(subject, map);
            }
            if ((objects = (HashSet<OWLLiteral>)map.get(predicate)) == null) {
                objects = new HashSet<OWLLiteral>();
                map.put(predicate, objects);
            }
            objects.add(con);
        }
    }
}

