/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.functional.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormatFactory;
import org.semanticweb.owlapi.functional.parser.CustomTokenizer;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxParser;
import org.semanticweb.owlapi.functional.parser.ParseException;
import org.semanticweb.owlapi.functional.parser.TokenMgrError;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class OWLFunctionalSyntaxOWLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public String getName() {
        return "OWLFunctionalSyntaxOWLParser";
    }

    @Nonnull
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new FunctionalSyntaxDocumentFormatFactory();
    }

    @Nonnull
    public OWLDocumentFormat parse(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        Reader reader = null;
        InputStream is = null;
        try {
            OWLFunctionalSyntaxParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new OWLFunctionalSyntaxParser(new CustomTokenizer(reader));
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new OWLFunctionalSyntaxParser(new CustomTokenizer(new InputStreamReader(is, "UTF-8")));
            } else {
                is = this.getInputStream(documentSource.getDocumentIRI(), configuration);
                parser = new OWLFunctionalSyntaxParser(new CustomTokenizer(new InputStreamReader(is, "UTF-8")));
            }
            parser.setUp(ontology, configuration);
            FunctionalSyntaxDocumentFormat functionalSyntaxDocumentFormat = parser.parse();
            return functionalSyntaxDocumentFormat;
        }
        catch (ParseException e) {
            throw new OWLParserException(e.getMessage(), (Throwable)((Object)e), 0, 0);
        }
        catch (TokenMgrError e) {
            throw new OWLParserException((Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

