/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class DLSyntaxStorerBase
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;
    private DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer();

    protected void storeOntology(@Nonnull OWLOntology ontology, Writer writer, OWLDocumentFormat format) {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        PrintWriter printWriter = new PrintWriter((Writer)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null"));
        this.beginWritingOntology(ontology, printWriter);
        HashSet<OWLAxiom> printed = new HashSet<OWLAxiom>();
        for (OWLObjectProperty prop : CollectionFactory.sortOptionally((Collection)ontology.getObjectPropertiesInSignature())) {
            assert (prop != null);
            this.write(ontology, (OWLEntity)prop, ontology.getAxioms((OWLObjectPropertyExpression)prop, Imports.EXCLUDED), printWriter, printed);
        }
        for (OWLObjectProperty prop : CollectionFactory.sortOptionally((Collection)ontology.getDataPropertiesInSignature())) {
            assert (prop != null);
            this.write(ontology, (OWLEntity)prop, ontology.getAxioms((OWLDataProperty)prop, Imports.EXCLUDED), printWriter, printed);
        }
        for (OWLClass cls : CollectionFactory.sortOptionally((Collection)ontology.getClassesInSignature())) {
            assert (cls != null);
            this.write(ontology, (OWLEntity)cls, ontology.getAxioms(cls, Imports.EXCLUDED), printWriter, printed);
        }
        for (OWLNamedIndividual ind : CollectionFactory.sortOptionally((Collection)ontology.getIndividualsInSignature())) {
            assert (ind != null);
            this.write(ontology, (OWLEntity)ind, ontology.getAxioms((OWLIndividual)ind, Imports.EXCLUDED), printWriter, printed);
        }
        this.beginWritingGeneralAxioms(ontology.getGeneralClassAxioms(), printWriter);
        for (OWLAxiom ax : ontology.getGeneralClassAxioms()) {
            assert (ax != null);
            if (!printed.add(ax)) continue;
            this.beginWritingAxiom(ax, printWriter);
            this.writeAxiom(null, ax, printWriter);
            this.endWritingAxiom(ax, printWriter);
        }
        this.endWritingGeneralAxioms(ontology.getGeneralClassAxioms(), printWriter);
        this.endWritingOntology(ontology, printWriter);
        printWriter.flush();
    }

    private void write(@Nonnull OWLOntology ont, @Nonnull OWLEntity entity, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer, Set<OWLAxiom> printed) {
        this.beginWritingAxioms(entity, axioms, writer);
        for (OWLAxiom ax : CollectionFactory.sortOptionally(axioms)) {
            assert (ax != null);
            if (!printed.add(ax)) continue;
            this.beginWritingAxiom(ax, writer);
            this.writeAxiom(entity, ax, writer);
            this.endWritingAxiom(ax, writer);
        }
        TreeSet usages = new TreeSet(ont.getReferencingAxioms((OWLPrimitive)entity, Imports.EXCLUDED));
        usages.removeAll(axioms);
        this.beginWritingUsage(entity, usages, writer);
        for (OWLAxiom usage : usages) {
            assert (usage != null);
            if (axioms.contains(usage) || !printed.add(usage)) continue;
            this.beginWritingAxiom(usage, writer);
            this.writeAxiom(entity, usage, writer);
            this.endWritingAxiom(usage, writer);
        }
        this.endWritingUsage(entity, usages, writer);
        this.endWritingAxioms(entity, axioms, writer);
    }

    protected void writeAxiom(@Nullable OWLEntity subject, @Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
        writer.write(this.getRendering(subject, axiom));
    }

    @Nonnull
    protected String getRendering(@Nullable OWLEntity subject, @Nonnull OWLAxiom axiom) {
        return this.ren.render((OWLObject)axiom);
    }

    protected void beginWritingOntology(@Nonnull OWLOntology ontology, @Nonnull PrintWriter writer) {
    }

    protected void endWritingOntology(@Nonnull OWLOntology ontology, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingAxiom(@Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
    }

    protected void endWritingAxiom(@Nonnull OWLAxiom axiom, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingAxioms(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingAxioms(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingUsage(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingUsage(@Nonnull OWLEntity subject, @Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void beginWritingGeneralAxioms(@Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }

    protected void endWritingGeneralAxioms(@Nonnull Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
    }
}

