/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.turtle.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserIOException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ConsoleTripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.OWLRDFConsumerAdapter;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ParseException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParser;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, UnloadableImportException, IOException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException {
        Reader reader = null;
        InputStream is = null;
        try {
            TurtleParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new TurtleParser(reader, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            } else {
                is = this.getInputStream(documentSource.getDocumentIRI(), configuration);
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            }
            OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, new AnonymousNodeChecker(){

                @Override
                public boolean isAnonymousNode(IRI iri) {
                    return NodeID.isAnonymousNodeIRI((IRI)iri);
                }

                @Override
                public boolean isAnonymousSharedNode(String iri) {
                    return NodeID.isAnonymousNodeID((String)iri);
                }

                @Override
                public boolean isAnonymousNode(String iri) {
                    return NodeID.isAnonymousNodeIRI((String)iri);
                }
            }, configuration);
            TurtleOntologyFormat format = new TurtleOntologyFormat();
            consumer.setOntologyFormat(format);
            parser.setTripleHandler(consumer);
            parser.parseDocument();
            PrefixManager prefixManager = parser.getPrefixManager();
            for (String prefixName : prefixManager.getPrefixNames()) {
                format.setPrefix(prefixName, prefixManager.getPrefix(prefixName));
            }
            Object object = format;
            return object;
        }
        catch (ParseException e) {
            throw new TurtleParserException(e);
        }
        catch (IOException e) {
            throw new OWLParserIOException(e);
        }
        finally {
            if (is != null) {
                is.close();
            } else if (reader != null) {
                reader.close();
            }
        }
    }
}

