/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;

public class SectionMap {
    private Map<Object, Collection<OWLAxiom>> object2Axioms = new LinkedHashMap<Object, Collection<OWLAxiom>>();

    public boolean isEmpty() {
        return this.object2Axioms.isEmpty();
    }

    public void add(Object o, OWLAxiom forAxiom) {
        Collection<OWLAxiom> axioms = this.object2Axioms.get(o);
        if (axioms == null) {
            axioms = new HashSet<OWLAxiom>();
            this.object2Axioms.put(o, axioms);
        }
        axioms.add(forAxiom);
    }

    public void remove(Object o) {
        this.object2Axioms.remove(o);
    }

    public Collection<Object> getSectionObjects() {
        return this.object2Axioms.keySet();
    }

    public Collection<Collection<OWLAnnotation>> getAnnotationsForSectionObject(Object sectionObject) {
        Collection<OWLAxiom> axioms = this.object2Axioms.get(sectionObject);
        if (axioms == null) {
            return new TreeSet<Collection<OWLAnnotation>>();
        }
        ArrayList<Collection<OWLAnnotation>> annos = new ArrayList<Collection<OWLAnnotation>>();
        for (OWLAxiom ax : axioms) {
            Set annotations = ax.getAnnotations();
            annos.add(new TreeSet(annotations));
        }
        return annos;
    }
}

