/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.coode.xml.IllegalElementNameException;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterNamespaceManager;
import org.coode.xml.XMLWriterPreferences;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class XMLWriterImpl
implements XMLWriter {
    private final XMLWriterPreferences instance = XMLWriterPreferences.getInstance();
    private Stack<XMLElement> elementStack;
    protected Writer writer;
    private String encoding = "";
    private String xmlBase;
    private URI xmlBaseURI;
    private XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map<String, String> entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = Integer.MAX_VALUE;
    private boolean preambleWritten;
    private static final String PERCENT_ENTITY = "&#37;";

    public XMLWriterImpl(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager, String xmlBase) {
        this.writer = writer;
        this.xmlWriterNamespaceManager = xmlWriterNamespaceManager;
        this.xmlBase = xmlBase;
        this.xmlBaseURI = URI.create(xmlBase);
        this.elementStack = new Stack();
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList<String> namespaces = new ArrayList<String>(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(namespaces, new StringLengthOnlyComparator());
        this.entities = new LinkedHashMap<String, String>();
        for (String curNamespace : namespaces) {
            String curPrefix = "";
            curPrefix = this.xmlWriterNamespaceManager.getDefaultNamespace().equals(curNamespace) ? this.xmlWriterNamespaceManager.getDefaultPrefix() : this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
            if (curPrefix.length() <= 0) continue;
            this.entities.put(curNamespace, "&" + curPrefix + ";");
        }
    }

    protected String swapForEntity(String value) {
        for (String curEntity : this.entities.keySet()) {
            String repVal;
            String entityVal = this.entities.get(curEntity);
            if (value.length() <= curEntity.length() || (repVal = value.replace(curEntity, entityVal)).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    @Override
    public String getXMLBase() {
        return this.xmlBase;
    }

    public URI getXMLBaseAsURI() {
        return this.xmlBaseURI;
    }

    @Override
    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private boolean isValidQName(String name) {
        if (name == null) {
            return false;
        }
        int colonIndex = name.indexOf(":");
        boolean valid = false;
        if (colonIndex == -1) {
            valid = OWL2Datatype.XSD_NCNAME.getPattern().matcher(name).matches();
        } else {
            valid = OWL2Datatype.XSD_NCNAME.getPattern().matcher(name.substring(0, colonIndex - 1)).matches();
            if (valid) {
                valid = OWL2Datatype.XSD_NAME.getPattern().matcher(name.substring(colonIndex + 1)).matches();
            }
        }
        return valid;
    }

    @Override
    public void setWrapAttributes(boolean b) {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    @Override
    public void writeStartElement(String name) throws IOException {
        XMLElement topElement;
        String qName = this.xmlWriterNamespaceManager.getQName(name);
        if ((qName == null || qName.equals(name)) && !this.isValidQName(name)) {
            throw new IllegalElementNameException(name);
        }
        XMLElement element = new XMLElement(qName, this.elementStack.size());
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    @Override
    public void writeStartElement(IRI name) throws IOException {
        XMLElement topElement;
        String qName = this.xmlWriterNamespaceManager.getQName(name);
        if (!XMLUtils.isQName((CharSequence)qName)) {
            throw new IllegalElementNameException(name.toString());
        }
        XMLElement element = new XMLElement(qName, this.elementStack.size());
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    @Override
    public void writeEndElement() throws IOException {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    @Override
    public void writeAttribute(String attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        if (qName != null) {
            element.setAttribute(qName, val);
        }
    }

    @Override
    public void writeAttribute(IRI attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        if (qName != null) {
            element.setAttribute(qName, val);
        }
    }

    @Override
    public void writeTextContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setText(text);
    }

    @Override
    public void writeComment(String commentText) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(null, this.elementStack.size());
        element.setText("<!-- " + commentText.replace("--", "&#45;&#45;") + " -->");
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        if (this.preambleWritten) {
            element.writeElementStart(true);
        } else {
            this.elementStack.push(element);
        }
    }

    private void writeEntities(IRI rootName) throws IOException {
        String qName = this.xmlWriterNamespaceManager.getQName(rootName);
        if (qName == null) {
            throw new IOException("Cannot create valid XML: qname for " + rootName + " is null");
        }
        this.writer.write("\n\n<!DOCTYPE " + qName + " [\n");
        for (String entityVal : this.entities.keySet()) {
            String entity = this.entities.get(entityVal);
            entity = entity.substring(1, entity.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(entity);
            this.writer.write(" \"");
            entityVal = XMLUtils.escapeXML((CharSequence)entityVal);
            entityVal = entityVal.replace("%", PERCENT_ENTITY);
            this.writer.write(entityVal);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    @Override
    public void startDocument(String rootElementName) throws IOException {
        this.startDocument(IRI.create((String)rootElementName));
    }

    @Override
    public void startDocument(IRI rootElement) throws IOException {
        String encodingString = "";
        if (this.encoding.length() > 0) {
            encodingString = " encoding=\"" + this.encoding + "\"";
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (this.instance.isUseNamespaceEntities()) {
            this.writeEntities(rootElement);
        }
        this.preambleWritten = true;
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().writeElementStart(true);
        }
        this.writeStartElement(rootElement);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (this.xmlBase.length() != 0) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            if (curPrefix.length() <= 0) continue;
            this.writeAttribute("xmlns:" + curPrefix, this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix));
        }
    }

    @Override
    public void endDocument() throws IOException {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.writer.flush();
    }

    public class XMLElement {
        private String name;
        private Map<String, String> attributes;
        String textContent;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;

        public XMLElement(String name) {
            this(name, 0);
            this.wrapAttributes = false;
        }

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.attributes = new LinkedHashMap<String, String>();
            this.indentation = indentation;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = b;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content) {
            this.textContent = content;
        }

        public void writeElementStart(boolean close) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                if (this.name != null) {
                    XMLWriterImpl.this.writer.write(60);
                    XMLWriterImpl.this.writer.write(this.name);
                    this.writeAttributes();
                    if (this.textContent != null) {
                        boolean wrap;
                        boolean bl = wrap = this.textContent.length() > Integer.MAX_VALUE;
                        if (wrap) {
                            this.writeNewLine();
                            ++this.indentation;
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(62);
                        this.writeTextContent();
                        if (wrap) {
                            --this.indentation;
                        }
                    }
                    if (close) {
                        if (this.textContent != null) {
                            this.writeElementEnd();
                        } else {
                            XMLWriterImpl.this.writer.write("/>");
                            this.writeNewLine();
                        }
                    } else if (this.textContent == null) {
                        XMLWriterImpl.this.writer.write(62);
                        this.writeNewLine();
                    }
                } else if (this.textContent != null) {
                    XMLWriterImpl.this.writer.write("\n\n\n");
                    StringTokenizer tokenizer = new StringTokenizer(this.textContent, "\n", true);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals("\n")) {
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(token);
                    }
                    XMLWriterImpl.this.writer.write("\n\n");
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (this.name != null) {
                if (!this.startWritten) {
                    this.writeElementStart(true);
                } else {
                    if (this.textContent == null) {
                        this.insertIndentation();
                    }
                    XMLWriterImpl.this.writer.write("</");
                    XMLWriterImpl.this.writer.write(this.name);
                    XMLWriterImpl.this.writer.write(">");
                    this.writeNewLine();
                }
            }
        }

        private void writeAttribute(String attr, String val) throws IOException {
            XMLWriterImpl.this.writer.write(attr);
            XMLWriterImpl.this.writer.write(61);
            XMLWriterImpl.this.writer.write(34);
            if (XMLWriterImpl.this.instance.isUseNamespaceEntities()) {
                XMLWriterImpl.this.writer.write(XMLWriterImpl.this.swapForEntity(XMLUtils.escapeXML((CharSequence)val)));
            } else {
                XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)val));
            }
            XMLWriterImpl.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator<String> it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = it.next();
                String val = this.attributes.get(attr);
                XMLWriterImpl.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                XMLWriterImpl.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)this.textContent));
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterImpl.this.instance.isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterImpl.this.instance.getIndentSize(); ++i) {
                    XMLWriterImpl.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() throws IOException {
            XMLWriterImpl.this.writer.write(10);
        }
    }

    private static final class StringLengthOnlyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    }
}

