/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owlapi.rdfxml.parser.AbstractResourceTripleHandler;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.ClassExpressionListItemTranslator;
import org.coode.owlapi.rdfxml.parser.ClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.DataAllValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.DataCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataHasValueTranslator;
import org.coode.owlapi.rdfxml.parser.DataMaxCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataMaxQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataMinCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataMinQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataPropertyListItemTranslator;
import org.coode.owlapi.rdfxml.parser.DataQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.DataRangeListItemTranslator;
import org.coode.owlapi.rdfxml.parser.DataSomeValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.GTPAnnotationLiteralHandler;
import org.coode.owlapi.rdfxml.parser.GTPAnnotationResourceTripleHandler;
import org.coode.owlapi.rdfxml.parser.GTPDataPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.GTPObjectPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.IRIProvider;
import org.coode.owlapi.rdfxml.parser.IndividualListItemTranslator;
import org.coode.owlapi.rdfxml.parser.Mode;
import org.coode.owlapi.rdfxml.parser.NamedClassTranslator;
import org.coode.owlapi.rdfxml.parser.OWLFacetRestrictionListItemTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectAllValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectComplementOfTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectHasSelfTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectHasValueTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectIntersectionOfTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMaxCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMaxQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMinCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectMinQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectOneOfTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectPropertyListItemTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectQualifiedCardinalityTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectSomeValuesFromTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectUnionOfTranslator;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.coode.owlapi.rdfxml.parser.SWRLRuleTranslator;
import org.coode.owlapi.rdfxml.parser.TPAllValuesFromHandler;
import org.coode.owlapi.rdfxml.parser.TPAnnotatedPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPAnnotatedSourceHandler;
import org.coode.owlapi.rdfxml.parser.TPAnnotatedTargetHandler;
import org.coode.owlapi.rdfxml.parser.TPComplementOfHandler;
import org.coode.owlapi.rdfxml.parser.TPDatatypeComplementOfHandler;
import org.coode.owlapi.rdfxml.parser.TPDeclaredAsHandler;
import org.coode.owlapi.rdfxml.parser.TPDifferentFromHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointUnionHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointWithHandler;
import org.coode.owlapi.rdfxml.parser.TPDistinctMembersHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentClassHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPFirstLiteralHandler;
import org.coode.owlapi.rdfxml.parser.TPFirstResourceHandler;
import org.coode.owlapi.rdfxml.parser.TPHasKeyHandler;
import org.coode.owlapi.rdfxml.parser.TPImportsHandler;
import org.coode.owlapi.rdfxml.parser.TPIntersectionOfHandler;
import org.coode.owlapi.rdfxml.parser.TPInverseOfHandler;
import org.coode.owlapi.rdfxml.parser.TPOnClassHandler;
import org.coode.owlapi.rdfxml.parser.TPOnDataRangeHandler;
import org.coode.owlapi.rdfxml.parser.TPOnPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPOneOfHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyChainAxiomHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyDisjointWithHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyDomainHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyRangeHandler;
import org.coode.owlapi.rdfxml.parser.TPRestHandler;
import org.coode.owlapi.rdfxml.parser.TPSameAsHandler;
import org.coode.owlapi.rdfxml.parser.TPSomeValuesFromHandler;
import org.coode.owlapi.rdfxml.parser.TPSubClassOfHandler;
import org.coode.owlapi.rdfxml.parser.TPSubPropertyOfHandler;
import org.coode.owlapi.rdfxml.parser.TPTypeHandler;
import org.coode.owlapi.rdfxml.parser.TPUnionOfHandler;
import org.coode.owlapi.rdfxml.parser.TPVersionIRIHandler;
import org.coode.owlapi.rdfxml.parser.TranslatedUnloadedImportException;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDifferentHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDisjointClassesHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDisjointPropertiesHandler;
import org.coode.owlapi.rdfxml.parser.TypeAnnotationHandler;
import org.coode.owlapi.rdfxml.parser.TypeAnnotationPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeAsymmetricPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeAxiomHandler;
import org.coode.owlapi.rdfxml.parser.TypeClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeDataPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeDataRangeHandler;
import org.coode.owlapi.rdfxml.parser.TypeDatatypeHandler;
import org.coode.owlapi.rdfxml.parser.TypeDeprecatedClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeDeprecatedPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeFunctionalPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeInverseFunctionalPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeIrreflexivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeListHandler;
import org.coode.owlapi.rdfxml.parser.TypeNamedIndividualHandler;
import org.coode.owlapi.rdfxml.parser.TypeNegativeDataPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.TypeNegativePropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.TypeObjectPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeOntologyHandler;
import org.coode.owlapi.rdfxml.parser.TypeOntologyPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeRDFSClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeReflexivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLAtomListHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLBuiltInAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLBuiltInHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLClassAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDataRangeAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDataValuedPropertyAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDifferentIndividualsAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLImpHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLIndividualPropertyAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLSameIndividualAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLVariableHandler;
import org.coode.owlapi.rdfxml.parser.TypeSelfRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeSymmetricPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeTransitivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypedConstantListItemTranslator;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFParserMetaData;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceParseError;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAnonymousIndividualByIdProvider;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rdf.syntax.RDFConsumer;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import org.xml.sax.SAXException;

public class OWLRDFConsumer
implements RDFConsumer,
OWLAnonymousIndividualByIdProvider {
    private static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private static final Logger tripleProcessor = Logger.getLogger("Triple processor");
    private OWLOntologyLoaderConfiguration configuration;
    private OWLOntologyManager owlOntologyManager;
    private AnonymousNodeChecker anonymousNodeChecker;
    private Set<IRI> classExpressionIRIs;
    private Set<IRI> objectPropertyExpressionIRIs;
    private Set<IRI> dataPropertyExpressionIRIs;
    private Set<IRI> propertyIRIs;
    private Set<IRI> individualIRIs;
    private Set<IRI> annotationPropertyIRIs;
    private Set<IRI> annotationIRIs;
    private Set<IRI> dataRangeIRIs;
    private IRI firstOntologyIRI;
    private Set<IRI> ontologyIRIs;
    private Set<IRI> restrictionIRIs;
    private Map<IRI, IRI> listRestTripleMap;
    private Map<IRI, IRI> listFirstResourceTripleMap;
    private Map<IRI, OWLLiteral> listFirstLiteralTripleMap;
    private Set<IRI> axioms = new HashSet<IRI>();
    private Map<IRI, Object> sharedAnonymousNodes = new HashMap<IRI, Object>();
    private OptimisedListTranslator<OWLClassExpression> classExpressionListTranslator;
    private OptimisedListTranslator<OWLIndividual> individualListTranslator;
    private OptimisedListTranslator<OWLObjectPropertyExpression> objectPropertyListTranslator;
    private OptimisedListTranslator<OWLLiteral> constantListTranslator;
    private OptimisedListTranslator<OWLDataPropertyExpression> dataPropertyListTranslator;
    private OptimisedListTranslator<OWLDataRange> dataRangeListTranslator;
    private OptimisedListTranslator<OWLFacetRestriction> faceRestrictionListTranslator;
    private Map<IRI, BuiltInTypeHandler> builtInTypeTripleHandlers;
    protected Map<IRI, BuiltInTypeHandler> axiomTypeTripleHandlers = new HashMap<IRI, BuiltInTypeHandler>();
    private Map<IRI, TriplePredicateHandler> predicateHandlers;
    protected List<AbstractLiteralTripleHandler> literalTripleHandlers;
    protected List<AbstractResourceTripleHandler> resourceTripleHandlers;
    private Set<OWLAnnotation> pendingAnnotations = new HashSet<OWLAnnotation>();
    private Map<IRI, Set<IRI>> annotatedAnonSource2AnnotationMap = new HashMap<IRI, Set<IRI>>();
    private OWLOntology ontology;
    private int expectedAxioms = -1;
    private int parsedAxioms = 0;
    private RDFOntologyFormat ontologyFormat;
    private OWLDataFactory dataFactory;
    private List<ClassExpressionTranslator> classExpressionTranslators = new ArrayList<ClassExpressionTranslator>();
    private OWLAxiom lastAddedAxiom;
    private Map<IRI, IRI> synonymMap;
    private Set<IRI> swrlRules;
    private Set<IRI> swrlIndividualPropertyAtoms;
    private Set<IRI> swrlDataValuedPropertyAtoms;
    private Set<IRI> swrlClassAtoms;
    private Set<IRI> swrlDataRangeAtoms;
    private Set<IRI> swrlBuiltInAtoms;
    private Set<IRI> swrlVariables;
    private Set<IRI> swrlSameAsAtoms;
    private Set<IRI> swrlDifferentFromAtoms;
    private IRIProvider iriProvider;
    protected TPInverseOfHandler inverseOfHandler;
    private TPTypeHandler nonBuiltInTypeHandler;
    private Collection<OWLAnnotationAxiom> parsedAnnotationAxioms = new ArrayList<OWLAnnotationAxiom>();
    private Collection<OWLAxiom> axiomsToBeRemoved = new ArrayList<OWLAxiom>();
    private boolean parsedAllTriples = false;
    protected RemappingIndividualProvider anonProvider;
    private static final String DAML_OIL = "http://www.daml.org/2001/03/daml+oil#";
    private Map<String, IRI> IRIMap = CollectionFactory.createMap();
    int currentBaseCount = 0;
    private int lastPercentParsed = 0;
    private int count = 0;
    private Map<IRI, OWLObjectPropertyExpression> translatedProperties = new HashMap<IRI, OWLObjectPropertyExpression>();
    private Map<IRI, OWLClassExpression> translatedClassExpression = new HashMap<IRI, OWLClassExpression>();
    private static final AtomicInteger errorCounter = new AtomicInteger(0);
    private Map<IRI, Map<IRI, Collection<IRI>>> resTriplesBySubject = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, IRI>> singleValuedResTriplesByPredicate = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, Collection<OWLLiteral>>> litTriplesBySubject = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, OWLLiteral>> singleValuedLitTriplesByPredicate = CollectionFactory.createMap();
    private final Map<IRI, IRI> remappedIRIs = CollectionFactory.createMap();
    private final Map<String, IRI> remappedIRIStrings = CollectionFactory.createMap();

    public OWLRDFConsumer(OWLOntology ontology, AnonymousNodeChecker checker, OWLOntologyLoaderConfiguration configuration) {
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.dataFactory = this.owlOntologyManager.getOWLDataFactory();
        this.anonProvider = new RemappingIndividualProvider(this.dataFactory);
        this.anonymousNodeChecker = checker;
        this.configuration = configuration;
        this.classExpressionTranslators.add(new NamedClassTranslator(this));
        this.classExpressionTranslators.add(new ObjectIntersectionOfTranslator(this));
        this.classExpressionTranslators.add(new ObjectUnionOfTranslator(this));
        this.classExpressionTranslators.add(new ObjectComplementOfTranslator(this));
        this.classExpressionTranslators.add(new ObjectOneOfTranslator(this));
        this.classExpressionTranslators.add(new ObjectSomeValuesFromTranslator(this));
        this.classExpressionTranslators.add(new ObjectAllValuesFromTranslator(this));
        this.classExpressionTranslators.add(new ObjectHasValueTranslator(this));
        this.classExpressionTranslators.add(new ObjectHasSelfTranslator(this));
        this.classExpressionTranslators.add(new ObjectMinQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new ObjectMaxQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new ObjectQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new ObjectMinCardinalityTranslator(this));
        this.classExpressionTranslators.add(new ObjectMaxCardinalityTranslator(this));
        this.classExpressionTranslators.add(new ObjectCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataSomeValuesFromTranslator(this));
        this.classExpressionTranslators.add(new DataAllValuesFromTranslator(this));
        this.classExpressionTranslators.add(new DataHasValueTranslator(this));
        this.classExpressionTranslators.add(new DataMinQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataMaxQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataQualifiedCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataMinCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataMaxCardinalityTranslator(this));
        this.classExpressionTranslators.add(new DataCardinalityTranslator(this));
        this.classExpressionIRIs = CollectionFactory.createSet();
        this.objectPropertyExpressionIRIs = CollectionFactory.createSet();
        this.dataPropertyExpressionIRIs = CollectionFactory.createSet();
        this.individualIRIs = CollectionFactory.createSet();
        this.annotationPropertyIRIs = CollectionFactory.createSet();
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.annotationPropertyIRIs.add(iri);
        }
        this.annotationIRIs = new HashSet<IRI>();
        this.dataRangeIRIs = CollectionFactory.createSet();
        this.propertyIRIs = CollectionFactory.createSet();
        this.restrictionIRIs = CollectionFactory.createSet();
        this.ontologyIRIs = CollectionFactory.createSet();
        this.listFirstLiteralTripleMap = CollectionFactory.createMap();
        this.listFirstResourceTripleMap = CollectionFactory.createMap();
        this.listRestTripleMap = CollectionFactory.createMap();
        this.classExpressionListTranslator = new OptimisedListTranslator<OWLClassExpression>(this, new ClassExpressionListItemTranslator(this));
        this.individualListTranslator = new OptimisedListTranslator<OWLIndividual>(this, new IndividualListItemTranslator(this));
        this.constantListTranslator = new OptimisedListTranslator<OWLLiteral>(this, new TypedConstantListItemTranslator(this));
        this.objectPropertyListTranslator = new OptimisedListTranslator<OWLObjectPropertyExpression>(this, new ObjectPropertyListItemTranslator(this));
        this.dataPropertyListTranslator = new OptimisedListTranslator<OWLDataPropertyExpression>(this, new DataPropertyListItemTranslator(this));
        this.dataRangeListTranslator = new OptimisedListTranslator<OWLDataRange>(this, new DataRangeListItemTranslator(this));
        this.faceRestrictionListTranslator = new OptimisedListTranslator<OWLFacetRestriction>(this, new OWLFacetRestrictionListItemTranslator(this));
        this.builtInTypeTripleHandlers = CollectionFactory.createMap();
        this.setupTypeTripleHandlers();
        this.setupPredicateHandlers();
        this.literalTripleHandlers = new ArrayList<AbstractLiteralTripleHandler>();
        this.literalTripleHandlers.add(new GTPDataPropertyAssertionHandler(this));
        this.literalTripleHandlers.add(new TPFirstLiteralHandler(this));
        this.literalTripleHandlers.add(new GTPAnnotationLiteralHandler(this));
        this.resourceTripleHandlers = new ArrayList<AbstractResourceTripleHandler>();
        this.resourceTripleHandlers.add(new GTPObjectPropertyAssertionHandler(this));
        this.resourceTripleHandlers.add(new GTPAnnotationResourceTripleHandler(this));
        for (OWL2Datatype oWL2Datatype : OWL2Datatype.values()) {
            this.dataRangeIRIs.add(oWL2Datatype.getIRI());
        }
        this.dataRangeIRIs.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        if (!configuration.isStrict()) {
            for (OWL2Datatype oWL2Datatype : XSDVocabulary.values()) {
                this.dataRangeIRIs.add(oWL2Datatype.getIRI());
            }
        }
        this.swrlRules = new HashSet<IRI>();
        this.swrlIndividualPropertyAtoms = new HashSet<IRI>();
        this.swrlDataValuedPropertyAtoms = new HashSet<IRI>();
        this.swrlClassAtoms = new HashSet<IRI>();
        this.swrlDataRangeAtoms = new HashSet<IRI>();
        this.swrlBuiltInAtoms = new HashSet<IRI>();
        this.swrlVariables = new HashSet<IRI>();
        this.swrlSameAsAtoms = new HashSet<IRI>();
        this.swrlDifferentFromAtoms = new HashSet<IRI>();
        this.classExpressionIRIs.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.classExpressionIRIs.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.objectPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
        this.objectPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
        this.dataPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
        this.dataPropertyExpressionIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
        this.setupSynonymMap();
        this.setupSinglePredicateMaps();
        this.importsClosureChanged();
        if (this.ontology.getOntologyID().getOntologyIRI() != null) {
            this.addOntology(this.ontology.getOntologyID().getOntologyIRI());
        }
    }

    @Deprecated
    public OWLRDFConsumer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, AnonymousNodeChecker checker, OWLOntologyLoaderConfiguration configuration) {
        this(ontology, checker, configuration);
    }

    @Override
    public void addPrefix(String abbreviation, String value) {
        if (this.ontologyFormat.isPrefixOWLOntologyFormat()) {
            this.ontologyFormat.asPrefixOWLOntologyFormat().setPrefix(abbreviation, value);
        }
    }

    public void setIRIProvider(IRIProvider iriProvider) {
        this.iriProvider = iriProvider;
    }

    private void addSingleValuedResPredicate(OWLRDFVocabulary v) {
        Map map = CollectionFactory.createMap();
        this.singleValuedResTriplesByPredicate.put(v.getIRI(), map);
    }

    private void setupSinglePredicateMaps() {
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_PROPERTY);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_CLASS);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_DATA_RANGE);
    }

    private void setupSynonymMap() {
        this.synonymMap = CollectionFactory.createMap();
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)"valuesFrom"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        if (!this.configuration.isStrict()) {
            this.addDAMLOILVocabulary();
            this.addIntermediateOWLSpecVocabulary();
        }
    }

    private void addDAMLOILVocabulary() {
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"subClassOf"), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"imports"), OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"range"), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasValue"), OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"type"), OWLRDFVocabulary.RDF_TYPE.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"domain"), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"versionInfo"), OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"comment"), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"onProperty"), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"toClass"), OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasClass"), OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Restriction"), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Class"), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Thing"), OWLRDFVocabulary.OWL_THING.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"Nothing"), OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"minCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"cardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"maxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"inverseOf"), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"samePropertyAs"), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"hasClassQ"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"cardinalityQ"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"maxCardinalityQ"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"minCardinalityQ"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"complementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"unionOf"), OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"intersectionOf"), OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"label"), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"ObjectProperty"), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create((String)DAML_OIL, (String)"DatatypeProperty"), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
    }

    private void addIntermediateOWLSpecVocabulary() {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            this.addLegacyMapping(oWLRDFVocabulary);
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLFacet.values()) {
            this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)oWLRDFVocabulary.getShortName()), oWLRDFVocabulary.getIRI());
            this.synonymMap.put(IRI.create((String)Namespaces.OWL11.toString(), (String)oWLRDFVocabulary.getShortName()), oWLRDFVocabulary.getIRI());
            this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)oWLRDFVocabulary.getShortName()), oWLRDFVocabulary.getIRI());
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLFacet.values()) {
            this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)oWLRDFVocabulary.getShortName()), oWLRDFVocabulary.getIRI());
        }
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_PREDICATE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)"cardinalityType"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL.toString(), (String)"dataComplementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_ANTI_SYMMETRIC_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_FUNCTIONAL_DATA_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_FUNCTIONAL_OBJECT_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_FUNCTIONAL_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUB_DATA_PROPERTY_OF.getIRI(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUB_OBJECT_PROPERTY_OF.getIRI(), OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_PROPERTY_RANGE.getIRI(), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_PROPERTY_RANGE.getIRI(), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_PROPERTY_DOMAIN.getIRI(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_PROPERTY_DOMAIN.getIRI(), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DISJOINT_DATA_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DISJOINT_OBJECT_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_PROPERTY_DISJOINT_WITH.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_EQUIVALENT_DATA_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_EQUIVALENT_OBJECT_PROPERTIES.getIRI(), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT_RESTRICTION.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RESTRICTION.getIRI(), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_PREDICATE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
    }

    private void addLegacyMapping(OWLRDFVocabulary v) {
        this.synonymMap.put(IRI.create((String)Namespaces.OWL2.toString(), (String)v.getShortName()), v.getIRI());
        this.synonymMap.put(IRI.create((String)Namespaces.OWL11.toString(), (String)v.getShortName()), v.getIRI());
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public RDFOntologyFormat getOntologyFormat() {
        return this.ontologyFormat;
    }

    public void setOntologyFormat(RDFOntologyFormat format) {
        this.ontologyFormat = format;
    }

    public void setExpectedAxioms(int expectedAxioms) {
        this.expectedAxioms = expectedAxioms;
    }

    private void addBuiltInTypeTripleHandler(BuiltInTypeHandler handler) {
        this.builtInTypeTripleHandlers.put(handler.getTypeIRI(), handler);
    }

    private void addAxiomTypeTripleHandler(BuiltInTypeHandler handler) {
        this.axiomTypeTripleHandlers.put(handler.getTypeIRI(), handler);
    }

    private void setupTypeTripleHandlers() {
        this.setupBasicTypeHandlers();
        this.setupAxiomTypeHandlers();
    }

    private void setupBasicTypeHandlers() {
        this.addBuiltInTypeTripleHandler(new TypeOntologyPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAsymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeObjectPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDatatypeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeInverseFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeIrreflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeReflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeTransitivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeListHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAnnotationPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDeprecatedClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDeprecatedPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataRangeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeOntologyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNegativeDataPropertyAssertionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRDFSClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSelfRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNamedIndividualHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAnnotationHandler(this));
        if (!this.configuration.isStrict()) {
            this.addBuiltInTypeTripleHandler(new TypeSWRLAtomListHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLClassAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLDataRangeAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLDataValuedPropertyAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLDifferentIndividualsAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLImpHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLIndividualPropertyAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLSameIndividualAtomHandler(this));
            this.addBuiltInTypeTripleHandler(new TypeSWRLVariableHandler(this));
        }
    }

    private void setupAxiomTypeHandlers() {
        this.addAxiomTypeTripleHandler(new TypeAxiomHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDifferentHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDisjointClassesHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDisjointPropertiesHandler(this));
        this.addAxiomTypeTripleHandler(new TypeNegativePropertyAssertionHandler(this));
    }

    private void addPredicateHandler(TriplePredicateHandler predicateHandler) {
        this.predicateHandlers.put(predicateHandler.getPredicateIRI(), predicateHandler);
    }

    private void setupPredicateHandlers() {
        this.predicateHandlers = CollectionFactory.createMap();
        this.addPredicateHandler(new TPDifferentFromHandler(this));
        this.addPredicateHandler(new TPDisjointUnionHandler(this));
        this.addPredicateHandler(new TPDisjointWithHandler(this));
        this.addPredicateHandler(new TPEquivalentClassHandler(this));
        this.addPredicateHandler(new TPEquivalentPropertyHandler(this));
        this.addPredicateHandler(new TPPropertyDomainHandler(this));
        this.addPredicateHandler(new TPPropertyRangeHandler(this));
        this.addPredicateHandler(new TPSameAsHandler(this));
        this.addPredicateHandler(new TPSubClassOfHandler(this));
        this.addPredicateHandler(new TPSubPropertyOfHandler(this));
        this.nonBuiltInTypeHandler = new TPTypeHandler(this);
        this.addPredicateHandler(this.nonBuiltInTypeHandler);
        this.addPredicateHandler(new TPDistinctMembersHandler(this));
        this.addPredicateHandler(new TPImportsHandler(this));
        this.addPredicateHandler(new TPIntersectionOfHandler(this));
        this.addPredicateHandler(new TPUnionOfHandler(this));
        this.addPredicateHandler(new TPComplementOfHandler(this));
        this.addPredicateHandler(new TPOneOfHandler(this));
        this.addPredicateHandler(new TPSomeValuesFromHandler(this));
        this.addPredicateHandler(new TPAllValuesFromHandler(this));
        this.addPredicateHandler(new TPRestHandler(this));
        this.addPredicateHandler(new TPFirstResourceHandler(this));
        this.addPredicateHandler(new TPDeclaredAsHandler(this));
        this.addPredicateHandler(new TPHasKeyHandler(this));
        this.addPredicateHandler(new TPVersionIRIHandler(this));
        this.addPredicateHandler(new TPPropertyChainAxiomHandler(this));
        this.addPredicateHandler(new TPAnnotatedSourceHandler(this));
        this.addPredicateHandler(new TPAnnotatedPropertyHandler(this));
        this.addPredicateHandler(new TPAnnotatedTargetHandler(this));
        this.addPredicateHandler(new TPPropertyDisjointWithHandler(this));
        this.inverseOfHandler = new TPInverseOfHandler(this);
        this.addPredicateHandler(this.inverseOfHandler);
        this.addPredicateHandler(new TPOnPropertyHandler(this));
        this.addPredicateHandler(new TPOnClassHandler(this));
        this.addPredicateHandler(new TPOnDataRangeHandler(this));
        this.addPredicateHandler(new TPComplementOfHandler(this));
        this.addPredicateHandler(new TPDatatypeComplementOfHandler(this));
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public Set<OWLAnnotation> getPendingAnnotations() {
        if (!this.pendingAnnotations.isEmpty()) {
            HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>(this.pendingAnnotations);
            this.pendingAnnotations.clear();
            return annos;
        }
        return Collections.emptySet();
    }

    public void setPendingAnnotations(Set<OWLAnnotation> annotations) {
        if (!this.pendingAnnotations.isEmpty()) {
            for (OWLAnnotation ann : this.pendingAnnotations) {
                logger.severe(ann.toString());
            }
            throw new OWLRuntimeException(this.pendingAnnotations.size() + " pending annotations should have been used by now.");
        }
        this.pendingAnnotations.addAll(annotations);
    }

    private IRI getIRI(String s) {
        IRI iri = null;
        if (this.iriProvider != null) {
            iri = this.iriProvider.getIRI(s);
        }
        if (iri != null) {
            return iri;
        }
        iri = this.IRIMap.get(s);
        if (iri == null) {
            iri = IRI.create((String)s);
            this.IRIMap.put(s, iri);
        }
        return iri;
    }

    public void importsClosureChanged() {
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            for (OWLAnnotationProperty prop : ont.getAnnotationPropertiesInSignature()) {
                this.annotationPropertyIRIs.add(prop.getIRI());
            }
            for (OWLAnnotationProperty prop : ont.getDataPropertiesInSignature()) {
                this.dataPropertyExpressionIRIs.add(prop.getIRI());
            }
            for (OWLAnnotationProperty prop : ont.getObjectPropertiesInSignature()) {
                this.objectPropertyExpressionIRIs.add(prop.getIRI());
            }
            for (OWLClass cls : ont.getClassesInSignature()) {
                this.classExpressionIRIs.add(cls.getIRI());
            }
            for (OWLDatatype datatype : ont.getDatatypesInSignature()) {
                this.dataRangeIRIs.add(datatype.getIRI());
            }
            for (OWLNamedIndividual ind : ont.getIndividualsInSignature()) {
                this.individualIRIs.add(ind.getIRI());
            }
        }
    }

    private boolean isOWLImportsTriple(RDFTriple triple) {
        return triple.getPredicate().getResource().equals((Object)OWLRDFVocabulary.OWL_IMPORTS.getIRI());
    }

    private void processRDFTriple(RDFTriple triple) throws UnloadableImportException {
        RDFResource subject = triple.getSubject();
        RDFResource predicate = triple.getPredicate();
        RDFNode object = triple.getObject();
        if (object.isLiteral()) {
            RDFLiteral literalObject = (RDFLiteral)object;
            this.handleStreaming(subject.getResource(), predicate.getResource(), literalObject.getLiteral());
        } else {
            RDFResource resourceObject = (RDFResource)object;
            this.handleStreaming(subject.getResource(), predicate.getResource(), resourceObject.getResource());
        }
    }

    private Set<RDFTriple> getUnconsumedTriplesFromImportsClosure() {
        HashSet<RDFTriple> unparsedTriples = new HashSet<RDFTriple>();
        Set imports = this.ontology.getImports();
        for (OWLOntology ont : imports) {
            unparsedTriples.addAll(this.getUnconsumedTriples(ont));
        }
        return unparsedTriples;
    }

    private Set<RDFTriple> getUnconsumedTriples(OWLOntology ont) {
        HashSet<RDFTriple> unparsedTriples = new HashSet<RDFTriple>();
        OWLOntologyManager man = ont.getOWLOntologyManager();
        OWLOntologyFormat format = man.getOntologyFormat(ont);
        if (format instanceof RDFOntologyFormat) {
            RDFOntologyFormat rdfFormat = (RDFOntologyFormat)format;
            RDFParserMetaData metaData = rdfFormat.getOntologyLoaderMetaData();
            unparsedTriples.addAll(metaData.getUnparsedTriples());
        }
        return unparsedTriples;
    }

    protected boolean isAnonymousNode(IRI iri) {
        return this.anonymousNodeChecker.isAnonymousNode(iri);
    }

    protected boolean isSharedAnonymousNode(IRI iri) {
        return this.anonymousNodeChecker.isAnonymousSharedNode(iri.toString());
    }

    protected void addSharedAnonymousNode(IRI iri, Object translation) {
        this.sharedAnonymousNodes.put(iri, translation);
    }

    protected Object getSharedAnonymousNode(IRI iri) {
        return this.sharedAnonymousNodes.get(iri);
    }

    protected void addAxiom(OWLAxiom axiom) {
        if (this.expectedAxioms > 0) {
            ++this.parsedAxioms;
            int percentParsed = (int)((double)this.parsedAxioms * 100.0 / (double)this.expectedAxioms);
            if (this.lastPercentParsed != percentParsed) {
                this.lastPercentParsed = percentParsed;
            }
        }
        if (axiom.isAnnotationAxiom()) {
            if (this.configuration.isLoadAnnotationAxioms()) {
                this.parsedAnnotationAxioms.add((OWLAnnotationAxiom)axiom);
            }
        } else {
            this.owlOntologyManager.addAxiom(this.ontology, axiom);
        }
        this.lastAddedAxiom = axiom;
    }

    protected void removeAxiom(OWLAxiom axiom) {
        this.axiomsToBeRemoved.add(axiom);
    }

    protected void checkForAndProcessAnnotatedDeclaration(IRI mainNode) throws UnloadableImportException {
        IRI annotatedPropertyObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, false);
        if (annotatedPropertyObject == null) {
            return;
        }
        boolean rdfTypePredicate = annotatedPropertyObject.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI());
        if (!rdfTypePredicate) {
            return;
        }
        IRI annotatedTargetObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_TARGET, false);
        if (annotatedTargetObject == null) {
            return;
        }
        IRI annotatedSubjectObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE, false);
        if (annotatedSubjectObject == null) {
            return;
        }
        boolean isEntityType = this.isEntityTypeIRI(annotatedTargetObject);
        if (isEntityType) {
            this.handle(annotatedSubjectObject, annotatedPropertyObject, annotatedTargetObject);
        }
    }

    private boolean isEntityTypeIRI(IRI iri) {
        return iri.equals((Object)OWLRDFVocabulary.OWL_CLASS.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.RDFS_DATATYPE.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
    }

    protected void applyChange(OWLOntologyChange change) {
        this.owlOntologyManager.applyChange(change);
    }

    protected void setOntologyID(OWLOntologyID ontologyID) {
        this.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, ontologyID));
    }

    protected void addOntologyAnnotation(OWLAnnotation annotation) {
        this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, annotation));
    }

    protected void addImport(OWLImportsDeclaration declaration) {
        this.applyChange((OWLOntologyChange)new AddImport(this.ontology, declaration));
    }

    public OWLAxiom getLastAddedAxiom() {
        return this.lastAddedAxiom;
    }

    protected boolean isIndividual(IRI iri) {
        return this.individualIRIs.contains(iri);
    }

    protected void addRDFProperty(IRI iri) {
        this.propertyIRIs.add(iri);
    }

    protected boolean isRDFProperty(IRI iri) {
        return this.propertyIRIs.contains(iri);
    }

    public void addClassExpression(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.classExpressionIRIs, explicitlyTyped);
    }

    public boolean isClassExpression(IRI iri) {
        return this.classExpressionIRIs.contains(iri);
    }

    public void addObjectProperty(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.objectPropertyExpressionIRIs, explicitlyTyped);
    }

    public void addDataProperty(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.dataPropertyExpressionIRIs, explicitlyTyped);
    }

    protected void addAnnotationProperty(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.annotationPropertyIRIs, explicitlyTyped);
    }

    public void addDataRange(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.dataRangeIRIs, explicitlyTyped);
    }

    protected void addOWLNamedIndividual(IRI iri, boolean explicitlyType) {
        this.addType(iri, this.individualIRIs, explicitlyType);
    }

    protected void addOWLRestriction(IRI iri, boolean explicitlyTyped) {
        this.addType(iri, this.restrictionIRIs, explicitlyTyped);
    }

    private void addType(IRI iri, Set<IRI> types, boolean explicitlyTyped) {
        if (this.configuration.isStrict()) {
            if (explicitlyTyped) {
                types.add(iri);
            }
        } else {
            types.add(iri);
        }
    }

    public boolean isRestriction(IRI iri) {
        return this.restrictionIRIs.contains(iri);
    }

    protected void addAnnotationIRI(IRI iri) {
        this.annotationIRIs.add(iri);
    }

    protected boolean isAnnotation(IRI iri) {
        return this.annotationIRIs.contains(iri);
    }

    protected boolean isObjectPropertyOnly(IRI iri) {
        return iri != null && !this.dataPropertyExpressionIRIs.contains(iri) && !this.annotationPropertyIRIs.contains(iri) && this.objectPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isObjectProperty(IRI iri) {
        return this.objectPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isDataPropertyOnly(IRI iri) {
        return iri != null && !this.objectPropertyExpressionIRIs.contains(iri) && !this.annotationPropertyIRIs.contains(iri) && this.dataPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isDataProperty(IRI iri) {
        return this.dataPropertyExpressionIRIs.contains(iri);
    }

    protected boolean isAnnotationPropertyOnly(IRI iri) {
        return iri != null && !this.objectPropertyExpressionIRIs.contains(iri) && !this.dataPropertyExpressionIRIs.contains(iri) && this.annotationPropertyIRIs.contains(iri);
    }

    protected boolean isAnnotationProperty(IRI iri) {
        return this.annotationPropertyIRIs.contains(iri);
    }

    protected boolean isOntology(IRI iri) {
        return this.ontologyIRIs.contains(iri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public void addAnnotatedSource(IRI annotatedAnonSource, IRI annotationMainNode) {
        Set<IRI> annotationMainNodes = this.annotatedAnonSource2AnnotationMap.get(annotatedAnonSource);
        if (annotationMainNodes == null) {
            annotationMainNodes = new HashSet<IRI>();
            this.annotatedAnonSource2AnnotationMap.put(annotatedAnonSource, annotationMainNodes);
        }
        annotationMainNodes.add(annotationMainNode);
    }

    public Set<IRI> getAnnotatedSourceAnnotationMainNodes(IRI source) {
        Set<IRI> mainNodes = this.annotatedAnonSource2AnnotationMap.get(source);
        if (mainNodes != null) {
            return mainNodes;
        }
        return Collections.emptySet();
    }

    protected OWLClass getOWLClass(IRI iri) {
        return this.getDataFactory().getOWLClass(iri);
    }

    protected OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.getDataFactory().getOWLObjectProperty(iri);
    }

    protected OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.getDataFactory().getOWLDataProperty(iri);
    }

    protected OWLIndividual getOWLIndividual(IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return this.getOWLAnonymousIndividual(iri.toString());
        }
        return this.dataFactory.getOWLNamedIndividual(iri);
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        return this.anonProvider.getOWLAnonymousIndividual(nodeId);
    }

    protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
        this.isTriplePresent(subject, predicate, object, true);
    }

    protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral con) {
        this.isTriplePresent(subject, predicate, con, true);
    }

    protected void addSWRLRule(IRI iri) {
        this.swrlRules.add(iri);
    }

    protected boolean isSWRLRule(IRI iri) {
        return this.swrlRules.contains(iri);
    }

    protected void addSWRLIndividualPropertyAtom(IRI iri) {
        this.swrlIndividualPropertyAtoms.add(iri);
    }

    protected boolean isSWRLIndividualPropertyAtom(IRI iri) {
        return this.swrlIndividualPropertyAtoms.contains(iri);
    }

    protected void addSWRLDataPropertyAtom(IRI iri) {
        this.swrlDataValuedPropertyAtoms.add(iri);
    }

    protected boolean isSWRLDataValuedPropertyAtom(IRI iri) {
        return this.swrlDataValuedPropertyAtoms.contains(iri);
    }

    protected void addSWRLClassAtom(IRI iri) {
        this.swrlClassAtoms.add(iri);
    }

    protected boolean isSWRLClassAtom(IRI iri) {
        return this.swrlClassAtoms.contains(iri);
    }

    protected void addSWRLSameAsAtom(IRI iri) {
        this.swrlSameAsAtoms.add(iri);
    }

    protected boolean isSWRLSameAsAtom(IRI iri) {
        return this.swrlSameAsAtoms.contains(iri);
    }

    protected void addSWRLDifferentFromAtom(IRI iri) {
        this.swrlDifferentFromAtoms.add(iri);
    }

    protected boolean isSWRLDifferentFromAtom(IRI iri) {
        return this.swrlDifferentFromAtoms.contains(iri);
    }

    protected void addSWRLDataRangeAtom(IRI iri) {
        this.swrlDataRangeAtoms.add(iri);
    }

    protected boolean isSWRLDataRangeAtom(IRI iri) {
        return this.swrlDataRangeAtoms.contains(iri);
    }

    protected void addSWRLBuiltInAtom(IRI iri) {
        this.swrlBuiltInAtoms.add(iri);
    }

    protected boolean isSWRLBuiltInAtom(IRI iri) {
        return this.swrlBuiltInAtoms.contains(iri);
    }

    protected void addSWRLVariable(IRI iri) {
        this.swrlVariables.add(iri);
    }

    protected boolean isSWRLVariable(IRI iri) {
        return this.swrlVariables.contains(iri);
    }

    public void handle(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        block5: {
            block3: {
                block4: {
                    if (!predicate.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI())) break block3;
                    BuiltInTypeHandler typeHandler = this.builtInTypeTripleHandlers.get(object);
                    if (typeHandler == null) break block4;
                    typeHandler.handleTriple(subject, predicate, object);
                    break block5;
                }
                if (this.axiomTypeTripleHandlers.get(object) != null) break block5;
                OWLIndividual ind = this.translateIndividual(subject);
                OWLClassExpression ce = this.translateClassExpression(object);
                this.addAxiom((OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom(ce, ind, this.getPendingAnnotations()));
                break block5;
            }
            AbstractResourceTripleHandler handler = this.predicateHandlers.get(predicate);
            if (handler != null && handler.canHandle(subject, predicate, object)) {
                handler.handleTriple(subject, predicate, object);
            } else {
                for (AbstractResourceTripleHandler resHandler : this.resourceTripleHandlers) {
                    if (!resHandler.canHandle(subject, predicate, object)) continue;
                    resHandler.handleTriple(subject, predicate, object);
                    break;
                }
            }
        }
    }

    public void handle(IRI subject, IRI predicate, OWLLiteral object) {
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandle(subject, predicate, object)) continue;
            handler.handleTriple(subject, predicate, object);
            break;
        }
    }

    private static void printTriple(Object subject, Object predicate, Object object) {
        logger.fine(subject + " -> " + predicate + " -> " + object);
    }

    protected void dumpRemainingTriples() {
        if (logger.isLoggable(Level.FINE)) {
            Collection objects;
            IRI object;
            Map<IRI, Object> map;
            for (IRI predicate : this.singleValuedResTriplesByPredicate.keySet()) {
                map = this.singleValuedResTriplesByPredicate.get(predicate);
                for (IRI subject : map.keySet()) {
                    object = map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object);
                }
            }
            for (IRI predicate : this.singleValuedLitTriplesByPredicate.keySet()) {
                map = this.singleValuedLitTriplesByPredicate.get(predicate);
                for (IRI subject : map.keySet()) {
                    object = (OWLLiteral)map.get(subject);
                    OWLRDFConsumer.printTriple(subject, predicate, object);
                }
            }
            for (IRI subject : new ArrayList<IRI>(this.resTriplesBySubject.keySet())) {
                map = this.resTriplesBySubject.get(subject);
                for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                    objects = (Collection)map.get(predicate);
                    for (IRI object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2);
                    }
                }
            }
            for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
                map = this.litTriplesBySubject.get(subject);
                for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                    objects = (Collection)map.get(predicate);
                    for (IRI object2 : objects) {
                        OWLRDFConsumer.printTriple(subject, predicate, object2);
                    }
                }
            }
        }
    }

    private void incrementTripleCount() {
        ++this.count;
        if (tripleProcessor.isLoggable(Level.FINE) && this.count % 10000 == 0) {
            tripleProcessor.fine("Parsed: " + this.count + " triples");
        }
    }

    @Override
    public void startModel(String string) throws SAXException {
        this.count = 0;
    }

    public boolean isParsedAllTriples() {
        return this.parsedAllTriples;
    }

    @Override
    public void endModel() throws SAXException {
        this.parsedAllTriples = true;
        try {
            IRI ontologyIRIToSet;
            this.IRIMap.clear();
            tripleProcessor.fine("Total number of triples: " + this.count);
            RDFOntologyFormat format = this.ontologyFormat;
            this.consumeSWRLRules();
            final TriplePredicateHandler propertyRangeHandler = this.predicateHandlers.get(OWLRDFVocabulary.RDFS_RANGE.getIRI());
            this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

                @Override
                public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                    if (propertyRangeHandler.canHandle(subject, predicate, object)) {
                        propertyRangeHandler.handleTriple(subject, predicate, object);
                    }
                }
            });
            this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

                @Override
                public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                    OWLRDFConsumer.this.handle(subject, predicate, object);
                }
            });
            this.iterateLiteralTriples(new LiteralTripleIterator<UnloadableImportException>(){

                @Override
                public void handleLiteralTriple(IRI subject, IRI predicate, OWLLiteral object) throws UnloadableImportException {
                    OWLRDFConsumer.this.handle(subject, predicate, object);
                }
            });
            this.inverseOfHandler.setAxiomParsingMode(true);
            this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

                @Override
                public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                    if (OWLRDFConsumer.this.inverseOfHandler.canHandle(subject, predicate, object)) {
                        OWLRDFConsumer.this.inverseOfHandler.handleTriple(subject, predicate, object);
                    }
                }
            });
            this.consumeNonReservedPredicateTriples();
            this.consumeAnnotatedAxioms();
            Set<RDFTriple> remainingTriples = this.getRemainingTriples();
            if (format != null) {
                RDFParserMetaData metaData = new RDFParserMetaData(RDFOntologyHeaderStatus.PARSED_ONE_HEADER, this.count, remainingTriples);
                format.setOntologyLoaderMetaData((OWLOntologyLoaderMetaData)metaData);
            }
            if ((ontologyIRIToSet = this.chooseOntologyIRI()) != null) {
                IRI versionIRI = this.ontology.getOntologyID().getVersionIRI();
                this.applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, new OWLOntologyID(ontologyIRIToSet, versionIRI)));
            }
            if (tripleProcessor.isLoggable(Level.FINE)) {
                tripleProcessor.fine("Loaded " + this.ontology.getOntologyID());
            }
            this.dumpRemainingTriples();
            this.cleanup();
            this.addAnnotationAxioms();
            this.removeAxiomsScheduledForRemoval();
        }
        catch (UnloadableImportException e) {
            throw new TranslatedUnloadedImportException(e);
        }
    }

    private void addAnnotationAxioms() {
        for (OWLAxiom oWLAxiom : this.parsedAnnotationAxioms) {
            this.owlOntologyManager.addAxiom(this.ontology, oWLAxiom);
        }
    }

    private void removeAxiomsScheduledForRemoval() {
        for (OWLAxiom axiom : this.axiomsToBeRemoved) {
            this.owlOntologyManager.removeAxiom(this.ontology, axiom);
        }
    }

    private Set<RDFTriple> getRemainingTriples() {
        final HashSet<RDFTriple> remainingTriples = new HashSet<RDFTriple>();
        this.iterateResourceTriples(new ResourceTripleIterator<OWLRuntimeException>(){

            @Override
            public void handleResourceTriple(IRI subject, IRI predicate, IRI object) {
                remainingTriples.add(new RDFTriple(subject, OWLRDFConsumer.this.isAnonymousNode(subject), predicate, OWLRDFConsumer.this.isAnonymousNode(predicate), object, OWLRDFConsumer.this.isAnonymousNode(object)));
            }
        });
        this.iterateLiteralTriples(new LiteralTripleIterator<RuntimeException>(){

            @Override
            public void handleLiteralTriple(IRI subject, IRI predicate, OWLLiteral object) {
                remainingTriples.add(new RDFTriple(subject, OWLRDFConsumer.this.isAnonymousNode(subject), predicate, OWLRDFConsumer.this.isAnonymousNode(predicate), object));
            }
        });
        return remainingTriples;
    }

    private void consumeNonReservedPredicateTriples() throws UnloadableImportException {
        this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

            @Override
            public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                if (OWLRDFConsumer.this.isGeneralPredicate(predicate)) {
                    for (AbstractResourceTripleHandler resTripHandler : OWLRDFConsumer.this.resourceTripleHandlers) {
                        if (!resTripHandler.canHandle(subject, predicate, object)) continue;
                        resTripHandler.handleTriple(subject, predicate, object);
                        break;
                    }
                }
            }
        });
        this.iterateLiteralTriples(new LiteralTripleIterator<UnloadableImportException>(){

            @Override
            public void handleLiteralTriple(IRI subject, IRI predicate, OWLLiteral object) throws UnloadableImportException {
                if (OWLRDFConsumer.this.isGeneralPredicate(predicate)) {
                    for (AbstractLiteralTripleHandler literalTripleHandler : OWLRDFConsumer.this.literalTripleHandlers) {
                        if (!literalTripleHandler.canHandle(subject, predicate, object)) continue;
                        literalTripleHandler.handleTriple(subject, predicate, object);
                        break;
                    }
                }
            }
        });
    }

    private void consumeSWRLRules() {
        SWRLRuleTranslator translator = new SWRLRuleTranslator(this);
        for (IRI ruleIRI : this.swrlRules) {
            translator.translateRule(ruleIRI);
        }
    }

    private void consumeAnnotatedAxioms() throws UnloadableImportException {
        this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

            @Override
            public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                BuiltInTypeHandler builtInTypeHandler = OWLRDFConsumer.this.axiomTypeTripleHandlers.get(object);
                if (builtInTypeHandler != null && builtInTypeHandler.canHandle(subject, predicate, object)) {
                    builtInTypeHandler.handleTriple(subject, predicate, object);
                }
            }
        });
    }

    private IRI chooseOntologyIRI() {
        IRI ontologyIRIToSet = null;
        if (!this.ontologyIRIs.isEmpty()) {
            if (this.ontologyIRIs.size() == 1) {
                IRI ontologyIRI = this.ontologyIRIs.iterator().next();
                if (!this.isAnonymousNode(ontologyIRI)) {
                    ontologyIRIToSet = ontologyIRI;
                }
            } else {
                HashSet<IRI> candidateIRIs = new HashSet<IRI>(this.ontologyIRIs);
                for (OWLAnnotation anno : this.ontology.getAnnotations()) {
                    IRI iri;
                    if (!(anno.getValue() instanceof IRI) || !this.ontologyIRIs.contains(iri = (IRI)anno.getValue())) continue;
                    candidateIRIs.remove(iri);
                }
                if (candidateIRIs.contains(this.firstOntologyIRI)) {
                    ontologyIRIToSet = this.firstOntologyIRI;
                } else if (!candidateIRIs.isEmpty()) {
                    ontologyIRIToSet = (IRI)candidateIRIs.iterator().next();
                }
            }
        }
        return ontologyIRIToSet;
    }

    private void cleanup() {
        this.classExpressionIRIs.clear();
        this.objectPropertyExpressionIRIs.clear();
        this.dataPropertyExpressionIRIs.clear();
        this.dataRangeIRIs.clear();
        this.restrictionIRIs.clear();
        this.listFirstLiteralTripleMap.clear();
        this.listFirstResourceTripleMap.clear();
        this.listRestTripleMap.clear();
        this.translatedClassExpression.clear();
        this.resTriplesBySubject.clear();
        this.litTriplesBySubject.clear();
        this.singleValuedLitTriplesByPredicate.clear();
        this.singleValuedResTriplesByPredicate.clear();
    }

    @Override
    public void addModelAttribte(String string, String string1) throws SAXException {
    }

    @Override
    public void includeModel(String string, String string1) throws SAXException {
    }

    @Override
    public void logicalURI(String string) throws SAXException {
    }

    public IRI getSynonym(IRI original) {
        IRI synonymIRI;
        if (!this.configuration.isStrict() && (synonymIRI = this.synonymMap.get(original)) != null) {
            return synonymIRI;
        }
        return original;
    }

    @Override
    public void statementWithLiteralValue(String subject, String predicate, String object, String lang, String datatype) throws SAXException {
        this.incrementTripleCount();
        IRI subjectIRI = this.getIRI(this.remapOnlyIfRemapped(subject));
        IRI predicateIRI = this.getIRI(predicate);
        predicateIRI = this.getSynonym(predicateIRI);
        this.handleStreaming(subjectIRI, predicateIRI, object, datatype, lang);
    }

    @Override
    public void statementWithResourceValue(String subject, String predicate, String object) throws SAXException {
        try {
            this.incrementTripleCount();
            IRI subjectIRI = this.getIRI(this.remapOnlyIfRemapped(subject));
            IRI predicateIRI = this.getIRI(predicate);
            predicateIRI = this.getSynonym(predicateIRI);
            IRI objectIRI = this.getSynonym(this.getIRI(object));
            this.handleStreaming(subjectIRI, predicateIRI, objectIRI);
        }
        catch (UnloadableImportException e) {
            throw new TranslatedUnloadedImportException(e);
        }
    }

    private void handleStreaming(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        boolean consumed;
        block4: {
            block6: {
                block2: {
                    block5: {
                        block3: {
                            consumed = false;
                            if (!predicate.equals((Object)OWLRDFVocabulary.RDF_TYPE.getIRI())) break block2;
                            BuiltInTypeHandler handler = this.builtInTypeTripleHandlers.get(object);
                            if (handler == null) break block3;
                            if (!handler.canHandleStreaming(subject, predicate, object)) break block4;
                            handler.handleTriple(subject, predicate, object);
                            consumed = true;
                            break block4;
                        }
                        if (this.axiomTypeTripleHandlers.get(object) != null) break block5;
                        this.addOWLNamedIndividual(subject, false);
                        if (!this.nonBuiltInTypeHandler.canHandleStreaming(subject, predicate, object)) break block4;
                        this.nonBuiltInTypeHandler.handleTriple(subject, predicate, object);
                        consumed = true;
                        break block4;
                    }
                    this.addAxiom(subject);
                    break block4;
                }
                AbstractResourceTripleHandler handler = this.predicateHandlers.get(predicate);
                if (handler == null) break block6;
                if (!handler.canHandleStreaming(subject, predicate, object)) break block4;
                handler.handleTriple(subject, predicate, object);
                consumed = true;
                break block4;
            }
            for (AbstractResourceTripleHandler resHandler : this.resourceTripleHandlers) {
                if (!resHandler.canHandleStreaming(subject, predicate, object)) continue;
                resHandler.handleTriple(subject, predicate, object);
                consumed = true;
                break;
            }
        }
        if (!consumed) {
            this.addTriple(subject, predicate, object);
        }
    }

    private void handleStreaming(IRI subject, IRI predicate, String literal, String datatype, String lang) {
        OWLLiteral con = this.getOWLLiteral(literal, datatype, lang);
        this.handleStreaming(subject, predicate, con);
    }

    private void handleStreaming(IRI subject, IRI predicate, OWLLiteral con) {
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandleStreaming(subject, predicate, con)) continue;
            handler.handleTriple(subject, predicate, con);
            return;
        }
        this.addTriple(subject, predicate, con);
    }

    private OWLLiteral getOWLLiteral(String literal, String datatype, String lang) {
        if (datatype != null) {
            return this.dataFactory.getOWLLiteral(literal, this.dataFactory.getOWLDatatype(this.getIRI(datatype)));
        }
        return this.dataFactory.getOWLLiteral(literal, lang);
    }

    public OWLDataRange translateDataRange(IRI mainNode) {
        if (!this.isDataRange(mainNode) && this.configuration.isStrict()) {
            return (OWLDataRange)this.generateAndLogParseError(EntityType.DATATYPE, mainNode);
        }
        if (!this.isAnonymousNode(mainNode) && this.isDataRange(mainNode)) {
            return this.dataFactory.getOWLDatatype(mainNode);
        }
        IRI intersectionOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INTERSECTION_OF, true);
        if (intersectionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translateToDataRangeSet(intersectionOfObject);
            return this.dataFactory.getOWLDataIntersectionOf(dataRanges);
        }
        IRI unionOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_UNION_OF, true);
        if (unionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translateToDataRangeSet(unionOfObject);
            return this.dataFactory.getOWLDataUnionOf(dataRanges);
        }
        IRI complementOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF, true);
        if (!this.configuration.isStrict() && complementOfObject == null) {
            complementOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_COMPLEMENT_OF, true);
        }
        if (complementOfObject != null) {
            OWLDataRange operand = this.translateDataRange(complementOfObject);
            return this.dataFactory.getOWLDataComplementOf(operand);
        }
        IRI oneOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ONE_OF, true);
        if (oneOfObject != null) {
            Set<OWLLiteral> literals = this.translateToConstantSet(oneOfObject);
            return this.dataFactory.getOWLDataOneOf(literals);
        }
        IRI onDatatypeObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_ON_DATA_TYPE, true);
        if (onDatatypeObject != null) {
            if (this.isAnonymousNode(onDatatypeObject)) {
                return this.dataFactory.getOWLDatatype(mainNode);
            }
            OWLDatatype restrictedDataRange = (OWLDatatype)this.translateDataRange(onDatatypeObject);
            Set<Object> restrictions = new HashSet();
            IRI facetRestrictionList = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS, true);
            if (facetRestrictionList != null) {
                restrictions = this.translateToFacetRestrictionSet(facetRestrictionList);
            } else if (!this.configuration.isStrict()) {
                for (IRI facetIRI : OWLFacet.FACET_IRIS) {
                    OWLLiteral val;
                    while ((val = this.getLiteralObject(mainNode, facetIRI, true)) != null) {
                        restrictions.add(this.dataFactory.getOWLFacetRestriction(OWLFacet.getFacet((IRI)facetIRI), val));
                    }
                }
            }
            return this.dataFactory.getOWLDatatypeRestriction(restrictedDataRange, restrictions);
        }
        return (OWLDataRange)this.generateAndLogParseError(EntityType.DATATYPE, mainNode);
    }

    public OWLDataPropertyExpression translateDataPropertyExpression(IRI iri) {
        return this.dataFactory.getOWLDataProperty(iri);
    }

    public OWLObjectPropertyExpression translateObjectPropertyExpression(IRI mainNode) {
        OWLObjectPropertyExpression prop = this.translatedProperties.get(mainNode);
        if (prop != null) {
            return prop;
        }
        if (!this.isAnonymousNode(mainNode)) {
            prop = this.dataFactory.getOWLObjectProperty(mainNode);
            this.translatedProperties.put(mainNode, prop);
        } else {
            IRI inverseOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INVERSE_OF, true);
            if (inverseOfObject != null) {
                OWLObjectPropertyExpression otherProperty = this.translateObjectPropertyExpression(inverseOfObject);
                prop = this.dataFactory.getOWLObjectInverseOf(otherProperty);
            } else {
                prop = this.dataFactory.getOWLObjectInverseOf((OWLObjectPropertyExpression)this.dataFactory.getOWLObjectProperty(mainNode));
            }
            this.objectPropertyExpressionIRIs.add(mainNode);
            this.translatedProperties.put(mainNode, prop);
        }
        return prop;
    }

    public OWLIndividual translateIndividual(IRI node) {
        return this.getOWLIndividual(node);
    }

    public Set<OWLAnnotation> translateAnnotations(IRI mainNode) {
        HashSet<OWLAnnotation> annosOnMainNodeAnnotations = new HashSet<OWLAnnotation>();
        Set<IRI> annotationMainNodes = this.getAnnotatedSourceAnnotationMainNodes(mainNode);
        if (!annotationMainNodes.isEmpty()) {
            for (IRI annotationMainNode : annotationMainNodes) {
                annosOnMainNodeAnnotations.addAll(this.translateAnnotations(annotationMainNode));
            }
        }
        HashSet<OWLAnnotation> mainNodeAnnotations = new HashSet<OWLAnnotation>();
        Set<IRI> predicates = this.getPredicatesBySubject(mainNode);
        for (IRI predicate : predicates) {
            if (!this.isAnnotationProperty(predicate)) continue;
            IRI resVal = this.getResourceObject(mainNode, predicate, true);
            while (resVal != null) {
                OWLAnnotationProperty prop = this.dataFactory.getOWLAnnotationProperty(predicate);
                Object val = this.isAnonymousNode(resVal) ? this.anonProvider.getOWLAnonymousIndividual(resVal.toString()) : resVal;
                mainNodeAnnotations.add(this.dataFactory.getOWLAnnotation(prop, (OWLAnnotationValue)val, annosOnMainNodeAnnotations));
                resVal = this.getResourceObject(mainNode, predicate, true);
            }
            OWLLiteral litVal = this.getLiteralObject(mainNode, predicate, true);
            while (litVal != null) {
                OWLAnnotationProperty prop = this.dataFactory.getOWLAnnotationProperty(predicate);
                mainNodeAnnotations.add(this.dataFactory.getOWLAnnotation(prop, (OWLAnnotationValue)litVal, annosOnMainNodeAnnotations));
                litVal = this.getLiteralObject(mainNode, predicate, true);
            }
        }
        return mainNodeAnnotations;
    }

    public OWLClassExpression translateClassExpression(IRI mainNode) {
        OWLClassExpression ce = this.translatedClassExpression.get(mainNode);
        if (ce == null) {
            ce = this.translateClassExpressionInternal(mainNode);
            this.translatedClassExpression.put(mainNode, ce);
        }
        return ce;
    }

    private <E extends OWLEntity> E getErrorEntity(EntityType<E> entityType) {
        IRI iri = IRI.create((String)"http://org.semanticweb.owlapi/error#", (String)("Error" + errorCounter.incrementAndGet()));
        return (E)this.dataFactory.getOWLEntity(entityType, iri);
    }

    private OWLClassExpression translateClassExpressionInternal(IRI mainNode) {
        Mode mode = this.getConfiguration().isStrict() ? Mode.STRICT : Mode.LAX;
        for (ClassExpressionTranslator translator : this.classExpressionTranslators) {
            if (!translator.matches(mainNode, mode)) continue;
            return translator.translate(mainNode);
        }
        if (!this.isAnonymousNode(mainNode)) {
            return this.dataFactory.getOWLClass(mainNode);
        }
        return (OWLClassExpression)this.generateAndLogParseError(EntityType.CLASS, mainNode);
    }

    private RDFResource getRDFResource(IRI iri) {
        return new RDFResource(iri, this.isAnonymousNode(iri));
    }

    private RDFTriple getRDFTriple(IRI subject, IRI predicate, IRI object) {
        return new RDFTriple(this.getRDFResource(subject), this.getRDFResource(predicate), (RDFNode)this.getRDFResource(object));
    }

    private RDFTriple getRDFTriple(IRI subject, IRI predicate, OWLLiteral object) {
        return new RDFTriple(this.getRDFResource(subject), this.getRDFResource(predicate), (RDFNode)new RDFLiteral(object));
    }

    private Set<RDFTriple> getTriplesForMainNode(IRI mainNode, IRI ... augmentingTypes) {
        HashSet<RDFTriple> triples = new HashSet<RDFTriple>();
        for (IRI predicate : this.getPredicatesBySubject(mainNode)) {
            for (IRI iRI : this.getResourceObjects(mainNode, predicate)) {
                triples.add(this.getRDFTriple(mainNode, predicate, iRI));
            }
            for (OWLLiteral oWLLiteral : this.getLiteralObjects(mainNode, predicate)) {
                triples.add(this.getRDFTriple(mainNode, predicate, oWLLiteral));
            }
        }
        for (IRI iRI : augmentingTypes) {
            triples.add(this.getRDFTriple(mainNode, OWLRDFVocabulary.RDF_TYPE.getIRI(), iRI));
        }
        return triples;
    }

    private void logError(RDFResourceParseError error) {
        this.ontologyFormat.addError(error);
    }

    private <E extends OWLEntity> E generateAndLogParseError(EntityType<E> entityType, IRI mainNode) {
        E entity = this.getErrorEntity(entityType);
        RDFResource mainNodeResource = this.getRDFResource(mainNode);
        Set<RDFTriple> mainNodeTriples = this.getTriplesForMainNode(mainNode, new IRI[0]);
        RDFResourceParseError error = new RDFResourceParseError(entity, (RDFNode)mainNodeResource, mainNodeTriples);
        this.logError(error);
        return entity;
    }

    public OWLClassExpression getClassExpressionIfTranslated(IRI mainNode) {
        return this.translatedClassExpression.get(mainNode);
    }

    public List<OWLObjectPropertyExpression> translateToObjectPropertyList(IRI mainNode) {
        return this.objectPropertyListTranslator.translateList(mainNode);
    }

    public List<OWLDataPropertyExpression> translateToDataPropertyList(IRI mainNode) {
        return this.dataPropertyListTranslator.translateList(mainNode);
    }

    public Set<OWLClassExpression> translateToClassExpressionSet(IRI mainNode) {
        return this.classExpressionListTranslator.translateToSet(mainNode);
    }

    public Set<OWLLiteral> translateToConstantSet(IRI mainNode) {
        return this.constantListTranslator.translateToSet(mainNode);
    }

    public Set<OWLIndividual> translateToIndividualSet(IRI mainNode) {
        return this.individualListTranslator.translateToSet(mainNode);
    }

    public Set<OWLDataRange> translateToDataRangeSet(IRI mainNode) {
        return this.dataRangeListTranslator.translateToSet(mainNode);
    }

    public Set<OWLFacetRestriction> translateToFacetRestrictionSet(IRI mainNode) {
        return this.faceRestrictionListTranslator.translateToSet(mainNode);
    }

    public Set<IRI> getPredicatesBySubject(IRI subject) {
        Map<IRI, Collection<OWLLiteral>> predObjMapLit;
        HashSet<IRI> IRIs = new HashSet<IRI>();
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null) {
            IRIs.addAll(predObjMap.keySet());
        }
        if ((predObjMapLit = this.litTriplesBySubject.get(subject)) != null) {
            IRIs.addAll(predObjMapLit.keySet());
        }
        return IRIs;
    }

    public IRI getResourceObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getResourceObject(subject, predicate.getIRI(), consume);
    }

    public IRI getResourceObject(IRI subject, IRI predicate, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            IRI object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
                if (predObjMap.isEmpty()) {
                    this.resTriplesBySubject.remove(subject);
                }
            }
            return object;
        }
        return null;
    }

    public Set<IRI> getResourceObjects(IRI subject, IRI predicate) {
        Collection<IRI> objects;
        Map<IRI, Collection<IRI>> predObjMap;
        IRI obj;
        HashSet<IRI> result = new HashSet<IRI>();
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.resTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    public OWLLiteral getLiteralObject(IRI subject, OWLRDFVocabulary predicate, boolean consume) {
        return this.getLiteralObject(subject, predicate.getIRI(), consume);
    }

    public OWLLiteral getLiteralObject(IRI subject, IRI predicate, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            OWLLiteral object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
            }
            return object;
        }
        return null;
    }

    public Set<OWLLiteral> getLiteralObjects(IRI subject, IRI predicate) {
        Collection<OWLLiteral> objects;
        Map<IRI, Collection<OWLLiteral>> predObjMap;
        OWLLiteral obj;
        HashSet<OWLLiteral> result = new HashSet<OWLLiteral>();
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null && (obj = subjPredMap.get(subject)) != null) {
            result.add(obj);
        }
        if ((predObjMap = this.litTriplesBySubject.get(subject)) != null && (objects = predObjMap.get(predicate)) != null) {
            result.addAll(objects);
        }
        return result;
    }

    public boolean isTriplePresent(IRI subject, IRI predicate, IRI object, boolean consume) {
        Collection<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.resTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean isGeneralPredicate(IRI predicate) {
        return !predicate.isReservedVocabulary() || OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(predicate) || Namespaces.SWRL.inNamespace(predicate) || Namespaces.SWRLB.inNamespace(predicate);
    }

    public boolean isTriplePresent(IRI subject, IRI predicate, OWLLiteral object, boolean consume) {
        Collection<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Collection<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.litTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasPredicate(IRI subject, IRI predicate) {
        boolean b;
        Map<IRI, IRI> resPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (resPredMap != null) {
            return resPredMap.containsKey(subject);
        }
        Map<IRI, OWLLiteral> litPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (litPredMap != null) {
            return litPredMap.containsKey(subject);
        }
        Map<IRI, Collection<IRI>> resPredObjMap = this.resTriplesBySubject.get(subject);
        if (resPredObjMap != null && (b = resPredObjMap.containsKey(predicate))) {
            return true;
        }
        Map<IRI, Collection<OWLLiteral>> litPredObjMap = this.litTriplesBySubject.get(subject);
        if (litPredObjMap != null) {
            return litPredObjMap.containsKey(predicate);
        }
        return false;
    }

    public void addRest(IRI subject, IRI object) {
        this.listRestTripleMap.put(subject, object);
    }

    public void addFirst(IRI subject, IRI object) {
        this.listFirstResourceTripleMap.put(subject, object);
    }

    public IRI getFirstResource(IRI subject, boolean consume) {
        if (consume) {
            return this.listFirstResourceTripleMap.remove(subject);
        }
        return this.listFirstResourceTripleMap.get(subject);
    }

    public OWLLiteral getFirstLiteral(IRI subject) {
        return this.listFirstLiteralTripleMap.get(subject);
    }

    public IRI getRest(IRI subject, boolean consume) {
        if (consume) {
            return this.listRestTripleMap.remove(subject);
        }
        return this.listRestTripleMap.get(subject);
    }

    public void addFirst(IRI subject, OWLLiteral object) {
        this.listFirstLiteralTripleMap.put(subject, object);
    }

    public void addOntology(IRI iri) {
        if (this.ontologyIRIs.isEmpty()) {
            this.firstOntologyIRI = iri;
        }
        this.ontologyIRIs.add(iri);
    }

    public Set<IRI> getOntologies() {
        return this.ontologyIRIs;
    }

    public void addAxiom(IRI axiomIRI) {
        this.axioms.add(axiomIRI);
    }

    public boolean isAxiom(IRI iri) {
        return this.axioms.contains(iri);
    }

    public boolean isDataRange(IRI iri) {
        return this.dataRangeIRIs.contains(iri);
    }

    public OWLOntologyLoaderConfiguration getConfiguration() {
        return this.configuration;
    }

    protected <E extends Throwable> void iterateResourceTriples(ResourceTripleIterator<E> iterator) throws E {
        for (IRI subject : new ArrayList<IRI>(this.resTriplesBySubject.keySet())) {
            Map<IRI, Collection<IRI>> map = this.resTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                Collection<IRI> objects = map.get(predicate);
                if (objects == null) continue;
                for (IRI object : new ArrayList<IRI>(objects)) {
                    iterator.handleResourceTriple(subject, predicate, object);
                }
            }
        }
    }

    protected <E extends Throwable> void iterateLiteralTriples(LiteralTripleIterator<E> iterator) throws E {
        for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
            Map<IRI, Collection<OWLLiteral>> map = this.litTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                Collection<OWLLiteral> objects = map.get(predicate);
                for (OWLLiteral object : new ArrayList<OWLLiteral>(objects)) {
                    iterator.handleLiteralTriple(subject, predicate, object);
                }
            }
        }
    }

    @Override
    public IRI remapIRI(IRI i) {
        if (this.anonymousNodeChecker.isAnonymousNode(i)) {
            return i;
        }
        IRI computeIfAbsent = this.remappedIRIs.get(i);
        if (computeIfAbsent == null) {
            computeIfAbsent = IRI.create((String)NodeID.nextAnonymousIRI());
            this.remappedIRIs.put(i, computeIfAbsent);
        }
        this.remappedIRIStrings.put(i.toString(), computeIfAbsent);
        return computeIfAbsent;
    }

    @Override
    public String remapOnlyIfRemapped(String i) {
        if (this.anonymousNodeChecker.isAnonymousNode(i) || this.anonymousNodeChecker.isAnonymousSharedNode(i)) {
            return i;
        }
        IRI iri = this.remappedIRIStrings.get(i);
        return iri == null ? i : iri.toString();
    }

    public void addTriple(IRI subject, IRI predicate, IRI object) {
        Map<IRI, IRI> subjObjMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, object);
        } else {
            HashSet<IRI> objects;
            Map map = this.resTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.resTriplesBySubject.put(subject, map);
            }
            if ((objects = (HashSet<IRI>)map.get(predicate)) == null) {
                objects = new HashSet<IRI>();
                map.put(predicate, objects);
            }
            objects.add(object);
        }
    }

    public void addTriple(IRI subject, IRI predicate, OWLLiteral con) {
        Map<IRI, OWLLiteral> subjObjMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, con);
        } else {
            HashSet<OWLLiteral> objects;
            Map map = this.litTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.litTriplesBySubject.put(subject, map);
            }
            if ((objects = (HashSet<OWLLiteral>)map.get(predicate)) == null) {
                objects = new HashSet<OWLLiteral>();
                map.put(predicate, objects);
            }
            objects.add(con);
        }
    }

    private static interface LiteralTripleIterator<E extends Throwable> {
        public void handleLiteralTriple(IRI var1, IRI var2, OWLLiteral var3) throws E;
    }

    private static interface ResourceTripleIterator<E extends Throwable> {
        public void handleResourceTriple(IRI var1, IRI var2, IRI var3) throws E;
    }
}

