/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.ListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public class HasKeyListItemTranslator
implements ListItemTranslator<OWLPropertyExpression<?, ?>> {
    private static Logger logger = Logger.getLogger(HasKeyListItemTranslator.class.getName());
    private OWLRDFConsumer consumer;

    public HasKeyListItemTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public OWLPropertyExpression<?, ?> translate(OWLLiteral firstObject) {
        return null;
    }

    @Override
    public OWLPropertyExpression translate(IRI firstObject) {
        if (this.consumer.isObjectPropertyOnly(firstObject)) {
            return this.consumer.getDataFactory().getOWLObjectProperty(firstObject);
        }
        if (this.consumer.isDataPropertyOnly(firstObject)) {
            return this.consumer.getDataFactory().getOWLDataProperty(firstObject);
        }
        OWLObjectProperty property = null;
        if (this.consumer.isObjectProperty(firstObject)) {
            logger.warning("Property " + firstObject + " has been punned illegally: found declaration as OWLObjectProperty");
            property = this.consumer.getDataFactory().getOWLObjectProperty(firstObject);
        }
        if (this.consumer.isDataProperty(firstObject)) {
            logger.warning("Property " + firstObject + " has been punned illegally: found declaration as OWLDataProperty");
            if (property == null) {
                property = this.consumer.getDataFactory().getOWLDataProperty(firstObject);
            }
        }
        if (property == null) {
            logger.warning("Property " + firstObject + " is undeclared at this point in parsing: typing as OWLDataProperty");
            property = this.consumer.getDataFactory().getOWLDataProperty(firstObject);
        }
        return property;
    }
}

