/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractResourceTripleHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class GTPAnnotationResourceTripleHandler
extends AbstractResourceTripleHandler {
    public GTPAnnotationResourceTripleHandler(OWLRDFConsumer consumer) {
        super(consumer);
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        if (this.isStrict()) {
            return false;
        }
        return !this.isAnonymous(subject) && !this.isAnonymous(object) && this.getConsumer().isAnnotationProperty(predicate);
    }

    @Override
    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        boolean builtInAnnotationProperty = OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS.contains(predicate);
        return !this.getConsumer().isAxiom(subject) && !this.getConsumer().isAnnotation(subject) && (builtInAnnotationProperty || !predicate.isReservedVocabulary());
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) {
        Object value = this.isAnonymous(object) ? this.getConsumer().getOWLAnonymousIndividual(object.toString()) : object;
        OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(predicate);
        OWLAnnotation anno = this.getDataFactory().getOWLAnnotation(prop, (OWLAnnotationValue)value);
        Object annoSubject = this.isAnonymous(subject) ? this.getConsumer().getOWLAnonymousIndividual(subject.toString()) : subject;
        if (this.getConsumer().isOntology(subject)) {
            this.getConsumer().addOntologyAnnotation(anno);
        } else {
            OWLAnnotationAssertionAxiom decAx = this.getDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)annoSubject, anno, this.getPendingAnnotations());
            this.addAxiom((OWLAxiom)decAx);
        }
    }
}

