/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import org.coode.owlapi.rdf.model.AbstractTranslator;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.IndividualAppearance;

public class RDFTranslator
extends AbstractTranslator<RDFNode, RDFResourceNode, RDFResourceNode, RDFLiteralNode> {
    private RDFGraph graph = new RDFGraph();

    public RDFTranslator(OWLOntologyManager manager, OWLOntology ontology, boolean useStrongTyping, IndividualAppearance occurrences) {
        super(manager, ontology, useStrongTyping, occurrences);
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    @Override
    protected void addTriple(RDFResourceNode subject, RDFResourceNode pred, RDFNode object) {
        this.graph.addTriple(new RDFTriple(subject, pred, object));
    }

    @Override
    protected RDFResourceNode getAnonymousNode(Object key) {
        if (key instanceof OWLAnonymousIndividual) {
            OWLAnonymousIndividual anon = (OWLAnonymousIndividual)key;
            String id = anon.getID().getID();
            RDFResourceNode toReturn = new RDFResourceNode(System.identityHashCode(id), true, this.multipleOccurrences.appearsMultipleTimes(anon));
            return toReturn;
        }
        RDFResourceNode toReturn = new RDFResourceNode(System.identityHashCode(key), false, false);
        return toReturn;
    }

    @Override
    protected RDFLiteralNode getLiteralNode(OWLLiteral literal) {
        return RDFTranslator.translateLiteralNode(literal);
    }

    public static RDFLiteralNode translateLiteralNode(OWLLiteral literal) {
        if (!literal.isRDFPlainLiteral()) {
            return new RDFLiteralNode(literal.getLiteral(), literal.getDatatype().getIRI());
        }
        return new RDFLiteralNode(literal.getLiteral(), literal.hasLang() ? literal.getLang() : null);
    }

    @Override
    protected RDFResourceNode getPredicateNode(IRI uri) {
        return new RDFResourceNode(uri);
    }

    @Override
    protected RDFResourceNode getResourceNode(IRI uri) {
        return new RDFResourceNode(uri);
    }

    public void reset() {
        this.graph = new RDFGraph();
    }
}

