/*
 * Decompiled with CFR 0.152.
 */
package de.uulm.ecs.ai.owlapi.krssrenderer;

import de.uulm.ecs.ai.owlapi.krssrenderer.KRSSVocabulary;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;

public class KRSSObjectRenderer
implements OWLObjectVisitor {
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private static final String NEWLINE = "\n";
    protected final OWLOntology ontology;
    protected final Writer writer;
    private int pos = 0;
    private int lastNewLinePos = 0;

    @Deprecated
    public KRSSObjectRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer writer) {
        this(ontology, writer);
    }

    public KRSSObjectRenderer(OWLOntology ontology, Writer writer) {
        this.ontology = ontology;
        this.writer = new PrintWriter(writer);
    }

    protected <T extends OWLObject> List<T> sort(Collection<T> objects) {
        ArrayList<T> sortedDescriptions = new ArrayList<T>(objects);
        CollectionFactory.sortOptionally(sortedDescriptions);
        return sortedDescriptions;
    }

    protected final void writeOpenBracket() {
        this.write(OPEN_BRACKET);
    }

    protected final void writeCloseBracket() {
        this.write(CLOSE_BRACKET);
    }

    protected final void write(int i) {
        this.write(" " + i);
    }

    protected final void write(IRI iri) {
        this.write(iri.toString());
    }

    private void write(KRSSVocabulary v) {
        this.write(v.toString());
    }

    protected final void writeSpace() {
        this.write(" ");
    }

    protected final void write(String s) {
        try {
            int newLineIndex = s.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    protected final int getIndent() {
        return this.pos - this.lastNewLinePos - 1;
    }

    protected final void writeIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.writeSpace();
        }
    }

    protected final void writeln() {
        this.write(NEWLINE);
    }

    public final void write(OWLClassExpression obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    public final void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept((OWLObjectVisitor)this);
    }

    public final void write(OWLPropertyExpression<?, ?> obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    public final void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept((OWLObjectVisitor)this);
    }

    protected void flattenProperties(Set<OWLObjectPropertyExpression> properties, KRSSVocabulary junctor) {
        if (properties.isEmpty()) {
            return;
        }
        if (properties.size() == 1) {
            this.write((OWLPropertyExpression)properties.iterator().next());
            return;
        }
        if (junctor != null) {
            this.writeOpenBracket();
            this.write(junctor);
        }
        List<OWLObjectPropertyExpression> props = this.sort(properties);
        this.write((OWLPropertyExpression)props.get(0));
        int size = props.size();
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write((OWLPropertyExpression)props.get(i));
        }
        if (junctor != null) {
            this.writeCloseBracket();
        }
    }

    protected void flatten(Set<OWLClassExpression> description, KRSSVocabulary junctor) {
        if (description.isEmpty()) {
            return;
        }
        if (description.size() == 1) {
            this.write(description.iterator().next());
            return;
        }
        this.writeOpenBracket();
        this.write(junctor);
        List<OWLClassExpression> descs = this.sort(description);
        this.write(descs.get(0));
        int size = descs.size();
        int indent = this.getIndent();
        for (int i = 1; i < size; ++i) {
            this.writeln();
            this.writeIndent(indent);
            this.write(descs.get(i));
        }
        this.writeCloseBracket();
    }

    public void visit(OWLOntology ontology1) {
        Set classes = ontology1.getClassesInSignature();
        classes.remove(ontology1.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        classes.remove(ontology1.getOWLOntologyManager().getOWLDataFactory().getOWLNothing());
        for (OWLClass eachClass : this.sort(classes)) {
            boolean primitive;
            boolean bl = primitive = !eachClass.isDefined(ontology1);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                this.flatten(eachClass.getSuperClasses(ontology1), KRSSVocabulary.AND);
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSSVocabulary.DEFINE_CONCEPT);
            this.write((OWLClassExpression)eachClass);
            this.flatten(eachClass.getEquivalentClasses(ontology1), KRSSVocabulary.AND);
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLObjectProperty property : this.sort(ontology1.getObjectPropertiesInSignature())) {
            boolean isDefined;
            this.writeOpenBracket();
            Set properties = property.getEquivalentProperties(ontology1);
            boolean bl = isDefined = !properties.isEmpty();
            if (isDefined) {
                this.write(KRSSVocabulary.DEFINE_ROLE);
                this.write((OWLPropertyExpression<?, ?>)property);
                properties.remove(property);
                if (!properties.isEmpty()) {
                    this.write((OWLPropertyExpression)properties.iterator().next());
                }
            } else {
                this.write(KRSSVocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write((OWLPropertyExpression<?, ?>)property);
                this.writeSpace();
                properties = property.getSuperProperties(ontology1);
                if (!properties.isEmpty()) {
                    this.write((OWLPropertyExpression)properties.iterator().next());
                }
            }
            this.writeCloseBracket();
            this.writeln();
        }
        for (OWLAxiom axiom : ontology1.getAxioms()) {
            axiom.accept((OWLObjectVisitor)this);
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void visit(OWLSubClassOfAxiom axiom) {
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        List classes = this.sort(axiom.getClassExpressions());
        int size = classes.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DISJOINT);
                this.write((OWLClassExpression)classes.get(i));
                this.write((OWLClassExpression)classes.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.DOMAIN);
        this.write(axiom.getProperty());
        this.write(axiom.getDomain());
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        List individuals = this.sort(axiom.getIndividuals());
        int size = individuals.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.DISTINCT);
                this.write((OWLIndividual)individuals.get(i));
                this.write((OWLIndividual)individuals.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RANGE);
        this.write(axiom.getProperty());
        this.write((OWLClassExpression)axiom.getRange());
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write(axiom.getProperty());
        this.write((OWLIndividual)axiom.getObject());
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.TRANSITIVE);
        this.write(axiom.getProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        List individuals = this.sort(axiom.getIndividuals());
        int size = individuals.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                this.writeOpenBracket();
                this.write(KRSSVocabulary.EQUAL);
                this.write((OWLIndividual)individuals.get(i));
                this.write((OWLIndividual)individuals.get(j));
                this.writeCloseBracket();
                this.writeln();
            }
        }
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    public void visit(SWRLRule rule) {
    }

    public void visit(SWRLClassAtom node) {
    }

    public void visit(SWRLDataRangeAtom node) {
    }

    public void visit(SWRLObjectPropertyAtom node) {
    }

    public void visit(SWRLDataPropertyAtom node) {
    }

    public void visit(SWRLBuiltInAtom node) {
    }

    public void visit(SWRLVariable node) {
    }

    public void visit(SWRLIndividualArgument node) {
    }

    public void visit(SWRLLiteralArgument node) {
    }

    public void visit(SWRLSameIndividualAtom node) {
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
    }

    public void visit(OWLClass desc) {
        this.write(desc.getIRI());
    }

    public void visit(OWLObjectIntersectionOf desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AND);
        List operands = this.sort(desc.getOperands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write((OWLClassExpression)operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write((OWLClassExpression)operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectUnionOf desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.OR);
        List operands = this.sort(desc.getOperands());
        int size = operands.size();
        if (size > 0) {
            int indent = this.getIndent();
            this.write((OWLClassExpression)operands.get(0));
            for (int i = 1; i < size; ++i) {
                this.writeln();
                this.writeIndent(indent);
                this.write((OWLClassExpression)operands.get(i));
            }
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectComplementOf desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.NOT);
        this.write(desc.getOperand());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(desc.getProperty());
        this.write((OWLClassExpression)desc.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(desc.getProperty());
        this.write((OWLClassExpression)desc.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasValue desc) {
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectExactCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectMaxCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLClassExpression)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLObjectHasSelf desc) {
    }

    public void visit(OWLObjectOneOf desc) {
    }

    public void visit(OWLDataSomeValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.SOME);
        this.write(desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.ALL);
        this.write(desc.getProperty());
        this.write((OWLDataRange)desc.getFiller());
        this.writeCloseBracket();
    }

    public void visit(OWLDataHasValue desc) {
    }

    public void visit(OWLDataMinCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_LEAST);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDataExactCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.EXACTLY);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDataMaxCardinality desc) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.AT_MOST);
        this.write(desc.getCardinality());
        this.write(desc.getProperty());
        if (desc.isQualified()) {
            this.write((OWLDataRange)desc.getFiller());
        }
        this.writeCloseBracket();
    }

    public void visit(OWLDatatype node) {
    }

    public void visit(OWLDataComplementOf node) {
    }

    public void visit(OWLDataOneOf node) {
    }

    public void visit(OWLDatatypeRestriction node) {
    }

    public void visit(OWLLiteral node) {
        this.write(node.getLiteral());
    }

    public void visit(OWLFacetRestriction node) {
    }

    public void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSSVocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataProperty property) {
        this.write(property.getIRI());
    }

    public void visit(OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }

    public void visit(OWLHasKeyAxiom axiom) {
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    public void visit(OWLDataIntersectionOf node) {
    }

    public void visit(OWLDataUnionOf node) {
    }

    public void visit(OWLAnnotationProperty property) {
    }

    public void visit(OWLAnonymousIndividual individual) {
    }

    public void visit(IRI iri) {
    }

    public void visit(OWLAnnotation node) {
    }
}

