/* Generated By:JavaCC: Do not edit this line. OWLFunctionalSyntaxParser.java */
package org.coode.owlapi.functionalparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;

/** The Class OWLFunctionalSyntaxParser. */
public class OWLFunctionalSyntaxParser implements
        OWLFunctionalSyntaxParserConstants {

    /** The man. */
    private OWLOntologyManager man;
    /** The configuration. */
    private OWLOntologyLoaderConfiguration configuration;
    /** The ontology. */
    private OWLOntology ontology;
    /** The data factory. */
    private OWLDataFactory dataFactory;
    /** The string2 iri. */
    private Map<String, IRI> string2IRI;
    /** The prefix map. */
    private Map<String, String> prefixMap;
    /** The ontology iri. */
    private IRI ontologyIRI;
    /** The ignore annotations and declarations. */
    private boolean ignoreAnnotationsAndDeclarations = false;
    /** The current annotations. */
    private Set<OWLAnnotation> currentAnnotations;
    
    protected RemappingIndividualProvider anonProvider;

    /**
     * Sets the up.
     * 
     * @param man
     *        the man
     * @param ontology
     *        the ontology
     * @param configuration
     *        the configuration
     */
    @Deprecated
    @SuppressWarnings("unused")
    public void setUp(OWLOntologyManager man, OWLOntology ontology,
            OWLOntologyLoaderConfiguration configuration) {
        setUp(ontology, configuration);
    }

    /**
     * Sets the up.
     * 
     * @param ontology
     *        the ontology
     * @param configuration
     *        the configuration
     */
    public void setUp(OWLOntology ontology,
            OWLOntologyLoaderConfiguration configuration) {
        man = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.configuration = configuration;
        dataFactory = man.getOWLDataFactory();
        anonProvider=new RemappingIndividualProvider(dataFactory);
        currentAnnotations = new HashSet<OWLAnnotation>();
        if (prefixMap == null) {
            prefixMap = new HashMap<String, String>();
            prefixMap.put("owl:", Namespaces.OWL.toString());
            prefixMap.put("rdf:", Namespaces.RDF.toString());
            prefixMap.put("rdfs:", Namespaces.RDFS.toString());
            prefixMap.put("xml:", Namespaces.XML.toString());
            prefixMap.put("xsd:", Namespaces.XSD.toString());
        }
        string2IRI = new HashMap<String, IRI>();
    }

    /**
     * Gets the iri.
     * 
     * @param s
     *        the s
     * @return the iri
     */
    public IRI getIRI(String s) {
        IRI iri = string2IRI.get(s);
        if (iri == null) {
            if (s.charAt(0) == '<') {
                iri = IRI.create(s.substring(1, s.length() - 1));
            } else {
                int colonIndex = s.indexOf(':');
                String prefixName = s.substring(0, colonIndex + 1);
                String prefix = prefixMap.get(prefixName);
                if (prefix == null) {
                    throw new OWLRuntimeException("Undefined prefix name: "
                            + prefixName);
                }
                String fullIRIString = prefix + s.substring(colonIndex + 1);
                iri = IRI.create(fullIRIString);
            }
            string2IRI.put(s, iri);
        }
        return iri;
    }

    /**
     * Sets the ignore annotations and declarations.
     * 
     * @param b
     *        the new ignore annotations and declarations
     */
    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    /**
     * Apply change.
     * 
     * @param chg
     *        the chg
     */
    protected void applyChange(OWLOntologyChange chg) {
        man.applyChange(chg);
    }

    /**
     * Adds the axiom.
     * 
     * @param ax
     *        the ax
     */
    protected void addAxiom(OWLAxiom ax) {
        if (!(ax instanceof OWLAnnotationAxiom)
                || configuration.isLoadAnnotationAxioms()) {
            AddAxiom addAxiom = new AddAxiom(ontology, ax);
            applyChange(addAxiom);
        }
    }

    /**
     * Sets the prefixes.
     * 
     * @param nsm
     *        the new prefixes
     */
    public void setPrefixes(PrefixManager nsm) {
        if (prefixMap == null) {
            prefixMap = new HashMap<String, String>();
        }
        prefixMap.putAll(nsm.getPrefixName2PrefixMap());
    }

    /**
     * Parses the.
     * 
     * @return the oWL functional syntax ontology format
     * @throws ParseException
     *         the parse exception
     * @throws OWLParserException
     *         the oWL parser exception
     * @throws UnloadableImportException
     *         the unloadable import exception
     */
    final public OWLFunctionalSyntaxOntologyFormat parse()
            throws ParseException, OWLParserException,
            UnloadableImportException {
        label_1: while (true) {
            if (jj_2_1(2)) {} else {
                break label_1;
            }
            Prefix();
        }
        Ontology();
        jj_consume_token(0);
        OWLFunctionalSyntaxOntologyFormat format = new OWLFunctionalSyntaxOntologyFormat();
        for (String pn : prefixMap.keySet()) {
            format.setPrefix(pn, prefixMap.get(pn));
        }
        return format;
    }

    /**
     * Ontology.
     * 
     * @throws ParseException
     *         the parse exception
     * @throws OWLParserException
     *         the oWL parser exception
     * @throws UnloadableImportException
     *         the unloadable import exception
     */
    final public void Ontology() throws ParseException, OWLParserException,
            UnloadableImportException {
        OWLAnnotation anno;
        OWLAxiom ax;
        OWLImportsDeclaration decl;
        IRI versionIRI = null;
        jj_consume_token(ONTOLOGY);
        jj_consume_token(OPENPAR);
        if (jj_2_3(2)) {
            ontologyIRI = IRI();
            if (jj_2_2(2)) {
                versionIRI = IRI();
            }
        }
        OWLOntologyID id = new OWLOntologyID(ontologyIRI, versionIRI);
        applyChange(new SetOntologyID(ontology, id));
        label_2: while (true) {
            if (jj_2_4(2)) {} else {
                break label_2;
            }
            if (jj_2_5(2)) {
                decl = ImportsDeclaration();
                applyChange(new AddImport(ontology, decl));
                man.makeLoadImportRequest(decl, configuration);
            } else if (jj_2_6(2)) {
                anno = Annotation();
                applyChange(new AddOntologyAnnotation(ontology, anno));
                currentAnnotations.clear();
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        label_3: while (true) {
            if (jj_2_7(2)) {} else {
                break label_3;
            }
            ax = Axiom();
            addAxiom(ax);
            currentAnnotations.clear();
        }
        jj_consume_token(CLOSEPAR);
    }

    /**
     * Prefix.
     * 
     * @throws ParseException
     *         the parse exception
     */
    final public void Prefix() throws ParseException {
        String prefixName = "";
        IRI iri;
        jj_consume_token(PREFIX);
        jj_consume_token(OPENPAR);
        prefixName = PrefixName();
        jj_consume_token(EQUALS);
        iri = FullIRI();
        jj_consume_token(CLOSEPAR);
        prefixMap.put(prefixName, iri.toString());
    }

    /**
     * Iri.
     * 
     * @return the iri
     * @throws ParseException
     *         the parse exception
     */
    final public IRI IRI() throws ParseException {
        IRI iri;
        if (jj_2_8(2)) {
            iri = FullIRI();
        } else if (jj_2_9(2)) {
            iri = AbbreviatedIRI();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return iri;
    }

    /**
     * Full iri.
     * 
     * @return the iri
     * @throws ParseException
     *         the parse exception
     */
    final public IRI FullIRI() throws ParseException {
        Token t;
        t = jj_consume_token(FULLIRI);
        return getIRI(t.image);
    }

    /**
     * Abbreviated iri.
     * 
     * @return the iri
     * @throws ParseException
     *         the parse exception
     */
    final public IRI AbbreviatedIRI() throws ParseException {
        Token t;
        t = jj_consume_token(PNAME_LN);
        return getIRI(t.image);
    }

    /**
     * Prefix name.
     * 
     * @return the string
     * @throws ParseException
     *         the parse exception
     */
    final public String PrefixName() throws ParseException {
        Token t;
        t = jj_consume_token(PNAME_NS);
        return t.image;
    }

    // ///////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Class Descriptions
    //
    // ///////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Class expression.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ClassExpression() throws ParseException {
        OWLClassExpression desc;
        if (jj_2_10(2)) {
            desc = ClassIRI();
        } else if (jj_2_11(2)) {
            desc = ObjectUnionOf();
        } else if (jj_2_12(2)) {
            desc = ObjectIntersectionOf();
        } else if (jj_2_13(2)) {
            desc = ObjectComplementOf();
        } else if (jj_2_14(2)) {
            desc = ObjectOneOf();
        } else if (jj_2_15(2)) {
            desc = ObjectSomeValuesFrom();
        } else if (jj_2_16(2)) {
            desc = ObjectAllValuesFrom();
        } else if (jj_2_17(2)) {
            desc = ObjectHasValue();
        } else if (jj_2_18(2)) {
            desc = ObjectSelf();
        } else if (jj_2_19(2)) {
            desc = ObjectMinCardinality();
        } else if (jj_2_20(2)) {
            desc = ObjectExactCardinality();
        } else if (jj_2_21(2)) {
            desc = ObjectMaxCardinality();
        } else if (jj_2_22(2)) {
            desc = DataSomeValuesFrom();
        } else if (jj_2_23(2)) {
            desc = DataAllValuesFrom();
        } else if (jj_2_24(2)) {
            desc = DataHasValue();
        } else if (jj_2_25(2)) {
            desc = DataMinCardinality();
        } else if (jj_2_26(2)) {
            desc = DataExactCardinality();
        } else if (jj_2_27(2)) {
            desc = DataMaxCardinality();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    /**
     * Class iri.
     * 
     * @return the oWL class
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClass ClassIRI() throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLClass(iri);
    }

    /**
     * Class expression set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLClassExpression> ClassExpressionSet()
            throws ParseException {
        Set<OWLClassExpression> classExpressions = new HashSet<OWLClassExpression>();
        OWLClassExpression desc;
        desc = ClassExpression();
        classExpressions.add(desc);
        desc = ClassExpression();
        classExpressions.add(desc);
        label_4: while (true) {
            if (jj_2_28(2)) {} else {
                break label_4;
            }
            desc = ClassExpression();
            classExpressions.add(desc);
        }
        return classExpressions;
    }

    /**
     * Individual min one set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLIndividual> IndividualMinOneSet() throws ParseException {
        Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        OWLIndividual ind;
        ind = Individual();
        individuals.add(ind);
        label_5: while (true) {
            if (jj_2_29(2)) {} else {
                break label_5;
            }
            ind = Individual();
            individuals.add(ind);
        }
        return individuals;
    }

    /**
     * Object union of.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectUnionOf() throws ParseException {
        Set<OWLClassExpression> classExpressions;
        jj_consume_token(OBJECTUNIONOF);
        jj_consume_token(OPENPAR);
        classExpressions = ClassExpressionSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectUnionOf(classExpressions);
    }

    /**
     * Object intersection of.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectIntersectionOf()
            throws ParseException {
        Set<OWLClassExpression> classExpressions;
        jj_consume_token(OBJECTINTERSECTIONOF);
        jj_consume_token(OPENPAR);
        classExpressions = ClassExpressionSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectIntersectionOf(classExpressions);
    }

    /**
     * Object complement of.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectComplementOf() throws ParseException {
        OWLClassExpression operand;
        jj_consume_token(OBJECTCOMPLEMENTOF);
        jj_consume_token(OPENPAR);
        operand = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectComplementOf(operand);
    }

    /**
     * Object one of.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectOneOf() throws ParseException {
        Set<OWLIndividual> individuals;
        jj_consume_token(OBJECTONEOF);
        jj_consume_token(OPENPAR);
        individuals = IndividualMinOneSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectOneOf(individuals);
    }

    /**
     * Object all values from.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectAllValuesFrom() throws ParseException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OBJECTALLVALUESFROM);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        filler = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    /**
     * Object some values from.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectSomeValuesFrom()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression filler;
        jj_consume_token(OBJECTSOMEVALUESFROM);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        filler = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    /**
     * Object has value.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectHasValue() throws ParseException {
        OWLObjectPropertyExpression prop;
        OWLIndividual ind;
        jj_consume_token(OBJECTHASVALUE);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        ind = Individual();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectHasValue(prop, ind);
    }

    /**
     * Object self.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectSelf() throws ParseException {
        OWLObjectPropertyExpression prop;
        jj_consume_token(OBJECTHASSELF);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectHasSelf(prop);
    }

    /**
     * Object min cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectMinCardinality()
            throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        jj_consume_token(OBJECTMINCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = ObjectPropertyExpression();
        if (jj_2_30(2)) {
            filler = ClassExpression();
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectMinCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLObjectMinCardinality(cardinality, prop,
                    filler);
        }
    }

    /**
     * Object exact cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectExactCardinality()
            throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        jj_consume_token(OBJECTEXACTCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = ObjectPropertyExpression();
        if (jj_2_31(2)) {
            filler = ClassExpression();
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectExactCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLObjectExactCardinality(cardinality, prop,
                    filler);
        }
    }

    /**
     * Object max cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ObjectMaxCardinality()
            throws ParseException {
        int cardinality = 0;
        OWLObjectPropertyExpression prop = null;
        OWLClassExpression filler = null;
        jj_consume_token(OBJECTMAXCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = ObjectPropertyExpression();
        if (jj_2_32(2)) {
            filler = ClassExpression();
        }
        jj_consume_token(CLOSEPAR);
        if (filler == null) {
            return dataFactory.getOWLObjectMaxCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLObjectMaxCardinality(cardinality, prop,
                    filler);
        }
    }

    /**
     * Data all values from.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataAllValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        jj_consume_token(DATAALLVALUESFROM);
        jj_consume_token(OPENPAR);
        prop = DataPropertyExpression();
        dataRange = DataRange();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataAllValuesFrom(prop, dataRange);
    }

    /**
     * Data some values from.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataSomeValuesFrom() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLDataRange dataRange = null;
        jj_consume_token(DATASOMEVALUESFROM);
        jj_consume_token(OPENPAR);
        prop = DataPropertyExpression();
        dataRange = DataRange();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataSomeValuesFrom(prop, dataRange);
    }

    /**
     * Data has value.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataHasValue() throws ParseException {
        OWLDataPropertyExpression prop = null;
        OWLLiteral literal = null;
        jj_consume_token(DATAHASVALUE);
        jj_consume_token(OPENPAR);
        prop = DataPropertyExpression();
        literal = Literal();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataHasValue(prop, literal);
    }

    /**
     * Data min cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataMinCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        jj_consume_token(DATAMINCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = DataPropertyExpression();
        if (jj_2_33(2)) {
            rng = DataRange();
        }
        jj_consume_token(CLOSEPAR);
        if (rng == null) {
            return dataFactory.getOWLDataMinCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLDataMinCardinality(cardinality, prop, rng);
        }
    }

    /**
     * Data exact cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataExactCardinality()
            throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        jj_consume_token(DATAEXACTCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = DataPropertyExpression();
        if (jj_2_34(2)) {
            rng = DataRange();
        }
        jj_consume_token(CLOSEPAR);
        if (rng == null) {
            return dataFactory.getOWLDataExactCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLDataExactCardinality(cardinality, prop,
                    rng);
        }
    }

    /**
     * Data max cardinality.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression DataMaxCardinality() throws ParseException {
        int cardinality = 0;
        OWLDataPropertyExpression prop = null;
        OWLDataRange rng = null;
        jj_consume_token(DATAMAXCARDINALITY);
        jj_consume_token(OPENPAR);
        cardinality = Cardinality();
        prop = DataPropertyExpression();
        if (jj_2_35(2)) {
            rng = DataRange();
        }
        jj_consume_token(CLOSEPAR);
        if (rng == null) {
            return dataFactory.getOWLDataMaxCardinality(cardinality, prop);
        } else {
            return dataFactory.getOWLDataMaxCardinality(cardinality, prop, rng);
        }
    }

    /**
     * Class.
     * 
     * @return the oWL class
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClass Class() throws ParseException {
        OWLClass cls;
        jj_consume_token(CLASS);
        jj_consume_token(OPENPAR);
        cls = ClassIRI();
        jj_consume_token(CLOSEPAR);
        return cls;
    }

    /**
     * Object property expression.
     * 
     * @return the oWL object property expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLObjectPropertyExpression ObjectPropertyExpression()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        if (jj_2_36(2)) {
            prop = InverseObjectProperty();
        } else if (jj_2_37(2)) {
            prop = ObjectPropertyIRI();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return prop;
    }

    /**
     * Inverse object property.
     * 
     * @return the oWL object property expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLObjectPropertyExpression InverseObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        jj_consume_token(OBJECTINVERSEOF);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectInverseOf(prop);
    }

    /**
     * Object property.
     * 
     * @return the oWL object property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLObjectProperty ObjectProperty() throws ParseException {
        OWLObjectProperty prop;
        jj_consume_token(OBJECTPROP);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyIRI();
        jj_consume_token(CLOSEPAR);
        return prop;
    }

    /**
     * Data property expression.
     * 
     * @return the oWL data property expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataPropertyExpression DataPropertyExpression()
            throws ParseException {
        OWLDataPropertyExpression prop;
        prop = DataPropertyIRI();
        return prop;
    }

    /**
     * Data property iri.
     * 
     * @return the oWL data property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataProperty DataPropertyIRI() throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLDataProperty(iri);
    }

    /**
     * Data property.
     * 
     * @return the oWL data property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataProperty DataProperty() throws ParseException {
        OWLDataProperty prop;
        jj_consume_token(DATAPROP);
        jj_consume_token(OPENPAR);
        prop = DataPropertyIRI();
        jj_consume_token(CLOSEPAR);
        return prop;
    }

    /**
     * Annotation property.
     * 
     * @return the oWL annotation property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationProperty AnnotationProperty()
            throws ParseException {
        OWLAnnotationProperty prop;
        jj_consume_token(ANNOTATIONPROPERTY);
        jj_consume_token(OPENPAR);
        prop = AnnotationPropertyIRI();
        jj_consume_token(CLOSEPAR);
        return prop;
    }

    /**
     * Annotation property iri.
     * 
     * @return the oWL annotation property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationProperty AnnotationPropertyIRI()
            throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLAnnotationProperty(iri);
    }

    /**
     * Named individual.
     * 
     * @return the oWL named individual
     * @throws ParseException
     *         the parse exception
     */
    final public OWLNamedIndividual NamedIndividual() throws ParseException {
        OWLNamedIndividual ind;
        jj_consume_token(NAMEDINDIVIDUAL);
        jj_consume_token(OPENPAR);
        ind = IndividualIRI();
        jj_consume_token(CLOSEPAR);
        return ind;
    }

    /**
     * Anonymous individual.
     * 
     * @return the oWL anonymous individual
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnonymousIndividual AnonymousIndividual()
            throws ParseException {
        Token t;
        t = jj_consume_token(NODEID);
        String id = t.image.substring(2, t.image.length());
        return anonProvider.getOWLAnonymousIndividual(id);
    }

    /**
     * Datatype.
     * 
     * @return the oWL datatype
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDatatype Datatype() throws ParseException {
        OWLDatatype dt;
        jj_consume_token(DATATYPE);
        jj_consume_token(OPENPAR);
        dt = DatatypeIRI();
        jj_consume_token(CLOSEPAR);
        return dt;
    }

    /**
     * Datatype iri.
     * 
     * @return the oWL datatype
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDatatype DatatypeIRI() throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLDatatype(iri);
    }

    /**
     * Cardinality.
     * 
     * @return the int
     * @throws ParseException
     *         the parse exception
     */
    final public int Cardinality() throws ParseException {
        int card = 0;
        card = Integer();
        return card;
    }

    /**
     * Integer.
     * 
     * @return the int
     * @throws ParseException
     *         the parse exception
     */
    final public int Integer() throws ParseException {
        Token t;
        t = jj_consume_token(INT);
        int i = Integer.parseInt(t.image);
        return i;
    }

    /**
     * Datatype definition axiom.
     * 
     * @return the oWL datatype definition axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDatatypeDefinitionAxiom DatatypeDefinitionAxiom()
            throws ParseException {
        OWLDatatype datatype;
        OWLDataRange dr;
        Set<OWLAnnotation> axAnnos;
        jj_consume_token(DATATYPEDEFINITION);
        jj_consume_token(OPENPAR);
        axAnnos = AxiomAnnotationSet();
        datatype = DatatypeIRI();
        dr = DataRange();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr, axAnnos);
    }

    /**
     * Data range.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataRange() throws ParseException {
        OWLDataRange rng;
        if (jj_2_38(2)) {
            rng = DatatypeIRI();
        } else if (jj_2_39(2)) {
            rng = DataOneOf();
        } else if (jj_2_40(2)) {
            rng = DataComplementOf();
        } else if (jj_2_41(2)) {
            rng = DataRangeRestriction();
        } else if (jj_2_42(2)) {
            rng = DataIntersectionOf();
        } else if (jj_2_43(2)) {
            rng = DataUnionOf();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return rng;
    }

    /**
     * Data complement of.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataComplementOf() throws ParseException {
        OWLDataRange rng;
        jj_consume_token(DATACOMPLEMENTOF);
        jj_consume_token(OPENPAR);
        rng = DataRange();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataComplementOf(rng);
    }

    /**
     * Data one of.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataOneOf() throws ParseException {
        Set<OWLLiteral> values = new HashSet<OWLLiteral>();
        OWLLiteral con = null;
        jj_consume_token(DATAONEOF);
        jj_consume_token(OPENPAR);
        label_6: while (true) {
            con = Literal();
            values.add(con);
            if (jj_2_44(2)) {} else {
                break label_6;
            }
        }
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataOneOf(values);
    }

    /**
     * Data union of.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataUnionOf() throws ParseException {
        OWLDataRange dataRange;
        Set<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        jj_consume_token(DATAUNIONOF);
        jj_consume_token(OPENPAR);
        label_7: while (true) {
            dataRange = DataRange();
            ranges.add(dataRange);
            if (jj_2_45(2)) {} else {
                break label_7;
            }
        }
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataUnionOf(ranges);
    }

    /**
     * Data intersection of.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataIntersectionOf() throws ParseException {
        OWLDataRange dataRange;
        Set<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        jj_consume_token(DATAINTERSECTIONOF);
        jj_consume_token(OPENPAR);
        label_8: while (true) {
            dataRange = DataRange();
            ranges.add(dataRange);
            if (jj_2_46(2)) {} else {
                break label_8;
            }
        }
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataIntersectionOf(ranges);
    }

    /**
     * Data range restriction.
     * 
     * @return the oWL data range
     * @throws ParseException
     *         the parse exception
     */
    final public OWLDataRange DataRangeRestriction() throws ParseException {
        OWLDatatype rng;
        OWLFacetRestriction facetRestriction;
        Set<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
        jj_consume_token(DATATYPERESTRICTION);
        jj_consume_token(OPENPAR);
        rng = DatatypeIRI();
        label_9: while (true) {
            facetRestriction = DataRangeFacetRestriction();
            facetRestrictions.add(facetRestriction);
            if (jj_2_47(2)) {} else {
                break label_9;
            }
        }
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDatatypeRestriction(rng, facetRestrictions);
    }

    /**
     * Data range facet restriction.
     * 
     * @return the oWL facet restriction
     * @throws ParseException
     *         the parse exception
     */
    final public OWLFacetRestriction DataRangeFacetRestriction()
            throws ParseException {
        IRI iri;
        OWLLiteral con;
        iri = IRI();
        con = Literal();
        OWLFacet v = OWLFacet.getFacet(iri);
        return dataFactory.getOWLFacetRestriction(v, con);
    }

    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Axioms
    //
    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Axiom.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Axiom() throws ParseException {
        OWLAxiom ax = null;
        if (jj_2_48(2)) {
            ax = ClassAxiom();
        } else if (jj_2_49(2)) {
            ax = ObjectPropertyAxiom();
        } else if (jj_2_50(2)) {
            ax = DataPropertyAxiom();
        } else if (jj_2_51(2)) {
            ax = IndividualAxiom();
        } else if (jj_2_52(2)) {
            ax = Declaration();
        } else if (jj_2_53(2)) {
            ax = HasKey();
        } else if (jj_2_54(2)) {
            ax = DatatypeDefinitionAxiom();
        } else if (jj_2_55(2)) {
            ax = AnnotationAxiom();
        } else if (jj_2_56(2)) {
            ax = DLSafeRule();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Class Axioms
    //
    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Class axiom.
     * 
     * @return the oWL class axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassAxiom ClassAxiom() throws ParseException {
        OWLClassAxiom ax;
        if (jj_2_57(2)) {
            ax = SubClassOf();
        } else if (jj_2_58(2)) {
            ax = EquivalentClasses();
        } else if (jj_2_59(2)) {
            ax = DisjointClasses();
        } else if (jj_2_60(2)) {
            ax = DisjointUnion();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Sub class of.
     * 
     * @return the oWL class axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassAxiom SubClassOf() throws ParseException {
        OWLClassExpression subClass;
        OWLClassExpression superClass;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SUBCLASSOF);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        subClass = ClassExpression();
        superClass = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSubClassOfAxiom(subClass, superClass,
                axiomAnnos);
    }

    /**
     * Equivalent classes.
     * 
     * @return the oWL class axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassAxiom EquivalentClasses() throws ParseException {
        Set<OWLClassExpression> classExpressions;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(EQUIVALENTCLASSES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        classExpressions = ClassExpressionSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLEquivalentClassesAxiom(classExpressions,
                axiomAnnos);
    }

    /**
     * Disjoint classes.
     * 
     * @return the oWL class axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassAxiom DisjointClasses() throws ParseException {
        Set<OWLClassExpression> classExpressions;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DISJOINTCLASSES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        classExpressions = ClassExpressionSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDisjointClassesAxiom(classExpressions,
                axiomAnnos);
    }

    /**
     * Disjoint union.
     * 
     * @return the oWL class axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassAxiom DisjointUnion() throws ParseException {
        OWLClass cls;
        Set<OWLClassExpression> classExpressions;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DISJOINTUNION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        cls = ClassIRI();
        classExpressions = ClassExpressionSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDisjointUnionAxiom(cls, classExpressions,
                axiomAnnos);
    }

    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Object Property Axioms
    //
    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Object property axiom.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom ObjectPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        if (jj_2_61(2)) {
            ax = SubObjectPropertyOf();
        } else if (jj_2_62(2)) {
            ax = EquivalentObjectProperties();
        } else if (jj_2_63(2)) {
            ax = DisjointObjectProperties();
        } else if (jj_2_64(2)) {
            ax = ObjectPropertyRange();
        } else if (jj_2_65(2)) {
            ax = ObjectPropertyDomain();
        } else if (jj_2_66(2)) {
            ax = FunctionalObjectProperty();
        } else if (jj_2_67(2)) {
            ax = InverseFunctionalObjectProperty();
        } else if (jj_2_68(2)) {
            ax = SymmetricObjectProperty();
        } else if (jj_2_69(2)) {
            ax = AsymmetricObjectProperty();
        } else if (jj_2_70(2)) {
            ax = ReflexiveObjectProperty();
        } else if (jj_2_71(2)) {
            ax = IrreflexiveObjectProperty();
        } else if (jj_2_72(2)) {
            ax = TransitiveObjectProperty();
        } else if (jj_2_73(2)) {
            ax = InverseObjectProperties();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Sub object property chain.
     * 
     * @return the list
     * @throws ParseException
     *         the parse exception
     */
    final public List<OWLObjectPropertyExpression> SubObjectPropertyChain()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        List<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
        jj_consume_token(SUBOBJECTPROPERTYCHAIN);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        props.add(prop);
        label_10: while (true) {
            if (jj_2_74(2)) {} else {
                break label_10;
            }
            prop = ObjectPropertyExpression();
            props.add(prop);
        }
        jj_consume_token(CLOSEPAR);
        return props;
    }

    /**
     * Sub object property of.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom SubObjectPropertyOf() throws ParseException {
        OWLObjectPropertyExpression subProperty = null;
        List<OWLObjectPropertyExpression> chain = null;
        OWLObjectPropertyExpression superProperty = null;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SUBOBJECTPROPERTYOF);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        if (jj_2_75(2)) {
            subProperty = ObjectPropertyExpression();
        } else if (jj_2_76(2)) {
            chain = SubObjectPropertyChain();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        superProperty = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        if (subProperty != null) {
            return dataFactory.getOWLSubObjectPropertyOfAxiom(subProperty,
                    superProperty, axiomAnnos);
        } else if (chain != null) {
            return dataFactory.getOWLSubPropertyChainOfAxiom(chain,
                    superProperty, axiomAnnos);
        } else {
            return null;
        }
    }

    /**
     * Equivalent object properties.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom EquivalentObjectProperties()
            throws ParseException {
        Set<OWLObjectPropertyExpression> props;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(EQUIVALENTOBJECTPROPERTIES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        props = ObjectPropertySet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLEquivalentObjectPropertiesAxiom(props,
                axiomAnnos);
    }

    /**
     * Disjoint object properties.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom DisjointObjectProperties()
            throws ParseException {
        Set<OWLObjectPropertyExpression> props;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DISJOINTOBJECTPROPERTIES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        props = ObjectPropertySet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDisjointObjectPropertiesAxiom(props,
                axiomAnnos);
    }

    /**
     * Object property set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLObjectPropertyExpression> ObjectPropertySet()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        prop = ObjectPropertyExpression();
        props.add(prop);
        prop = ObjectPropertyExpression();
        props.add(prop);
        label_11: while (true) {
            if (jj_2_77(2)) {} else {
                break label_11;
            }
            prop = ObjectPropertyExpression();
            props.add(prop);
        }
        return props;
    }

    /**
     * Object property range.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom ObjectPropertyRange() throws ParseException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression range;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(OBJECTPROPERTYRANGE);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        range = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectPropertyRangeAxiom(prop, range,
                axiomAnnos);
    }

    /**
     * Object property domain.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom ObjectPropertyDomain() throws ParseException {
        OWLObjectPropertyExpression prop;
        OWLClassExpression desc;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(OBJECTPROPERTYDOMAIN);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        desc = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectPropertyDomainAxiom(prop, desc,
                axiomAnnos);
    }

    /**
     * Functional object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom FunctionalObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos = Collections.emptySet();
        jj_consume_token(FUNCTIONALOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory
                .getOWLFunctionalObjectPropertyAxiom(prop, axiomAnnos);
    }

    /**
     * Inverse object properties.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom InverseObjectProperties()
            throws ParseException {
        OWLObjectPropertyExpression propA;
        OWLObjectPropertyExpression propB;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(INVERSEOBJECTPROPERTIES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        propA = ObjectPropertyExpression();
        propB = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLInverseObjectPropertiesAxiom(propA, propB,
                axiomAnnos);
    }

    /**
     * Inverse functional object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom InverseFunctionalObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(INVERSEFUNCTIONALOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop,
                axiomAnnos);
    }

    /**
     * Symmetric object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom SymmetricObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SYMMETRICOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, axiomAnnos);
    }

    /**
     * Asymmetric object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom AsymmetricObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(ASYMMETRICOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory
                .getOWLAsymmetricObjectPropertyAxiom(prop, axiomAnnos);
    }

    /**
     * Reflexive object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom ReflexiveObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(REFLEXIVEOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, axiomAnnos);
    }

    /**
     * Irreflexive object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom IrreflexiveObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(IRREFLEXIVEOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop,
                axiomAnnos);
    }

    /**
     * Transitive object property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom TransitiveObjectProperty()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(TRANSITIVEOBJECTPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory
                .getOWLTransitiveObjectPropertyAxiom(prop, axiomAnnos);
    }

    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Data Property Axioms
    //
    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Data property axiom.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom DataPropertyAxiom() throws ParseException {
        OWLPropertyAxiom ax;
        if (jj_2_78(2)) {
            ax = SubDataPropertyOf();
        } else if (jj_2_79(2)) {
            ax = EquivalentDataProperties();
        } else if (jj_2_80(2)) {
            ax = DisjointDataProperties();
        } else if (jj_2_81(2)) {
            ax = DataPropertyRange();
        } else if (jj_2_82(2)) {
            ax = DataPropertyDomain();
        } else if (jj_2_83(2)) {
            ax = FunctionalDataProperty();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Sub data property of.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom SubDataPropertyOf() throws ParseException {
        OWLDataPropertyExpression subProperty;
        OWLDataPropertyExpression superProperty;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SUBDATAPROPERTYOF);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        subProperty = DataPropertyExpression();
        superProperty = DataPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSubDataPropertyOfAxiom(subProperty,
                superProperty, axiomAnnos);
    }

    /**
     * Equivalent data properties.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom EquivalentDataProperties()
            throws ParseException {
        Set<OWLDataPropertyExpression> props;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(EQUIVALENTDATAPROPERTIES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        props = DataPropertySet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLEquivalentDataPropertiesAxiom(props,
                axiomAnnos);
    }

    /**
     * Disjoint data properties.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom DisjointDataProperties()
            throws ParseException {
        Set<OWLDataPropertyExpression> props;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DISJOINTDATAPROPERTIES);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        props = DataPropertySet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDisjointDataPropertiesAxiom(props, axiomAnnos);
    }

    /**
     * Data property set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLDataPropertyExpression> DataPropertySet()
            throws ParseException {
        OWLDataPropertyExpression prop;
        Set<OWLDataPropertyExpression> props = new HashSet<OWLDataPropertyExpression>();
        prop = DataPropertyExpression();
        props.add(prop);
        prop = DataPropertyExpression();
        props.add(prop);
        label_12: while (true) {
            if (jj_2_84(2)) {} else {
                break label_12;
            }
            prop = DataPropertyExpression();
            props.add(prop);
        }
        return props;
    }

    /**
     * Data property domain.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom DataPropertyDomain() throws ParseException {
        OWLDataPropertyExpression prop;
        OWLClassExpression domain;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DATAPROPERTYDOMAIN);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = DataPropertyExpression();
        domain = ClassExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataPropertyDomainAxiom(prop, domain,
                axiomAnnos);
    }

    /**
     * Data property range.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom DataPropertyRange() throws ParseException {
        OWLDataPropertyExpression prop;
        OWLDataRange rng;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DATAPROPERTYRANGE);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = DataPropertyExpression();
        rng = DataRange();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataPropertyRangeAxiom(prop, rng, axiomAnnos);
    }

    /**
     * Functional data property.
     * 
     * @return the oWL property axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLPropertyAxiom FunctionalDataProperty()
            throws ParseException {
        OWLDataPropertyExpression prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(FUNCTIONALDATAPROPERTY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = DataPropertyExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLFunctionalDataPropertyAxiom(prop, axiomAnnos);
    }

    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Individual Axioms
    //
    // /////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Individual axiom.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom IndividualAxiom() throws ParseException {
        OWLIndividualAxiom ax;
        if (jj_2_85(2)) {
            ax = SameIndividuals();
        } else if (jj_2_86(2)) {
            ax = DifferentIndividuals();
        } else if (jj_2_87(2)) {
            ax = ClassAssertion();
        } else if (jj_2_88(2)) {
            ax = ObjectPropertyAssertion();
        } else if (jj_2_89(2)) {
            ax = DataPropertyAssertion();
        } else if (jj_2_90(2)) {
            ax = NegativeObjectPropertyAssertion();
        } else if (jj_2_91(2)) {
            ax = NegativeDataPropertyAssertion();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Individual set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLIndividual> IndividualSet() throws ParseException {
        OWLIndividual ind;
        Set<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        ind = Individual();
        individuals.add(ind);
        ind = Individual();
        individuals.add(ind);
        label_13: while (true) {
            if (jj_2_92(2)) {} else {
                break label_13;
            }
            ind = Individual();
            individuals.add(ind);
        }
        return individuals;
    }

    /**
     * Same individuals.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom SameIndividuals() throws ParseException {
        Set<OWLIndividual> individuals;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SAMEINDIVIDUAL);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        individuals = IndividualSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSameIndividualAxiom(individuals, axiomAnnos);
    }

    /**
     * Different individuals.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom DifferentIndividuals()
            throws ParseException {
        Set<OWLIndividual> individuals;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DIFFERENTINDIVIDUALS);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        individuals = IndividualSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDifferentIndividualsAxiom(individuals,
                axiomAnnos);
    }

    /**
     * Class assertion.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom ClassAssertion() throws ParseException {
        OWLIndividual ind;
        OWLClassExpression desc;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(CLASSASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        desc = ClassExpression();
        ind = Individual();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLClassAssertionAxiom(desc, ind, axiomAnnos);
    }

    /**
     * Object property assertion.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom ObjectPropertyAssertion()
            throws ParseException {
        OWLIndividual subj;
        OWLObjectPropertyExpression prop;
        OWLIndividual obj;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(OBJECTPROPERTYASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        subj = Individual();
        obj = Individual();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj,
                axiomAnnos);
    }

    /**
     * Negative object property assertion.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom NegativeObjectPropertyAssertion()
            throws ParseException {
        OWLIndividual subj;
        OWLObjectPropertyExpression prop;
        OWLIndividual obj;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(NEGATIVEOBJECTPROPERTYASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = ObjectPropertyExpression();
        subj = Individual();
        obj = Individual();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLNegativeObjectPropertyAssertionAxiom(prop,
                subj, obj, axiomAnnos);
    }

    /**
     * Data property assertion.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom DataPropertyAssertion()
            throws ParseException {
        OWLIndividual subj;
        OWLDataPropertyExpression prop;
        OWLLiteral obj;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DATAPROPERTYASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = DataPropertyExpression();
        subj = Individual();
        obj = Literal();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLDataPropertyAssertionAxiom(prop, subj, obj,
                axiomAnnos);
    }

    /**
     * Negative data property assertion.
     * 
     * @return the oWL individual axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividualAxiom NegativeDataPropertyAssertion()
            throws ParseException {
        OWLIndividual subj;
        OWLDataPropertyExpression prop;
        OWLLiteral obj;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(NEGATIVEDATAPROPERTYASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = DataPropertyExpression();
        subj = Individual();
        obj = Literal();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLNegativeDataPropertyAssertionAxiom(prop, subj,
                obj, axiomAnnos);
    }

    /**
     * Individual iri.
     * 
     * @return the oWL named individual
     * @throws ParseException
     *         the parse exception
     */
    final public OWLNamedIndividual IndividualIRI() throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLNamedIndividual(iri);
    }

    /**
     * Individual.
     * 
     * @return the oWL individual
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividual Individual() throws ParseException {
        OWLIndividual ind;
        if (jj_2_93(2)) {
            ind = IndividualIRI();
        } else if (jj_2_94(2)) {
            ind = AnonymousIndividual();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ind;
    }

    /**
     * Object property iri.
     * 
     * @return the oWL object property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLObjectProperty ObjectPropertyIRI() throws ParseException {
        IRI iri;
        iri = IRI();
        return dataFactory.getOWLObjectProperty(iri);
    }

    // //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Annotation Stuff
    //
    // //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Annotation axiom.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom AnnotationAxiom() throws ParseException {
        OWLAxiom axiom;
        if (jj_2_95(2)) {
            axiom = AnnotationAssertion();
        } else if (jj_2_96(2)) {
            axiom = AnnotationPropertyDomain();
        } else if (jj_2_97(2)) {
            axiom = AnnotationPropertyRange();
        } else if (jj_2_98(2)) {
            axiom = SubAnnotationPropertyOf();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return axiom;
    }

    /**
     * Annotation.
     * 
     * @return the oWL annotation
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotation Annotation() throws ParseException {
        OWLAnnotationProperty prop;
        OWLAnnotationValue val;
        Set<OWLAnnotation> annos = null;
        OWLAnnotation anno = null;
        jj_consume_token(ANNOTATION);
        annos = new HashSet<OWLAnnotation>();
        jj_consume_token(OPENPAR);
        label_14: while (true) {
            if (jj_2_99(2)) {} else {
                break label_14;
            }
            anno = Annotation();
            annos.add(anno);
        }
        prop = AnnotationPropertyIRI();
        val = AnnotationValue();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLAnnotation(prop, val, annos);
    }

    /**
     * Annotation subject.
     * 
     * @return the oWL annotation subject
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationSubject AnnotationSubject() throws ParseException {
        OWLAnnotationSubject subj;
        if (jj_2_100(2)) {
            subj = IRI();
        } else if (jj_2_101(2)) {
            subj = AnonymousIndividual();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return subj;
    }

    /**
     * Annotation value.
     * 
     * @return the oWL annotation value
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationValue AnnotationValue() throws ParseException {
        OWLAnnotationValue value;
        if (jj_2_102(2)) {
            value = IRI();
        } else if (jj_2_103(2)) {
            value = AnonymousIndividual();
        } else if (jj_2_104(2)) {
            value = Literal();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return value;
    }

    /**
     * Axiom annotation set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLAnnotation> AxiomAnnotationSet() throws ParseException {
        Set<OWLAnnotation> annos = null;
        OWLAnnotation anno;
        label_15: while (true) {
            if (jj_2_105(2)) {} else {
                break label_15;
            }
            anno = Annotation();
            if (annos == null) {
                annos = new HashSet<OWLAnnotation>();
            }
            annos.add(anno);
        }
        if (annos == null) {
            annos = Collections.emptySet();
        }
        return annos;
    }

    /**
     * Imports declaration.
     * 
     * @return the oWL imports declaration
     * @throws ParseException
     *         the parse exception
     */
    final public OWLImportsDeclaration ImportsDeclaration()
            throws ParseException {
        IRI iri;
        jj_consume_token(IMPORT);
        jj_consume_token(OPENPAR);
        iri = IRI();
        jj_consume_token(CLOSEPAR);
        OWLImportsDeclaration importsDeclaration = dataFactory
                .getOWLImportsDeclaration(iri);
        return importsDeclaration;
    }

    /**
     * Annotation assertion.
     * 
     * @return the oWL annotation assertion axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationAssertionAxiom AnnotationAssertion()
            throws ParseException {
        OWLAnnotationProperty prop;
        OWLAnnotationSubject subj;
        OWLAnnotationValue val;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(ANNOTATIONASSERTION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = AnnotationPropertyIRI();
        subj = AnnotationSubject();
        val = AnnotationValue();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLAnnotationAssertionAxiom(prop, subj, val,
                axiomAnnos);
    }

    /**
     * Sub annotation property of.
     * 
     * @return the oWL sub annotation property of axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLSubAnnotationPropertyOfAxiom SubAnnotationPropertyOf()
            throws ParseException {
        OWLAnnotationProperty subProp;
        OWLAnnotationProperty superProperty;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(SUBANNOTATIONPROPERTYOF);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        subProp = AnnotationPropertyIRI();
        superProperty = AnnotationPropertyIRI();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSubAnnotationPropertyOfAxiom(subProp,
                superProperty, axiomAnnos);
    }

    /**
     * Annotation property domain.
     * 
     * @return the oWL annotation property domain axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationPropertyDomainAxiom AnnotationPropertyDomain()
            throws ParseException {
        IRI domain;
        OWLAnnotationProperty prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(ANNOTATIONPROPERTYDOMAIN);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = AnnotationPropertyIRI();
        domain = IRI();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, domain,
                axiomAnnos);
    }

    /**
     * Annotation property range.
     * 
     * @return the oWL annotation property range axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAnnotationPropertyRangeAxiom AnnotationPropertyRange()
            throws ParseException {
        IRI range;
        OWLAnnotationProperty prop;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(ANNOTATIONPROPERTYRANGE);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        prop = AnnotationPropertyIRI();
        range = IRI();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, range,
                axiomAnnos);
    }

    /**
     * Checks for key.
     * 
     * @return the oWL has key axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLHasKeyAxiom HasKey() throws ParseException {
        OWLClassExpression ce;
        OWLPropertyExpression<?, ?> prop;
        Set<OWLPropertyExpression<?, ?>> props = new HashSet<OWLPropertyExpression<?, ?>>();
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(HASKEY);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        ce = ClassExpression();
        jj_consume_token(OPENPAR);
        label_16: while (true) {
            if (jj_2_106(2)) {} else {
                break label_16;
            }
            prop = ObjectPropertyExpression();
            props.add(prop);
        }
        jj_consume_token(CLOSEPAR);
        jj_consume_token(OPENPAR);
        label_17: while (true) {
            if (jj_2_107(2)) {} else {
                break label_17;
            }
            prop = DataPropertyExpression();
            props.add(prop);
        }
        jj_consume_token(CLOSEPAR);
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLHasKeyAxiom(ce, props, axiomAnnos);
    }

    /**
     * Declaration.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Declaration() throws ParseException {
        OWLEntity entity = null;
        Set<OWLAnnotation> axiomAnnos;
        jj_consume_token(DECLARATION);
        jj_consume_token(OPENPAR);
        axiomAnnos = AxiomAnnotationSet();
        entity = Entity();
        jj_consume_token(CLOSEPAR);
        if (ignoreAnnotationsAndDeclarations) {
            return null;
        } else {
            return dataFactory.getOWLDeclarationAxiom(entity, axiomAnnos);
        }
    }

    /**
     * Entity.
     * 
     * @return the oWL entity
     * @throws ParseException
     *         the parse exception
     */
    final public OWLEntity Entity() throws ParseException {
        OWLEntity entity;
        if (jj_2_108(2)) {
            entity = Class();
        } else if (jj_2_109(2)) {
            entity = ObjectProperty();
        } else if (jj_2_110(2)) {
            entity = DataProperty();
        } else if (jj_2_111(2)) {
            entity = NamedIndividual();
        } else if (jj_2_112(2)) {
            entity = Datatype();
        } else if (jj_2_113(2)) {
            entity = AnnotationProperty();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return entity;
    }

    // //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Data Stuff
    //
    // //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Literal.
     * 
     * @return the oWL literal
     * @throws ParseException
     *         the parse exception
     */
    final public OWLLiteral Literal() throws ParseException {
        boolean plain = true;
        String literal;
        OWLDatatype datatype = null;
        String lang = "";
        literal = QuotedString();
        if (jj_2_116(2)) {
            if (jj_2_114(2)) {
                jj_consume_token(DATATYPEIDENTIFIER);
                plain = false;
                datatype = DatatypeIRI();
            } else if (jj_2_115(2)) {
                jj_consume_token(LANGIDENTIFIER);
                lang = LangTag();
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (plain) {
            return dataFactory.getOWLLiteral(literal, lang);
        } else {
            // a float value in this syntax has an extra 'f' or 'F' character
            // that must be removed to make a valid OWL literal
            if (datatype.isFloat()
                    && (literal.endsWith("f") || literal.endsWith("F"))
                    && !(literal.endsWith("inf") || literal.endsWith("INF"))) {
                literal = literal.substring(0, literal.length() - 1);
            }
            return dataFactory.getOWLLiteral(literal, datatype);
        }
    }

    /**
     * Quoted string.
     * 
     * @return the string
     * @throws ParseException
     *         the parse exception
     */
    final public String QuotedString() throws ParseException {
        Token t;
        t = jj_consume_token(STRINGLITERAL);
        String raw = t.image.substring(1, t.image.length() - 1);
        return EscapeUtils.unescapeString(raw);
    }

    /**
     * Lang tag.
     * 
     * @return the string
     * @throws ParseException
     *         the parse exception
     */
    final public String LangTag() throws ParseException {
        String lang = "";
        Token t;
        t = jj_consume_token(PN_LOCAL);
        lang += t.image;
        return lang;
    }

    // ////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // Rules
    //
    // ////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * DL safe rule.
     * 
     * @return the sWRL rule
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLRule DLSafeRule() throws ParseException {
        Set<OWLAnnotation> annos;
        SWRLAtom atom;
        Set<SWRLAtom> body;
        Set<SWRLAtom> head;
        jj_consume_token(DLSAFERULE);
        jj_consume_token(OPENPAR);
        annos = AxiomAnnotationSet();
        jj_consume_token(BODY);
        body = new HashSet<SWRLAtom>();
        jj_consume_token(OPENPAR);
        label_18: while (true) {
            if (jj_2_117(2)) {} else {
                break label_18;
            }
            atom = Atom();
            body.add(atom);
        }
        jj_consume_token(CLOSEPAR);
        jj_consume_token(HEAD);
        head = new HashSet<SWRLAtom>();
        jj_consume_token(OPENPAR);
        label_19: while (true) {
            if (jj_2_118(2)) {} else {
                break label_19;
            }
            atom = Atom();
            head.add(atom);
        }
        jj_consume_token(CLOSEPAR);
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLRule(body, head, annos);
    }

    /**
     * Atom.
     * 
     * @return the sWRL atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLAtom Atom() throws ParseException {
        SWRLAtom atom;
        if (jj_2_119(2)) {
            atom = ClassAtom();
        } else if (jj_2_120(2)) {
            atom = DataRangeAtom();
        } else if (jj_2_121(2)) {
            atom = ObjectPropertyAtom();
        } else if (jj_2_122(2)) {
            atom = DataPropertyAtom();
        } else if (jj_2_123(2)) {
            atom = BuiltInAtom();
        } else if (jj_2_124(2)) {
            atom = SameIndividualAtom();
        } else if (jj_2_125(2)) {
            atom = DifferentIndividualsAtom();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return atom;
    }

    /**
     * Class atom.
     * 
     * @return the sWRL class atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLClassAtom ClassAtom() throws ParseException {
        OWLClassExpression ce;
        SWRLIArgument arg0;
        jj_consume_token(CLASSATOM);
        jj_consume_token(OPENPAR);
        ce = ClassExpression();
        arg0 = IArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLClassAtom(ce, arg0);
    }

    /**
     * Data range atom.
     * 
     * @return the sWRL data range atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLDataRangeAtom DataRangeAtom() throws ParseException {
        OWLDataRange rng;
        SWRLDArgument arg0;
        jj_consume_token(DATARANGEATOM);
        jj_consume_token(OPENPAR);
        rng = DataRange();
        arg0 = DArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLDataRangeAtom(rng, arg0);
    }

    /**
     * Object property atom.
     * 
     * @return the sWRL object property atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLObjectPropertyAtom ObjectPropertyAtom()
            throws ParseException {
        OWLObjectPropertyExpression prop;
        SWRLIArgument arg0;
        SWRLIArgument arg1;
        jj_consume_token(OBJECTPROPERTYATOM);
        jj_consume_token(OPENPAR);
        prop = ObjectPropertyExpression();
        arg0 = IArg();
        arg1 = IArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLObjectPropertyAtom(prop, arg0, arg1);
    }

    /**
     * Data property atom.
     * 
     * @return the sWRL data property atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLDataPropertyAtom DataPropertyAtom() throws ParseException {
        OWLDataProperty prop;
        SWRLIArgument arg0;
        SWRLDArgument arg1;
        jj_consume_token(DATAPROPERTYATOM);
        jj_consume_token(OPENPAR);
        prop = DataPropertyIRI();
        arg0 = IArg();
        arg1 = DArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLDataPropertyAtom(prop, arg0, arg1);
    }

    /**
     * Built in atom.
     * 
     * @return the sWRL built in atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLBuiltInAtom BuiltInAtom() throws ParseException {
        IRI iri;
        List<SWRLDArgument> args;
        SWRLDArgument arg;
        jj_consume_token(BUILTINATOM);
        jj_consume_token(OPENPAR);
        args = new ArrayList<SWRLDArgument>();
        iri = IRI();
        arg = DArg();
        args.add(arg);
        label_20: while (true) {
            if (jj_2_126(2)) {} else {
                break label_20;
            }
            arg = DArg();
            args.add(arg);
        }
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLBuiltInAtom(iri, args);
    }

    /**
     * Same individual atom.
     * 
     * @return the sWRL same individual atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLSameIndividualAtom SameIndividualAtom()
            throws ParseException {
        SWRLIArgument arg0;
        SWRLIArgument arg1;
        jj_consume_token(SAMEINDIVIDUALATOM);
        jj_consume_token(OPENPAR);
        arg0 = IArg();
        arg1 = IArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLSameIndividualAtom(arg0, arg1);
    }

    /**
     * Different individuals atom.
     * 
     * @return the sWRL different individuals atom
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLDifferentIndividualsAtom DifferentIndividualsAtom()
            throws ParseException {
        SWRLIArgument arg0;
        SWRLIArgument arg1;
        jj_consume_token(DIFFERENTINDIVIDUALSATOM);
        jj_consume_token(OPENPAR);
        arg0 = IArg();
        arg1 = IArg();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getSWRLDifferentIndividualsAtom(arg0, arg1);
    }

    /**
     * I arg.
     * 
     * @return the sWRLI argument
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLIArgument IArg() throws ParseException {
        OWLNamedIndividual ind;
        IRI iri;
        if (jj_2_127(2)) {
            jj_consume_token(VARIABLE);
            jj_consume_token(OPENPAR);
            iri = IRI();
            jj_consume_token(CLOSEPAR);
            return dataFactory.getSWRLVariable(iri);
        } else if (jj_2_128(2)) {
            ind = IndividualIRI();
            return dataFactory.getSWRLIndividualArgument(ind);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    /**
     * D arg.
     * 
     * @return the sWRLD argument
     * @throws ParseException
     *         the parse exception
     */
    final public SWRLDArgument DArg() throws ParseException {
        OWLLiteral literal;
        IRI iri;
        if (jj_2_129(2)) {
            jj_consume_token(VARIABLE);
            jj_consume_token(OPENPAR);
            iri = IRI();
            jj_consume_token(CLOSEPAR);
            return dataFactory.getSWRLVariable(iri);
        } else if (jj_2_130(2)) {
            literal = Literal();
            return dataFactory.getSWRLLiteralArgument(literal);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    /**
     * Jj_2_1.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    /**
     * Jj_2_2.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    /**
     * Jj_2_3.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    /**
     * Jj_2_4.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    /**
     * Jj_2_5.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    /**
     * Jj_2_6.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    /**
     * Jj_2_7.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    /**
     * Jj_2_8.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    /**
     * Jj_2_9.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    /**
     * Jj_2_10.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_10();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    /**
     * Jj_2_11.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_11();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    /**
     * Jj_2_12.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_12();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    /**
     * Jj_2_13.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_13();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    /**
     * Jj_2_14.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_14();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    /**
     * Jj_2_15.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_15();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    /**
     * Jj_2_16.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_16(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_16();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(15, xla);
        }
    }

    /**
     * Jj_2_17.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_17(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_17();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(16, xla);
        }
    }

    /**
     * Jj_2_18.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_18(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_18();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(17, xla);
        }
    }

    /**
     * Jj_2_19.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_19(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_19();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(18, xla);
        }
    }

    /**
     * Jj_2_20.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_20(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_20();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(19, xla);
        }
    }

    /**
     * Jj_2_21.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_21(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_21();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(20, xla);
        }
    }

    /**
     * Jj_2_22.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_22(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_22();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(21, xla);
        }
    }

    /**
     * Jj_2_23.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_23(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_23();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(22, xla);
        }
    }

    /**
     * Jj_2_24.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_24(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_24();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(23, xla);
        }
    }

    /**
     * Jj_2_25.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_25(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_25();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(24, xla);
        }
    }

    /**
     * Jj_2_26.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_26(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_26();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(25, xla);
        }
    }

    /**
     * Jj_2_27.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_27(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_27();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(26, xla);
        }
    }

    /**
     * Jj_2_28.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_28(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_28();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(27, xla);
        }
    }

    /**
     * Jj_2_29.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_29(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_29();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(28, xla);
        }
    }

    /**
     * Jj_2_30.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_30(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_30();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(29, xla);
        }
    }

    /**
     * Jj_2_31.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_31(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_31();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(30, xla);
        }
    }

    /**
     * Jj_2_32.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_32(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_32();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(31, xla);
        }
    }

    /**
     * Jj_2_33.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_33(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_33();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(32, xla);
        }
    }

    /**
     * Jj_2_34.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_34(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_34();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(33, xla);
        }
    }

    /**
     * Jj_2_35.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_35(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_35();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(34, xla);
        }
    }

    /**
     * Jj_2_36.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_36(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_36();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(35, xla);
        }
    }

    /**
     * Jj_2_37.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_37(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_37();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(36, xla);
        }
    }

    /**
     * Jj_2_38.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_38(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_38();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(37, xla);
        }
    }

    /**
     * Jj_2_39.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_39(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_39();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(38, xla);
        }
    }

    /**
     * Jj_2_40.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_40(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_40();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(39, xla);
        }
    }

    /**
     * Jj_2_41.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_41(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_41();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(40, xla);
        }
    }

    /**
     * Jj_2_42.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_42(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_42();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(41, xla);
        }
    }

    /**
     * Jj_2_43.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_43(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_43();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(42, xla);
        }
    }

    /**
     * Jj_2_44.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_44(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_44();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(43, xla);
        }
    }

    /**
     * Jj_2_45.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_45(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_45();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(44, xla);
        }
    }

    /**
     * Jj_2_46.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_46(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_46();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(45, xla);
        }
    }

    /**
     * Jj_2_47.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_47(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_47();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(46, xla);
        }
    }

    /**
     * Jj_2_48.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_48(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_48();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(47, xla);
        }
    }

    /**
     * Jj_2_49.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_49(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_49();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(48, xla);
        }
    }

    /**
     * Jj_2_50.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_50(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_50();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(49, xla);
        }
    }

    /**
     * Jj_2_51.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_51(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_51();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(50, xla);
        }
    }

    /**
     * Jj_2_52.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_52(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_52();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(51, xla);
        }
    }

    /**
     * Jj_2_53.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_53(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_53();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(52, xla);
        }
    }

    /**
     * Jj_2_54.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_54(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_54();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(53, xla);
        }
    }

    /**
     * Jj_2_55.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_55(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_55();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(54, xla);
        }
    }

    /**
     * Jj_2_56.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_56(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_56();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(55, xla);
        }
    }

    /**
     * Jj_2_57.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_57(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_57();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(56, xla);
        }
    }

    /**
     * Jj_2_58.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_58(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_58();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(57, xla);
        }
    }

    /**
     * Jj_2_59.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_59(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_59();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(58, xla);
        }
    }

    /**
     * Jj_2_60.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_60(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_60();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(59, xla);
        }
    }

    /**
     * Jj_2_61.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_61(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_61();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(60, xla);
        }
    }

    /**
     * Jj_2_62.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_62(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_62();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(61, xla);
        }
    }

    /**
     * Jj_2_63.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_63(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_63();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(62, xla);
        }
    }

    /**
     * Jj_2_64.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_64(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_64();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(63, xla);
        }
    }

    /**
     * Jj_2_65.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_65(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_65();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(64, xla);
        }
    }

    /**
     * Jj_2_66.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_66(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_66();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(65, xla);
        }
    }

    /**
     * Jj_2_67.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_67(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_67();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(66, xla);
        }
    }

    /**
     * Jj_2_68.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_68(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_68();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(67, xla);
        }
    }

    /**
     * Jj_2_69.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_69(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_69();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(68, xla);
        }
    }

    /**
     * Jj_2_70.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_70(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_70();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(69, xla);
        }
    }

    /**
     * Jj_2_71.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_71(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_71();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(70, xla);
        }
    }

    /**
     * Jj_2_72.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_72(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_72();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(71, xla);
        }
    }

    /**
     * Jj_2_73.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_73(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_73();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(72, xla);
        }
    }

    /**
     * Jj_2_74.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_74(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_74();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(73, xla);
        }
    }

    /**
     * Jj_2_75.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_75(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_75();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(74, xla);
        }
    }

    /**
     * Jj_2_76.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_76(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_76();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(75, xla);
        }
    }

    /**
     * Jj_2_77.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_77(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_77();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(76, xla);
        }
    }

    /**
     * Jj_2_78.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_78(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_78();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(77, xla);
        }
    }

    /**
     * Jj_2_79.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_79(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_79();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(78, xla);
        }
    }

    /**
     * Jj_2_80.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_80(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_80();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(79, xla);
        }
    }

    /**
     * Jj_2_81.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_81(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_81();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(80, xla);
        }
    }

    /**
     * Jj_2_82.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_82(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_82();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(81, xla);
        }
    }

    /**
     * Jj_2_83.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_83(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_83();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(82, xla);
        }
    }

    /**
     * Jj_2_84.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_84(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_84();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(83, xla);
        }
    }

    /**
     * Jj_2_85.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_85(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_85();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(84, xla);
        }
    }

    /**
     * Jj_2_86.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_86(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_86();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(85, xla);
        }
    }

    /**
     * Jj_2_87.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_87(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_87();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(86, xla);
        }
    }

    /**
     * Jj_2_88.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_88(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_88();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(87, xla);
        }
    }

    /**
     * Jj_2_89.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_89(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_89();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(88, xla);
        }
    }

    /**
     * Jj_2_90.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_90(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_90();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(89, xla);
        }
    }

    /**
     * Jj_2_91.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_91(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_91();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(90, xla);
        }
    }

    /**
     * Jj_2_92.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_92(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_92();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(91, xla);
        }
    }

    /**
     * Jj_2_93.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_93(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_93();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(92, xla);
        }
    }

    /**
     * Jj_2_94.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_94(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_94();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(93, xla);
        }
    }

    /**
     * Jj_2_95.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_95(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_95();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(94, xla);
        }
    }

    /**
     * Jj_2_96.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_96(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_96();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(95, xla);
        }
    }

    /**
     * Jj_2_97.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_97(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_97();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(96, xla);
        }
    }

    /**
     * Jj_2_98.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_98(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_98();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(97, xla);
        }
    }

    /**
     * Jj_2_99.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_99(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_99();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(98, xla);
        }
    }

    /**
     * Jj_2_100.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_100(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_100();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(99, xla);
        }
    }

    /**
     * Jj_2_101.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_101(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_101();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(100, xla);
        }
    }

    /**
     * Jj_2_102.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_102(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_102();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(101, xla);
        }
    }

    /**
     * Jj_2_103.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_103(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_103();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(102, xla);
        }
    }

    /**
     * Jj_2_104.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_104(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_104();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(103, xla);
        }
    }

    /**
     * Jj_2_105.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_105(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_105();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(104, xla);
        }
    }

    /**
     * Jj_2_106.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_106(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_106();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(105, xla);
        }
    }

    /**
     * Jj_2_107.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_107(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_107();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(106, xla);
        }
    }

    /**
     * Jj_2_108.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_108(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_108();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(107, xla);
        }
    }

    /**
     * Jj_2_109.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_109(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_109();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(108, xla);
        }
    }

    /**
     * Jj_2_110.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_110(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_110();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(109, xla);
        }
    }

    /**
     * Jj_2_111.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_111(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_111();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(110, xla);
        }
    }

    /**
     * Jj_2_112.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_112(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_112();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(111, xla);
        }
    }

    /**
     * Jj_2_113.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_113(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_113();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(112, xla);
        }
    }

    /**
     * Jj_2_114.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_114(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_114();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(113, xla);
        }
    }

    /**
     * Jj_2_115.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_115(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_115();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(114, xla);
        }
    }

    /**
     * Jj_2_116.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_116(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_116();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(115, xla);
        }
    }

    /**
     * Jj_2_117.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_117(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_117();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(116, xla);
        }
    }

    /**
     * Jj_2_118.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_118(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_118();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(117, xla);
        }
    }

    /**
     * Jj_2_119.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_119(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_119();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(118, xla);
        }
    }

    /**
     * Jj_2_120.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_120(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_120();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(119, xla);
        }
    }

    /**
     * Jj_2_121.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_121(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_121();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(120, xla);
        }
    }

    /**
     * Jj_2_122.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_122(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_122();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(121, xla);
        }
    }

    /**
     * Jj_2_123.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_123(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_123();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(122, xla);
        }
    }

    /**
     * Jj_2_124.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_124(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_124();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(123, xla);
        }
    }

    /**
     * Jj_2_125.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_125(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_125();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(124, xla);
        }
    }

    /**
     * Jj_2_126.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_126(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_126();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(125, xla);
        }
    }

    /**
     * Jj_2_127.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_127(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_127();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(126, xla);
        }
    }

    /**
     * Jj_2_128.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_128(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_128();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(127, xla);
        }
    }

    /**
     * Jj_2_129.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_129(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_129();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(128, xla);
        }
    }

    /**
     * Jj_2_130.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_130(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_130();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(129, xla);
        }
    }

    /**
     * Jj_3_84.
     * 
     * @return true, if successful
     */
    private boolean jj_3_84() {
        if (jj_3R_93()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_116.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_116() {
        if (jj_scan_token(DATARANGEATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_58.
     * 
     * @return true, if successful
     */
    private boolean jj_3_58() {
        if (jj_3R_69()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_41.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_41() {
        if (jj_scan_token(DATAALLVALUESFROM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_113.
     * 
     * @return true, if successful
     */
    private boolean jj_3_113() {
        if (jj_3R_112()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_68.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_68() {
        if (jj_scan_token(SUBCLASSOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_95.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_95() {
        if (jj_scan_token(DIFFERENTINDIVIDUALS)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_115.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_115() {
        if (jj_scan_token(CLASSATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_90.
     * 
     * @return true, if successful
     */
    private boolean jj_3_90() {
        if (jj_3R_99()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_43.
     * 
     * @return true, if successful
     */
    private boolean jj_3_43() {
        if (jj_3R_56()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_39.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_39() {
        if (jj_scan_token(OBJECTMAXCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_57.
     * 
     * @return true, if successful
     */
    private boolean jj_3_57() {
        if (jj_3R_68()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_86.
     * 
     * @return true, if successful
     */
    private boolean jj_3_86() {
        if (jj_3R_95()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_125.
     * 
     * @return true, if successful
     */
    private boolean jj_3_125() {
        if (jj_3R_121()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_94.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_94() {
        if (jj_scan_token(SAMEINDIVIDUAL)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_59.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_59() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_57()) {
            jj_scanpos = xsp;
            if (jj_3_58()) {
                jj_scanpos = xsp;
                if (jj_3_59()) {
                    jj_scanpos = xsp;
                    if (jj_3_60()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_124.
     * 
     * @return true, if successful
     */
    private boolean jj_3_124() {
        if (jj_3R_120()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_123.
     * 
     * @return true, if successful
     */
    private boolean jj_3_123() {
        if (jj_3R_119()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_112.
     * 
     * @return true, if successful
     */
    private boolean jj_3_112() {
        if (jj_3R_111()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_122.
     * 
     * @return true, if successful
     */
    private boolean jj_3_122() {
        if (jj_3R_118()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_121.
     * 
     * @return true, if successful
     */
    private boolean jj_3_121() {
        if (jj_3R_117()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_120.
     * 
     * @return true, if successful
     */
    private boolean jj_3_120() {
        if (jj_3R_116()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_119.
     * 
     * @return true, if successful
     */
    private boolean jj_3_119() {
        if (jj_3R_115()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_114.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_114() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_119()) {
            jj_scanpos = xsp;
            if (jj_3_120()) {
                jj_scanpos = xsp;
                if (jj_3_121()) {
                    jj_scanpos = xsp;
                    if (jj_3_122()) {
                        jj_scanpos = xsp;
                        if (jj_3_123()) {
                            jj_scanpos = xsp;
                            if (jj_3_124()) {
                                jj_scanpos = xsp;
                                if (jj_3_125()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_47.
     * 
     * @return true, if successful
     */
    private boolean jj_3_47() {
        if (jj_3R_58()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_56.
     * 
     * @return true, if successful
     */
    private boolean jj_3_56() {
        if (jj_3R_67()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_38.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_38() {
        if (jj_scan_token(OBJECTEXACTCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_55.
     * 
     * @return true, if successful
     */
    private boolean jj_3_55() {
        if (jj_3R_66()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_54.
     * 
     * @return true, if successful
     */
    private boolean jj_3_54() {
        if (jj_3R_65()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_67.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_67() {
        if (jj_scan_token(DLSAFERULE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_53.
     * 
     * @return true, if successful
     */
    private boolean jj_3_53() {
        if (jj_3R_64()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_52.
     * 
     * @return true, if successful
     */
    private boolean jj_3_52() {
        if (jj_3R_63()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_51.
     * 
     * @return true, if successful
     */
    private boolean jj_3_51() {
        if (jj_3R_62()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_50.
     * 
     * @return true, if successful
     */
    private boolean jj_3_50() {
        if (jj_3R_61()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_49.
     * 
     * @return true, if successful
     */
    private boolean jj_3_49() {
        if (jj_3R_60()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_42.
     * 
     * @return true, if successful
     */
    private boolean jj_3_42() {
        if (jj_3R_55()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_85.
     * 
     * @return true, if successful
     */
    private boolean jj_3_85() {
        if (jj_3R_94()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_89.
     * 
     * @return true, if successful
     */
    private boolean jj_3_89() {
        if (jj_3R_98()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_62.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_62() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_85()) {
            jj_scanpos = xsp;
            if (jj_3_86()) {
                jj_scanpos = xsp;
                if (jj_3_87()) {
                    jj_scanpos = xsp;
                    if (jj_3_88()) {
                        jj_scanpos = xsp;
                        if (jj_3_89()) {
                            jj_scanpos = xsp;
                            if (jj_3_90()) {
                                jj_scanpos = xsp;
                                if (jj_3_91()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_48.
     * 
     * @return true, if successful
     */
    private boolean jj_3_48() {
        if (jj_3R_59()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_25.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_25() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_48()) {
            jj_scanpos = xsp;
            if (jj_3_49()) {
                jj_scanpos = xsp;
                if (jj_3_50()) {
                    jj_scanpos = xsp;
                    if (jj_3_51()) {
                        jj_scanpos = xsp;
                        if (jj_3_52()) {
                            jj_scanpos = xsp;
                            if (jj_3_53()) {
                                jj_scanpos = xsp;
                                if (jj_3_54()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_55()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_56()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_111.
     * 
     * @return true, if successful
     */
    private boolean jj_3_111() {
        if (jj_3R_110()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_37.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_37() {
        if (jj_scan_token(OBJECTMINCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_113.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_113() {
        if (jj_scan_token(PN_LOCAL)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_92.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_92() {
        if (jj_scan_token(FUNCTIONALDATAPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_46.
     * 
     * @return true, if successful
     */
    private boolean jj_3_46() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_36.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_36() {
        if (jj_scan_token(OBJECTHASSELF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_58.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_58() {
        if (jj_3R_22()) {
            return true;
        }
        if (jj_3R_57()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_123.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_123() {
        if (jj_scan_token(STRINGLITERAL)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_90.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_90() {
        if (jj_scan_token(DATAPROPERTYRANGE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_41.
     * 
     * @return true, if successful
     */
    private boolean jj_3_41() {
        if (jj_3R_54()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_110.
     * 
     * @return true, if successful
     */
    private boolean jj_3_110() {
        if (jj_3R_109()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_35.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_35() {
        if (jj_scan_token(OBJECTHASVALUE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_54.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_54() {
        if (jj_scan_token(DATATYPERESTRICTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_45.
     * 
     * @return true, if successful
     */
    private boolean jj_3_45() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_91.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_91() {
        if (jj_scan_token(DATAPROPERTYDOMAIN)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_80.
     * 
     * @return true, if successful
     */
    private boolean jj_3_80() {
        if (jj_3R_89()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_115.
     * 
     * @return true, if successful
     */
    private boolean jj_3_115() {
        if (jj_scan_token(LANGIDENTIFIER)) {
            return true;
        }
        if (jj_3R_113()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_33.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_33() {
        if (jj_scan_token(OBJECTSOMEVALUESFROM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_114.
     * 
     * @return true, if successful
     */
    private boolean jj_3_114() {
        if (jj_scan_token(DATATYPEIDENTIFIER)) {
            return true;
        }
        if (jj_3R_51()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_116.
     * 
     * @return true, if successful
     */
    private boolean jj_3_116() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_114()) {
            jj_scanpos = xsp;
            if (jj_3_115()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3_14.
     * 
     * @return true, if successful
     */
    private boolean jj_3_14() {
        if (jj_3R_32()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_44.
     * 
     * @return true, if successful
     */
    private boolean jj_3_44() {
        if (jj_3R_57()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_83.
     * 
     * @return true, if successful
     */
    private boolean jj_3_83() {
        if (jj_3R_92()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_55.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_55() {
        if (jj_scan_token(DATAINTERSECTIONOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_57.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_57() {
        if (jj_3R_123()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_116()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     * Jj_3 r_34.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_34() {
        if (jj_scan_token(OBJECTALLVALUESFROM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_40.
     * 
     * @return true, if successful
     */
    private boolean jj_3_40() {
        if (jj_3R_53()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_109.
     * 
     * @return true, if successful
     */
    private boolean jj_3_109() {
        if (jj_3R_108()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_56.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_56() {
        if (jj_scan_token(DATAUNIONOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_18.
     * 
     * @return true, if successful
     */
    private boolean jj_3_18() {
        if (jj_3R_36()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_89.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_89() {
        if (jj_scan_token(DISJOINTDATAPROPERTIES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_25.
     * 
     * @return true, if successful
     */
    private boolean jj_3_25() {
        if (jj_3R_43()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_32.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_32() {
        if (jj_scan_token(OBJECTONEOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_52.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_52() {
        if (jj_scan_token(DATAONEOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_39.
     * 
     * @return true, if successful
     */
    private boolean jj_3_39() {
        if (jj_3R_52()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_13.
     * 
     * @return true, if successful
     */
    private boolean jj_3_13() {
        if (jj_3R_31()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_79.
     * 
     * @return true, if successful
     */
    private boolean jj_3_79() {
        if (jj_3R_88()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_82.
     * 
     * @return true, if successful
     */
    private boolean jj_3_82() {
        if (jj_3R_91()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_108.
     * 
     * @return true, if successful
     */
    private boolean jj_3_108() {
        if (jj_3R_107()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_31.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_31() {
        if (jj_scan_token(OBJECTCOMPLEMENTOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_88.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_88() {
        if (jj_scan_token(EQUIVALENTDATAPROPERTIES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_21.
     * 
     * @return true, if successful
     */
    private boolean jj_3_21() {
        if (jj_3R_39()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_53.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_53() {
        if (jj_scan_token(DATACOMPLEMENTOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_17.
     * 
     * @return true, if successful
     */
    private boolean jj_3_17() {
        if (jj_3R_35()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_30.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_30() {
        if (jj_scan_token(OBJECTINTERSECTIONOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_87.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_87() {
        if (jj_scan_token(SUBDATAPROPERTYOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_24.
     * 
     * @return true, if successful
     */
    private boolean jj_3_24() {
        if (jj_3R_42()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_63.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_63() {
        if (jj_scan_token(DECLARATION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_38.
     * 
     * @return true, if successful
     */
    private boolean jj_3_38() {
        if (jj_3R_51()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_48.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_48() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_38()) {
            jj_scanpos = xsp;
            if (jj_3_39()) {
                jj_scanpos = xsp;
                if (jj_3_40()) {
                    jj_scanpos = xsp;
                    if (jj_3_41()) {
                        jj_scanpos = xsp;
                        if (jj_3_42()) {
                            jj_scanpos = xsp;
                            if (jj_3_43()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_107.
     * 
     * @return true, if successful
     */
    private boolean jj_3_107() {
        if (jj_3R_93()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_29.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_29() {
        if (jj_scan_token(OBJECTUNIONOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_106.
     * 
     * @return true, if successful
     */
    private boolean jj_3_106() {
        if (jj_3R_85()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_78.
     * 
     * @return true, if successful
     */
    private boolean jj_3_78() {
        if (jj_3R_87()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_81.
     * 
     * @return true, if successful
     */
    private boolean jj_3_81() {
        if (jj_3R_90()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_61.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_61() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_78()) {
            jj_scanpos = xsp;
            if (jj_3_79()) {
                jj_scanpos = xsp;
                if (jj_3_80()) {
                    jj_scanpos = xsp;
                    if (jj_3_81()) {
                        jj_scanpos = xsp;
                        if (jj_3_82()) {
                            jj_scanpos = xsp;
                            if (jj_3_83()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3 r_65.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_65() {
        if (jj_scan_token(DATATYPEDEFINITION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_12.
     * 
     * @return true, if successful
     */
    private boolean jj_3_12() {
        if (jj_3R_30()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_29.
     * 
     * @return true, if successful
     */
    private boolean jj_3_29() {
        if (jj_3R_47()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_64.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_64() {
        if (jj_scan_token(HASKEY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_27.
     * 
     * @return true, if successful
     */
    private boolean jj_3_27() {
        if (jj_3R_45()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_20.
     * 
     * @return true, if successful
     */
    private boolean jj_3_20() {
        if (jj_3R_38()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_16.
     * 
     * @return true, if successful
     */
    private boolean jj_3_16() {
        if (jj_3R_34()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_23.
     * 
     * @return true, if successful
     */
    private boolean jj_3_23() {
        if (jj_3R_41()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_83.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_83() {
        if (jj_scan_token(TRANSITIVEOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_28.
     * 
     * @return true, if successful
     */
    private boolean jj_3_28() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_105.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_105() {
        if (jj_scan_token(ANNOTATIONPROPERTYRANGE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_11.
     * 
     * @return true, if successful
     */
    private boolean jj_3_11() {
        if (jj_3R_29()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_82.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_82() {
        if (jj_scan_token(IRREFLEXIVEOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_77.
     * 
     * @return true, if successful
     */
    private boolean jj_3_77() {
        if (jj_3R_85()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_28.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_28() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_104.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_104() {
        if (jj_scan_token(ANNOTATIONPROPERTYDOMAIN)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_81.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_81() {
        if (jj_scan_token(REFLEXIVEOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_51.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_51() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_26.
     * 
     * @return true, if successful
     */
    private boolean jj_3_26() {
        if (jj_3R_44()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_22.
     * 
     * @return true, if successful
     */
    private boolean jj_3_22() {
        if (jj_3R_40()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_19.
     * 
     * @return true, if successful
     */
    private boolean jj_3_19() {
        if (jj_3R_37()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_15.
     * 
     * @return true, if successful
     */
    private boolean jj_3_15() {
        if (jj_3R_33()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_10.
     * 
     * @return true, if successful
     */
    private boolean jj_3_10() {
        if (jj_3R_28()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_46.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_46() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_10()) {
            jj_scanpos = xsp;
            if (jj_3_11()) {
                jj_scanpos = xsp;
                if (jj_3_12()) {
                    jj_scanpos = xsp;
                    if (jj_3_13()) {
                        jj_scanpos = xsp;
                        if (jj_3_14()) {
                            jj_scanpos = xsp;
                            if (jj_3_15()) {
                                jj_scanpos = xsp;
                                if (jj_3_16()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_17()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_18()) {
                                            jj_scanpos = xsp;
                                            if (jj_3_19()) {
                                                jj_scanpos = xsp;
                                                if (jj_3_20()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3_21()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3_22()) {
                                                            jj_scanpos = xsp;
                                                            if (jj_3_23()) {
                                                                jj_scanpos = xsp;
                                                                if (jj_3_24()) {
                                                                    jj_scanpos = xsp;
                                                                    if (jj_3_25()) {
                                                                        jj_scanpos = xsp;
                                                                        if (jj_3_26()) {
                                                                            jj_scanpos = xsp;
                                                                            if (jj_3_27()) {
                                                                                return true;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3 r_106.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_106() {
        if (jj_scan_token(SUBANNOTATIONPROPERTYOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_111.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_111() {
        if (jj_scan_token(DATATYPE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_80.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_80() {
        if (jj_scan_token(ASYMMETRICOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_104.
     * 
     * @return true, if successful
     */
    private boolean jj_3_104() {
        if (jj_3R_57()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_103.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_103() {
        if (jj_scan_token(ANNOTATIONASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_102.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_102() {
        if (jj_scan_token(NODEID)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_79.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_79() {
        if (jj_scan_token(SYMMETRICOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_99.
     * 
     * @return true, if successful
     */
    private boolean jj_3_99() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_76.
     * 
     * @return true, if successful
     */
    private boolean jj_3_76() {
        if (jj_3R_86()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_110.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_110() {
        if (jj_scan_token(NAMEDINDIVIDUAL)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_78.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_78() {
        if (jj_scan_token(INVERSEFUNCTIONALOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_27.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_27() {
        if (jj_scan_token(PNAME_LN)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_23.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_23() {
        if (jj_scan_token(IMPORT)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_9.
     * 
     * @return true, if successful
     */
    private boolean jj_3_9() {
        if (jj_3R_27()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_84.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_84() {
        if (jj_scan_token(INVERSEOBJECTPROPERTIES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_26.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_26() {
        if (jj_scan_token(FULLIRI)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_118.
     * 
     * @return true, if successful
     */
    private boolean jj_3_118() {
        if (jj_3R_114()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_103.
     * 
     * @return true, if successful
     */
    private boolean jj_3_103() {
        if (jj_3R_102()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_35.
     * 
     * @return true, if successful
     */
    private boolean jj_3_35() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_112.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_112() {
        if (jj_scan_token(ANNOTATIONPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_8.
     * 
     * @return true, if successful
     */
    private boolean jj_3_8() {
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_105.
     * 
     * @return true, if successful
     */
    private boolean jj_3_105() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_22.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_22() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_8()) {
            jj_scanpos = xsp;
            if (jj_3_9()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3 r_77.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_77() {
        if (jj_scan_token(FUNCTIONALOBJECTPROPERTY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_74.
     * 
     * @return true, if successful
     */
    private boolean jj_3_74() {
        if (jj_3R_85()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_101.
     * 
     * @return true, if successful
     */
    private boolean jj_3_101() {
        if (jj_3R_102()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_73.
     * 
     * @return true, if successful
     */
    private boolean jj_3_73() {
        if (jj_3R_84()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_2.
     * 
     * @return true, if successful
     */
    private boolean jj_3_2() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_109.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_109() {
        if (jj_scan_token(DATAPROP)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_102.
     * 
     * @return true, if successful
     */
    private boolean jj_3_102() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_76.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_76() {
        if (jj_scan_token(OBJECTPROPERTYDOMAIN)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_34.
     * 
     * @return true, if successful
     */
    private boolean jj_3_34() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_75.
     * 
     * @return true, if successful
     */
    private boolean jj_3_75() {
        if (jj_3R_85()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_21.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_21() {
        if (jj_scan_token(PREFIX)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_126.
     * 
     * @return true, if successful
     */
    private boolean jj_3_126() {
        if (jj_3R_122()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_124.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_124() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_100.
     * 
     * @return true, if successful
     */
    private boolean jj_3_100() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_75.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_75() {
        if (jj_scan_token(OBJECTPROPERTYRANGE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_37.
     * 
     * @return true, if successful
     */
    private boolean jj_3_37() {
        if (jj_3R_50()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_3.
     * 
     * @return true, if successful
     */
    private boolean jj_3_3() {
        if (jj_3R_22()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_2()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     * Jj_3_7.
     * 
     * @return true, if successful
     */
    private boolean jj_3_7() {
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_93.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_93() {
        if (jj_3R_124()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_33.
     * 
     * @return true, if successful
     */
    private boolean jj_3_33() {
        if (jj_3R_48()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_24.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_24() {
        if (jj_scan_token(ANNOTATION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_69.
     * 
     * @return true, if successful
     */
    private boolean jj_3_69() {
        if (jj_3R_80()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_6.
     * 
     * @return true, if successful
     */
    private boolean jj_3_6() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_108.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_108() {
        if (jj_scan_token(OBJECTPROP)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_72.
     * 
     * @return true, if successful
     */
    private boolean jj_3_72() {
        if (jj_3R_83()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_4.
     * 
     * @return true, if successful
     */
    private boolean jj_3_4() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_5()) {
            jj_scanpos = xsp;
            if (jj_3_6()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3_5.
     * 
     * @return true, if successful
     */
    private boolean jj_3_5() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_63.
     * 
     * @return true, if successful
     */
    private boolean jj_3_63() {
        if (jj_3R_74()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_98.
     * 
     * @return true, if successful
     */
    private boolean jj_3_98() {
        if (jj_3R_106()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_97.
     * 
     * @return true, if successful
     */
    private boolean jj_3_97() {
        if (jj_3R_105()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_96.
     * 
     * @return true, if successful
     */
    private boolean jj_3_96() {
        if (jj_3R_104()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_95.
     * 
     * @return true, if successful
     */
    private boolean jj_3_95() {
        if (jj_3R_103()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_74.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_74() {
        if (jj_scan_token(DISJOINTOBJECTPROPERTIES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_66.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_66() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_95()) {
            jj_scanpos = xsp;
            if (jj_3_96()) {
                jj_scanpos = xsp;
                if (jj_3_97()) {
                    jj_scanpos = xsp;
                    if (jj_3_98()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3 r_49.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_49() {
        if (jj_scan_token(OBJECTINVERSEOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_66.
     * 
     * @return true, if successful
     */
    private boolean jj_3_66() {
        if (jj_3R_77()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_94.
     * 
     * @return true, if successful
     */
    private boolean jj_3_94() {
        if (jj_3R_102()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_36.
     * 
     * @return true, if successful
     */
    private boolean jj_3_36() {
        if (jj_3R_49()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_85.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_85() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_36()) {
            jj_scanpos = xsp;
            if (jj_3_37()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3 r_73.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_73() {
        if (jj_scan_token(EQUIVALENTOBJECTPROPERTIES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_50.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_50() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_1.
     * 
     * @return true, if successful
     */
    private boolean jj_3_1() {
        if (jj_3R_21()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_68.
     * 
     * @return true, if successful
     */
    private boolean jj_3_68() {
        if (jj_3R_79()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_107.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_107() {
        if (jj_scan_token(CLASS)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_71.
     * 
     * @return true, if successful
     */
    private boolean jj_3_71() {
        if (jj_3R_82()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_93.
     * 
     * @return true, if successful
     */
    private boolean jj_3_93() {
        if (jj_3R_101()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_47.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_47() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_93()) {
            jj_scanpos = xsp;
            if (jj_3_94()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3_130.
     * 
     * @return true, if successful
     */
    private boolean jj_3_130() {
        if (jj_3R_57()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_122.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_122() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_129()) {
            jj_scanpos = xsp;
            if (jj_3_130()) {
                return true;
            }
        }
        return false;
    }

    /**
     * Jj_3_129.
     * 
     * @return true, if successful
     */
    private boolean jj_3_129() {
        if (jj_scan_token(VARIABLE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_72.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_72() {
        if (jj_scan_token(SUBOBJECTPROPERTYOF)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_32.
     * 
     * @return true, if successful
     */
    private boolean jj_3_32() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_65.
     * 
     * @return true, if successful
     */
    private boolean jj_3_65() {
        if (jj_3R_76()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_62.
     * 
     * @return true, if successful
     */
    private boolean jj_3_62() {
        if (jj_3R_73()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_101.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_101() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_45.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_45() {
        if (jj_scan_token(DATAMAXCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_117.
     * 
     * @return true, if successful
     */
    private boolean jj_3_117() {
        if (jj_3R_114()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_128.
     * 
     * @return true, if successful
     */
    private boolean jj_3_128() {
        if (jj_3R_101()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_127.
     * 
     * @return true, if successful
     */
    private boolean jj_3_127() {
        if (jj_scan_token(VARIABLE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_86.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_86() {
        if (jj_scan_token(SUBOBJECTPROPERTYCHAIN)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_31.
     * 
     * @return true, if successful
     */
    private boolean jj_3_31() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_100.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_100() {
        if (jj_scan_token(NEGATIVEDATAPROPERTYASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_92.
     * 
     * @return true, if successful
     */
    private boolean jj_3_92() {
        if (jj_3R_47()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_121.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_121() {
        if (jj_scan_token(DIFFERENTINDIVIDUALSATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_44.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_44() {
        if (jj_scan_token(DATAEXACTCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_60.
     * 
     * @return true, if successful
     */
    private boolean jj_3_60() {
        if (jj_3R_71()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_70.
     * 
     * @return true, if successful
     */
    private boolean jj_3_70() {
        if (jj_3R_81()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_67.
     * 
     * @return true, if successful
     */
    private boolean jj_3_67() {
        if (jj_3R_78()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_64.
     * 
     * @return true, if successful
     */
    private boolean jj_3_64() {
        if (jj_3R_75()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_61.
     * 
     * @return true, if successful
     */
    private boolean jj_3_61() {
        if (jj_3R_72()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_60.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_60() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_61()) {
            jj_scanpos = xsp;
            if (jj_3_62()) {
                jj_scanpos = xsp;
                if (jj_3_63()) {
                    jj_scanpos = xsp;
                    if (jj_3_64()) {
                        jj_scanpos = xsp;
                        if (jj_3_65()) {
                            jj_scanpos = xsp;
                            if (jj_3_66()) {
                                jj_scanpos = xsp;
                                if (jj_3_67()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_68()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_69()) {
                                            jj_scanpos = xsp;
                                            if (jj_3_70()) {
                                                jj_scanpos = xsp;
                                                if (jj_3_71()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3_72()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3_73()) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3 r_98.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_98() {
        if (jj_scan_token(DATAPROPERTYASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_120.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_120() {
        if (jj_scan_token(SAMEINDIVIDUALATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_30.
     * 
     * @return true, if successful
     */
    private boolean jj_3_30() {
        if (jj_3R_46()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_43.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_43() {
        if (jj_scan_token(DATAMINCARDINALITY)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_88.
     * 
     * @return true, if successful
     */
    private boolean jj_3_88() {
        if (jj_3R_97()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_119.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_119() {
        if (jj_scan_token(BUILTINATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_99.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_99() {
        if (jj_scan_token(NEGATIVEOBJECTPROPERTYASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_71.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_71() {
        if (jj_scan_token(DISJOINTUNION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_91.
     * 
     * @return true, if successful
     */
    private boolean jj_3_91() {
        if (jj_3R_100()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_59.
     * 
     * @return true, if successful
     */
    private boolean jj_3_59() {
        if (jj_3R_70()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_42.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_42() {
        if (jj_scan_token(DATAHASVALUE)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_118.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_118() {
        if (jj_scan_token(DATAPROPERTYATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_97.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_97() {
        if (jj_scan_token(OBJECTPROPERTYASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_70.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_70() {
        if (jj_scan_token(DISJOINTCLASSES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_117.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_117() {
        if (jj_scan_token(OBJECTPROPERTYATOM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_40.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_40() {
        if (jj_scan_token(DATASOMEVALUESFROM)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_87.
     * 
     * @return true, if successful
     */
    private boolean jj_3_87() {
        if (jj_3R_96()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_96.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_96() {
        if (jj_scan_token(CLASSASSERTION)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_69.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_69() {
        if (jj_scan_token(EQUIVALENTCLASSES)) {
            return true;
        }
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        return false;
    }

    /** Generated Token Manager. */
    public OWLFunctionalSyntaxParserTokenManager token_source;
    /** The jj_input_stream. */
    JavaCharStream jj_input_stream;
    /** Current token. */
    public Token token;
    /** Next token. */
    public Token jj_nt;
    /** The jj_lastpos. */
    private Token jj_scanpos, jj_lastpos;
    /** The jj_la. */
    private int jj_la;
    /** The jj_gen. */
    private int jj_gen;
    /** The jj_la1. */
    final private int[] jj_la1 = new int[0];
    /** The jj_la1_0. */
    static private int[] jj_la1_0;
    /** The jj_la1_1. */
    static private int[] jj_la1_1;
    /** The jj_la1_2. */
    static private int[] jj_la1_2;
    /** The jj_la1_3. */
    static private int[] jj_la1_3;
    /** The jj_la1_4. */
    static private int[] jj_la1_4;
    static {
        jj_la1_init_0();
        jj_la1_init_1();
        jj_la1_init_2();
        jj_la1_init_3();
        jj_la1_init_4();
    }

    /** Jj_la1_init_0. */
    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] {};
    }

    /** Jj_la1_init_1. */
    private static void jj_la1_init_1() {
        jj_la1_1 = new int[] {};
    }

    /** Jj_la1_init_2. */
    private static void jj_la1_init_2() {
        jj_la1_2 = new int[] {};
    }

    /** Jj_la1_init_3. */
    private static void jj_la1_init_3() {
        jj_la1_3 = new int[] {};
    }

    /** Jj_la1_init_4. */
    private static void jj_la1_init_4() {
        jj_la1_4 = new int[] {};
    }

    /** The jj_2_rtns. */
    final private JJCalls[] jj_2_rtns = new JJCalls[130];
    /** The jj_rescan. */
    private boolean jj_rescan = false;
    /** The jj_gc. */
    private int jj_gc = 0;

    /**
     * Constructor with InputStream.
     * 
     * @param stream
     *        the stream
     */
    public OWLFunctionalSyntaxParser(java.io.InputStream stream) {
        this(stream, null);
    }

    /**
     * Constructor with InputStream and supplied encoding.
     * 
     * @param stream
     *        the stream
     * @param encoding
     *        the encoding
     */
    public OWLFunctionalSyntaxParser(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new OWLFunctionalSyntaxParserTokenManager(
                jj_input_stream);
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     */
    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     * @param encoding
     *        the encoding
     */
    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor.
     * 
     * @param stream
     *        the stream
     */
    public OWLFunctionalSyntaxParser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new OWLFunctionalSyntaxParserTokenManager(
                jj_input_stream);
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     */
    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor with generated Token Manager.
     * 
     * @param tm
     *        the tm
     */
    public OWLFunctionalSyntaxParser(OWLFunctionalSyntaxParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param tm
     *        the tm
     */
    public void ReInit(OWLFunctionalSyntaxParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Jj_consume_token.
     * 
     * @param kind
     *        the kind
     * @return the token
     * @throws ParseException
     *         the parse exception
     */
    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    /** The Class LookaheadSuccess. */
    static private final class LookaheadSuccess extends java.lang.Error {

        private static final long serialVersionUID = 1L;

        public LookaheadSuccess() {}
    }

    /** The jj_ls. */
    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    /**
     * Jj_scan_token.
     * 
     * @param kind
     *        the kind
     * @return true, if successful
     */
    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
                        .getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    /**
     * Get the next Token.
     * 
     * @return the next token
     */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_gen++;
        return token;
    }

    /**
     * Get the specific Token.
     * 
     * @param index
     *        the index
     * @return the token
     */
    final public Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    /** The jj_expentries. */
    private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
    /** The jj_expentry. */
    private int[] jj_expentry;
    /** The jj_kind. */
    private int jj_kind = -1;
    /** The jj_lasttokens. */
    private int[] jj_lasttokens = new int[100];
    /** The jj_endpos. */
    private int jj_endpos;

    /**
     * Jj_add_error_token.
     * 
     * @param kind
     *        the kind
     * @param pos
     *        the pos
     */
    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries
                    .iterator(); it.hasNext();) {
                int[] oldentry = (int[]) it.next();
                if (oldentry.length == jj_expentry.length) {
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            continue jj_entries_loop;
                        }
                    }
                    jj_expentries.add(jj_expentry);
                    break jj_entries_loop;
                }
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /**
     * Generate ParseException.
     * 
     * @return the parses the exception
     */
    public ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[130];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 0; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((jj_la1_3[i] & 1 << j) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    if ((jj_la1_4[i] & 1 << j) != 0) {
                        la1tokens[128 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 130; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    /** Enable tracing. */
    final public void enable_tracing() {}

    /** Disable tracing. */
    final public void disable_tracing() {}

    /** Jj_rescan_token. */
    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 130; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                            case 12:
                                jj_3_13();
                                break;
                            case 13:
                                jj_3_14();
                                break;
                            case 14:
                                jj_3_15();
                                break;
                            case 15:
                                jj_3_16();
                                break;
                            case 16:
                                jj_3_17();
                                break;
                            case 17:
                                jj_3_18();
                                break;
                            case 18:
                                jj_3_19();
                                break;
                            case 19:
                                jj_3_20();
                                break;
                            case 20:
                                jj_3_21();
                                break;
                            case 21:
                                jj_3_22();
                                break;
                            case 22:
                                jj_3_23();
                                break;
                            case 23:
                                jj_3_24();
                                break;
                            case 24:
                                jj_3_25();
                                break;
                            case 25:
                                jj_3_26();
                                break;
                            case 26:
                                jj_3_27();
                                break;
                            case 27:
                                jj_3_28();
                                break;
                            case 28:
                                jj_3_29();
                                break;
                            case 29:
                                jj_3_30();
                                break;
                            case 30:
                                jj_3_31();
                                break;
                            case 31:
                                jj_3_32();
                                break;
                            case 32:
                                jj_3_33();
                                break;
                            case 33:
                                jj_3_34();
                                break;
                            case 34:
                                jj_3_35();
                                break;
                            case 35:
                                jj_3_36();
                                break;
                            case 36:
                                jj_3_37();
                                break;
                            case 37:
                                jj_3_38();
                                break;
                            case 38:
                                jj_3_39();
                                break;
                            case 39:
                                jj_3_40();
                                break;
                            case 40:
                                jj_3_41();
                                break;
                            case 41:
                                jj_3_42();
                                break;
                            case 42:
                                jj_3_43();
                                break;
                            case 43:
                                jj_3_44();
                                break;
                            case 44:
                                jj_3_45();
                                break;
                            case 45:
                                jj_3_46();
                                break;
                            case 46:
                                jj_3_47();
                                break;
                            case 47:
                                jj_3_48();
                                break;
                            case 48:
                                jj_3_49();
                                break;
                            case 49:
                                jj_3_50();
                                break;
                            case 50:
                                jj_3_51();
                                break;
                            case 51:
                                jj_3_52();
                                break;
                            case 52:
                                jj_3_53();
                                break;
                            case 53:
                                jj_3_54();
                                break;
                            case 54:
                                jj_3_55();
                                break;
                            case 55:
                                jj_3_56();
                                break;
                            case 56:
                                jj_3_57();
                                break;
                            case 57:
                                jj_3_58();
                                break;
                            case 58:
                                jj_3_59();
                                break;
                            case 59:
                                jj_3_60();
                                break;
                            case 60:
                                jj_3_61();
                                break;
                            case 61:
                                jj_3_62();
                                break;
                            case 62:
                                jj_3_63();
                                break;
                            case 63:
                                jj_3_64();
                                break;
                            case 64:
                                jj_3_65();
                                break;
                            case 65:
                                jj_3_66();
                                break;
                            case 66:
                                jj_3_67();
                                break;
                            case 67:
                                jj_3_68();
                                break;
                            case 68:
                                jj_3_69();
                                break;
                            case 69:
                                jj_3_70();
                                break;
                            case 70:
                                jj_3_71();
                                break;
                            case 71:
                                jj_3_72();
                                break;
                            case 72:
                                jj_3_73();
                                break;
                            case 73:
                                jj_3_74();
                                break;
                            case 74:
                                jj_3_75();
                                break;
                            case 75:
                                jj_3_76();
                                break;
                            case 76:
                                jj_3_77();
                                break;
                            case 77:
                                jj_3_78();
                                break;
                            case 78:
                                jj_3_79();
                                break;
                            case 79:
                                jj_3_80();
                                break;
                            case 80:
                                jj_3_81();
                                break;
                            case 81:
                                jj_3_82();
                                break;
                            case 82:
                                jj_3_83();
                                break;
                            case 83:
                                jj_3_84();
                                break;
                            case 84:
                                jj_3_85();
                                break;
                            case 85:
                                jj_3_86();
                                break;
                            case 86:
                                jj_3_87();
                                break;
                            case 87:
                                jj_3_88();
                                break;
                            case 88:
                                jj_3_89();
                                break;
                            case 89:
                                jj_3_90();
                                break;
                            case 90:
                                jj_3_91();
                                break;
                            case 91:
                                jj_3_92();
                                break;
                            case 92:
                                jj_3_93();
                                break;
                            case 93:
                                jj_3_94();
                                break;
                            case 94:
                                jj_3_95();
                                break;
                            case 95:
                                jj_3_96();
                                break;
                            case 96:
                                jj_3_97();
                                break;
                            case 97:
                                jj_3_98();
                                break;
                            case 98:
                                jj_3_99();
                                break;
                            case 99:
                                jj_3_100();
                                break;
                            case 100:
                                jj_3_101();
                                break;
                            case 101:
                                jj_3_102();
                                break;
                            case 102:
                                jj_3_103();
                                break;
                            case 103:
                                jj_3_104();
                                break;
                            case 104:
                                jj_3_105();
                                break;
                            case 105:
                                jj_3_106();
                                break;
                            case 106:
                                jj_3_107();
                                break;
                            case 107:
                                jj_3_108();
                                break;
                            case 108:
                                jj_3_109();
                                break;
                            case 109:
                                jj_3_110();
                                break;
                            case 110:
                                jj_3_111();
                                break;
                            case 111:
                                jj_3_112();
                                break;
                            case 112:
                                jj_3_113();
                                break;
                            case 113:
                                jj_3_114();
                                break;
                            case 114:
                                jj_3_115();
                                break;
                            case 115:
                                jj_3_116();
                                break;
                            case 116:
                                jj_3_117();
                                break;
                            case 117:
                                jj_3_118();
                                break;
                            case 118:
                                jj_3_119();
                                break;
                            case 119:
                                jj_3_120();
                                break;
                            case 120:
                                jj_3_121();
                                break;
                            case 121:
                                jj_3_122();
                                break;
                            case 122:
                                jj_3_123();
                                break;
                            case 123:
                                jj_3_124();
                                break;
                            case 124:
                                jj_3_125();
                                break;
                            case 125:
                                jj_3_126();
                                break;
                            case 126:
                                jj_3_127();
                                break;
                            case 127:
                                jj_3_128();
                                break;
                            case 128:
                                jj_3_129();
                                break;
                            case 129:
                                jj_3_130();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {}
        }
        jj_rescan = false;
    }

    /**
     * Jj_save.
     * 
     * @param index
     *        the index
     * @param xla
     *        the xla
     */
    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    /** The Class JJCalls. */
    static final class JJCalls {

        /** The gen. */
        int gen;
        /** The first. */
        Token first;
        /** The arg. */
        int arg;
        /** The next. */
        JJCalls next;
    }
}
