/*
 * Decompiled with CFR 0.152.
 */
package org.coode.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;

public class XMLWriterNamespaceManager {
    private Map<String, String> prefixNamespaceMap = new HashMap<String, String>();
    private Map<String, String> namespacePrefixMap = new HashMap<String, String>();
    private Map<String, String> wellknownNamespaces = new HashMap<String, String>();
    private String defaultNamespace;

    public XMLWriterNamespaceManager(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void addWellKnownNamespace(String prefix, String namespace) {
        this.wellknownNamespaces.put(prefix, namespace);
    }

    public void setPrefix(String prefix, String namespace) {
        this.prefixNamespaceMap.put(prefix, namespace);
        this.namespacePrefixMap.put(namespace, prefix);
    }

    public String getPrefixForNamespace(String namespace) {
        return this.namespacePrefixMap.get(namespace);
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.prefixNamespaceMap.get(prefix);
    }

    public String getQName(String name) {
        if (name.startsWith(this.defaultNamespace)) {
            return name.substring(this.defaultNamespace.length(), name.length());
        }
        for (String ns : this.namespacePrefixMap.keySet()) {
            if (!name.startsWith(ns)) continue;
            String localName = name.substring(ns.length(), name.length());
            return this.namespacePrefixMap.get(ns) + ":" + localName;
        }
        return name;
    }

    public String getQName(IRI name) {
        if (name.getNamespace().equals(this.defaultNamespace)) {
            return (String)name.getRemainder().or((Object)"");
        }
        String candidate = this.namespacePrefixMap.get(name.getNamespace());
        if (candidate != null) {
            return name.prefixedBy(candidate + ':');
        }
        return name.toString();
    }

    public void createPrefixForNamespace(String namespace) {
        if (namespace.equals(this.defaultNamespace)) {
            return;
        }
        if (this.wellknownNamespaces.containsKey(namespace)) {
            this.setPrefix(this.wellknownNamespaces.get(namespace), namespace);
        }
        if (!this.namespacePrefixMap.containsKey(namespace)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Set<String> getPrefixes() {
        return new HashSet<String>(this.prefixNamespaceMap.keySet());
    }

    public Set<String> getNamespaces() {
        return new HashSet<String>(this.namespacePrefixMap.keySet());
    }

    public Map<String, String> getPrefixNamespaceMap() {
        return new HashMap<String, String>(this.prefixNamespaceMap);
    }

    public String getDefaultPrefix() {
        for (String prefix : this.prefixNamespaceMap.keySet()) {
            String ns;
            if (prefix.equals("") || !(ns = this.prefixNamespaceMap.get(prefix)).equals(this.defaultNamespace)) continue;
            return prefix;
        }
        return "";
    }
}

