/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TypeAllDisjointPropertiesHandler
extends BuiltInTypeHandler {
    public TypeAllDisjointPropertiesHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_ALL_DISJOINT_PROPERTIES.getIRI());
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        this.consumeTriple(subject, predicate, object);
        IRI listNode = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.OWL_MEMBERS.getIRI(), true);
        if (this.getConsumer().isObjectProperty(this.getConsumer().getFirstResource(listNode, false))) {
            Set<OWLAnnotation> annotations = this.getConsumer().translateAnnotations(subject);
            List<OWLObjectPropertyExpression> props = this.getConsumer().translateToObjectPropertyList(listNode);
            this.getConsumer().addAxiom((OWLAxiom)this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(new HashSet<OWLObjectPropertyExpression>(props), annotations));
        } else {
            Set<OWLAnnotation> annotations = this.getConsumer().translateAnnotations(subject);
            List<OWLDataPropertyExpression> props = this.getConsumer().translateToDataPropertyList(listNode);
            this.getConsumer().addAxiom((OWLAxiom)this.getDataFactory().getOWLDisjointDataPropertiesAxiom(new HashSet<OWLDataPropertyExpression>(props), annotations));
        }
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }
}

