/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.renderer;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.coode.owlapi.obo.renderer.OBOExceptionHandler;
import org.coode.owlapi.obo.renderer.OBORelationship;
import org.coode.owlapi.obo.renderer.OBORelationshipGenerator;
import org.coode.owlapi.obo.renderer.OBOStorageException;
import org.coode.owlapi.obo.renderer.OBOStorageIncompleteException;
import org.coode.owlapi.obo.renderer.OBOTagValuePairList;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OBOFlatFileRenderer
extends AbstractOWLRenderer
implements OBOExceptionHandler {
    private OBORelationshipGenerator relationshipHandler;
    private SimpleShortFormProvider sfp;
    private String defaultPrefix;
    private List<OBOStorageException> exceptions = new ArrayList<OBOStorageException>();
    private NamespaceUtil nsUtil;
    private String defaultNamespace;
    private OWLDataFactory factory;

    @Deprecated
    protected OBOFlatFileRenderer(OWLOntologyManager owlOntologyManager) {
        this();
    }

    protected OBOFlatFileRenderer() {
        this.relationshipHandler = new OBORelationshipGenerator(this);
        this.sfp = new SimpleShortFormProvider();
    }

    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        this.factory = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.exceptions.clear();
        IRI ontologyIRI = ontology.getOntologyID().getOntologyIRI();
        if (ontologyIRI != null) {
            String ontURIStr = ontologyIRI.toString();
            this.defaultNamespace = ontURIStr.endsWith("/") ? ontURIStr : ontURIStr + "#";
        } else {
            this.defaultNamespace = "urn:defaultOBONamespace:ontology" + System.currentTimeMillis() + "#";
            System.err.println("WARNING: anonymous ontology saved in OBO format. Default namespace created for it.");
        }
        this.nsUtil = new NamespaceUtil();
        this.defaultPrefix = this.nsUtil.getPrefix(this.defaultNamespace);
        this.writeHeader(ontology, writer);
        this.writeStanzas(ontology, writer);
        if (!this.exceptions.isEmpty()) {
            throw new OBOStorageIncompleteException(this.exceptions);
        }
    }

    @Override
    public void addException(OBOStorageException exception) {
        this.exceptions.add(exception);
    }

    @Override
    public List<OBOStorageException> getExceptions() {
        return this.exceptions;
    }

    private void writeHeader(OWLOntology ontology, Writer writer) {
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getHeaderTags());
        tvpList.setDefault(OBOVocabulary.DEFAULT_NAMESPACE, this.defaultPrefix);
        for (OWLAnnotation ax : ontology.getAnnotations()) {
            if (ax.getProperty().isComment()) {
                tvpList.addPair(OBOVocabulary.REMARK, ((OWLLiteral)ax.getValue()).getLiteral());
                continue;
            }
            tvpList.visit(ax);
        }
        for (OWLImportsDeclaration importDecl : ontology.getImportsDeclarations()) {
            tvpList.addPair(OBOVocabulary.IMPORT, importDecl.getIRI().toString());
        }
        Map<String, String> namespace2PrefixMap = this.loadUsedNamespaces(ontology);
        for (String namespace : namespace2PrefixMap.keySet()) {
            String mapping = namespace2PrefixMap.get(namespace) + " " + namespace;
            tvpList.addPair(OBOVocabulary.ID_SPACE, mapping);
        }
        tvpList.setPair(OBOVocabulary.FORMAT_VERSION, "1.2");
        tvpList.setPair(OBOVocabulary.DATE, this.getTimestampFormatter().format(new Date(System.currentTimeMillis())));
        tvpList.setPair(OBOVocabulary.SAVED_BY, System.getProperty("user.name"));
        tvpList.setPair(OBOVocabulary.AUTO_GENERATED_BY, VersionInfo.getVersionInfo().toString());
        tvpList.write(writer);
    }

    private Map<String, String> loadUsedNamespaces(OWLOntology ontology) {
        for (OWLEntity entity : ontology.getSignature()) {
            IRI base = IRI.create((String)XMLUtils.getNCNamePrefix((CharSequence)entity.getIRI().toString()));
            this.nsUtil.getPrefix(base.toString());
        }
        return this.nsUtil.getNamespace2PrefixMap();
    }

    private void writeStanzas(OWLOntology ontology, Writer writer) {
        this.write("\n\n! ----------------------  CLASSES  -------------------------\n", writer);
        ArrayList sortedClasses = new ArrayList(ontology.getClassesInSignature());
        CollectionFactory.sortOptionally(sortedClasses);
        for (Object cls : sortedClasses) {
            this.writeTermStanza((OWLClass)cls, ontology, writer);
        }
        this.write("\n\n! ----------------------  PROPERTIES  -------------------------\n", writer);
        ArrayList objProps = new ArrayList(ontology.getObjectPropertiesInSignature());
        CollectionFactory.sortOptionally(objProps);
        for (Object property : objProps) {
            this.writeTypeDefStanza((OWLObjectProperty)property, ontology, writer);
        }
        ArrayList dataProps = new ArrayList(ontology.getDataPropertiesInSignature());
        CollectionFactory.sortOptionally(dataProps);
        for (OWLDataProperty property : dataProps) {
            this.writeTypeDefStanza(property, ontology, writer);
        }
        this.write("\n\n! ----------------------  INSTANCES  -------------------------\n", writer);
        ArrayList individuals = new ArrayList(ontology.getIndividualsInSignature());
        CollectionFactory.sortOptionally(individuals);
        for (OWLNamedIndividual individual : individuals) {
            this.writeInstanceStanza(individual, ontology, writer);
        }
        for (OWLClassAxiom ax : ontology.getGeneralClassAxioms()) {
            if (ax instanceof OWLSubClassOfAxiom) {
                this.exceptions.add(new OBOStorageException((OWLObject)ax, null, "Superclass GCI found in ontology cannot be translated to OBO"));
            }
            if (ax instanceof OWLEquivalentClassesAxiom) {
                this.exceptions.add(new OBOStorageException((OWLObject)ax, null, "Equivalent class GCI found in ontology cannot be translated to OBO"));
            }
            if (!(ax instanceof OWLDisjointClassesAxiom)) continue;
            this.exceptions.add(new OBOStorageException((OWLObject)ax, null, "Disjoint axiom contains anonymous classes - cannot be translated to OBO"));
        }
        for (SWRLRule r : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            this.exceptions.add(new OBOStorageException((OWLObject)r, null, "SWRL rules cannot be translated to OBO"));
        }
    }

    private void writeTermStanza(OWLClass cls, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.TERM.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getTermStanzaTags());
        this.handleEntityBase((OWLEntity)cls, ontology, tvpList);
        this.relationshipHandler.setClass(cls);
        for (OWLClassExpression superCls : cls.getSuperClasses(ontology)) {
            if (!superCls.isAnonymous()) {
                String superclassID = this.getID((OWLEntity)superCls.asOWLClass());
                tvpList.addPair(OBOVocabulary.IS_A, superclassID);
                continue;
            }
            if (superCls instanceof OWLRestriction) {
                superCls.accept((OWLClassExpressionVisitor)this.relationshipHandler);
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)cls, (OWLObject)superCls, "OBO format only supports named superclass or someValuesFrom restrictions"));
        }
        OWLClass owlThing = this.factory.getOWLThing();
        if (!cls.equals(owlThing) && tvpList.getValues(OBOVocabulary.IS_A).isEmpty()) {
            tvpList.addPair(OBOVocabulary.IS_A, this.getID((OWLEntity)owlThing));
        }
        for (OWLClassExpression equiv : cls.getEquivalentClasses(ontology)) {
            if (equiv instanceof OWLObjectIntersectionOf) {
                this.handleIntersection(cls, (OWLObjectIntersectionOf)equiv, tvpList);
                continue;
            }
            if (equiv instanceof OWLObjectUnionOf) {
                this.handleUnion(cls, (OWLObjectUnionOf)equiv, tvpList);
                continue;
            }
            if (equiv instanceof OWLRestriction) {
                OWLObjectIntersectionOf intersection = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{owlThing, equiv});
                this.handleIntersection(cls, intersection, tvpList);
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)cls, (OWLObject)equiv, "Cannot answer equivalent class that is not intersection or union"));
        }
        for (OWLClassExpression disjoint : cls.getDisjointClasses(ontology)) {
            if (!disjoint.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.DISJOINT_FROM, this.getID((OWLEntity)disjoint.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)cls, (OWLObject)disjoint, "Found anonymous disjoint class that cannot be represented in OBO"));
        }
        for (OBORelationship relationship : this.relationshipHandler.getOBORelationships()) {
            this.handleRelationship(relationship, tvpList);
        }
        tvpList.write(writer);
    }

    private void handleIntersection(OWLClass cls, OWLObjectIntersectionOf intersectionOf, OBOTagValuePairList tvpList) {
        for (OWLClassExpression op : intersectionOf.getOperands()) {
            if (!op.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INTERSECTION_OF, this.getID((OWLEntity)op.asOWLClass()));
                continue;
            }
            this.relationshipHandler.setClass(cls);
            op.accept((OWLClassExpressionVisitor)this.relationshipHandler);
            Set<OBORelationship> relations = this.relationshipHandler.getOBORelationships();
            if (!relations.isEmpty()) {
                OBORelationship rel = relations.iterator().next();
                tvpList.addPair(OBOVocabulary.INTERSECTION_OF, this.renderRestriction(rel));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)cls, (OWLObject)op, "Found operand in intersection that cannot be represented"));
        }
    }

    private String renderRestriction(OBORelationship rel) {
        StringBuilder sb = new StringBuilder(this.getID((OWLEntity)rel.getProperty()));
        sb.append(" ");
        sb.append(this.getID(rel.getFiller()));
        return sb.toString();
    }

    private void handleUnion(OWLClass cls, OWLObjectUnionOf union, OBOTagValuePairList tvpList) {
        for (OWLClassExpression op : union.getOperands()) {
            if (!op.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.UNION_OF, this.getID((OWLEntity)op.asOWLClass()));
                continue;
            }
            this.relationshipHandler.setClass(cls);
            op.accept((OWLClassExpressionVisitor)this.relationshipHandler);
            Set<OBORelationship> relations = this.relationshipHandler.getOBORelationships();
            if (!relations.isEmpty()) {
                OBORelationship rel = relations.iterator().next();
                tvpList.addPair(OBOVocabulary.UNION_OF, this.renderRestriction(rel));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)cls, (OWLObject)op, "Found operand in union that cannot be represented"));
        }
    }

    private void handleRelationship(OBORelationship relationship, OBOTagValuePairList tvpList) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.renderRestriction(relationship));
        sb.append("\n");
        if (relationship.getCardinality() >= 0) {
            sb.append(OBOVocabulary.CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getCardinality()));
            sb.append("\n");
        }
        if (relationship.getMaxCardinality() >= 0) {
            sb.append(OBOVocabulary.MAX_CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getMaxCardinality()));
            sb.append("\n");
        }
        if (relationship.getMinCardinality() >= 0) {
            sb.append(OBOVocabulary.MIN_CARDINALITY.getName());
            sb.append(":");
            sb.append(Integer.toString(relationship.getMinCardinality()));
            sb.append("\n");
        }
        tvpList.addPair(OBOVocabulary.RELATIONSHIP, sb.toString());
    }

    private <P extends OWLProperty> OBOTagValuePairList handleCommonTypeDefStanza(P property, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.TYPEDEF.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getTypeDefStanzaTags());
        this.handleEntityBase((OWLEntity)property, ontology, tvpList);
        Set domains = property.getDomains(ontology);
        for (OWLClassExpression domain : domains) {
            if (!domain.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.DOMAIN, this.getID((OWLEntity)domain.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)domain, "Anonymous domain that cannot be represented in OBO"));
        }
        Set sp = property.getSuperProperties(ontology);
        for (OWLPropertyExpression superProp : sp) {
            if (!superProp.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.IS_A, this.getID((OWLEntity)((OWLProperty)superProp)));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)superProp, "Anonymous property in superProperty is not supported in OBO"));
        }
        tvpList.setDefault(OBOVocabulary.IS_METADATA_TAG, "false");
        return tvpList;
    }

    private void writeTypeDefStanza(OWLObjectProperty property, OWLOntology ontology, Writer writer) {
        OBOTagValuePairList tvpList = this.handleCommonTypeDefStanza(property, ontology, writer);
        for (OWLClassExpression range : property.getRanges(ontology)) {
            if (!range.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.RANGE, this.getID((OWLEntity)range.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)range, "Anonymous range that cannot be represented in OBO"));
        }
        if (property.isAsymmetric(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_ASYMMETRIC, "true");
        }
        if (property.isReflexive(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_REFLEXIVE, "true");
        }
        if (property.isSymmetric(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_SYMMETRIC, "true");
        }
        if (property.isTransitive(ontology)) {
            tvpList.addPair(OBOVocabulary.IS_TRANSITIVE, "true");
        }
        for (OWLObjectPropertyExpression inv : property.getInverses(ontology)) {
            if (!inv.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INVERSE, this.getID((OWLEntity)inv.asOWLObjectProperty()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)inv, "Anonymous property in inverse is not supported in OBO"));
        }
        for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            if (!ax.getSuperProperty().equals(property)) continue;
            List chain = ax.getPropertyChain();
            if (chain.size() == 2 && ((OWLObjectPropertyExpression)chain.get(0)).equals(property) && !((OWLObjectPropertyExpression)chain.get(1)).isAnonymous()) {
                tvpList.addPair(OBOVocabulary.TRANSITIVE_OVER, this.getID((OWLEntity)((OWLObjectPropertyExpression)chain.get(1)).asOWLObjectProperty()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)ax, "Only property chains of form 'p o q -> p' supported"));
        }
        tvpList.write(writer);
    }

    private void writeTypeDefStanza(OWLDataProperty property, OWLOntology ontology, Writer writer) {
        OBOTagValuePairList tvpList = this.handleCommonTypeDefStanza(property, ontology, writer);
        for (OWLDataRange range : property.getRanges(ontology)) {
            if (range.isDatatype()) {
                tvpList.addPair(OBOVocabulary.RANGE, range.asOWLDatatype().getIRI().toString());
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)property, (OWLObject)range, "Complex data range cannot be represented in OBO"));
        }
        tvpList.write(writer);
    }

    private void writeInstanceStanza(OWLNamedIndividual individual, OWLOntology ontology, Writer writer) {
        this.write("\n[", writer);
        this.write(OBOVocabulary.INSTANCE.getName(), writer);
        this.write("]\n", writer);
        OBOTagValuePairList tvpList = new OBOTagValuePairList(OBOVocabulary.getInstanceStanzaTags());
        if (individual.isAnonymous()) {
            tvpList.setDefault(OBOVocabulary.IS_ANONYMOUS, "true");
        }
        this.handleEntityBase((OWLEntity)individual, ontology, tvpList);
        for (Object type : individual.getTypes(ontology)) {
            if (!type.isAnonymous()) {
                tvpList.addPair(OBOVocabulary.INSTANCE_OF, this.getID((OWLEntity)type.asOWLClass()));
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)individual, (OWLObject)type, "Complex types cannot be represented in OBO"));
        }
        Map objPropAssertions = individual.getObjectPropertyValues(ontology);
        for (OWLObjectPropertyExpression p : objPropAssertions.keySet()) {
            if (!p.isAnonymous()) {
                for (OWLIndividual ind : (Set)objPropAssertions.get(p)) {
                    if (ind.isAnonymous()) continue;
                    String rel = this.renderRestriction(new OBORelationship(p.asOWLObjectProperty(), ind.asOWLNamedIndividual()));
                    tvpList.addPair(OBOVocabulary.PROPERTY_VALUE, rel);
                }
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)individual, (OWLObject)p, "Anonymous property in assertion is not supported in OBO"));
        }
        Map dataPropAssertions = individual.getDataPropertyValues(ontology);
        for (OWLDataPropertyExpression p : dataPropAssertions.keySet()) {
            if (!p.isAnonymous()) {
                for (OWLLiteral literal : (Set)dataPropAssertions.get(p)) {
                    String rel = this.renderPropertyAssertion(p.asOWLDataProperty(), literal);
                    tvpList.addPair(OBOVocabulary.PROPERTY_VALUE, rel);
                }
                continue;
            }
            this.exceptions.add(new OBOStorageException((OWLObject)individual, (OWLObject)p, "Anonymous property in assertion is not supported in OBO"));
        }
        tvpList.write(writer);
    }

    private void handleEntityBase(OWLEntity entity, OWLOntology ontology, OBOTagValuePairList tvpList) {
        tvpList.addPair(OBOVocabulary.ID, this.getID(entity));
        HashSet<OWLAnnotation> potentialNames = new HashSet<OWLAnnotation>();
        for (OWLAnnotation annotation : entity.getAnnotations(ontology)) {
            if (annotation.getProperty().getIRI().equals((Object)OWLRDFVocabulary.RDFS_LABEL.getIRI())) {
                potentialNames.add(annotation);
                continue;
            }
            if (annotation.getProperty().isComment()) {
                tvpList.addPair(OBOVocabulary.COMMENT, ((OWLLiteral)annotation.getValue()).getLiteral());
                continue;
            }
            tvpList.visit(annotation);
        }
        if (tvpList.getValues(OBOVocabulary.NAME).isEmpty()) {
            if (!potentialNames.isEmpty()) {
                OWLAnnotation firstLabel = (OWLAnnotation)potentialNames.iterator().next();
                tvpList.addPair(OBOVocabulary.NAME, ((OWLLiteral)firstLabel.getValue()).getLiteral());
                potentialNames.remove(firstLabel);
            } else {
                tvpList.addPair(OBOVocabulary.NAME, this.getID(entity));
            }
        }
        for (OWLAnnotation anno : potentialNames) {
            tvpList.visit(anno);
        }
        String uri = entity.getIRI().toString();
        if (!uri.startsWith(this.defaultNamespace)) {
            IRI base = IRI.create((String)XMLUtils.getNCNamePrefix((CharSequence)uri));
            String prefix = this.nsUtil.getPrefix(base.toString());
            tvpList.setDefault(OBOVocabulary.NAMESPACE, prefix);
        }
    }

    private String renderPropertyAssertion(OWLDataProperty property, OWLLiteral literal) {
        StringBuilder sb = new StringBuilder(this.getID((OWLEntity)property));
        sb.append(" \"");
        sb.append(literal.getLiteral());
        sb.append("\" ");
        if (!literal.isRDFPlainLiteral()) {
            sb.append((CharSequence)literal.getDatatype().getIRI());
        }
        return sb.toString();
    }

    private String getID(OWLEntity entity) {
        return this.sfp.getShortForm(entity);
    }

    private void write(String s, Writer writer) {
        try {
            writer.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private DateFormat getTimestampFormatter() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("dd:MM:yyyy HH:mm");
        return sdf;
    }
}

