/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, The University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated By:JavaCC: Do not edit this line. KRSSParser.java */
package org.coode.owl.krssparser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.Namespaces;

/** The Class KRSSParser. */
@SuppressWarnings("unused")
public class KRSSParser implements KRSSParserConstants {

    /** The ontology. */
    private OWLOntology ontology;
    /** The data factory. */
    private OWLDataFactory dataFactory;
    /** The string2 iri. */
    private Map<String, IRI> string2IRI;
    /** The ignore annotations and declarations. */
    private boolean ignoreAnnotationsAndDeclarations = false;
    /** The base. */
    private String base;

    /**
     * Sets the ontology.
     * 
     * @param ontology
     *        the ontology
     * @param dataFactory
     *        the data factory
     */
    public void setOntology(OWLOntology ontology, OWLDataFactory dataFactory) {
        this.ontology = ontology;
        this.dataFactory = dataFactory;
        string2IRI = new HashMap<String, IRI>();
        if (!ontology.isAnonymous()) {
            base = ontology.getOntologyID().getOntologyIRI() + "#";
        } else {
            base = Namespaces.OWL.toString();
        }
    }

    /**
     * Adds the axiom.
     * 
     * @param ax
     *        the ax
     * @throws KRSSOWLParserException
     *         the kRSSOWL parser exception
     */
    protected void addAxiom(OWLAxiom ax) throws KRSSOWLParserException {
        try {
            ((OWLMutableOntology) ontology).applyChange(new AddAxiom(ontology,
                    ax));
        } catch (OWLOntologyChangeException e) {
            throw new KRSSOWLParserException(e);
        }
    }

    /**
     * Gets the iri.
     * 
     * @param _s
     *        the string
     * @return the iri
     */
    public IRI getIRI(String _s) {
        String s = base + _s;
        IRI iri = string2IRI.get(s);
        if (iri == null) {
            iri = IRI.create(s);
            string2IRI.put(s, iri);
        }
        return iri;
    }

    /**
     * Sets the ignore annotations and declarations.
     * 
     * @param b
     *        the new ignore annotations and declarations
     */
    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        ignoreAnnotationsAndDeclarations = b;
    }

    /**
     * Parses the.
     * 
     * @throws ParseException
     *         the parse exception
     * @throws KRSSOWLParserException
     *         the kRSSOWL parser exception
     */
    final public void parse() throws ParseException, KRSSOWLParserException {
        OWLAxiom ax;
        label_1: while (true) {
            if (jj_2_1(2)) {} else {
                break label_1;
            }
            ax = TBoxStatement();
            if (ax != null) {
                addAxiom(ax);
            }
        }
        if (jj_2_2(2)) {
            jj_consume_token(ENDTBOX);
        } else {}
        label_2: while (true) {
            if (jj_2_3(2)) {} else {
                break label_2;
            }
            ABoxStatement();
        }
        if (jj_2_4(2)) {
            jj_consume_token(ENDABOX);
        } else {}
        jj_consume_token(0);
    }

    /**
     * T box statement.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom TBoxStatement() throws ParseException {
        OWLAxiom ax;
        if (jj_2_5(2)) {
            ax = DefinePrimitiveConcept();
        } else if (jj_2_6(2)) {
            ax = DefineConcept();
        } else if (jj_2_7(2)) {
            ax = DefinePrimitiveRole();
        } else if (jj_2_8(2)) {
            ax = Transitive();
        } else if (jj_2_9(2)) {
            ax = Range();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Define primitive concept.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom DefinePrimitiveConcept() throws ParseException {
        OWLClassExpression subClass;
        OWLClassExpression superClass;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVECONCEPT);
        subClass = ConceptName();
        superClass = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLSubClassOfAxiom(subClass, superClass);
    }

    /**
     * Define concept.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom DefineConcept() throws ParseException {
        OWLClassExpression clsA;
        OWLClassExpression clsB;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINECONCEPT);
        clsA = ConceptName();
        clsB = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        Set<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        ops.add(clsA);
        ops.add(clsB);
        return dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    /**
     * Define primitive role.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom DefinePrimitiveRole() throws ParseException {
        OWLObjectProperty subProp;
        OWLObjectProperty superProp;
        jj_consume_token(OPENPAR);
        jj_consume_token(DEFINEPRIMITIVEROLE);
        subProp = RoleName();
        superProp = RoleName();
        if (jj_2_10(2)) {
            jj_consume_token(42);
            RoleName();
        } else {}
        jj_consume_token(CLOSEPAR);
        if (superProp != null) {
            return dataFactory.getOWLSubObjectPropertyOfAxiom(subProp,
                    superProp);
        }
        throw new ParseException("Missing return statement in function");
    }

    /**
     * Transitive.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Transitive() throws ParseException {
        OWLObjectProperty prop;
        jj_consume_token(OPENPAR);
        jj_consume_token(TRANSITIVE);
        prop = RoleName();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
    }

    /**
     * Range.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Range() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression rng;
        jj_consume_token(OPENPAR);
        jj_consume_token(RANGE);
        prop = RoleName();
        rng = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng);
    }

    /**
     * Concept expression.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ConceptExpression() throws ParseException {
        OWLClassExpression desc;
        if (jj_2_11(2)) {
            desc = ConceptName();
        } else if (jj_2_12(2)) {
            desc = And();
        } else if (jj_2_13(2)) {
            desc = Or();
        } else if (jj_2_14(2)) {
            desc = Not();
        } else if (jj_2_15(2)) {
            desc = All();
        } else if (jj_2_16(2)) {
            desc = Some();
        } else if (jj_2_17(2)) {
            desc = AtLeast();
        } else if (jj_2_18(2)) {
            desc = AtMost();
        } else if (jj_2_19(2)) {
            desc = Exactly();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    /**
     * Concept name.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression ConceptName() throws ParseException {
        IRI iri;
        iri = Name();
        return dataFactory.getOWLClass(iri);
    }

    /**
     * Concept set.
     * 
     * @return the sets the
     * @throws ParseException
     *         the parse exception
     */
    final public Set<OWLClassExpression> ConceptSet() throws ParseException {
        Set<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        OWLClassExpression desc;
        label_3: while (true) {
            desc = ConceptExpression();
            descs.add(desc);
            if (jj_2_20(2)) {} else {
                break label_3;
            }
        }
        return descs;
    }

    /**
     * And.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression And() throws ParseException {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(AND);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectIntersectionOf(operands);
    }

    /**
     * Or.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression Or() throws ParseException {
        Set<OWLClassExpression> operands;
        jj_consume_token(OPENPAR);
        jj_consume_token(OR);
        operands = ConceptSet();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectUnionOf(operands);
    }

    /**
     * Not.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression Not() throws ParseException {
        OWLClassExpression operand;
        jj_consume_token(OPENPAR);
        jj_consume_token(NOT);
        operand = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectComplementOf(operand);
    }

    /**
     * All.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression All() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(ALL);
        prop = RoleName();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectAllValuesFrom(prop, filler);
    }

    /**
     * Some.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression Some() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression filler;
        jj_consume_token(OPENPAR);
        jj_consume_token(SOME);
        prop = RoleName();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    /**
     * At least.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression AtLeast() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression filler;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATLEAST);
        card = Integer();
        prop = RoleName();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectMinCardinality(card, prop, filler);
    }

    /**
     * At most.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression AtMost() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression filler;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(ATMOST);
        card = Integer();
        prop = RoleName();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
    }

    /**
     * Exactly.
     * 
     * @return the oWL class expression
     * @throws ParseException
     *         the parse exception
     */
    final public OWLClassExpression Exactly() throws ParseException {
        OWLObjectProperty prop;
        OWLClassExpression filler;
        int card;
        jj_consume_token(OPENPAR);
        jj_consume_token(EXACTLY);
        card = Integer();
        prop = RoleName();
        filler = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectExactCardinality(card, prop, filler);
    }

    /**
     * Role name.
     * 
     * @return the oWL object property
     * @throws ParseException
     *         the parse exception
     */
    final public OWLObjectProperty RoleName() throws ParseException {
        IRI iri;
        iri = Name();
        return dataFactory.getOWLObjectProperty(iri);
    }

    /**
     * A box statement.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom ABoxStatement() throws ParseException {
        OWLAxiom ax;
        if (jj_2_21(2)) {
            ax = Instance();
        } else if (jj_2_22(2)) {
            ax = Related();
        } else if (jj_2_23(2)) {
            ax = Equal();
        } else if (jj_2_24(2)) {
            ax = Distinct();
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    /**
     * Instance.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Instance() throws ParseException {
        OWLIndividual ind;
        OWLClassExpression type;
        jj_consume_token(OPENPAR);
        jj_consume_token(INSTANCE);
        ind = IndividualName();
        type = ConceptExpression();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLClassAssertionAxiom(type, ind);
    }

    /**
     * Related.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Related() throws ParseException {
        OWLIndividual subj;
        OWLObjectProperty prop;
        OWLIndividual obj;
        jj_consume_token(OPENPAR);
        jj_consume_token(RELATED);
        subj = IndividualName();
        prop = RoleName();
        obj = IndividualName();
        jj_consume_token(CLOSEPAR);
        return dataFactory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj);
    }

    /**
     * Equal.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Equal() throws ParseException {
        OWLIndividual indA, indB;
        Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
        jj_consume_token(OPENPAR);
        jj_consume_token(EQUAL);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        return dataFactory.getOWLSameIndividualAxiom(inds);
    }

    /**
     * Distinct.
     * 
     * @return the oWL axiom
     * @throws ParseException
     *         the parse exception
     */
    final public OWLAxiom Distinct() throws ParseException {
        OWLIndividual indA, indB;
        Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
        jj_consume_token(OPENPAR);
        jj_consume_token(DISTINCT);
        indA = IndividualName();
        indB = IndividualName();
        jj_consume_token(CLOSEPAR);
        inds.add(indA);
        inds.add(indB);
        return dataFactory.getOWLDifferentIndividualsAxiom(inds);
    }

    /**
     * Individual name.
     * 
     * @return the oWL individual
     * @throws ParseException
     *         the parse exception
     */
    final public OWLIndividual IndividualName() throws ParseException {
        IRI name;
        name = Name();
        return dataFactory.getOWLNamedIndividual(name);
    }

    /**
     * Name.
     * 
     * @return the iri
     * @throws ParseException
     *         the parse exception
     */
    final public IRI Name() throws ParseException {
        Token t;
        t = jj_consume_token(NAME);
        return getIRI(t.image);
    }

    /**
     * Integer.
     * 
     * @return the int
     * @throws ParseException
     *         the parse exception
     */
    final public int Integer() throws ParseException {
        Token t;
        t = jj_consume_token(INT);
        return Integer.parseInt(t.image);
    }

    /**
     * Jj_2_1.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    /**
     * Jj_2_2.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    /**
     * Jj_2_3.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    /**
     * Jj_2_4.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    /**
     * Jj_2_5.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    /**
     * Jj_2_6.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    /**
     * Jj_2_7.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    /**
     * Jj_2_8.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    /**
     * Jj_2_9.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    /**
     * Jj_2_10.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_10();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    /**
     * Jj_2_11.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_11();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    /**
     * Jj_2_12.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_12();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    /**
     * Jj_2_13.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_13();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    /**
     * Jj_2_14.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_14();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    /**
     * Jj_2_15.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_15();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    /**
     * Jj_2_16.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_16(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_16();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(15, xla);
        }
    }

    /**
     * Jj_2_17.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_17(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_17();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(16, xla);
        }
    }

    /**
     * Jj_2_18.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_18(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_18();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(17, xla);
        }
    }

    /**
     * Jj_2_19.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_19(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_19();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(18, xla);
        }
    }

    /**
     * Jj_2_20.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_20(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_20();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(19, xla);
        }
    }

    /**
     * Jj_2_21.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_21(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_21();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(20, xla);
        }
    }

    /**
     * Jj_2_22.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_22(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_22();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(21, xla);
        }
    }

    /**
     * Jj_2_23.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_23(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_23();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(22, xla);
        }
    }

    /**
     * Jj_2_24.
     * 
     * @param xla
     *        the xla
     * @return true, if successful
     */
    private boolean jj_2_24(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_24();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(23, xla);
        }
    }

    /**
     * Jj_3_24.
     * 
     * @return true, if successful
     */
    private boolean jj_3_24() {
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_7.
     * 
     * @return true, if successful
     */
    private boolean jj_3_7() {
        if (jj_3R_8()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_17.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_17() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(SOME)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_9.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_9() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(TRANSITIVE)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_16.
     * 
     * @return true, if successful
     */
    private boolean jj_3_16() {
        if (jj_3R_17()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_24.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_24() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EQUAL)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_23.
     * 
     * @return true, if successful
     */
    private boolean jj_3_23() {
        if (jj_3R_24()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_16.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_16() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ALL)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_8.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_8() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVEROLE)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_15.
     * 
     * @return true, if successful
     */
    private boolean jj_3_15() {
        if (jj_3R_16()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_23.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_23() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RELATED)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_6.
     * 
     * @return true, if successful
     */
    private boolean jj_3_6() {
        if (jj_3R_7()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_15.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_15() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(NOT)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_22.
     * 
     * @return true, if successful
     */
    private boolean jj_3_22() {
        if (jj_3R_23()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_4.
     * 
     * @return true, if successful
     */
    private boolean jj_3_4() {
        if (jj_scan_token(ENDABOX)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_14.
     * 
     * @return true, if successful
     */
    private boolean jj_3_14() {
        if (jj_3R_15()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_22.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_22() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(INSTANCE)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_7.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_7() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINECONCEPT)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_14.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_14() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(OR)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_10.
     * 
     * @return true, if successful
     */
    private boolean jj_3_10() {
        if (jj_scan_token(42)) {
            return true;
        }
        if (jj_3R_11()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_21.
     * 
     * @return true, if successful
     */
    private boolean jj_3_21() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_6.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_6() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DEFINEPRIMITIVECONCEPT)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_13.
     * 
     * @return true, if successful
     */
    private boolean jj_3_13() {
        if (jj_3R_14()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_5.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_5() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_21()) {
            jj_scanpos = xsp;
            if (jj_3_22()) {
                jj_scanpos = xsp;
                if (jj_3_23()) {
                    jj_scanpos = xsp;
                    if (jj_3_24()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_3.
     * 
     * @return true, if successful
     */
    private boolean jj_3_3() {
        if (jj_3R_5()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_13.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_13() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(AND)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_9.
     * 
     * @return true, if successful
     */
    private boolean jj_3_9() {
        if (jj_3R_10()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_19.
     * 
     * @return true, if successful
     */
    private boolean jj_3_19() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_11.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_11() {
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_5.
     * 
     * @return true, if successful
     */
    private boolean jj_3_5() {
        if (jj_3R_6()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_20.
     * 
     * @return true, if successful
     */
    private boolean jj_3_20() {
        if (jj_3R_21()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_4.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_4() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_5()) {
            jj_scanpos = xsp;
            if (jj_3_6()) {
                jj_scanpos = xsp;
                if (jj_3_7()) {
                    jj_scanpos = xsp;
                    if (jj_3_8()) {
                        jj_scanpos = xsp;
                        if (jj_3_9()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_12.
     * 
     * @return true, if successful
     */
    private boolean jj_3_12() {
        if (jj_3R_13()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_2.
     * 
     * @return true, if successful
     */
    private boolean jj_3_2() {
        if (jj_scan_token(ENDTBOX)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_20.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_20() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(EXACTLY)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_1.
     * 
     * @return true, if successful
     */
    private boolean jj_3_1() {
        if (jj_3R_4()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_26.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_26() {
        if (jj_scan_token(NAME)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_12.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_12() {
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_18.
     * 
     * @return true, if successful
     */
    private boolean jj_3_18() {
        if (jj_3R_19()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_8.
     * 
     * @return true, if successful
     */
    private boolean jj_3_8() {
        if (jj_3R_9()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_19.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_19() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATMOST)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3_11.
     * 
     * @return true, if successful
     */
    private boolean jj_3_11() {
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_21.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_21() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_11()) {
            jj_scanpos = xsp;
            if (jj_3_12()) {
                jj_scanpos = xsp;
                if (jj_3_13()) {
                    jj_scanpos = xsp;
                    if (jj_3_14()) {
                        jj_scanpos = xsp;
                        if (jj_3_15()) {
                            jj_scanpos = xsp;
                            if (jj_3_16()) {
                                jj_scanpos = xsp;
                                if (jj_3_17()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_18()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_19()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * Jj_3_17.
     * 
     * @return true, if successful
     */
    private boolean jj_3_17() {
        if (jj_3R_18()) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_18.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_18() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(ATLEAST)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_10.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_10() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(RANGE)) {
            return true;
        }
        return false;
    }

    /**
     * Jj_3 r_25.
     * 
     * @return true, if successful
     */
    private boolean jj_3R_25() {
        if (jj_scan_token(OPENPAR)) {
            return true;
        }
        if (jj_scan_token(DISTINCT)) {
            return true;
        }
        return false;
    }

    /** Generated Token Manager. */
    public KRSSParserTokenManager token_source;
    /** The jj_input_stream. */
    JavaCharStream jj_input_stream;
    /** Current token. */
    public Token token;
    /** Next token. */
    public Token jj_nt;
    /** The jj_ntk. */
    private int jj_ntk;
    /** The jj_lastpos. */
    private Token jj_scanpos, jj_lastpos;
    /** The jj_la. */
    private int jj_la;
    /** The jj_gen. */
    private int jj_gen;
    /** The jj_la1. */
    final private int[] jj_la1 = new int[0];
    /** The jj_la1_0. */
    static private int[] jj_la1_0;
    /** The jj_la1_1. */
    static private int[] jj_la1_1;
    static {
        jj_la1_init_0();
        jj_la1_init_1();
    }

    /** Jj_la1_init_0. */
    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] {};
    }

    /** Jj_la1_init_1. */
    private static void jj_la1_init_1() {
        jj_la1_1 = new int[] {};
    }

    /** The jj_2_rtns. */
    final private JJCalls[] jj_2_rtns = new JJCalls[24];
    /** The jj_rescan. */
    private boolean jj_rescan = false;
    /** The jj_gc. */
    private int jj_gc = 0;

    /**
     * Constructor with InputStream.
     * 
     * @param stream
     *        the stream
     */
    public KRSSParser(java.io.InputStream stream) {
        this(stream, null);
    }

    /**
     * Constructor with InputStream and supplied encoding.
     * 
     * @param stream
     *        the stream
     * @param encoding
     *        the encoding
     */
    public KRSSParser(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        token_source = new KRSSParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     */
    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     * @param encoding
     *        the encoding
     */
    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor.
     * 
     * @param stream
     *        the stream
     */
    public KRSSParser(java.io.Reader stream) {
        jj_input_stream = new JavaCharStream(stream, 1, 1);
        token_source = new KRSSParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param stream
     *        the stream
     */
    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor with generated Token Manager.
     * 
     * @param tm
     *        the tm
     */
    public KRSSParser(KRSSParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * 
     * @param tm
     *        the tm
     */
    public void ReInit(KRSSParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Jj_consume_token.
     * 
     * @param kind
     *        the kind
     * @return the token
     * @throws ParseException
     *         the parse exception
     */
    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    /** The Class LookaheadSuccess. */
    static private final class LookaheadSuccess extends OWLRuntimeException {

        /** The Constant serialVersionUID. */
        private static final long serialVersionUID = 30406L;

        /** Instantiates a new lookahead success. */
        public LookaheadSuccess() {}
    }

    /** The jj_ls. */
    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    /**
     * Jj_scan_token.
     * 
     * @param kind
     *        the kind
     * @return true, if successful
     */
    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
                        .getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    /**
     * Get the next Token.
     * 
     * @return the next token
     */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    /**
     * Get the specific Token.
     * 
     * @param index
     *        the index
     * @return the token
     */
    final public Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    /**
     * Jj_ntk.
     * 
     * @return the int
     */
    private int jj_ntk() {
        if ((jj_nt = token.next) == null) {
            return jj_ntk = (token.next = token_source.getNextToken()).kind;
        } else {
            return jj_ntk = jj_nt.kind;
        }
    }

    /** The jj_expentries. */
    private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
    /** The jj_expentry. */
    private int[] jj_expentry;
    /** The jj_kind. */
    private int jj_kind = -1;
    /** The jj_lasttokens. */
    private int[] jj_lasttokens = new int[100];
    /** The jj_endpos. */
    private int jj_endpos;

    /**
     * Jj_add_error_token.
     * 
     * @param kind
     *        the kind
     * @param pos
     *        the pos
     */
    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries
                    .iterator(); it.hasNext();) {
                int[] oldentry = (int[]) it.next();
                if (oldentry.length == jj_expentry.length) {
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            continue jj_entries_loop;
                        }
                    }
                    jj_expentries.add(jj_expentry);
                    break jj_entries_loop;
                }
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /**
     * Generate ParseException.
     * 
     * @return the parses the exception
     */
    public ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[43];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 0; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 43; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    /** Enable tracing. */
    final public void enable_tracing() {}

    /** Disable tracing. */
    final public void disable_tracing() {}

    /** Jj_rescan_token. */
    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 24; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0:
                                jj_3_1();
                                break;
                            case 1:
                                jj_3_2();
                                break;
                            case 2:
                                jj_3_3();
                                break;
                            case 3:
                                jj_3_4();
                                break;
                            case 4:
                                jj_3_5();
                                break;
                            case 5:
                                jj_3_6();
                                break;
                            case 6:
                                jj_3_7();
                                break;
                            case 7:
                                jj_3_8();
                                break;
                            case 8:
                                jj_3_9();
                                break;
                            case 9:
                                jj_3_10();
                                break;
                            case 10:
                                jj_3_11();
                                break;
                            case 11:
                                jj_3_12();
                                break;
                            case 12:
                                jj_3_13();
                                break;
                            case 13:
                                jj_3_14();
                                break;
                            case 14:
                                jj_3_15();
                                break;
                            case 15:
                                jj_3_16();
                                break;
                            case 16:
                                jj_3_17();
                                break;
                            case 17:
                                jj_3_18();
                                break;
                            case 18:
                                jj_3_19();
                                break;
                            case 19:
                                jj_3_20();
                                break;
                            case 20:
                                jj_3_21();
                                break;
                            case 21:
                                jj_3_22();
                                break;
                            case 22:
                                jj_3_23();
                                break;
                            case 23:
                                jj_3_24();
                                break;
                            default:
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {}
        }
        jj_rescan = false;
    }

    /**
     * Jj_save.
     * 
     * @param index
     *        the index
     * @param xla
     *        the xla
     */
    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    /** The Class JJCalls. */
    static final class JJCalls {

        /** The gen. */
        int gen;
        /** The first. */
        Token first;
        /** The arg. */
        int arg;
        /** The next. */
        JJCalls next;
    }
}
