/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPPropertyDomainHandler
extends TriplePredicateHandler {
    public TPPropertyDomainHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isObjectProperty(subject) && this.getConsumer().isClassExpression(object)) {
            this.translateObjectPropertyDomain(subject, predicate, object);
        } else if (this.getConsumer().isDataPropertyOnly(subject) && this.getConsumer().isClassExpression(object)) {
            this.translateDataPropertyDomain(subject, predicate, object);
        } else if (this.getConsumer().isAnnotationProperty(subject) && this.getConsumer().isClassExpression(object) && !this.getConsumer().isAnonymousNode(object)) {
            this.translateAnnotationPropertyDomain(subject, predicate, object);
        } else if (!this.isStrict()) {
            this.getConsumer().addAnnotationProperty(subject, false);
            this.translateAnnotationPropertyDomain(subject, predicate, object);
        }
    }

    private void translateAnnotationPropertyDomain(IRI subject, IRI predicate, IRI object) {
        OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(subject);
        this.addAxiom((OWLAxiom)this.getDataFactory().getOWLAnnotationPropertyDomainAxiom(prop, object, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateDataPropertyDomain(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom((OWLAxiom)this.getDataFactory().getOWLDataPropertyDomainAxiom(this.translateDataProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }

    private void translateObjectPropertyDomain(IRI subject, IRI predicate, IRI object) throws OWLOntologyChangeException {
        this.addAxiom((OWLAxiom)this.getDataFactory().getOWLObjectPropertyDomainAxiom(this.translateObjectProperty(subject), this.translateClassExpression(object), this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

