/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxObjectRenderer;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererEvent;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RendererListener;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.RenderingDirector;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.SectionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    private Set<AxiomType<?>> filteredAxiomTypes = new HashSet();
    private boolean renderExtensions = false;
    private List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = new OWLAxiomFilter(){

        public boolean passes(OWLAxiom axiom) {
            return true;
        }
    };
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    private RendererEvent event;

    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(owlOntologyManager, Collections.singleton(ontology), ontology, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology defaultOntology, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public Set<OWLOntology> getOntologies() {
        return this.ontologies;
    }

    public void writeOntology() throws OWLRendererException {
        SectionMap map;
        if (this.ontologies.size() != 1) {
            throw new RuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.getOntologies().iterator().next();
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty prop : ontology.getAnnotationPropertiesInSignature()) {
            this.write(prop);
        }
        for (OWLDatatype datatype : ontology.getDatatypesInSignature()) {
            this.write(datatype);
        }
        for (OWLAnnotationProperty prop : ontology.getObjectPropertiesInSignature()) {
            this.write((OWLObjectPropertyExpression)prop);
            OWLObjectPropertyExpression invProp = prop.getInverseProperty();
            if (ontology.getAxioms(invProp).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLAnnotationProperty prop : ontology.getDataPropertiesInSignature()) {
            this.write((OWLDataProperty)prop);
        }
        for (OWLClass cls : ontology.getClassesInSignature()) {
            this.write(cls);
        }
        for (OWLNamedIndividual ind : ontology.getIndividualsInSignature()) {
            this.write((OWLIndividual)ind);
        }
        for (OWLNamedIndividual ind : ontology.getReferencedAnonymousIndividuals()) {
            this.write((OWLIndividual)ind);
        }
        this.event = new RendererEvent(this, (OWLObject)ontology);
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (ax.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getClassExpressions(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            if (ax.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getClassExpressions(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS)) {
            if (ax.getIndividuals().size() <= 2) continue;
            map = new SectionMap();
            map.add(ax.getIndividuals(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ",", false, ontology);
        }
        for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), ", ", false, new OWLOntology[0]);
        }
        this.flush();
    }

    public void writeOntologyHeader(OWLOntology ontology) {
        this.event = new RendererEvent(this, (OWLObject)ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(ontology.getOntologyID().getOntologyIRI().toString());
            this.writeNewLine();
            this.pushTab(indent);
            if (ontology.getOntologyID().getVersionIRI() != null) {
                this.writeFullURI(ontology.getOntologyID().getVersionIRI().toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getURI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        }
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, ontology.getAnnotations(), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (String prefixName : prov.getPrefixManager().getPrefixName2PrefixMap().keySet()) {
            String prefix = prov.getPrefixManager().getPrefix(prefixName);
            prefixMap.put(prefixName, prefix);
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(prefixName);
            this.write(" ");
            this.writeFullURI(prefix);
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Set<OWLAxiom> writeFrame(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write((OWLIndividual)entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return Collections.emptySet();
    }

    public Set<OWLAxiom> write(OWLClass cls) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, (OWLObject)cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap equivalentClasses = new SectionMap();
                for (OWLEquivalentClassesAxiom ax : ontology.getEquivalentClassesAxioms(cls)) {
                    if (ax.getClassExpressions().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                    for (OWLClassExpression equivCls : ax.getClassExpressionsMinus(new OWLClassExpression[]{cls})) {
                        equivalentClasses.add(equivCls, (OWLAxiom)ax);
                    }
                    axioms.add((OWLAxiom)ax);
                }
                equivalentClasses.remove(cls);
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap superclasses = new SectionMap();
                for (OWLEquivalentClassesAxiom ax : ontology.getSubClassAxiomsForSubClass(cls)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    superclasses.add(ax.getSuperClass(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ont : this.getOntologies()) {
                    SectionMap subClasses = new SectionMap();
                    for (OWLEquivalentClassesAxiom ax : ont.getSubClassAxiomsForSuperClass(cls)) {
                        if (!this.isDisplayed((OWLAxiom)ax)) continue;
                        subClasses.add(ax.getSubClass(), (OWLAxiom)ax);
                        axioms.add((OWLAxiom)ax);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<OWLDisjointClassesAxiom> pairwiseDisjointClassesAxioms = new HashSet<OWLDisjointClassesAxiom>();
                SectionMap disjointClasses = new SectionMap();
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    if (ax.getClassExpressions().size() == 2) {
                        pairwiseDisjointClassesAxioms.add(ax);
                        OWLClassExpression disjointWith = (OWLClassExpression)ax.getClassExpressionsMinus(new OWLClassExpression[]{cls}).iterator().next();
                        disjointClasses.add(disjointWith, (OWLAxiom)ax);
                    }
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
                    if (!this.isDisplayed((OWLAxiom)ax) || ax.getClassExpressions().size() <= 2) continue;
                    TreeSet allDisjointClasses = new TreeSet(ax.getClassExpressions());
                    allDisjointClasses.remove(cls);
                    axioms.add((OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, allDisjointClasses, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLHasKeyAxiom ax : ontology.getHasKeyAxioms(cls)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    SectionMap map = new SectionMap();
                    map.add(ax.getPropertyExpressions(), (OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.HAS_KEY, map, ", ", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap individuals = new SectionMap();
                for (OWLEquivalentClassesAxiom ax : ontology.getClassAssertionAxioms((OWLClassExpression)cls)) {
                    if (!this.isDisplayed((OWLAxiom)ax) || !this.renderExtensions && !ax.getIndividual().isAnonymous()) continue;
                    individuals.add(ax.getIndividual(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block15: for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals(cls)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ", ", true, ontology);
                        continue block15;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    public Set<OWLAxiom> write(OWLObjectPropertyExpression property) {
        SectionMap expressions;
        Set props;
        Object properties;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    ((SectionMap)properties).add(ax.getSuperProperty(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, (SectionMap)properties, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ontology : this.getOntologies()) {
                    properties = new SectionMap();
                    for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectSubPropertyAxiomsForSuperProperty(property)) {
                        if (!this.isDisplayed((OWLAxiom)ax)) continue;
                        ((SectionMap)properties).add(ax.getSubProperty(), (OWLAxiom)ax);
                        axioms.add((OWLAxiom)ax);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, (SectionMap)properties, ",", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getEquivalentObjectPropertiesAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax) || ax.getProperties().size() != 2) continue;
                    props = ax.getPropertiesMinus((OWLPropertyExpression)property);
                    ((SectionMap)properties).add(props.iterator().next(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, (SectionMap)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getDisjointObjectPropertiesAxioms(property)) {
                    if (ax.getProperties().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                    props = ax.getPropertiesMinus((OWLPropertyExpression)property);
                    ((SectionMap)properties).add(props.iterator().next(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, (SectionMap)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            for (OWLOntology ontology : this.getOntologies()) {
                for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!ax.getSuperProperty().equals(property) || !this.isDisplayed((OWLAxiom)ax)) continue;
                    SectionMap map = new SectionMap();
                    map.add(ax.getPropertyChain(), (OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, map, " o ", false, ontology);
                    axioms.add((OWLAxiom)ax);
                }
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            SectionMap characteristics = new SectionMap();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getInverseFunctionalObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getSymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.SYMMETRIC.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getTransitiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.TRANSITIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getReflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.REFLEXIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getIrreflexiveObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.IRREFLEXIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getAsymmetricObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.ASYMMETRIC.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.add(ax.getDomain(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                expressions = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getObjectPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.add(ax.getRange(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                properties = new TreeSet();
                for (OWLSubObjectPropertyOfAxiom ax : ontology.getInverseObjectPropertyAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    if (ax.getFirstProperty().equals(property)) {
                        properties.add(ax.getSecondProperty());
                    } else {
                        properties.add(ax.getFirstProperty());
                    }
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.INVERSE_OF, (Collection<?>)properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet<SWRLRule> rules = new HashSet<SWRLRule>();
                block25: for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        rules.add(rule);
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ",", true, ontology);
                        continue block25;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDataProperty property) {
        SectionMap props;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap characteristics = new SectionMap();
                for (OWLAxiom ax : ontology.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)property)) {
                    if (!this.isDisplayed(ax)) continue;
                    characteristics.add(ManchesterOWLSyntax.FUNCTIONAL.toString(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap domains = new SectionMap();
                for (OWLAxiom ax : ontology.getDataPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed(ax)) continue;
                    domains.add(ax.getDomain(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap ranges = new SectionMap();
                for (OWLAxiom ax : ontology.getDataPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed(ax)) continue;
                    ranges.add(ax.getRange(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap supers = new SectionMap();
                for (OWLAxiom ax : ontology.getDataSubPropertyAxiomsForSubProperty(property)) {
                    if (!this.isDisplayed(ax)) continue;
                    supers.add(ax.getSuperProperty(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new SectionMap();
                for (OWLAxiom ax : ontology.getEquivalentDataPropertiesAxioms(property)) {
                    if (!this.isDisplayed(ax) || ax.getProperties().size() != 2) continue;
                    props.add(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.getOntologies()) {
                props = new SectionMap();
                for (OWLAxiom ax : ontology.getDisjointDataPropertiesAxioms(property)) {
                    if (ax.getProperties().size() != 2 || !this.isDisplayed(ax)) continue;
                    props.add(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), ax);
                    axioms.add(ax);
                }
                props.remove(property);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.getOntologies()) {
                HashSet rules = new HashSet();
                block13: for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals(property)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "", true, ontology);
                        continue block13;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLIndividual individual) {
        TreeSet inds;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, (OWLObject)individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap expressions = new SectionMap();
                for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms(individual)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.add(ax.getClassExpression(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
            }
        }
        for (OWLOntology ontology : this.getOntologies()) {
            ArrayList assertions = new ArrayList();
            assertions.addAll(ontology.getObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getDataPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeDataPropertyAssertionAxioms(individual));
            if (assertions.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(1);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                OWLClassAssertionAxiom ax;
                ax = (OWLPropertyAssertionAxiom)it.next();
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                Set annos = ax.getAnnotations();
                if (!annos.isEmpty()) {
                    this.writeAnnotations(annos);
                    this.pushTab(this.getIndent() + 1);
                }
                if (ax instanceof OWLNegativeDataPropertyAssertionAxiom || ax instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                ax.getProperty().accept((OWLObjectVisitor)this);
                this.writeSpace();
                this.writeSpace();
                ax.getObject().accept((OWLObjectVisitor)this);
                if (!annos.isEmpty()) {
                    this.popTab();
                }
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet();
                for (OWLClassAssertionAxiom ax : ontology.getSameIndividualAxioms(individual)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    inds.addAll(ax.getIndividuals());
                    axioms.add((OWLAxiom)ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            for (OWLOntology ontology : this.getOntologies()) {
                inds = new TreeSet();
                TreeSet<OWLDifferentIndividualsAxiom> nary = new TreeSet<OWLDifferentIndividualsAxiom>();
                for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(individual)) {
                    if (ax.getIndividuals().size() == 2 && this.isDisplayed((OWLAxiom)ax)) {
                        inds.addAll(ax.getIndividuals());
                        axioms.add((OWLAxiom)ax);
                        continue;
                    }
                    nary.add(ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDifferentIndividualsAxiom ax : nary) {
                    this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ax.getIndividuals(), ", ", false, ontology);
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(OWLDatatype datatype) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, (OWLObject)datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                TreeSet<OWLDataRange> dataRanges = new TreeSet<OWLDataRange>();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    axioms.add((OWLAxiom)ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    public Set<OWLAxiom> write(SWRLRule rule) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(1);
        for (OWLOntology ontology : this.getOntologies()) {
            if (!ontology.containsAxiom((OWLAxiom)rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule), "", true, ontology);
            axioms.add((OWLAxiom)rule);
        }
        return axioms;
    }

    public Set<OWLAxiom> write(OWLAnnotationProperty property) {
        TreeSet<IRI> iris;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotation> annos = new TreeSet<OWLAnnotation>();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationAssertionAxioms((OWLAnnotationSubject)property.getIRI())) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    annos.add(ax.getAnnotation());
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, annos, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.getOntologies()) {
                TreeSet<OWLAnnotationProperty> props = new TreeSet<OWLAnnotationProperty>();
                for (OWLAnnotationAssertionAxiom ax : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    props.add(ax.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet<IRI>();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.getOntologies()) {
                iris = new TreeSet();
                for (OWLAnnotationAssertionAxiom ax : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Set<OWLAnnotationAssertionAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept((OWLObjectVisitor)this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLAnonymousIndividual)entity));
        }
        return Collections.emptySet();
    }

    public Set<OWLAnnotationAssertionAxiom> writeAnnotations(OWLAnnotationSubject subject) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.getOntologies()) {
                SectionMap sectionMap = new SectionMap();
                for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(subject)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    axioms.add(ax);
                    sectionMap.add(ax.getAnnotation(), (OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    public void writeSection(ManchesterOWLSyntax keyword, SectionMap content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Set<Set<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator<Set<OWLAnnotation>> annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Set<OWLAnnotation> annos = annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator<OWLAnnotation> annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            annoIt.next().accept((OWLObjectVisitor)this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept((OWLObjectVisitor)this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object o = listIt.next();
                            if (o instanceof OWLObject) {
                                ((OWLObject)o).accept((OWLObjectVisitor)this);
                            } else {
                                this.write(o.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (it.hasNext()) {
                        this.write(delimeter);
                        this.fireSectionItemFinished(sec);
                        if (newline) {
                            this.writeNewLine();
                        }
                    } else {
                        this.fireSectionItemFinished(sec);
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(ManchesterOWLSyntax keyword, Collection<?> content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<?> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept((OWLObjectVisitor)this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }
}

